<?php
ini_set('session.save_path', '/home/web_user');
session_id('fake-cookie');
session_start();

$stdErr = fopen('php://stderr', 'w');
$errors = [];

fwrite($stdErr, json_encode(['session' => $_SESSION]) . "\n");

register_shutdown_function(function() use($stdErr){
	fwrite($stdErr, json_encode(['session_id' => session_id()]) . "\n");
	fwrite($stdErr, json_encode(['headers'=>headers_list()]) . "\n");
	fwrite($stdErr, json_encode(['errors' => error_get_last()]) . "\n");
	fwrite($stdErr, json_encode(['session' => $_SESSION]) . "\n");
});

set_error_handler(function(...$args) use($stdErr, &$errors){
	fwrite($stdErr, json_encode($args, JSON_PRETTY_PRINT) . "\n" );
});

$request = (object) json_decode(
	'${ JSON.stringify({path, method, _GET, _POST}) }'
	, JSON_OBJECT_AS_ARRAY
);

parse_str(substr($request->_GET, 1), $_GET);

$_POST = $request->_POST;

$origin  = 'http://localhost:3333';
$docroot = '/preload/drupal-7.59';
$script  = 'index.php';

$path = $request->path;
$path = preg_replace('/^\\/php-wasm/', '', $path);

$_SERVER['REQUEST_URI']     = $path;
$_SERVER['REMOTE_ADDR']     = '127.0.0.1';
$_SERVER['SERVER_NAME']     = $origin;
$_SERVER['SERVER_PORT']     = 3333;
$_SERVER['REQUEST_METHOD']  = $request->method;
$_SERVER['SCRIPT_FILENAME'] = $docroot . '/' . $script;
$_SERVER['SCRIPT_NAME']     = $docroot . '/' . $script;
$_SERVER['PHP_SELF']        = $docroot . '/' . $script;
$_SERVER['DOCUMENT_ROOT']   = '/';
$_SERVER['HTTPS']           = '';

chdir($docroot);

define('DRUPAL_ROOT', getcwd());

require_once DRUPAL_ROOT . '/includes/bootstrap.inc';
drupal_bootstrap(DRUPAL_BOOTSTRAP_FULL);

$uid     = 1;
$user    = user_load($uid);
$account = array('uid' => $user->uid);
user_login_submit(array(), $account);

$itemPath = $path;
$itemPath = preg_replace('/^\\/preload/', '', $itemPath);
$itemPath = preg_replace('/^\\/drupal-7.59/', '', $itemPath);
$itemPath = preg_replace('/^\\//', '', $itemPath);

if($itemPath && (substr($itemPath, 0, 4) !== 'node' || substr($itemPath, -4) === 'edit'))
{
    $router_item = menu_get_item($itemPath);
    $router_item['access_callback'] = true;
    $router_item['access'] = true;

    if ($router_item['include_file']) {
      require_once DRUPAL_ROOT . '/' . $router_item['include_file'];
    }

    $page_callback_result = call_user_func_array($router_item['page_callback'], unserialize($router_item['page_arguments']));

    drupal_deliver_page($page_callback_result);
}
else
{
    menu_execute_active_handler();
}
