---
layout: documentation
title: Projects
---

# Projects

For Spring, 2016, here are some project ideas:


### Power System Overhaul

A student working on this task will design and implement a power backup system for the OPQBox. This will allow our power quality meter to operate when the mains power is out. This is a great opportunity for students interested in PCB design and simulation software.

### Analog Front End (AFE) Overhaul

OPQBox is analog front end is responsible for both electrical isolation from the mains and signal conditioning. A student working on this task will work on improving the AFE design, and characterize the its performance. This is a great opportunity for a student interested in the analog design and simulation.

### DSP Developer

A student working on this task will be responsible for improving the data acquisition system, as well as implementing power quality algorithms. This is a great opportunity for a student interested in embedded systems.

### Raspberry PI communications software development

Raspberry PI is the OPQBox gateway to the internet. A student working on this task will improve the communication system between the DSP, raspberry PI and the OPQHub cloud service. This is a great opportunity for a student interested in network communication, or with previous Java experience.  


### Notes

The Power System Overhaul task is largely decoupled from the rest of the development. The AFE and DSP tasks overlap to some degree. The Raspberry PI communication task will work with the OPQHub developers toward the end of the semester.  

Here is how the tasks relate to various areas of interest: circuit design, simulation, embedded and Linux software, and data analysis:

<table class="table table-bordered">
<tr> <td></td> <td>Power</td>   <td>AFE</td>   <td>DSP</td>    <td>PI</td> </tr>

<tr> <td>Circuit design</td>    <td>X</td>  <td></td>   <td></td>  <td></td>  </tr>
<tr> <td>Simulation</td>        <td>X</td>  <td>X</td>  <td>X</td> <td></td>  </tr>
<tr> <td>Software/Embedded</td> <td></td>   <td>X</td>  <td>X</td> <td>X</td>  </tr>
<tr> <td>Software/Linux</td>    <td></td>   <td></td>   <td></td>  <td>X</td>  </tr>
<tr> <td>Data analysis</td>     <td></td>   <td></td>   <td>X</td> <td></td>  </tr>

</table>

Here's student interest relates to the tasks (big X means primary interest, small x means secondary interest):

<table class="table table-bordered">
<tr> <td></td>               <td>Power</td> <td>AFE</td> <td>DSP</td>  <td>PI</td> </tr>

<tr> <td>Bobby White</td>        <td></td>   <td></td>   <td>X</td> <td></td>  </tr>
<tr> <td>Jordan Ugalino</td>     <td>X</td>  <td></td>   <td></td>  <td>x</td>  </tr>
<tr> <td>Grant Liu</td>          <td>x</td>  <td></td>   <td></td>  <td>X</td>  </tr>
<tr> <td>Rochelle Pagaduan</td>  <td>x</td>   <td>X</td>   <td></td>  <td></td>  </tr>

</table>


 








