---
layout: documentation
title: Summer 2018 OPQ Opportunities
---

# Summer 2018 Research and Development Opportunities

Looking for something to do this summer that will beef up your professional portfolio and earn you some independent study credits at the same time? The Open Power Quality project has a number of opportunities available for Summer 2018, and you can earn up to 6 credits of ICS 499 or ICS 699 for participating. If you are coming from a different department, we can see if credits for one of your "home" courses can be arranged. Some of these opportunities have the potential to grow into M.S. or Ph.D. dissertations if you are looking for a longer-term research project. 

To learn more about OPQ, please see our [system overview](https://open-power-quality.gitbook.io/open-power-quality-manual/introduction/opq-system-overview).  

### 1. React and Meteor UI development

The front-end to the OPQ system is a web application called OPQView which is implemented using technologies including [Meteor](http://meteor.com), [React](https://reactjs.org/), and [React Timeseries Charts](https://software.es.net/react-timeseries-charts/#/). You can see it at [http://emilia.ics.hawaii.edu](http://emilia.ics.hawaii.edu). 

We will be implementing UI components in React for various types of visualizations this summer. This is a great opportunity if you want to improve your UI development and/or visualization chops, 

### 2. Hardware design, certification, and manufacturing 

We are currently completing a new generation of our [OPQ Box](https://open-power-quality.gitbook.io/open-power-quality-manual/opq-box/design) hardware device. We hope to obtain UL listing and develop scalable manufacturing procedures this summer. 

This is a great opportunity if you are interested in the Internet of Things from a hardware perspective and want to gain some practical experience with design and implementation.  

### 3. Data Science: Managing big data and applying machine learning

OPQ provides an excellent opportunity to develop skills in data science, which in this case means manipulating large data sets and applying machine learning techniques to gather insights.  To give you a sense of the situation, each OPQBox samples the power signal approximately 15,000 times per second, and our cloud-based system processes about a half million power quality data points per OPQBox every day. We intend each OPQ system instance to support hundreds of OPQBoxes.  

This is a great opportunity if you are interested in data fusion, sensor fusion, classification, clustering, and other techniques to produce actionable insights from the generation and processing of literally millions of data points every hour.

### 4. UH agile power quality monitoring project

OPQ is a recipient of a [2018 UH Presidents Green Award](http://www.hawaii.edu/news/2018/02/12/2018-presidents-green-awards/) for a project called [Agile Power Monitoring](http://openpowerquality.org/projects/agile-power-monitoring.html).  

This project will begin during Summer, 2018.  This is a great opportunity if you are interested in renewable energy and microgrid operations and would like to learn more about the UH microgrid. 


###  5. Twitter alerts for power quality events

OPQ has a [Twitter feed](https://twitter.com/opquality). Alas, it has nothing in it. Wouldn't it be cool if OPQ posted signficant power quality events to Twitter so that anyone could monitor the health of the grid? This can also provide a simple way to show how OPQ can support citizen engagement in renewable energy and other power-related social issues. 

This is a great opportunity if you want to learn how to interface a system to Twitter and generate meaningful notifications. 

### 6. Kickstarter campaign design and execution

We would like to have a KickStarter campaign to solicit funding for manufacturing OPQ Boxes and scaling up the system. We're not quite sure how to do it, but Kickstarter has an excellent [Creator Handbook](https://www.kickstarter.com/help/handbook/) with details on what to think about. 

This is a great opportunity if you are interested in alternative forms of fundraising and would like to gain experience using Kickstarter. 


### 7. Static Site Design and Implementation using Docusaurus

The OPQ project documentation is currently split between a [home site](http://openpowerquality.org) implemented using [Jekyll](https://jekyllrb.com/) and hosted via GitHub pages, and a [documentation manual](https://open-power-quality.gitbook.io/open-power-quality-manual/) written using [GitBook](https://www.gitbook.com/).

This is suboptimal for a number of reasons. This summer, we would like to transition to [Docusaurus](https://docusaurus.io/), which will enable us to unify both home site and documentation manual in one code base. 

This is a great opportunity if you enjoy writing and would like to gain experience with a modern static site generator. 


### Next steps

If you're interested in learning more, the next step is to [contact us](contact.html) and indicate the opportunity or opportunities of interest. The next step is to attend one of our regular weekly project meeting, where you can get to know the members of OPQ and learn more about the project.   If you're still interested, you can sign up for an independent study and get to work!
