---
layout: documentation
title: Motivation
---

# Why do we need open power quality?

For economic, environmental, and political reasons, there is a growing, global movement away from fossil-fuel based forms of electrical energy and toward renewable alternatives. This movement is particularly relevant to Hawaii, where over 80% of our electrical energy comes from oil, and where the average cost per kilowatt-hour of electricity ($0.30) is triple that of the mainland United States ($0.10).

The economic, environmental, and political advantages of renewable energy sources are balanced by significant new technical challenges: most renewables are intermittent (solar energy cannot be harvested at night) and unpredictable (wind and solar energy fluctuate based upon cloud cover and wind speed).  In addition, renewable energy generation can be distributed throughout the grid (such as in the case of residential rooftop photovoltaic (PV) systems). These three properties contrast with traditional fossil-fuel electrical generation, which is firm (available 24/7) and centralized (all power is generated by a few, large-scale plants under control of the utilities).

An article in the September 6, 2013 issue of the Honolulu Star-Advertiser ([Solar saturation could mean new HECO charges](http://www.staradvertiser.com/newspremium/20130906_Solar_saturation_could_mean_new_HECO_charges.html)) reveals the challenges that come with significant penetration of intermittent, unpredictable, and distributed renewable energy.  According to the article, rooftop PV now generates all the power needed by 13% of Oahu neighborhoods during daylight hours, far beyond what is occurring anywhere on the mainland. This is creating significant concerns about grid power quality and stability, with the utility contemplating caps on new installations and additional costs to future customers wishing to install renewable energy systems.  While Hawaii’s unique attributes make it the first to confront these problems, other communities will face them in the future as they too reach significant penetration of intermittent, unpredictable, and distributed renewable energy.

On October 14, 2013, Hawaii News Now reported on a hearing convened by legislators regarding HECO's solar policy changes.  According to the report, "*The Hawaiian Electric Company answered to lawmakers Monday afternoon about a new policy requiring its approval before solar photovoltaic installations. HECO says the change, which went into effect, September 6, ensures its circuits have the capacity to remain reliable as PV growth skyrockets in Hawaii. Critics say the new policy has crippled the industry and left hundreds of customers who were at various stages in the transition to solar in limbo.*" The full news article is available [here](http://www.hawaiinewsnow.com/story/23689275/lawmakers-call-hearing-to-discuss-hecos-solar-policy-changes).

The goal of Open Power Quality is to support the continued growth in use of renewable energy sources in Hawaii and elsewhere through a novel "triple open source" combination of hardware, software, and power quality data. We are designing and implementing a  low cost, consumer-grade hardware device called OPQBox for power quality whose specifications are available through an open source license.  Each OPQBox can capture power quality data and send it to an instance of OPQHub, our cloud-based, software service, whose source code is also available as open source.  Finally, the collected information will be available as “open data”, facilitating analysis and innovation.

Our major project goals include:

  * Low-cost, residential-level power quality monitoring.  Our target price for the hardware is under $40.  Current commercial solutions are $200 and up.  Our hardware specifications will be made available under open-source licensing to promote innovation and even lower costs.
  
  * Point-of-use power quality data.  Traditionally, utilities were responsible for all power generation, and so they were also responsible for power quality monitoring.  Such monitoring traditionally occurs at the substation, with the assumption that this reflects the quality of power experienced by the hundreds or thousands of end-users serviced by the substation.  As end-users become both consumers and producers of power, the "substation assumption" is no longer valid, and it becomes important to know power quality as experienced by the end-user.
  
  * Crowd-sourced grid-level acquisition of power quality data.  A key feature of our approach is to upload power quality data from end-users to a cloud-based service. Such crowd-sourcing can reveal trends and explanations for power quality not available to individuals.

  * Crowd-sourced analysis of power quality data.  The creation of open data and its availability through an API to our cloud-based service creates an open-ended opportunity for analyses and combination with other data sources (such as cloud-cover and weather data).

  * Protection of end-user privacy.  Our approach creates a technical and social challenge: how to allow end-users to share their power quality data with others (to reap the benefits of crowd-sourcing) while not forcing them to reveal more than they wish about themselves and their location?   Our software service will provide various privacy protection capabilities to enable end-users to share data in a way with which they feel comfortable.

We believe our combination of open hardware, software, and data provides a compelling and complementary alternative to traditional, utility-based data collection, analysis, and management. It creates a path to active engagement by end-users in the development of a reliable, high quality grid.


