---
layout: documentation
title: Join us!
---

# Help us create the Internet of Things for power quality!

Looking for a semester long project in the fast-evolving smart grid field? Enjoy programming, computer science, and software engineering? Want to learn more about cloud computing? Interested in how renewable energies affect Hawaii's power grid? Then look no further! 

The OpenPowerQuality project is looking for undergraduate or graduate students who want to advance the field of smart-grids and power quality analysis. Below we've outlined a list of potential projects for Spring 2018. All projects will be developed and deployed to a cloud environment with scalability in mind. If you think there is potential for a project we haven't listed below, please bring your idea to our attention!

### Graph / Network Analysis / Community Detection

Students will look at differences and similarities between PQ event metrics over time and space. These similarities will be used to group PQ devices into groups of similar PQ, effectively creating PQ communities. Students interested in this topic will be required to dive into network theory and community structure. Students should have a basic background in graph theory, discrete mathematics, and linear algebra.

The end deliverable will be a visualization that shows PQ communities. Some ideas for visualizations include [hierarchical clustering](https://en.wikipedia.org/wiki/Hierarchical_clustering) and [dendograms](https://en.wikipedia.org/wiki/Dendrogram).

### Data / Sensor Fusion

Students will explore issues in [data](https://en.wikipedia.org/wiki/Data_fusion) and [sensor](https://en.wikipedia.org/wiki/Sensor_fusion) fusion by correlating signals between PQ data and other data sources. We are interested in investigating what external factors may create PQ issues on the grid. For example, how does solar production affect the PQ on the grid? In this scenario, students would compare solar production data with PQ data and attempt to find correlations. Since we don't have access to direct solar production numbers, students may need to use indirect means of obtaining those measurements. For example, students can look at satellite cloud cover or solar radiance numbers.

Students should have an interest in linear algebra, DSP, statistics, image processing, and/or machine learning. 

Students interested in this topic may also wish to speak with Dr. Lipyeow Lim who is performing research using these techniques.

The end deliverable will be a visualization that takes multiple data sources and unifies them into a single plot or map with the hope of allowing us to visualize external PQ forces on the grid. 

###  Power Quality Prediction

Students will attempt to create a [predictive model](https://en.wikipedia.org/wiki/Predictive_modelling) of PQ events within a single household, a community, or the entire grid. Similar to weather forecasting, we would like to explore the possibility of creating a predictive model for PQ data to allow us to perform PQ forecasting. Students should be very comfortable with statistics and linear algebra and have a willingness to learn new machine learning techniques.

Students interested in this topic may also wish to speak with Dr. Lipyeow Lim who is performing research using these techniques.

The end deliverable will be a visualization that provides a PQ forecast.


### Classification

Students will use DSP, statistical, and/or machine learning techniques such as [feature extraction](https://en.wikipedia.org/wiki/Feature_extraction) to identify standard PQ events such as voltage sags, harmonic distortions, or a long list of other standard PQ issues. Students interested in this topic should have a strong background in DSP, statistics, differential equations, and time-frequency analysis.

The end deliverable will be a visualization that provides a list of individually identified PQ events as well as "grid-wise" PQ events.

### Security / Classification

Students will use signal analysis to attempt to classify the PQ signatures of different electronic equipment and their operating modes. Early pilot studies show that it may be possible to classify electric equipment in one's household by looking at its PQ signature. It may even be possible to classify the operating modes of electronic equipment such as personal computers (i.e. launching a web page, running certain software, etc). Students interested in this topic should have a strong background in DSP, statistics, differential equations, and time-frequency analysis.

The end deliverable will be a visualization and/or plot that shows the classification of electronic equipment and/or operting modes of electronic equipment based off of PQ signatures. These results would make a great study, tech report, or publication as well.


### UI Innovations

Students will develop web-based user interfaces for PQ data consumption using the [Meteor Framework](http://www.meteor.com). Students should have some background in web technologies (javascript, css, html, etc). Ideas of UI components include PQ maps, PQ event lists, display of grid-events vs local-event, and more.

The end deliverable will be a UI component(s) that enhances the way we provide PQ information to consumers and researchers.


# For more information

Let us know you're interested in any or all of these projects through the [Contact](contact.html) page.
