---
layout: documentation
---

# Help us create the Internet of Things for power quality!

Interested in the Internet of Things? The Open Power Quality project is looking for undergraduates and graduate students in both computer science and electrical engineering to help us create technology that supports renewable energy in Hawaii!

## Hardware design: OPQBox2

<div class="row">
  <div class="col-sm-2">
    <img class="img-circle img-responsive" style="margin-top: 10px; margin-bottom: 0px" src="../images/opqbox2-engineering-sample-250.jpg"/>
  </div>
  <div class="col-sm-10">
  <p style="margin-top: 10px">
  Are you interested in hardware?  We are currently designing, fabricating, and deploying <a href= "http://openpowerquality.org/opqbox2/">OPQBox2</a>.   You will gain experience in hardware design, integration, building a product for consumer market, DSP, and integration with web technologies. You will help with the design of our custom power quality instrument, implement power quality algorithms, learn about IEEE standards, do interdisciplinary work with ICS students, and discuss power quality concerns with HECO engineers and other stakeholders.
  </p>
  <p>
  Example project: In order to function through a power outage, our device employs a supercapacitor circuit. At the moment, we are only able to achieve 1 second of uptime. You can help us redesign our instrument to support 30 seconds of uptime.</p>
  </div>
</div>

## Software design: Web and mobile UI development

<div class="row">
  <div class="col-sm-2">
    <img class="img-circle img-responsive" style="margin-top: 10px; margin-bottom: 0px" src="../images/meteor-logo.png"/>
  </div>
  <div class="col-sm-10">
  <p style="margin-top: 10px">
  Are you interested in web application development? We are currently designing and implementing <a href="https://github.com/openpowerquality/opqview2">OPQView2</a>, a <a href="http://meteor.com">Meteor</a> application for user interaction with the data.
  </p>
  <p>Meteor is a modern framework for developing "reactive" applications using Javascript and MongoDB, and with the ability to compile into native mobile applications for Android and iOS.</p>
  <p>
  Example project:  Design and implement a geo-aware application that can provide users with power quality information about their immediate vicinity.</p>
  </div>
</div>


## System design: Scalability and big data

<div class="row">
  <div class="col-sm-2">
    <img class="img-circle img-responsive" style="margin-top: 10px; margin-bottom: 0px" src="../images/bigdata.jpg"/>
  </div>
  <div class="col-sm-10">
  <p style="margin-top: 10px">
  Are you interested in highly scalable systems and big data?  Come help us develop the system architecture for OPQ Version 2, including <a href="https://github.com/openpowerquality/opqhub2">OPQHub2</a>, a repository for power quality data.
  </p>
  <p>We will also be exploring the use of <a href="http://iobeam.com">IOBeam</a> as a possible back-end infrastructure.</p>
  </div>
</div>






Let us know you're interested in any or all of these projects through the [Contact](contact.html) page.
