// Copyright © 2023 OpenIM open source community. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package common

// HTTP response code.
const (
	SUCCESS        = 200
	ERROR          = 500
	INVALID_PARAMS = 400
	UNAUTHORIZED   = 401
	FORBIDDEN      = 403

	// OpenIM callback code.
	OPENIM_SERVER_ALLOW_ACTION = 0
	OPENIM_SERVER_DENY_ACTION  = 1

	// KF service status.
	KF_RECORD_NOT_FOUND = 10001
	KF_FILE_SIZE_LIMIT  = 10002
	KF_INTERNAL_ERROR   = 10003
)

// KF internal error code.
const (
	I_INVALID_PARAM = 20000 + iota
)
