# Proposal Design Guidelines

To ensure a streamlined and collaborative approach to proposal designs, we recommend that every major proposal includes a pull request (PR) in the current directory. You can refer to the template file `0000-template.md` as a starting point for writing your proposal.

## Why Submit a PR?

Pull requests provide a transparent and efficient way to review, discuss, and track changes made to proposals. By submitting a PR, you enable the community to participate in the proposal development process, offer feedback, and suggest improvements.

## Procedure

1. Fork the [OpenIMSDK/community](https://github.com/OpenIMSDK/community) repository to your GitHub account.
2. Create a new branch in your forked repository named after your proposal. For example, `feature/proposal-name`.
3. Copy the `0000-template.md` file to the current directory.
4. Rename the copied file to reflect your proposal, using the format `YYYYMMDD-proposal-name.md`, where `YYYYMMDD` is the current date.
5. Modify the contents of the proposal file with your proposed design, ensuring all necessary details are included.
6. Commit the changes to your branch with an appropriate commit message describing the purpose of the proposal.
7. Open a pull request from your branch to the `main` branch of the main repository.

## Review Process

Once the pull request is opened, it will undergo a review process that involves feedback, discussions, and potential iterations. The community will provide comments and suggestions for improvement. Please actively engage in these discussions and address any concerns raised.

## Finalizing the Proposal

After incorporating feedback and making necessary changes, the proposal will be approved or rejected based on the consensus reached by the community. Once approved, it will be merged into the main repository, marking it as an official proposal.

## Additional Resources

For more information on creating and submitting proposals, please refer to the [OpenIMSDK/community](https://github.com/OpenIMSDK/community) repository's documentation.

We look forward to your valuable contributions in shaping the future of OpenIMSDK!