# [RFC #0000] OpenIMSDK proposal template
## Meta
[meta]: #meta
- Name: (fill in the feature name: My Feature)
- Start Date: (fill in today's date: YYYY-MM-DD)
- Author(s): (Github usernames)
- Status: Draft <!-- Acceptable values: Draft, Approved, On Hold, Superseded -->
- RFC Pull Request: (leave blank)
- OpenIMSDK Pull Request: (leave blank)
- OpenIMSDK Issue: (leave blank)
- Supersedes: (put "N/A" unless this replaces an existing RFC, then link to that RFC)


## 📇Topics
- [\[RFC #0000\] OpenIMSDK proposal template](#rfc-0000-openimsdk-proposal-template)
  - [Meta](#meta)
  - [📇Topics](#topics)
  - [Summary](#summary)
  - [Definitions](#definitions)
  - [Motivation](#motivation)
  - [What it is](#what-it-is)
  - [How it Works](#how-it-works)
  - [Migration](#migration)
  - [Drawbacks](#drawbacks)
  - [Alternatives](#alternatives)
  - [Prior Art](#prior-art)
  - [Unresolved Questions](#unresolved-questions)
  - [Spec. Changes (OPTIONAL)](#spec-changes-optional)
  - [History](#history)


## Summary
[summary]: #summary

One paragraph explanation of the feature.

## Definitions
[definitions]: #definitions

Make a list of the definitions that may be useful for those reviewing. Include phrases and words that OpenIMSDK authors or other interested parties may not be familiar with.

## Motivation
[motivation]: #motivation

- Why should we do this?
- What use cases does it support?
- What is the expected outcome?

## What it is
[what-it-is]: #what-it-is

This provides a high level overview of the feature.

- Define any new terminology.
- Define the target persona: OpenIMSDK author, OpenIMSDK user, platform operator, platform implementor, and/or project contributor.
- Explaining the feature largely in terms of examples.
- If applicable, provide sample error messages, deprecation warnings, or migration guidance.
- If applicable, describe the differences between teaching this to existing users and new users.

## How it Works
[how-it-works]: #how-it-works

This is the technical portion of the RFC, where you explain the design in sufficient detail.

The section should return to the examples given in the previous section, and explain more fully how the detailed proposal makes those examples work.

## Migration
[migration]: #migration

This section should document breaks to public API and breaks in compatibility due to this RFC's proposed changes. In addition, it should document the proposed steps that one would need to take to work through these changes. Care should be give to include all applicable personas, such as platform developers, OpenIMSDK developers, OpenIMSDK users and consumers of OpenIMSDK images.

## Drawbacks
[drawbacks]: #drawbacks

Why should we *not* do this?

## Alternatives
[alternatives]: #alternatives

- What other designs have been considered?
- Why is this proposal the best?
- What is the impact of not doing this?

## Prior Art
[prior-art]: #prior-art

Discuss prior art, both the good and bad.

## Unresolved Questions
[unresolved-questions]: #unresolved-questions

- What parts of the design do you expect to be resolved before this gets merged?
- What parts of the design do you expect to be resolved through implementation of the feature?
- What related issues do you consider out of scope for this RFC that could be addressed in the future independently of the solution that comes out of this RFC?

## Spec. Changes (OPTIONAL)
[spec-changes]: #spec-changes
Does this RFC entail any proposed changes to the core specifications or extensions? If so, please document changes here.
Examples of a spec. change might be new lifecycle flags, new `OpenIMSDK.toml` fields, new fields in the OpenIMSDKage label, etc.
This section is not intended to be binding, but as discussion of an RFC unfolds, if spec changes are necessary, they should be documented here.

## History
[history]: #history

<!--
## Amended
### Meta
[meta-1]: #meta-1
- Name: (fill in the amendment name: Variable Rename)
- Start Date: (fill in today's date: YYYY-MM-DD)
- Author(s): (Github usernames)
- Amendment Pull Request: (leave blank)

### Summary

A brief description of the changes.

### Motivation

Why was this amendment necessary?
--->