# `/assets`

The `/assets` directory in the OpenKF repository contains various assets such as images, logos, and animated GIFs. These assets serve different purposes and contribute to the functionality and aesthetics of the OpenKF project.

## Directory Structure:

```bash
assets/
├── README.md                     # Documentation for the assets directory
├── images                        # Directory holding images related to OpenKF
│   ├── architecture.png          # Image depicting the architecture of OpenKF
│   └── mvc.png                   # Image illustrating the Model-View-Controller (MVC) pattern
├── intive-slack.png              # Image displaying the Intive Slack logo
├── logo                          # Directory containing various logo variations for OpenKF
│   ├── openkf-logo-black.png     # OpenKF logo with a black background
│   ├── openkf-logo-blue.png      # OpenKF logo with a blue background
│   ├── openkf-logo-green.png     # OpenKF logo with a green background
│   ├── openkf-logo-purple.png    # OpenKF logo with a purple background
│   ├── openkf-logo-white.png     # OpenKF logo with a white background
│   ├── openkf-logo-yellow.png    # OpenKF logo with a yellow background
│   ├── openkf-logo-yellow2.png   # Another variation of OpenKF logo with a yellow background
│   └── openkf-logo.png           # OpenKF logo with a transparent background
└── logo-gif                      # Directory containing animated GIF versions of the OpenKF logo
    ├── openkf-log-dark.gif       # Dark-themed animated OpenKF logo
    ├── openkf-log-dazzling.gif   # Dazzling-themed animated OpenKF logo
    ├── openkf-log-insipid.gif    # Insipid-themed animated OpenKF logo
    ├── openkf-log-white.gif      # White-colored animated OpenKF logo
    └── openkf-log.gif            # Animated OpenKF logo with a transparent background
```

## Copyright Notice:

The OpenKF logo, including its variations and animated versions, displayed in this repository [OpenKF](https://github.com/openimsdk/openkf) under the `/assets/logo` and `/assets/logo-gif` directories, are protected by copyright laws.

The logo design is credited to @Xx(席欣).

Please respect the intellectual property rights and refrain from unauthorized use and distribution of these assets.