# Boolean FHE (BinFHE) documentation

Refer to our [OpenFHE-Readthedocs](https://openfhe-development.readthedocs.io/en/latest/sphinx_rsts/modules/binfhe.html) for more information. This folder contains implementations of [Ducas-Micciancio (FHEW)](https://eprint.iacr.org/2014/816.pdf), [Chillotti-Gama-Georgieva-Izabachene (TFHE)](https://eprint.iacr.org/2018/421.pdf) and [Lee-Micciancio-Kim-Choi-Deryabin-Eom-Yoo(LMKCDEY)] (https://eprint.iacr.org/2022/198).

## File Listings

[Binary FHE CryptoContext](binfhecontext.h)

- CryptoContext for the boolean circuit FHE scheme
- A CryptoContext is the primary object through which we interact with the various `OpenFHE` capabilities

[Binary FHE CryptoContext Serialization](binfhecontext-ser.h)

- Adds serialization support to Bollean Circuit FHE

[DM/CGGI Cryptosystem](binfhe-base-scheme.h)

- The main cryptosystem implementation used for DM/CGGI schemes
- The scheme is described in [Bootstrapping in FHEW-like Cryptosystems](https://eprint.iacr.org/2014/816) from Daniele
  Micciancio and Yuriy Polyakov as published in Cryptology ePrint Archive, Report 2020/086
- The Ring GSW accumulator implementation with AP, GINX and LMKCDEY methods for bootstrapping

[Constants for DM/CGGI Cryptosystem](binfhe-constants.h)

- Defines all options for BINFHE_PARAMSET (security levels for predefined parameter sets), BINFHE_METHOD (bootstrapping method), BINFHE_OUTPUT (type of ciphertext generated by encryption), BINGATE (type of gates supported, either with two or more inputs), and KEYGEN_MODE (secret or public key encryption) enums

[Parameters for DM/CGGI Cryptosystem](binfhe-base-params.h)

- The parameters for LWE and Ring GSW schemes

[LWE CryptoParameters](lwe-cryptoparameters.h)

- Class for all LWE parameters used for boolean FHE

[Ring GSW CryptoParameters](rgsw-ciphertext.h)

- Class for all RGSW parameters used for boolean FHE bootstrapping

[LWE public-key scheme](lwe-pke.h)

- Additive LWE scheme with public-key encryption

[LWE Ciphertext](lwe-ciphertext.h)

- Class for LWE ciphertext for boolean FHE

[RLWE Ciphertext](lwe-ciphertext.h)

- Class for RLWE ciphertext for boolean FHE

[LWE secret key](lwe-privatekey.h)

- Class for the secret key of the LWE scheme

[LWE public key](lwe-publickey.h)

- Class for the public key of the LWE scheme, in the case where asymmetric encryption is desired

[LWE Keypair](lwe-keypair.h)

- Classes for the key pair of private and public key, in the case where asymmetric encryption is desired

[LWE switching key](lwe-keyswitchkey.h)

- Class for the switching key of the LWE scheme

[Ring GSW accumulator](rgsw-acc.h)

- The main accumulator class for bootstrapping. The different methods are described in:
- (rgsw-acc-cggi.h) for CGGI method
- (rgsw-acc-dm.h) for DM method
- (rgsw-acc-lmkcdey.h) for LMKCDEY method

[Ring GSW accumulator key](rgsw-acckey.h)

- Class for the bootstrapping key

[Ring GSW evaluation key](rgsw-evalkey.h)

- Class for the internal RGSW scheme used in bootstrapping
