OpenFHE Examples
=================

To support users in understanding and integration OpenFHE provides a number of examples. There are a few examples inside
this repository but also independent repositories.

---

**Table of Contents**

- [OpenFHE/PALISADE Integer Examples](#OpenFHE-integer-examples)
- [OpenFHE/PALISADE Encrypted Circuit Emulator](#OpenFHE-encrypted-circuit-emulator)
- [OpenFHE/PALISADE Python 3 Demos](#OpenFHE-python-3-demos)
- [OpenFHE/PALISADE Serial examples](#OpenFHE-serial-examples)
- [Local Examples](#local-examples)

---

[OpenFHE Integer Examples](https://gitlab.com/palisade/palisade-integer-examples)
---------------------------

This repository has a number of examples related to FHE integer operations. Check out
the [README](https://gitlab.com/palisade/palisade-integer-examples/-/blob/master/README.md) in the repository for more
details.


[OpenFHE Encrypted Circuit Emulator](https://gitlab.com/palisade/palisade-encrypted-circuit-emulator)
-------------------------------------

This is a demonstration application using OpenFHE's binfhe module for encrypted boolean logic. Check out
the [README](https://gitlab.com/palisade/palisade-encrypted-circuit-emulator/-/blob/master/README.md) in the repository
for more details.

[OpenFHE Python 3 Demos](https://gitlab.com/palisade/palisade-python-demo)
-------------------------

This repository contains an example python 3 wrapper for OpenFHE. It does not expose all functionality of OpenFHE,
rather it is an example of how to build a specific python application program using a python wrapper, Boost/python
bindings and an installed OpenFHE library. Check out
the [README](https://gitlab.com/palisade/palisade-python-demo/-/blob/master/README.md) in the repository for more
details.

[OpenFHE serial examples](https://gitlab.com/palisade/palisade-serial-examples)
--------------------------

Sample programs for Encrypted Processing between cooperating processes. Check out
the [README](https://gitlab.com/palisade/palisade-serial-examples/-/blob/master/README.md) in the repository for more
details.

Local Examples
--------------

The examples included with the OpenFHE lattice crypto library. Check out the [README](../../src/pke/examples/README.md)
in the repository for more details.
