# Agents

You may optionally install [orchestrator-agent](https://github.com/openark/orchestrator-agent) on your MySQL hosts.
`orchestrator-agent`* is a service which registers with your `orchestrator` server and accepts requests by `orchestrator` via web API.

Supported requests relate to general, OS and LVM operations, such as:
- Stopping/starting MySQL service on host
- Getting MySQL OS info such as data directory, port, disk space usage
- Performing various LVM operations such as finding LVM snapshots, mounting/unmounting a snapshot
- Transferring data between hosts (e.g. via `netcat`)

`orchestrator-agent` is an ongoing effort in solving host-specific operations. It was originally developed to overcome cloning and restoring issues, and later expanded to other areas.

The information and API exposed by `orchestrator-agent` to `orchestrator` allow `orchestrator` to coordinate and operate seeding of new or corrupted machines by getting data from freshly available snapshots. Moreover, it allows `orchestrator`
to automatically suggest the source of data for a given MySQL machine, by looking up such hosts that actually have a
recent snapshot available, preferably in the same datacenter.

For security measures, an agent requires a token to operate all but the simplest requests. This token is randomly generated by the agent and negotiated with `orchestrator`. `orchestrator` does not expose the agent's token (right now some work needs to be done on obscuring the token on error messages).
