// https://github.com/openai/openai-node/blob/master/src/resources/chat/completions.ts

interface ChatCompletionDelta {
  role: 'assistant';
  content: string;
  /**
   * The refusal message generated by the model.
   */
  refusal: string | null;
}

/**
 * A chat completion message generated by the model.
 */
export interface ChatCompletionMessage {
  /**
   * The contents of the message.
   */
  content: string | null;

  /**
   * The refusal message generated by the model.
   */
  refusal: string | null;

  /**
   * The role of the author of this message.
   */
  role: 'assistant';
}


interface ChatCompletionChoice {
  index: number;
  delta: ChatCompletionDelta;
  /**
   * The refusal message generated by the model.
   */
  refusal: string | null;
  /**
   * The reason the model stopped generating tokens. This will be `stop` if the model
   * hit a natural stop point or a provided stop sequence, `length` if the maximum
   * number of tokens specified in the request was reached, `content_filter` if
   * content was omitted due to a flag from our content filters, `tool_calls` if the
   * model called a tool, or `function_call` (deprecated) if the model called a
   * function.
   */
  finish_reason: 'stop' | 'length' | 'tool_calls' | 'content_filter' | 'function_call';

  /**
   * A chat completion message generated by the model.
   */
  message: ChatCompletionMessage;
}

export interface ChatCompletion {
  id: string;
  object: string;
  created: number;
  model: string;
  system_fingerprint?: string;
  choices: ChatCompletionChoice[];
}

/**
 * Describes an OpenAI model offering that can be used with the API.
 */
interface Model {
  /**
   * The model identifier, which can be referenced in the API endpoints.
   */
  id: string;

  /**
   * The Unix timestamp (in seconds) when the model was created.
   */
  created: number;

  /**
   * The object type, which is always "model".
   */
  object: 'model';

  /**
   * The organization that owns the model.
   */
  owned_by: string;
}

export interface ModelList {
  object: string,
  data: Model[]
}