# OpenTelemetry Instrumentation: Spring and Spring Boot

<!-- ReadMe is in progress -->
<!-- TO DO: Add sections for starter guide -->

This package streamlines the manual instrumentation process of OpenTelemetry for [Spring](https://spring.io/projects/spring-framework) and [Spring Boot](https://spring.io/projects/spring-boot) applications. It will enable you to add traces to requests and database calls with minimal changes to application code. This package will not fully automate your OpenTelemetry instrumentation, instead, it will provide you with better tools to instrument your own code.

## Settings

| System property                                                               | Type    | Default | Description                                                                                                                                                                                                                                                                                                                                             |
|-------------------------------------------------------------------------------|---------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `otel.instrumentation.spring-batch.item.enabled`                              | Boolean | `false` | Enable creating a span for each batch item.                                                                                                                                                                                                                                                                                                             |
| `otel.instrumentation.spring-batch.experimental.chunk.new-trace`              | Boolean | `false` | Enable staring a new trace for each batch chunk.                                                                                                                                                                                                                                                                                                        |
| `otel.instrumentation.spring-batch.experimental-span-attributes`              | Boolean | `false` | Enable the capture of experimental span attributes for Spring Batch version 3.0.                                                                                                                                                                                                                                                                        |
| `otel.instrumentation.spring-integration.global-channel-interceptor-patterns` | List    | `*`     | An array of Spring channel name patterns that will be intercepted. See [Spring Integration docs](https://docs.spring.io/spring-integration/reference/channel/configuration.html#global-channel-configuration-interceptors) for more details.                                                                                                            |
| `otel.instrumentation.spring-integration.producer.enabled`                    | Boolean | `false` | Create producer spans when messages are sent to an output channel. Enable when you're using a messaging library that doesn't have its own instrumentation for generating producer spans. Note that the detection of output channels only works for [Spring Cloud Stream](https://spring.io/projects/spring-cloud-stream) `DirectWithAttributesChannel`. |
| `otel.instrumentation.spring-scheduling.experimental-span-attributes`         | Boolean | `false` | Enable the capture of experimental span attributes for Spring Scheduling version 3.1.                                                                                                                                                                                                                                                                   |
| `otel.instrumentation.spring-webflux.experimental-span-attributes`            | Boolean | `false` | Enable the capture of experimental span attributes for Spring WebFlux version 5.0.                                                                                                                                                                                                                                                                      |
| `otel.instrumentation.spring-webmvc.experimental-span-attributes`             | Boolean | `false` | Enable the capture of experimental span attributes for Spring Web MVC version 3.1.                                                                                                                                                                                                                                                                      |
