# Camel Metrics

Here is the list of metrics based on MBeans exposed by Camel.

| Metric Name                                    | Type          | Attributes                             | Description                                                                                                                                                                                                                                                       |
|------------------------------------------------|---------------|----------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| camel.context.exchange                         | Counter       | context, camelVersion                  | Indicates the total number of exchanges, passed or failed, processed since context start-up or the last reset operation.                                                                                                                                          |
| camel.context.exchange.completed               | Counter       | context, camelVersion                  | Indicates the total number of exchanges processed successfully since context start-up or the last reset operation.                                                                                                                                                |
| camel.context.exchange.failed                  | Counter       | context, camelVersion                  | Indicates the total number of exchanges that failed to process since context start-up or the last reset operation.                                                                                                                                                |
| camel.context.exchange.failed_handled          | Counter       | context, camelVersion                  | Indicates the number of exchanges failed and handled by an ExceptionHandler in the context.                                                                                                                                                                       |
| camel.context.exchange.inflight                | UpDownCounter | context, camelVersion                  | Indicates the number of exchanges currently transiting the context.                                                                                                                                                                                               |
| camel.context.exchange.processing.delta_time   | Gauge         | context, camelVersion                  | Indicates the difference, in milliseconds, of the Processing Time of the last two exchanges transited the context.                                                                                                                                                |
| camel.context.exchange.processing.last_time    | Gauge         | context, camelVersion                  | Indicates the time, in milliseconds, it took to process the last exchange.                                                                                                                                                                                        |
| camel.context.exchange.processing.max_time     | Gauge         | context, camelVersion                  | Indicates the longest time, in milliseconds, to process an exchange since context start-up or the last reset operation.                                                                                                                                           |
| camel.context.exchange.processing.mean_time    | Gauge         | context, camelVersion                  | Indicates the mean processing time, in milliseconds, for all exchanges processed since context start-up or the last reset operation.                                                                                                                              |
| camel.context.exchange.processing.min_time     | Gauge         | context, camelVersion                  | Indicates the shortest time, in milliseconds, to process an exchange since context start-up or the last reset operation.                                                                                                                                          |
| camel.context.exchange.processing.time         | Counter       | context, camelVersion                  | Indicates the total processing time, in milliseconds, to process all exchanges since context start-up or the last reset operation.                                                                                                                                |
| camel.context.exchange.redelivered             | Counter       | context, camelVersion                  | Number of exchanges redelivered (internal only)  since context start-up or the last reset operation.                                                                                                                                                              |
| camel.context.exchange.redelivered_external    | Counter       | context, camelVersion                  | The total number of all external initiated redeliveries (such as from JMS broker) since context start-up or the last reset operation.                                                                                                                             |
| camel.route.exchange                           | Counter       | context, route                         | Indicates the total number of exchanges, passed or failed, that the route has processed since route start-up or the last reset operation.                                                                                                                         |
| camel.route.exchange.completed                 | Counter       | context, route                         | Indicates the total number of exchanges the route has processed successfully since route start-up or the last reset operation.                                                                                                                                    |
| camel.route.exchange.failed                    | Counter       | context, route                         | Indicates the total number of exchanges that the route has failed to process since route start-up or the last reset operation.                                                                                                                                    |
| camel.route.exchange.failed_handled            | Counter       | context, route                         | Indicates the number of exchanges failed and handled by an ExceptionHandler in the route.                                                                                                                                                                         |
| camel.route.exchange.inflight                  | UpDownCounter | context, route                         | Indicates the number of exchanges currently transiting the route.                                                                                                                                                                                                 |
| camel.route.exchange.processing.delta_time     | Gauge         | context, route                         | Indicates the difference, in milliseconds, of the Processing Time of the last two exchanges transited the route.                                                                                                                                                  |
| camel.route.exchange.processing.last_time      | Gauge         | context, route                         | Indicates the time, in milliseconds, it took the route to process the last exchange.                                                                                                                                                                              |
| camel.route.exchange.processing.max_time       | Gauge         | context, route                         | Indicates the longest time, in milliseconds, to process an exchange since the route start-up or the last reset operation.                                                                                                                                         |
| camel.route.exchange.processing.mean_time      | Gauge         | context, route                         | Indicates the mean processing time, in milliseconds, for all exchanges processed since the route start-up or the last reset operation.                                                                                                                            |
| camel.route.exchange.processing.min_time       | Gauge         | context, route                         | Indicates the shortest time, in milliseconds, to process an exchange since the route start-up or the last reset operation.                                                                                                                                        |
| camel.route.exchange.processing.time           | Counter       | context, route                         | Indicates the total processing time, in milliseconds, of all exchanges the selected processed since route start-up or the last reset operation.                                                                                                                   |
| camel.route.exchange.redelivered               | Counter       | context, route                         | Number of exchanges redelivered (internal only)  since route start-up or the last reset operation.                                                                                                                                                                |
| camel.route.exchange.redelivered_external      | Counter       | context, route                         | The total number of all external initiated redeliveries (such as from JMS broker) since the route start-up or the last reset operation.                                                                                                                           |
| camel.processor.exchange                       | Counter       | context, route, processor, destination | Indicates the total number of exchanges, passed or failed, that the selected processor has processed since processor start-up or the last reset operation.                                                                                                        |
| camel.processor.exchange.completed             | Counter       | context, route, processor, destination | Indicates the total number of exchanges the selected processor has processed successfully since processor start-up or the last reset operation.                                                                                                                   |
| camel.processor.exchange.failed                | Counter       | context, route, processor, destination | Indicates the total number of exchanges that the selected processor has failed to process since processor start-up or the last reset operation.                                                                                                                   |
| camel.processor.exchange.inflight              | UpDownCounter | context, route, processor, destination | Indicates the number of exchanges currently transiting the processor.                                                                                                                                                                                             |
| camel.processor.exchange.failed_handled        | Counter       | context, route, processor, destination | Indicates the number of exchanges failed and handled by an ExceptionHandler in the context.                                                                                                                                                                       |
| camel.processor.exchange.processing.delta_time | Gauge         | context, route, processor, destination | Indicates the difference, in milliseconds, of the Processing Time of the last two exchanges transited the selected processor.                                                                                                                                     |
| camel.processor.exchange.processing.last_time  | Gauge         | context, route, processor, destination | Indicates the time, in milliseconds, it took the selected processor to process the last exchange.                                                                                                                                                                 |
| camel.processor.exchange.processing.max_time   | Gauge         | context, route, processor, destination | Indicates the longest time, in milliseconds, to process an exchange since processor start-up or the last reset operation.                                                                                                                                         |
| camel.processor.exchange.processing.mean_time  | Gauge         | context, route, processor, destination | Indicates the mean processing time, in milliseconds, for all exchanges processed since processor start-up or the last reset operation.                                                                                                                            |
| camel.processor.exchange.processing.min_time   | Gauge         | context, route, processor, destination | Indicates the shortest time, in milliseconds, to process an exchange since processor start-up or the last reset operation.                                                                                                                                        |
| camel.processor.exchange.processing.time       | Counter       | context, route, processor, destination | Indicates the total processing time, in milliseconds, to process all exchanges since start-up or the last reset operation.                                                                                                                                        |
| camel.processor.exchange.redelivered           | Counter       | context, route, processor, destination | Number of exchanges redelivered (internal only)  since selected processor start-up or the last reset operation.                                                                                                                                                   |
| camel.processor.exchange.redelivered_external  | Counter       | context, route, processor, destination | The total number of all external initiated redeliveries (such as from JMS broker) since processor start-up or the last reset operation.                                                                                                                           |
| camel.threadpool.active                        | UpDownCounter | context, route                         | The approximate number of threads that are actively executing tasks.                                                                                                                                                                                              |
| camel.threadpool.pool.size                     | UpDownCounter | context, route                         | The current number of threads in the pool.                                                                                                                                                                                                                        |
| camel.threadpool.pool.largest_size             | Gauge         | context, route                         | The largest number of threads that have ever simultaneously been in the pool.                                                                                                                                                                                     |
| camel.threadpool.task                          | Counter       | context, route                         | The approximate total number of tasks that have ever been scheduled for execution.                                                                                                                                                                                |
| camel.threadpool.task.completed                | Counter       | context, route                         | The approximate total number of tasks that have completed execution. Because the states of tasks and threads may change dynamically during computation, the returned value is only an approximation, but one that does not ever decrease across successive calls. |
| camel.threadpool.task.queue_size               | UpDownCounter | context, route                         | The number of Tasks in the Task Queue.                                                                                                                                                                                                                            |
