# 分支

本文档旨在全面解释 MMOCR 中每个分支的目的和功能。

## 分支概述

### 1. `main`

`main` 分支是 MMOCR 项目的默认分支。它包含了 MMOCR 的最新稳定版本，目前包含了 MMOCR 1.x（例如 v1.0.0）的代码。`main` 分支确保用户能够使用最新和最可靠的软件版本。

### 2. `dev-1.x`

`dev-1.x` 分支用于开发 MMOCR 的下一个版本。此分支将在发版前进行依赖性测试，通过的提交将会合成到新版本中，并被发布到 `main` 分支。通过设置单独的开发分支，项目可以在不影响 `main` 分支稳定性的情况下继续发展。**所有 PR 应合并到 `dev-1.x` 分支。**

### 3. `0.x`

`0.x` 分支用作 MMOCR 0.x（例如 v0.6.3）的存档。此分支将不再积极接受更新或改进，但它仍可作为历史参考，或供尚未升级到 MMOCR 1.x 的用户使用。

### 4. `1.x`

它是 `main` 分支的别名，旨在实现从兼容性时期平稳过渡。它将在 2023 年的年中删除。

```{note}
分支映射在 2023.04.06 发生了变化。有关旧分支映射和迁移指南，请参阅[分支迁移指南](../migration/branches.md)。
```
