## NLP 2019 Highlights
2019 was an impressive year for the field of natural language processing (NLP). In this report, I want to highlight some of the most important stories related to machine learning and NLP that I came across in 2019. I will mostly focus on NLP but I will also highlight a few interesting stories related to AI in general. The headlines are in no particular order. Stories may include publications, engineering efforts, yearly reports, the release of educational resources, etc.

[PDF of "NLP 2019 Highlights"](https://github.com/omarsar/nlp_highlights/blob/master/NLP_2019_Highlights.pdf)

---

## NLP 2018 Highlights

It has been a big year for the field of natural language processing (NLP) and for machine learning as a whole. There have been many trends and breaking stories, with state-of-the-art results and new interesting research directions emerging. We owe all of this progress to the brilliant researchers around the world and the millions of developers devoting their full time to improve tools that make it easier for everyone to learn and progress the field. We have witnessed a rise in transfer learning and other niche areas of research such as AI Ethics.

In this report, I have provided a summary of all the biggest NLP stories of the year (2018) coming from both academia and the industry. I hope this report serves as a guide for the researcher and developer that wishes to start learning about this field and also for the expert who wishes to brush up on some of the latest advancements. The selected topics are based purely on personal observation, so it is highly possible that I missed other important stories. In fact, the stories shared here are an extended compilation of the NLP Newsletter published weekly on the [dair.ai](https://medium.com/dair-ai) publication. I have made an effort to categorize the stories in the best possible way so that the report could benefit as many readers as possible. Please note that the report is meant to be non-technical for the purpose of reaching as many diverse readers as possible. The stories are mainly categorized by the following key topics: AI ethics, research publications, trends, education, resources, industry, and much more.

[PDF of "NLP 2018 Highlights"](https://github.com/omarsar/nlp_highlights/blob/master/NLP_2018_Highlights.pdf)

---
If you are interested in extending this report for the upcoming year (2020), get in touch with me through Twitter ([@omarsar0](https://twitter.com/omarsar0)) or at ellfae@gmail.com.

If you use this report as reference, please cite:

```
@misc{saravia2019nlp,
  title={NLP Year in Review — 2019},
  author={Saravia, Elvis},
  journal={https://dair.ai/NLP\_Year\_in\_Review-2019/},
  year={2019}
}
```
