﻿using Mosaik.Core;
using System;
using System.Collections.Generic;
using System.Text;

namespace languages.LanguageDetection
{
    public static class Data
    {
        //Samples from List of pangrams, available here http://clagnut.com/blog/2380/

        public static Dictionary<Language, string> ShortSamples = new Dictionary<Language, string>()
        {
            [Language.English] = "The quick brown fox jumps over the lazy dog.",
            [Language.Arabic] = "صِف خَلقَ خَودِ كَمِثلِ الشَمسِ إِذ بَزَغَت — يَحظى الضَجيعُ بِها نَجلاءَ مِعطارِ",
            [Language.Bulgarian] = "Ах чудна българска земьо, полюшвай цъфтящи жита.",
            [Language.Catalan] = "Jove xef, porti whisky amb quinze glaçons d’hidrogen, coi!",
            [Language.Croatian] = "Gojazni đačić s biciklom drži hmelj i finu vatu u džepu nošnje.",
            [Language.Czech] = "Nechť již hříšné saxofony ďáblů rozezvučí síň úděsnými tóny waltzu, tanga a quickstepu.",
            [Language.Danish] = "Quizdeltagerne spiste jordbær med fløde, mens cirkusklovnen Walther spillede på xylofon.",
            [Language.Esperanto] = "Laŭ Ludoviko Zamenhof bongustas freŝa ĉeĥa manĝaĵo kun spicoj.",
            [Language.Estonian] = "Põdur Zagrebi tšellomängija-följetonist Ciqo külmetas kehvas garaažis",
            [Language.Finnish] = "Hyvän lorun sangen pieneksi hyödyksi jäi suomen kirjaimet.",
            [Language.French] = "Portez ce vieux whisky au juge blond qui fume",
            [Language.German] = "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern",
            [Language.Greek_Modern] = "Ταχίστη αλώπηξ βαφής ψημένη γη, δρασκελίζει υπέρ νωθρού κυνός",
            [Language.Hebrew] = "דג סקרן שט בים מאוכזב ולפתע מצא חברה dg sqrn šṭ bjM mʾwkzb wlptʿ mṣʾ ḥbrh",
            [Language.Hindi] = "ऋषियों को सताने वाले दुष्ट राक्षसों के राजा रावण का सर्वनाश करने वाले विष्णुवतार भगवान श्रीराम, अयोध्या के महाराज दशरथ के बड़े सपुत्र थे।",
            [Language.Hungarian] = "Jó foxim és don Quijote húszwattos lámpánál ülve egy pár bűvös cipőt készít",
            [Language.Icelandic] = "Kæmi ný öxi hér, ykist þjófum nú bæði víl og ádrepa.",
            [Language.Indonesian] = "Muharjo seorang xenofobia universal yang takut pada warga jazirah, contohnya Qatar.",
            [Language.Irish] = "D’fhuascail Íosa Úrmhac na hÓighe Beannaithe pór Éava agus Ádhaimh",
            [Language.Italian] = "Quel vituperabile xenofobo zelante assaggia il whisky ed esclama: alleluja!",
            [Language.Japanese] = "いろはにほへと ちりぬるを わかよたれそ つねならむ うゐのおくやま けふこえて あさきゆめみし ゑひもせす（ん）",
            [Language.Javanese] = "꧋ ꦲꦤꦕꦫꦏ꧈ ꦢꦠꦱꦮꦭ꧈ ꦥꦝꦗꦪꦚ꧈ ꦩꦒꦧꦛꦔ꧉ Hanacaraka, datasawala, padhajayanya, magabathanga.",
            [Language.Korean] = "키스의 고유조건은 입술끼리 만나야 하고 특별한 기술은 필요치 않다.",
            [Language.Latvian] = "Muļķa hipiji mēģina brīvi nogaršot celofāna žņaudzējčūsku.",
            [Language.Lithuanian] = "Įlinkdama fechtuotojo špaga sublykčiojusi pragręžė apvalų arbūzą",
            [Language.Macedonian] = "Ѕидарски пејзаж: шугав билмез со чудење џвака ќофте и кељ на туѓ цех.",
            [Language.Malay] = "അജവും ആനയും ഐരാവതവും ഗരുഡനും കഠോര സ്വരം പൊഴിക്കെ ഹാരവും ഒഢ്യാണവും ഫാലത്തില്‍ മഞ്ഞളും ഈറന്‍ കേശത്തില്‍ ഔഷധ എണ്ണയുമായി ഋതുമതിയും അനഘയും ഭൂനാഥയുമായ ഉമ ദുഃഖഛവിയോടെ ഇടതു പാദം ഏന്തി ങ്യേയാദൃശം നിര്‍ഝരിയിലെ ചിറ്റലകളെ ഓമനിക്കുമ്പോള്‍ ബാ‍ലയുടെ കണ്‍കളില്‍ നീര്‍ ഊര്‍ന്നു വിങ്ങി.",
            [Language.Mongolian] = "Щётканы фермд пийшин цувъя. Бөгж зогсч хэльюү.",
            [Language.Norwegian] = "Vår sære Zulu fra badeøya spilte jo whist og quickstep i min taxi.",
            [Language.Polish] = "Jeżu klątw, spłódź Finom część gry hańb!",
            [Language.Portuguese] = "Um pequeno jabuti xereta viu dez cegonhas felizes.",
            [Language.Romanian] = "Muzicologă în bej vând whisky și tequila, preț fix.",
            [Language.Russian] = "Эх, чужак, общий съём цен шляп (юфть) – вдрызг!",
            [Language.Serbian] = "Gojazni đačić s biciklom drži hmelj i finu vatu u džepu nošnje.",
            [Language.Slovak] = "Kŕdeľ šťastných ďatľov učí pri ústí Váhu mĺkveho koňa obhrýzať kôru a žrať čerstvé mäso.",
            [Language.Slovenian] = "Besni dirkač iz formule žuga cehu poštarjev.",
            [Language.Spanish] = "José compró una vieja zampoña en Perú. Excusándose, Sofía tiró su whisky al desagüe de la banqueta.",
            [Language.Swedish] = "Flygande bäckasiner söka hwila på mjuka tuvor.",
            [Language.Thai] = "เป็นมนุษย์สุดประเสริฐเลิศคุณค่า กว่าบรรดาฝูงสัตว์เดรัจฉาน จงฝ่าฟันพัฒนาวิชาการ อย่าล้างผลาญฤๅเข่นฆ่าบีฑาใคร ไม่ถือโทษโกรธแช่งซัดฮึดฮัดด่า หัดอภัยเหมือนกีฬาอัชฌาสัย ปฏิบัติประพฤติกฎกำหนดใจ พูดจาให้จ๊ะๆ จ๋าๆ น่าฟังเอยฯ",
            [Language.Turkish] = "Pijamalı hasta yağız şoföre çabucak güvendi.",
            [Language.Ukrainian] = "Жебракують філософи при ґанку церкви в Гадячі, ще й шатро їхнє п’яне знаємо.",
            [Language.Urdu] = "ٹھنڈ میں، ایک قحط زدہ گاؤں سے گذرتے وقت ایک چڑچڑے، باأثر و فارغ شخص کو بعض جل پری نما اژدہے نظر آئے۔",
            [Language.Yoruba] = "Ìwò̩fà ń yò̩ séji tó gbojúmó̩, ó hàn pákànpò̩ gan-an nis̩é̩ rè̩ bó dò̩la.",
            [Language.Welsh] = "Parciais fy jac codi baw hud llawn dŵr ger tŷ Mabon.",
        };

        public static Dictionary<Language, string> LongSamples = new Dictionary<Language, string>()
        {
            [Language.English] = "There is an increasing need to deal with multi-lingual documents today. If we could segment multi-lingual documents language-wise, it would be very useful both for exploration of linguistic phenomena, such as code-switching and code mixing, and for computational processing of each segment as appropriate. Identification of language from a given small piece of text is therefore an important problem. This paper is about language identification from small text samples.",
            [Language.Arabic] = "هناك حاجة متزايدة للتعامل مع الوثائق متعددة اللغات اليوم. إذا استطعنا تقسيم مستندات متعددة اللغات بلغة حكيمة ، فسيكون ذلك مفيدًا جدًا لاستكشاف الظواهر اللغوية ، مثل تبديل الشفرة وخلط الكود ، والمعالجة الحسابية لكل مقطع حسب الاقتضاء. لذلك فإن تحديد اللغة من جزء صغير من النص يمثل مشكلة مهمة. هذه الورقة تدور حول تحديد اللغة من عينات نصية صغيرة.",
            [Language.Bulgarian] = "Днес има все по-голяма необходимост от справяне с многоезични документи. Ако можем да сегментираме езикови документи на много езици, би било много полезно както за изследване на езикови явления, като превключване на кодове и смесване на кодове, така и за изчислителна обработка на всеки сегмент, според случая. Следователно идентифицирането на езика от даден малък текст е важен проблем. Тази статия е за идентификация на езика от малки текстови проби.",
            [Language.Catalan] = "Hi ha una necessitat creixent de tractar els documents multilingües avui en dia. Si poguéssim segmentar documents multilingües en sentit lingüístic, seria molt útil tant per a l'exploració de fenòmens lingüístics, com ara el canvi de codis i la barreja de codis, i per al processament computacional de cada segment, segons convingui. Per tant, la identificació del llenguatge a partir d'un petit text és un problema important. Aquest article tracta sobre la identificació del llenguatge a partir de petites mostres de text.",
            [Language.Croatian] = "Danas je sve veća potreba za rješavanjem višejezičnih dokumenata. Ako možemo jezične segmentirati višejezične dokumente, bilo bi vrlo korisno i za istraživanje jezičnih pojava, kao što su prebacivanje koda i miješanje koda, te za računalnu obradu svakog segmenta, prema potrebi. Identifikacija jezika iz određenog malog teksta je stoga važan problem. Ovaj rad govori o prepoznavanju jezika iz malih uzoraka teksta.",
            [Language.Czech] = "V dnešní době narůstá potřeba zabývat se vícejazyčnými dokumenty. Kdybychom mohli segmentovat vícejazyčné dokumenty jazykem, bylo by to velmi užitečné jak pro zkoumání lingvistických jevů, jako je přepínání kódu a míchání kódu, a pro výpočetní zpracování každého segmentu podle potřeby. Identifikace jazyka z daného malého textu je proto důležitým problémem. Tato práce pojednává o identifikaci jazyka z malých textových ukázek.",
            [Language.Danish] = "Der er et stigende behov for at behandle flersprogede dokumenter i dag. Hvis vi kunne segmentere flersprogede dokumenter sprogligt, ville det være meget nyttigt både til udforskning af sproglige fænomener, såsom kodeskift og kodeblanding, og til beregningsbehandling af hvert segment efter behov. Identifikation af sprog fra et givet lille stykke tekst er derfor et vigtigt problem. Dette papir handler om sprogidentifikation fra små teksteksempler.",
            [Language.Esperanto] = "Estas kreskanta bezono trakti hodiaŭ plurlingvajn dokumentojn. Se ni povus segmentigi plurlingvajn dokumentojn lingve saĝajn, ĝi estus tre utila tiel por esplorado de lingvaj fenomenoj, kiel ekzemple interŝanĝo de kodoj kaj miksado de kodoj, kaj por komputila prilaborado de ĉiu segmento laŭbezone. Identigo de lingvo el difinita malgranda teksto estas tial grava problemo. Ĉi tiu papero temas pri lingva identigo de malgrandaj tekstoj.",
            [Language.Estonian] = "Täna on üha suurem vajadus tegeleda mitmekeelsete dokumentidega. Kui saaksime mitmekeelsed dokumendid keeleliselt segmentida, oleks see väga kasulik nii keeleliste nähtuste uurimiseks, nagu koodide vahetamine ja koodide segamine, kui ka iga segmendi arvutuslikuks töötlemiseks vastavalt vajadusele. Keele tuvastamine antud väikese tekstiosa põhjal on seetõttu oluline probleem. Selles artiklis käsitletakse keele tuvastamist väikeste tekstinäidete põhjal.",
            [Language.Finnish] = "Monikielisten asiakirjojen käsittely on nykyään kasvava tarve. Jos pystymme segmentoimaan monikieliset asiakirjat kielellisesti, se olisi erittäin hyödyllinen sekä kielellisten ilmiöiden tutkimiseen, kuten koodinvaihto tai koodin sekoitus, että kunkin segmentin laskennalliseen käsittelyyn tarvittaessa. Kielen tunnistaminen tietystä pienestä tekstistä on siksi tärkeä ongelma. Tämä artikkeli käsittelee kielen tunnistamista pienistä tekstinäytteistä.",
            [Language.French] = "De nos jours, il est de plus en plus nécessaire de traiter des documents multilingues. Si nous pouvions segmenter les documents multilingues d'un point de vue linguistique, cela serait très utile à la fois pour l'exploration de phénomènes linguistiques, tels que la commutation de code et le mélange de code, et pour le traitement informatique de chaque segment, le cas échéant. L'identification de la langue à partir d'un petit texte donné est donc un problème important. Ce document concerne l'identification de la langue à partir de petits échantillons de texte.",
            [Language.German] = "Heutzutage besteht ein zunehmender Bedarf an mehrsprachigen Dokumenten. Wenn wir mehrsprachige Dokumente sprachlich segmentieren könnten, wäre dies sowohl für die Erforschung sprachlicher Phänomene wie Code-Switching und Code-Mixing als auch für die entsprechende Verarbeitung der einzelnen Segmente von großem Nutzen. Die Identifizierung der Sprache aus einem bestimmten kleinen Textstück ist daher ein wichtiges Problem. In diesem Artikel geht es um die Spracherkennung anhand kleiner Textbeispiele.",
            [Language.Greek_Modern] = "Υπάρχει μια αυξανόμενη ανάγκη να ασχοληθούμε σήμερα με πολύγλωσσα έγγραφα. Αν μπορούσαμε να χωρίσουμε τα γλωσσικά πολυγλωσσικά έγγραφα, θα ήταν πολύ χρήσιμο τόσο για την εξερεύνηση των γλωσσικών φαινομένων, όπως για την αλλαγή κώδικα και για την ανάμιξη κώδικα, όσο και για την υπολογιστική επεξεργασία κάθε τμήματος, ανάλογα με την περίπτωση. Η αναγνώριση της γλώσσας από ένα μικρό κομμάτι κειμένου είναι επομένως ένα σημαντικό πρόβλημα. Αυτό το έγγραφο αφορά την αναγνώριση γλώσσας από μικρά δείγματα κειμένου.",
            [Language.Hebrew] = "ישנו צורך גובר והולך להתמודד עם מסמכים רב-לשוניים כיום. אם היינו יכולים לפלח מסמכים רב-לשוניים מבחינה שפה, זה היה מועיל מאוד הן לבחינת תופעות לשוניות, כמו החלפת קוד ועירוב קוד, והן לצורך עיבוד חישובי של כל קטע לפי הצורך. לפיכך זיהוי השפה מתוך פיסת טקסט קטנה נתונה היא בעיה חשובה. מאמר זה עוסק בזיהוי שפה מדגימות טקסט קטנות.",
            [Language.Hindi] = "आज बहुभाषी दस्तावेजों से निपटने की आवश्यकता है। यदि हम बहु-भाषी दस्तावेजों को भाषा-वार खंड कर सकते हैं, तो यह भाषाई घटना की खोज, जैसे कोड-स्विचिंग और कोड मिश्रण, और उपयुक्त के रूप में प्रत्येक खंड के कम्प्यूटेशनल प्रसंस्करण के लिए दोनों के लिए बहुत उपयोगी होगा। पाठ के एक छोटे टुकड़े से भाषा की पहचान इसलिए एक महत्वपूर्ण समस्या है। यह पत्र छोटे पाठ नमूनों से भाषा पहचान के बारे में है।",
            [Language.Hungarian] = "Ma egyre nagyobb szükség van a többnyelvű dokumentumok kezelésére. Ha fel tudjuk osztani a többnyelvű dokumentumokat nyelvenként, akkor nagyon hasznos lenne mind a nyelvi jelenségek feltárására, például a kódváltásra és a kódkeverésre, mind pedig az egyes szegmensek számításos feldolgozására. Ezért fontos probléma a nyelv azonosítása egy adott kis szövegből. Ez a cikk a nyelvi azonosításról szól a kis szövegminták alapján.",
            [Language.Icelandic] = "Það er vaxandi þörf á að fást við fjölþjóðleg skjöl í dag. Ef við gætum skipt upp fjöltungnum skjölum tungumálum, þá væri það mjög gagnlegt bæði við könnun á málfyrirbærum, svo sem kóðaskiptum og kóðablöndun, og til tölvuvinnslu á hverjum þætti eftir því sem við á. Að bera kennsl á tungumál úr tilteknu litla texta er því mikilvægt vandamál. Þessi grein fjallar um tungumálamerkingu úr litlum textasýnum.",
            [Language.Indonesian] = "Ada kebutuhan yang semakin meningkat untuk berurusan dengan dokumen multi-bahasa saat ini. Jika kita dapat mengelompokkan dokumen multi-bahasa dengan menggunakan bahasa, akan sangat berguna baik untuk eksplorasi fenomena linguistik, seperti alih kode dan pencampuran kode, dan untuk pemrosesan komputasi setiap segmen yang sesuai. Identifikasi bahasa dari sepotong kecil teks tertentu merupakan masalah penting. Makalah ini adalah tentang identifikasi bahasa dari sampel teks kecil.",
            [Language.Irish] = "Tá gá méadaitheach le déileáil le doiciméid ilteangacha inniu. Dá mbeimis ábalta doiciméid ilteangacha a dheighilt ó thaobh na teanga de, bheadh sé an-úsáideach araon chun feiniméin teanga a iniúchadh, amhail athrú cód agus meascadh cód, agus próiseáil ríomhaireachtúil gach deighleog mar is cuí. Is fadhb thábhachtach é dá bhrí sin teanga a aithint ó phíosa beag téacs ar leith. Baineann an páipéar seo le haitheantas teanga ó shamplaí beaga téacs.",
            [Language.Italian] = "Oggi c'è una crescente necessità di trattare documenti multilingue. Se potessimo segmentare i documenti multilingue in termini linguistici, sarebbe molto utile sia per l'esplorazione di fenomeni linguistici, come la commutazione del codice e la miscelazione del codice, sia per l'elaborazione computazionale di ciascun segmento, se del caso. L'identificazione della lingua da una determinata porzione di testo è quindi un problema importante. Questo documento riguarda l'identificazione della lingua da piccoli esempi di testo.",
            [Language.Japanese] = "今日、多言語ドキュメントを扱う必要性が高まっています。 多言語ドキュメントを言語ごとに分割できれば、コード切り替えやコード混合などの言語現象の調査と、必要に応じて各セグメントの計算処理の両方に非常に役立ちます。 したがって、特定の小さなテキストから言語を識別することは重要な問題です。 このペーパーは、小さなテキストサンプルからの言語識別に関するものです。",
            [Language.Javanese] = "Ana akeh kebutuhan kanggo ngatasi dokumen pirang-pirang dina. Yen kita bisa mbagi pirang-pirang dokumen basa sing wicaksana, bisa uga migunani kanggo eksplorasi fénoména linguistik, kayata kodhe pertukaran lan kode nyampur, lan pamrosesan komputasional saben segmen sing cocog. Identifikasi basa saka potongan teks sing cilik mula dadi masalah sing penting. Makalah iki babagan identifikasi basa saka conto teks cilik.",
            [Language.Korean] = "오늘날 다국어 문서를 다루어야 할 필요성이 증가하고 있습니다. 다국어 문서를 언어 단위로 분할 할 수 있다면 코드 전환 및 코드 믹싱과 같은 언어 현상을 탐색하고 각 세그먼트를 적절하게 계산 처리하는 데 매우 유용합니다. 주어진 작은 텍스트에서 언어를 식별하는 것은 중요한 문제입니다. 이 문서는 작은 텍스트 샘플에서 언어를 식별하는 것에 관한 것입니다.",
            [Language.Latvian] = "Mūsdienās arvien vairāk ir jārisina daudzvalodu dokumenti. Ja mēs varētu segmentēt daudzvalodu dokumentus valodas ziņā, tas būtu ļoti noderīgi gan lingvistisko parādību izpētei, piemēram, koda maiņai un koda sajaukšanai, gan katra segmenta aprēķinamai apstrādei pēc vajadzības. Tādēļ svarīga problēma ir valodas identificēšana no dota neliela teksta. Šis raksts ir par valodas identificēšanu no maziem teksta paraugiem.",
            [Language.Lithuanian] = "Šiandien didėja poreikis tvarkyti daugiakalbius dokumentus. Jei galėtume segmentuoti daugiakalbius dokumentus kalbine prasme, tai būtų labai naudinga tyrinėjant kalbinius reiškinius, tokius kaip kodo perjungimas ir kodų maišymas, ir atitinkamai kiekvieno kompiuterio segmento apdorojimą. Taigi kalbos identifikavimas iš tam tikro mažo teksto yra svarbi problema. Šis straipsnis yra apie kalbos identifikavimą iš mažų teksto pavyzdžių.",
            [Language.Macedonian] = "Денес се зголемува потребата да се справиме со повеќејазични документи. Ако можеме да ги сегментираме јазиците на повеќе јазици, тоа би било многу корисно и за истражување на јазични феномени, како што се префрлување на кодови и мешање на шифри и за компјутерска обработка на секој сегмент како што е соодветно. Затоа, идентификувањето на јазикот од даден мал дел од текстот е важен проблем. Овој труд е за јазична идентификација од мали примероци на текст.",
            [Language.Malay] = "Terdapat keperluan yang semakin meningkat untuk menangani dokumen pelbagai bahasa hari ini. Sekiranya kita dapat menyatukan dokumen-dokumen pelbagai bahasa bahasa-bijak, ia akan sangat berguna untuk penerokaan fenomena linguistik, seperti pengalihan kod dan pencampuran kod, dan untuk memproses pengiraan setiap segmen yang sesuai. Oleh itu, pengenalan bahasa dari teks kecil yang diberikan adalah masalah penting. Kertas ini adalah mengenai pengenalan bahasa dari sampel teks kecil.",
            [Language.Mongolian] = "Өнөөдөр олон хэл дээр бичиг баримттай харьцах хэрэгцээ нэмэгдэж байна. Хэрэв бид олон хэл дээрх баримтуудыг хэлээр мэргэшүүлж чадвал код шилжих, код холих гэх мэт хэл шинжлэлийн үзэгдлийг судлах, хэсэг тус бүрийг тооцооллын дагуу боловсруулахад маш их хэрэгтэй болно. Тиймээс өгөгдсөн жижиг текстээс хэлийг таних нь чухал асуудал юм. Энэ баримт нь жижиг текстийн дээжээс хэлний танилтын талаар юм.",
            [Language.Norwegian] = "Det er et økende behov for å håndtere flerspråklige dokumenter i dag. Hvis vi kunne segmentere flerspråklige dokumenter språkmessig, ville det være veldig nyttig både for utforsking av språklige fenomener, for eksempel kodebytte og kodeblanding, og for beregningsbehandling av hvert segment etter behov. Identifisering av språk fra et gitt lite stykke tekst er derfor et viktig problem. Denne artikkelen handler om språkidentifikasjon fra små tekstprøver.",
            [Language.Polish] = "Obecnie rośnie potrzeba zajmowania się dokumentami wielojęzycznymi. Gdybyśmy mogli segmentować dokumenty wielojęzyczne pod względem językowym, byłoby to bardzo przydatne zarówno do badania zjawisk językowych, takich jak przełączanie kodów i miksowanie kodów, jak i do przetwarzania obliczeniowego każdego segmentu, stosownie do przypadku. Ważnym problemem jest zatem identyfikacja języka na podstawie małego fragmentu tekstu. Ten artykuł dotyczy identyfikacji języka na podstawie małych próbek tekstu.",
            [Language.Portuguese] = "Atualmente, há uma necessidade crescente de lidar com documentos multilíngues. Se pudéssemos segmentar documentos multilíngues em termos de idioma, seria muito útil tanto para a exploração de fenômenos linguísticos, como troca de código e mistura de código, quanto para o processamento computacional de cada segmento, conforme apropriado. A identificação da linguagem a partir de um pequeno pedaço de texto é, portanto, um problema importante. Este artigo trata da identificação de idiomas em pequenas amostras de texto.",
            [Language.Romanian] = "Există o nevoie din ce în ce mai mare de a trata documentele multilingve astăzi. Dacă am putea segmenta documente multilingve în limbaj, ar fi foarte util atât pentru explorarea fenomenelor lingvistice, cum ar fi comutarea codurilor și amestecarea codurilor, cât și pentru prelucrarea computațională a fiecărui segment, după caz. Identificarea limbajului dintr-o mică bucată de text este, așadar, o problemă importantă. Acest referat se referă la identificarea limbii din probe de text mici.",
            [Language.Russian] = "В настоящее время возрастает потребность в работе с многоязычными документами. Если бы мы могли сегментировать многоязычные документы по языку, это было бы очень полезно как для изучения лингвистических явлений, таких как переключение кода и смешивание кода, так и для вычислительной обработки каждого сегмента в зависимости от ситуации. Поэтому идентификация языка по данному небольшому фрагменту текста является важной проблемой. Эта статья о языковой идентификации по небольшим текстовым образцам.",
            [Language.Serbian] = "Данас је све већа потреба за бављењем вишејезичним документима. Ако бисмо могли језички сегментирати вишејезичне документе, било би корисно и за истраживање језичких појава, као што су пребацивање кода и мешање кода, као и за рачунску обраду сваког сегмента, према потреби. Идентификација језика из одређеног малог дела текста је стога важан проблем. Овај рад говори о идентификацији језика из малих узорака текста.",
            [Language.Slovak] = "V súčasnosti je čoraz viac potrebné zaoberať sa viacjazyčnými dokumentmi. Keby sme mohli segmentovať viacjazyčné dokumenty jazykovo, bolo by to veľmi užitočné tak pre skúmanie jazykových javov, ako je prepínanie kódov a zmiešavanie kódov, ako aj pre počítačové spracovanie každého segmentu podľa potreby. Identifikácia jazyka z daného malého textu je preto dôležitým problémom. Tento príspevok pojednáva o jazykovej identifikácii malých vzoriek textu.",
            [Language.Slovenian] = "Danes je vse večja potreba po obravnavi večjezičnih dokumentov. Če bi lahko jezikovno segmentirali večjezične dokumente, bi bilo to zelo koristno tako za raziskovanje jezikovnih pojavov, kot sta preklop kode in mešanje kode, kot tudi za računalniško obdelavo vsakega segmenta. Prepoznavanje jezika iz določenega majhnega besedila je zato pomemben problem. Ta članek govori o jezikovni identifikaciji iz majhnih vzorcev besedila.",
            [Language.Spanish] = "Hay una creciente necesidad de lidiar con documentos multilingües hoy. Si pudiéramos segmentar documentos multilingües en términos lingüísticos, sería muy útil tanto para la exploración de fenómenos lingüísticos, como el cambio de código y la mezcla de código, como para el procesamiento computacional de cada segmento, según corresponda. La identificación del lenguaje a partir de un pequeño texto dado es, por lo tanto, un problema importante. Este documento trata sobre la identificación del idioma a partir de pequeñas muestras de texto.",
            [Language.Swedish] = "Det finns ett ökande behov av att hantera flerspråkiga dokument idag. Om vi kunde segmentera flerspråkiga dokument språkmässigt, skulle det vara mycket användbart både för utforskning av språkliga fenomen, såsom kodbyte och kodblandning, och för beräkning av varje segment efter behov. Identifiering av språk från en viss textbit är därför ett viktigt problem. Detta papper handlar om språkidentifiering från små textprover.",
            [Language.Thai] = "มีความต้องการเพิ่มขึ้นในการจัดการกับเอกสารหลายภาษาในวันนี้ หากเราสามารถแบ่งเอกสารหลายภาษาเป็นภาษาที่ชาญฉลาดมันจะมีประโยชน์มากสำหรับการสำรวจปรากฏการณ์ทางภาษาเช่นการสลับรหัสและการผสมรหัสและสำหรับการประมวลผลการคำนวณของแต่ละส่วนตามความเหมาะสม การระบุภาษาจากข้อความตัวเล็ก ๆ นั้นเป็นปัญหาที่สำคัญ บทความนี้เกี่ยวกับการระบุภาษาจากตัวอย่างข้อความขนาดเล็ก",
            [Language.Turkish] = "Bugün çok dilli belgelerle ilgilenmek için artan bir ihtiyaç var. Çok dilli belgeleri dil olarak bölümlere ayırabilirsek, hem kod değiştirme hem de kod karıştırma gibi dilbilimsel olayları araştırmak ve her bir parçanın uygun şekilde işlemden geçirilmesi için çok yararlı olacaktır. Dilin verilen küçük bir metinden tanımlanması bu nedenle önemli bir sorundur. Bu makale küçük metin örneklerinden dil tanımlama ile ilgilidir.",
            [Language.Ukrainian] = "Сьогодні зростає потреба в роботі з багатомовними документами. Якби ми могли сегментувати багатомовні документи на мові, це було б дуже корисно як для вивчення лінгвістичних явищ, таких як переключення коду та змішування коду, так і для обчислювальної обробки кожного сегмента, якщо це доречно. Отже, ідентифікація мови з певного невеликого тексту є важливою проблемою. У цьому документі йдеться про ідентифікацію мови з невеликих зразків тексту.",
            [Language.Urdu] = "آج کثیر لسانی دستاویزات سے نمٹنے کی ضرورت بڑھ رہی ہے۔ اگر ہم زبان کے لحاظ سے کثیر لسانی دستاویزات کا طبقہ بناسکتے ہیں تو ، یہ لسانی مظاہر کی تلاش ، جیسے کوڈ سوئچنگ اور کوڈ مکسنگ ، اور ہر طبقے کی کمپیوٹیشنل پروسیسنگ کے لئے بہت مفید ہوگا۔ لہذا کسی مخصوص متن کے ٹکڑے سے زبان کی شناخت ایک اہم مسئلہ ہے۔ یہ کاغذ چھوٹے متن کے نمونوں سے زبان کی شناخت کے بارے میں ہے۔",
            [Language.Yoruba] = "Iwulo npo si wa lati ba awọn iwe aṣẹ liluho ọpọlọpọ-ede lode oni. Ti a ba le ṣe awọn iwe aṣẹ ọpọlọpọ awọn iwe-ede oniruru ede-ọlọgbọn, o yoo wulo pupọ fun iṣawakiri awọn iyasọtọ ede, bii yiyi koodu ati isọpọ koodu, ati fun sisilẹ iṣiro ti apakan kọọkan bi o ṣe yẹ. Idanimọ ede lati ọdọ nkan kekere ti a fun ni nitorina iṣoro pataki. Iwe yii jẹ nipa idanimọ ede lati awọn ayẹwo ọrọ kekere.",
            [Language.Welsh] = "Mae angen cynyddol i ddelio â dogfennau amlieithog heddiw. Pe gallem segmentu dogfennau amlieithog yn ddoeth o ran iaith, byddai'n ddefnyddiol iawn ar gyfer archwilio ffenomenau ieithyddol, megis newid cod a chymysgu cod, ac ar gyfer prosesu cyfrifiadol pob segment fel sy'n briodol. Felly mae adnabod iaith o ddarn bach penodol o destun yn broblem bwysig. Mae'r papur hwn yn ymwneud ag adnabod iaith o samplau testun bach.",
        };

    }
}