import FakeRest from "fakerest";
import fetchMock from "fetch-mock";
import generateData from "./data";

export default () => {
  const data = generateData({ serializeDate: true });
  const restServer = new FakeRest.FetchServer("http://localhost:3000");
  if (window) {
    window.restServer = restServer; // give way to update data in the console
  }
  restServer.init(data);
  restServer.toggleLogging(); // logging is off by default, enable it
  fetchMock.mock("begin:http://localhost:3000", restServer.getHandler());
  return () => fetchMock.restore();
};
