// Copyright (c) 2018, Peter Ohler, All rights reserved.

#ifndef AGOO_PUB_H
#define AGOO_PUB_H

#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

struct _agooText;
struct _agooUpgraded;
struct _agooSubject;

typedef enum {
    AGOO_PUB_SUB	= 'S',
    AGOO_PUB_CLOSE	= 'C',
    AGOO_PUB_UN		= 'U',
    AGOO_PUB_MSG	= 'M',
    AGOO_PUB_WRITE	= 'W',
} agooPubKind;

// Generated by extened handlers and placed on the pub_queue to be pulled off
// in the con_loop.
typedef struct _agooPub {
    struct _agooPub		*next;
    agooPubKind			kind;
    struct _agooUpgraded	*up;
    struct _agooSubject		*subject;
    struct _agooText		*msg;
} *agooPub;

extern agooPub	agoo_pub_close(struct _agooUpgraded *up);
extern agooPub	agoo_pub_subscribe(struct _agooUpgraded *up, const char *subject, int slen);
extern agooPub	agoo_pub_unsubscribe(struct _agooUpgraded *up, const char *subject, int slen);
extern agooPub	agoo_pub_publish(const char *subject, int slen, const char *message, size_t mlen);
extern agooPub	agoo_pub_write(struct _agooUpgraded *up, const char *message, size_t mlen, bool bin);
extern agooPub	agoo_pub_dup(agooPub src);
extern void	agoo_pub_destroy(agooPub pub);

#endif // AGOO_PUB_H
