<?php
return [
    'home_title' => 'Administration de votre compte OfficeLife',
    'home_role_administrator' => 'En tant que <span class="fw5 brush-blue">représentant·e des ressources humaines</span>, vous pouvez…',
    'home_role_owner' => 'En tant qu’<span class="fw5 brush-orange">administrateur</span>, vous pouvez…',
    'home_manage_employees' => 'Administrer les employé·e·s',
    'home_manage_positions' => 'Administrer les postes',
    'home_manage_teams' => 'Administrer les équipes',
    'home_manage_flows' => 'Administrer les flux',
    'home_manage_employee_statuses' => 'Administrer les statuts d’employé·e·s',
    'home_company_news' => 'Administrer les nouvelles sur l’entreprise',
    'home_audit_log' => 'Consulter le journal d’audit pour savoir qui a fait quoi',
    'home_manage_pto' => 'Gérer les politiques de congés payés',
    'home_manage_questions' => 'Gérer les questions',
    'home_manage_hardware' => 'Gérer le matériel',
    'home_manage_expenses' => 'Gérer les notes de frais',
    'home_general_settings' => 'Paramètres généraux',
    'home_manage_ecoffee' => 'Gérer le processus de café virtuel',
    'home_cancel_account' => 'Fermer ce compte',
    'employees_title' => 'Gérer les employé·e·s de {company}',
    'employees_all_title' => 'Tous les employé·e·s de {company}',
    'employees_permission_title' => 'Tous les employé·e·s trié·e·s par permission dans {company}',
    'employees_all_active_title' => 'Tous les employé·e·s actifs de {company}',
    'employees_all_locked_title' => 'Tous les employé·e·s verrouillé·e·s de {company}',
    'employees_all_no_hiring_date_title' => 'Tous les employé·e·s sans date d’embauche dans {company}',
    'employees_description_1' => 'Afficher tous les employé·e·s',
    'employees_description_2' => 'Ou filtrez les employé·e·s correspondant à un critère donné',
    'employees_description_3' => 'Autres actions',
    'employees_cta' => 'Ajouter un·e seul·e employé·e',
    'employees_cta_view_all_employees' => 'Afficher tous les employé·e·s ({count})',
    'employees_cta_view_active_employees' => 'Afficher uniquement les employé·e·s actifs ({count})',
    'employees_cta_view_locked_employees' => 'Afficher uniquement les employé·e·s verrouillé·e·s ({count})',
    'employees_cta_view_employees_without_hiring_date' => 'Afficher les employé·e·s sans date d’embauche ({count})',
    'employees_view_profile' => 'Afficher le profil',
    'employees_invite_user' => 'Inviter un employé·e',
    'employees_lock_account' => 'Verrouiller le compte',
    'employees_unlock_account' => 'Déverrouiller le compte',
    'employees_change_permission' => 'Modifier les permissions',
    'employees_number_employees' => '{company} a un·e employé·e.|{company} a {count} employé·e·s.',
    'employees_import' => 'Importer un groupe d’employé·e·s en une seule fois (dans un fichier CSV)',
    'employees_view_past_imports' => 'Afficher les importations passées',
    'employees_invite_title' => 'Inviter {name} à devenir un·e utilisateur d’OfficeLife',
    'employees_invite_description' => '{firstname} a un profil sur OfficeLife, mais doit créer un compte pour pouvoir participer.',
    'employees_invite_description_2' => 'Nous pouvons envoyer à {firstname} une invitation de votre part par courriel (à {email}).',
    'employees_invite_cta' => 'Envoyer un courriel d’invitation à {firstname}',
    'employees_invite_success' => 'L’invitation a été envoyée.',
    'employees_invite_pending' => 'Invitation en attente',
    'employee_delete_title' => 'Supprimer toutes les informations sur {name}',
    'employee_delete_description' => 'Vous êtes sur le point de supprimer {name} d’OfficeLife. Cela aura pour effet de supprimer toutes les informations que nous connaissons sur cette personne. Nous révoquerons immédiatement tout accès possible à OfficeLife.',
    'employee_delete_success' => 'L’employé·e a été supprimé·e avec succès.',
    'employee_lock_title' => 'Verrouiller le compte de {name}',
    'employee_lock_description' => 'Êtes-vous sûr de vouloir verrouiller le compte de {name} ? Le verrouillage d’un compte a beaucoup d’effets. Vous pourrez déverrouiller le compte à tout moment.',
    'employee_lock_success' => 'L’employé·e a été verrouillé·e avec succès.',
    'employee_unlock_title' => 'Déverrouiller le compte de {name}',
    'employee_unlock_description' => 'Êtes-vous sûr de vouloir débloquer le compte de {name} ? Le déblocage d’un compte est immédiat.',
    'employee_unlock_success' => 'L’employé·e a été débloqué·e avec succès.',
    'employee_permission_safest' => 'le choix le plus sûr',
    'employee_permission_title' => 'Changer les permissions de {name}',
    'employee_permission_success' => 'L’employé·e a été mis·e à jour.',
    'employee_new_basic_information' => 'Informations sur les employé·e·s',
    'employee_new_title' => 'Ajouter un·e employé·e à {name}',
    'employee_new_firstname' => 'Prénom',
    'employee_new_lastname' => 'Nom de famille',
    'employee_new_email' => 'Adresse éléctronique',
    'employee_new_hiring_date' => 'Quand l’employé·e commencera-t-iel ?',
    'employee_new_permission_level' => 'Permissions',
    'employee_new_administrator' => 'Administrateur',
    'employee_new_hr' => 'Représentant·e des Ressources Humaines',
    'employee_new_user' => 'Employé·e',
    'employee_new_administrator_desc' => 'Peut tout faire, y compris la gestion des comptes. Attention : l’employé·e aura accès à tout, y compris à toutes les données privées des autres employés·e·s.',
    'employee_new_hr_desc' => 'A accès à la plupart des fonctionnalités, y compris la lecture et l’écriture d’informations privées, mais ne peut pas gérer le compte lui-même.',
    'employee_new_user_desc' => 'Peut voir toutes les équipes et les employé·e·s, mais ne peut pas gérer le compte ou lire les informations privées.',
    'employee_new_send_email' => 'Envoyez un courriel à cette personne avec un lien pour configurer le compte.',
    'employee_new_send_email_optional' => 'Facultatif – vous pourrez inviter cette personne plus tard.',
    'employee_new_success' => 'L’employé·e a été ajouté·e.',
    'teams_title' => 'Toutes les équipes listées dans {company}',
    'teams_number_teams' => '{company} a une équipe.|{company} a {count} équipes.',
    'teams_cta' => 'Ajouter une équipe',
    'teams_blank' => 'Les équipes sont un excellent moyen pour les groupes de personnes de votre entreprise de travailler ensemble dans la vie professionnelle.',
    'team_new_name' => 'Nom de l’équipe',
    'team_creation_success' => 'L’équipe a été créée.',
    'team_update_success' => 'L’équipe a été mise à jour.',
    'team_destroy_success' => 'L’équipe a été supprimée.',
    'team_visit_page' => 'Visitez la page de l’équipe',
    'team_view_audit_logs' => 'Afficher les journaux d’audit',
    'team_confirm_deletion' => 'Êtes-vous sûr de vouloir supprimer l’équipe appelée {name} ? Cela supprimera tous les membres de cette équipe, ainsi que toutes les notes, les nouvelles et les données qui lui sont associées.',
    'employee_statuses_title' => 'Tous les statuts des employé·e·s de {company}',
    'employee_statuses_number_positions' => '{company} a un statut d’employé.|{company} has {count} statuts d’employés.',
    'employee_statuses_cta' => 'Ajouter un statut d’employé',
    'employee_statuses_blank' => 'Les statuts sont des termes qui décrivent la situation professionnelle d’un·e employé·e. Comme plein-temps, temps partiel, etc.…',
    'employee_statuses_new_title' => 'Nom du statut',
    'employee_statuses_new_external' => 'Ce statut s’applique aux employé·e·s externes',
    'employee_statuses_new_external_help' => 'En cochant cette case, vous ajouterez quelques champs pour ces employé·e·s (comme les dates de renouvellement des contrats).',
    'employee_statuses_placeholder' => 'Plein-temps',
    'employee_statuses_success_new' => 'Le statut d’employé a été créé',
    'employee_statuses_success_update' => 'Le statut d’employé a été mis à jour',
    'employee_statuses_success_destroy' => 'Le statut d’employé a été supprimé',
    'employee_statuses_internal' => 'interne',
    'employee_statuses_external' => 'externe',
    'positions_title' => 'Tous les postes utilisés dans {company}',
    'positions_number_positions' => '{company} a un poste.|{company} a un {count} postes.',
    'positions_cta' => 'Ajouter un poste',
    'positions_blank' => 'Les postes sont des termes qui décrivent en quelques mots ce que fait un employé. Comme coordinateur marketing par exemple.',
    'position_new_title' => 'Nom du poste',
    'position_success_new' => 'Le poste a été créé',
    'position_success_update' => 'Le poste a été mis à jour',
    'position_success_destroy' => 'Le poste a été supprimé',
    'flows_title' => 'Tous les flux de {company}',
    'flows_cta' => 'Créer un flux',
    'flows_number_flows' => '{company} a un flux.|{company} a {count} flux.',
    'flows_blank' => 'Les flux vous permettent de définir comment le système doit réagir lorsque quelque chose se produit dans l’entreprise. C’est… assez puissant.',
    'flow_new_flow' => 'Quel est le nom du flux ?',
    'flow_new_help' => 'Il s’agit d’un nom interne, utilisé uniquement pour identifier le flux.',
    'flow_new_days' => 'jours',
    'flow_new_weeks' => 'semaines',
    'flow_new_months' => 'mois',
    'flow_new_before' => 'avant',
    'flow_new_after' => 'après',
    'flow_new_type_employee_joins_company' => 'Un·e employé·e rejoint l’entreprise',
    'flow_new_type_employee_leaves_company' => 'Un·e employé·e quitte l’entreprise',
    'flow_new_type_employee_birthday' => 'Un·e employé·e a son anniversaire',
    'flow_new_type_employee_joins_team' => 'Un·e employé·e est ajouté·e à une équipe',
    'flow_new_type_employee_leaves_team' => 'Un·e employé·e est retiré·e d’une équipe',
    'flow_new_type_employee_becomes_manager' => 'Un·e employé·e devient manager',
    'flow_new_type_employee_new_position' => 'Un·e employé·e a un nouveau poste',
    'flow_new_type_employee_leaves_holidays' => 'Un·e employé·e part en vacances',
    'flow_new_type_employee_returns_holidays' => 'Un·e employé·e revient de vacances',
    'flow_new_type_employee_returns_leave' => 'Un·e employé·e revient d’un congé',
    'flow_new_the_day_event_happens' => 'Au moment où cet événement se produit',
    'flow_new_action_following' => 'Faites ce qui suit',
    'flow_new_action_notification' => 'Notifier un·e employé·e',
    'flow_new_action_task' => 'Ajouter une tâche',
    'flow_new_action_email' => 'Envoyer un courriel',
    'flow_new_action_notification_actual_employee' => 'L’employé·e réel·le',
    'flow_new_action_notification_specific_employee' => 'Un·e employé·e spécifique',
    'flow_new_action_notification_manager' => 'Le(s) manager(s) de l’employé·e',
    'flow_new_action_notification_report' => 'Le(s) subordonné(s) de l’employé·e',
    'flow_new_action_notification_team_members' => 'Tous les membres de l’équipe de l’employé·e',
    'flow_new_action_notification_specific_team' => 'Une équipe spécifique',
    'flow_new_action_notification_everyone' => 'Tout le monde dans l’entreprise',
    'flow_new_action_notification_confirmation' => 'Vous êtes sûr ? Cela va alerter tous les employés de l’entreprise.',
    'flow_new_action_notification_search_employees' => 'Rechercher un·e employé·e',
    'flow_new_action_notification_search_hint' => 'Tapez les premières lettres du nom',
    'flow_new_action_notification_search_teams' => 'Rechercher une équipe',
    'flow_new_action_remove' => 'Action supprimée',
    'flow_new_action_label_actual_employee' => 'l’employé·e réel·le',
    'flow_new_action_label_everyone' => 'tout le monde dans l’entreprise',
    'flow_new_action_label_managers' => 'le(s) manager(s) de l’employé',
    'flow_new_action_label_reports' => 'le(s) subordonné(s) de l’employé·e',
    'flow_new_action_label_team_employee' => 'l’équipe de l’employé·e',
    'flow_new_action_label_employee' => 'un·e employé·e',
    'flow_new_action_label_unknown_message' => 'un message inconnu',
    // account logs
    'log_account_created' => 'Création du compte.',
    'log_employee_added_to_company' => 'Ajout de :employee comme employé·e.',
    'log_employee_destroyed' => 'Supprimé l’employé·e nommé·e :employee.',
    'log_employee_locked' => 'Verrouillé le compte de l’employé·e nommé·e :employee.',
    'log_employee_unlocked' => 'Déverrouillé le compte de l’employé·e nommé·e :employee.',
    'log_team_created' => 'Création de l’équipe appelée :name.',
    'log_team_updated' => 'Changement du nom de l’équipe de :old_name à :new_name.',
    'log_team_destroyed' => 'Supprimé l’équipe appelée :name.',
    'log_employee_added_to_team' => 'Ajouté :employee à :team.',
    'log_employee_removed_from_team' => 'Supprimé :employee de :team.',
    'log_employee_updated' => 'Mise à jour de :employee.',
    'log_employee_updated_hiring_information' => 'Mise à jour de l’embauche de :employee.',
    'log_manager_assigned' => 'Affectation de :name comme manager de :employee.',
    'log_manager_unassigned' => 'Suppression de :name comme manager de :employee.',
    'log_employee_invited_to_become_user' => 'Envoyé une invitation à :employee à rejoindre l’entreprise.',
    'log_position_created' => 'Création d’un poste appelé :name.',
    'log_position_updated' => 'Mise à jour de poste anciennement appelée :former_name en :new_name.',
    'log_position_destroyed' => 'Suppression du poste appelée :name.',
    'log_position_assigned' => 'Affecté le poste appelé :name à :employee.',
    'log_position_removed' => 'Suppression du poste appelée :name de :employee.',
    'log_flow_created' => 'Création du flux appelé :name.',
    'log_employee_worklog_logged' => 'Ajout d’un journal de travail.',
    'log_employee_status_created' => 'Ajout d’un statut d’employé appelé :name.',
    'log_employee_status_updated' => 'Mise à jour du nom du statut de l’employé de :former_name à :new_name.',
    'log_employee_status_destroyed' => 'Suppression du statut de l’employé appelé :name.',
    'log_employee_status_assigned' => 'Affecté le statut d’employé appelé :name à :employee.',
    'log_employee_status_removed' => 'Suppression du statut d’employé appelé :name de :employee.',
    'log_company_news_created' => 'Rédaction d’une nouvelle d’entreprise nommé :name.',
    'log_company_news_updated' => 'Mise à jour de la nouvelle appelée :name.',
    'log_company_news_destroyed' => 'Suppression de la nouvelle appelée :name.',
    'log_employee_morale_logged' => 'Ajout d’une émotion sur le déroulement de la journée.',
    'log_company_pto_policy_created' => 'Création d’une politique de congés payés pour :year.',
    'log_company_pto_policy_updated' => 'Mise à jour de la politique de congés payés pour l’année :year.',
    'log_company_time_off_created' => 'Ajout d’un nouveau congé pour :date.',
    'log_company_time_off_destroyed' => 'Suppression d’un congé pour :date.',
    'log_employee_address_set' => 'Ajout d’une adresse à :address.',
    'log_employee_pronoun_set' => 'Affecté le pronom appelé :name à :employee.',
    'log_employee_pronoun_removed' => 'Suppression du pronom de genre pour :name.',
    'log_employee_description_set' => 'Définissez une description personnelle pour :name.',
    'log_employee_description_cleared' => 'Effacement de la description personnelle de :name.',
    'log_employee_birthday_set' => 'Définir la date de naissance de :name.',
    'log_team_description_set' => 'Définition de la description de l’équipe appelée :name.',
    'log_team_description_cleared' => 'Effacement de la description de l’équipe appelée :name.',
    'log_team_useful_link_created' => 'Ajout d’un lien appelé :link_name à l’équipe appelée :name.',
    'log_team_useful_link_updated' => 'Mise à jour du lien appelé :link_name pour l’équipe appelée :name.',
    'log_team_useful_link_destroyed' => 'Suppression du lien appelé :link_name à l’équipe appelée :name.',
    'log_team_news_created' => 'Rédaction d’une nouvelle appelée :news_name pour l’équipe :name.',
    'log_team_news_updated' => 'Mise à jour de la nouvelle appelée :news_name pour l’équipe appelée :name.',
    'log_team_news_destroyed' => 'Suppression de la nouvelle appelée :news_name pour l’équipe appelée :name.',
    'log_employee_personal_details_set' => 'Définissez le nom et l’adresse électronique de l’employé·e comme :name et :email.',
    'log_team_leader_assigned' => 'Assigné :name comme chef d’équipe de l’équipe appelée :team_name.',
    'log_team_leader_removed' => 'Suppression de :name comme chef d’équipe de l’équipe appelée :team_name.',
    'log_employee_work_from_home_logged' => 'Indique que :name a travaillé à domicile le :date.',
    'log_employee_work_from_home_destroyed' => 'Suppression de l’entrée indiquant que :name a travaillé à domicile le :date.',
    'log_question_created' => 'Ajout d’une question intitulée :title.',
    'log_question_updated' => 'Mise à jour de la question de :old_title à :title.',
    'log_question_destroyed' => 'Suppression de la question intitulée :title.',
    'log_question_activated' => 'Activation de la question intitulée :title.',
    'log_question_deactivated' => 'Désactivation de la question appelée :title.',
    'log_answer_created' => 'A répondu à la question intitulée :title.',
    'log_answer_updated' => 'Mise à jour de la réponse à la question intitulée :title.',
    'log_answer_destroyed' => 'Suppression de la réponse à la question intitulée :title.',
    'log_hardware_created' => 'Ajout d’un matériel appelé :name.',
    'log_hardware_updated' => 'Mise à jour du nom du matériel de :old_name à :name.',
    'log_hardware_destroyed' => 'Suppression du matériel appelé :name.',
    'log_hardware_lent' => 'Prêt du le matériel nommé :hardware_name à :employee_name.',
    'log_hardware_regained' => 'Retour du matériel nommé :hardware_name de :employee_name.',
    'log_recent_ship_created' => 'Création d’une entrée de livraison appelée :ship_title associée à l’équipe appelée :team_name.',
    'log_recent_ship_destroyed' => 'Suppression de l’entrée de livraison appelée :ship_title associé à l’équipe appelée :team_name.',
    'log_employee_attached_to_recent_ship' => 'Associé l’employé·e appelé·e :employee_name avec l’entrée de livraison appelée :ship_title dans l’équipe appelée :team_name.',
    'log_skill_created' => 'Création de la compétence appelée :skill_name.',
    'log_skill_associated_with_employee' => 'Associé la compétence appelée :skill_name à :name.',
    'log_skill_removed_from_an_employee' => 'Suppression de la compétence appelée :skill_name de :name.',
    'log_skill_destroyed' => 'Suppression de la compétence appelée :name.',
    'log_skill_updated' => 'Mise à jour du nom de la compétence de :skill_old_name à :skill_new_name.',
    'log_expense_category_created' => 'Création d’une catégorie de note de frais appelée :name.',
    'log_expense_category_updated' => 'Mise à jour du nom de la catégorie de note de frais de :old_name à :new_name.',
    'log_expense_category_destroyed' => 'Suppression de la catégorie de note de frais appelée :name.',
    'log_task_created' => 'Création d’une tâche appelée :title pour :name.',
    'log_company_renamed' => 'Renommage de l’entreprise de :old_name à :new_name.',
    'log_company_currency_updated' => 'Changement de la devise de l’entreprise de :old_currency à :new_currency.',
    'log_expense_created' => 'Création d’une note de frais concernant :expense_title pour un montant de :expense_amount.',
    'log_expense_accepted_by_manager' => 'Accepté une note de frais pour :employee_name à propos de :expense_title pour un montant de :expense_amount.',
    'log_expense_rejected_by_manager' => 'Rejeté une note de frais pour :employee_name à propos de :expense_title pour un montant de :expense_amount.',
    'log_expense_accepted_by_accounting' => 'En tant que comptable, a accepté une note de frais pour :employee_name à propos de :expense_title pour un montant de :expense_amount.',
    'log_expense_rejected_by_accounting' => 'En tant que comptable, a rejeté une note de frais pour :employee_name à propos de :expense_title pour un montant de :expense_amount.',
    'log_employee_allowed_to_manage_expenses' => 'Autorisé :employee_name à gérer les notes de frais de l’entreprise.',
    'log_employee_disallowed_to_manage_expenses' => 'Interdit à :employee_name de gérer les notes de frais de l’entreprise.',
    'log_rate_your_manager_survey_answered' => 'A répondu à l’enquête à propos de :manager_name en tant que manager.',
    'log_employee_twitter_set' => 'Définition de l’identifiant Twitter de :employee_name sur :twitter.',
    'log_employee_twitter_reset' => 'Réinitialisation des identifiants Twitter de :employee_name.',
    'log_employee_slack_set' => 'Définition de l’identifiant Slack de :employee_name à :slack.',
    'log_employee_slack_reset' => 'Réinitialisation des identifiants Slack de :employee_name.',
    'log_employee_hiring_date_set' => 'Définition de la date d’embauche de :employee_name à :hiring_date.',
    'log_one_on_one_entry_created' => 'Création d’une entrée tête-à-tête entre :manager_name et :employee_name.',
    'log_one_on_one_entry_destroyed' => 'Suppression de l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_talking_point_created' => 'Ajout d’un point de discussion à l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_action_item_created' => 'Ajout d’une action à l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_note_created' => 'Ajout d’une note à l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_action_item_destroyed' => 'Suppression d’un élément d’action sur l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_talking_point_destroyed' => 'Suppression d’un point de discussion sur l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_note_destroyed' => 'Suppression d’une note sur l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name.',
    'log_one_on_one_note_marked_happened' => 'Marquage de l’entrée tête-à-tête de :happened_at entre :manager_name et :employee_name comme étant arrivée.',
    'log_project_created' => 'Création du projet appelé :project_name.',
    'log_project_destroyed' => 'Suppression du projet appelé :project_name.',
    'log_employee_added_to_project' => 'Ajout de :employee_name au projet appelé :project_name.',
    'log_employee_removed_from_project' => 'Suppression de :employee_name du projet appelé :project_name.',
    'log_project_started' => 'Démarrage du projet appelé :project_name.',
    'log_project_closed' => 'Fermeture du projet appelé :project_name.',
    'log_project_paused' => 'Mise en pause du projet appelé :project_name.',
    'log_project_team_lead_updated' => 'Affectation de :employee_name comme chef du projet appelé :project_name.',
    'log_project_link_created' => 'Ajout du lien appelé :project_link_name dans le projet appelé :project_name.',
    'log_project_link_destroyed' => 'Suppression du lien appelé :project_link_name du projet appelé :project_name.',
    'log_project_status_created' => 'Rédaction du statut du projet appelé :project_name.',
    'log_project_information_updated' => 'Mise à jour des informations sur le projet intitulé :project_name.',
    'log_project_description_updated' => 'Mise à jour de la description du projet appelé :project_name.',
    'log_project_team_lead_cleared' => 'Suppression de :employee_name comme chef de projet du projet appelé :project_name.',
    'log_project_decision_created' => 'Ajout d’une décision appelée :title dans le projet appelé :project_name.',
    'log_project_decision_destroyed' => 'A supprimé d’une décision appelée :title dans le projet appelé :project_name.',
    'log_project_message_created' => 'A ajouté un message appelé :title dans le projet appelé :project_name.',
    'log_project_message_destroyed' => 'A supprimé un message appelé :title dans le projet appelé :project_name.',
    'log_project_message_updated' => 'A mis à jour d’un message appelé :title dans le projet appelé :project_name.',
    'log_project_task_created' => 'A crée une tâche appelée :titre_tâche_projet dans le projet appelé :nom_du_projet.',
    'log_project_task_toggled' => 'A changé le statut de la tâche appelée :project_task_title dans le projet appelé :project_name.',
    'log_project_task_assigned_to_task_list' => 'A affecté une tâche appelée :project_task_title à la liste de tâches appelée :project_task_list_title dans le projet appelé :project_name.',
    'log_project_task_list_created' => 'A crée une liste de tâches appelée :project_task_list_title dans le projet appelé :project_name.',
    'log_project_task_destroyed' => 'A supprimé une tâche appelée :title dans le projet appelé :project_name.',
    'log_project_task_list_destroyed' => 'A supprimé une liste de tâches appelée :title dans le projet appelé :project_name.',
    'log_project_task_assigned_to_assignee' => 'A assigné la tâche appelée :project_task_title dans le projet appelé :project_name à :assignee_name.',
    'log_project_task_list_udpated' => 'A mis à jour la tâche appelée :project_task_list_title dans le projet appelé :project_name.',
    'log_time_tracking_entry_created' => 'A ajouté une entrée de suivi du temps pour la semaine :week_number pour :employee_name.',
    'log_employee_contract_renewed_at_set' => 'A défini la date de renouvellement du contrat de :employee_name à :contract_renewed_at.',
    'log_timesheet_submitted' => 'A soumis la feuille de temps de la semaine commencée le :started_at pour :employee_name.',
    'log_timesheet_approved' => 'A approuvé la feuille de temps de la semaine commencée le :started_at pour :employee_name.',
    'log_timesheet_rejected' => 'A rejeté la feuille de temps de la semaine commencée le :started_at pour :employee_name.',
    'log_employee_avatar_set' => 'A mis un avatar à :employee_name.',
    'log_consultant_rate_set' => 'A indiqué le taux de consultation à :rate de :employee_name.',
    'log_consultant_rate_destroy' => 'A supprimé le taux de consultation de :rate pour :employee_name.',
    'log_e_coffee_match_session_as_happened' => 'A marqué une session de café virtuel comme ayant eu lieu entre :employee_name et :other_employee_name.',
    'log_toggle_e_coffee_process' => 'A changé le process de café virtuel dans l’entreprise.',
    'log_group_created' => 'A crée le groupe appelé :group_name.',
    'log_employee_added_to_group' => 'A ajouté :employee_name au groupe appelé :group_name.',
    'log_employee_removed_from_group' => 'A supprimé :employee_name du groupe appelé :group_name.',
    'log_group_destroyed' => 'A supprimé le groupe appelé :group_name.',
    'log_meeting_created' => 'A crée une réunion dans le groupe appelé :group_name.',
    'log_meeting_destroyed' => 'A supprimé une réunion dans le groupe appelé :group_name.',
    'log_employee_marked_as_participant_in_meeting' => 'A indiqué que :employee_name a participé à une réunion dans le groupe appelé :group_name.',
    'log_employee_removed_from_meeting' => 'A indiqué que :nom_employé n’était pas présent à une réunion du groupe appelé :nom_groupe.',
    'log_company_logo_changed' => 'A mis à jour le logo de l’entreprise.',
    'log_agenda_item_created' => 'A ajouté un point à l’ordre du jour d’une réunion dans le groupe appelé :group_name.',
    'log_agenda_item_updated' => 'A mis à jour un point de l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'log_agenda_item_destroyed' => 'A détruit un point de l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'log_meeting_decision_created' => 'A crée une décision de réunion concernant un point de l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'log_meeting_decision_destroyed' => 'A supprimé une décision de réunion concernant un point de l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'log_meeting_decision_updated' => 'A mis à jour une décision de réunion concernant un point de l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'log_file_added_to_project' => 'A ajouté un fichier appelé :name dans le projet appelé :project_name.',
    'log_project_file_destroyed' => 'A supprimé un fichier appelé :name dans le projet appelé :project_name.',
    'log_add_guest_to_meeting' => 'A ajouté :nom_employé dans une réunion du projet appelé :nom_du_projet.',
    'log_meeting_date_set' => 'A défini la date de la réunion dans une réunion du projet appelé :nom_du_projet.',
    'log_company_founded_date_updated' => 'A mis à jour la date de création de l’entreprise en :founded_at.',
    'log_group_updated' => 'A mis à jour le groupe appelé :group_name.',
    // employee logs
    'employee_log_employee_created' => 'A crée cette fiche d’employé.',
    'employee_log_employee_locked' => 'A verrouillé la fiche de cet·te employé·e.',
    'employee_log_employee_unlocked' => 'A déverrouillé la fiche de cet employé.',
    'employee_log_manager_assigned' => 'Attribué :name en tant que manager.',
    'employee_log_direct_report_assigned' => 'A assigné :name comme subordonné.',
    'employee_log_manager_unassigned' => 'A retiré :name comme manager.',
    'employee_log_direct_report_unassigned' => 'A supprimé :name comme subordonné·e.',
    'employee_log_position_assigned' => 'A assigné le poste appelé :nom.',
    'employee_log_position_removed' => 'A supprimé la position appelée :name.',
    'employee_log_employee_added_to_team' => 'A été ajouté à l’équipe appelée :nom.',
    'employee_log_employee_removed_from_team' => 'A été retiré de l’équipe appelé :name.',
    'employee_log_employee_worklog_logged' => 'A ajouté une entrée dans le journal de travail.',
    'employee_log_employee_status_assigned' => 'A attribué le statut d’employé appelé :name.',
    'employee_log_employee_status_removed' => 'A supprimé le statut d’employé appelé :name.',
    'employee_log_morale_logged' => 'A indiqué son émotion sur le déroulement de la journée.',
    'employee_log_time_off_created' => 'A ajouté un nouveau congé pour :date.',
    'employee_log_time_off_destroyed' => 'A supprimé une période d’arrêt pour :date.',
    'employee_log_address_set' => 'A ajoutée une adresse à :address.',
    'employee_log_pronoun_set' => 'A attribué le pronom appelé : name.',
    'employee_log_pronoun_removed' => 'A supprimé le pronom.',
    'employee_log_description_set' => 'Définissez une description personnelle.',
    'employee_log_description_cleared' => 'A supprimé la description personnelle.',
    'employee_birthday_set' => 'A défini la date de naissance.',
    'employee_personal_details_set' => 'Définissez le nom et l’adresse électronique comme :name et :email.',
    'employee_log_work_from_home_logged' => 'A travaillé de la maison le :date.',
    'employee_log_work_from_home_destroyed' => 'A supprimé l’entrée concernant le travail à domicile le :date.',
    'employee_log_answer_created' => 'A répondu à la question intitulée :titre.',
    'employee_log_answer_updated' => 'A mis à jour la réponse à la question intitulée :title.',
    'employee_log_answer_destroyed' => 'A supprimé la réponse à la question intitulée :title.',
    'employee_log_employee_attached_to_recent_ship' => 'A été associé à l’accomplissement appelé :ship_title dans l’équipe appelée :team_name.',
    'employee_log_skill_associated_with_employee' => 'A été associé à la compétence appelée :name.',
    'employee_log_skill_removed_from_an_employee' => 'S’est vu retiré la compétence appelée :name.',
    'employee_log_task_created' => 'A crée la tâche appelée :title.',
    'employee_log_expense_created' => 'A crée la note de frais concernant :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_accepted_by_manager' => 'S’est vu acceptée une note de frais concernant :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_accepted_for_employee' => 'A accepté une note de frais pour :employee_name sur :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_rejected_for_employee' => 'A rejeté une note de frais pour :employee_name sur :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_rejected_by_manager' => 'A rejeté une note de frais concernant :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_accepted_by_accounting_for_employee' => 'En tant que comptable, a accepté une note de frais pour :employee_name sur :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_accepted_by_accounting' => 'S’est vu acceptée une note de frais par le service comptable à propos de :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_rejected_by_accounting_for_employee' => 'En tant que comptable, a rejeté une note de frais pour :employee_name sur :expense_title pour un montant de :expense_amount.',
    'employee_log_expense_rejected_by_accounting' => 'S’est vu rejeté par le service comptable une note de frais concernant :expense_title pour un montant de :expense_amount.',
    'employee_log_employee_allowed_to_manage_expenses' => 'A été autorisé à gérer les notes de frais de l’entreprise.',
    'employee_log_employee_disallowed_to_manage_expenses' => 'A été refusé pour gérer les notes de frais de l’entreprise.',
    'employee_log_rate_your_manager_survey_answered' => 'A répondu au sondage sur la façon dont :manager_name agît comme manager.',
    'employee_log_employee_twitter_set' => 'A défini les identifiants Twitter comme :twitter.',
    'employee_log_employee_twitter_reset' => 'Réinitialiser l’identifiant Twitter.',
    'employee_log_employee_slack_set' => 'A défini les identifiants Slack comme :slack.',
    'employee_log_employee_slack_reset' => 'Réinitialiser l’identifiant Slack.',
    'employee_log_hiring_date_set' => 'A défini la date d’embauche à :hiring_date.',
    'employee_log_one_on_one_entry_created' => 'A organisé un 1:1 avec :employee_name.',
    'employee_log_one_on_one_entry_destroyed' => 'A supprimé l’entrée 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_talking_point_created' => 'A ajouté un point de discussion au 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_action_item_created' => 'A ajouté un point d’action au 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_note_created' => 'A ajouté une note au 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_action_item_destroyed' => 'A supprimé un point d’action dans le 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_talking_point_destroyed' => 'A supprimé un point de discussion du 1:1 du :happened_at avec :employee_name.',
    'employee_log_one_on_one_note_marked_happened' => 'A complété l’entrée 1:1 du :happened_at avec :employee_name.',
    'employee_log_employee_added_to_project' => 'A été ajouté au projet appelé :nom_du_projet.',
    'employee_log_employee_removed_from_project' => 'A été retiré du projet appelé :project_name.',
    'employee_log_project_team_lead_updated' => 'A été désigné comme chef de projet pour le projet appelé :project_name.',
    'employee_log_project_team_lead_cleared' => 'A été démis de ses fonctions de chef de projet pour le projet intitulé :project_name.',
    'employee_log_time_tracking_entry_created' => 'A ajouté une entrée de temps pour la semaine :week_number.',
    'employee_log_contract_renewed_at_set' => 'S’est vu fixé la date de renouvellement du contrat à :contract_renewed_at.',
    'employee_log_timesheet_submitted' => 'A soumis la feuille de temps de la semaine commencée le :started_at.',
    'employee_log_timesheet_approved' => 'A approuvé la feuille de temps de la semaine commencée le :started_at.',
    'employee_log_timesheet_rejected' => 'A rejeté la feuille de temps de la semaine commencée le :started_at.',
    'employee_log_employee_avatar_set' => 'A crée un nouvel avatar.',
    'employee_log_consultant_rate_set' => 'A fixé le taux de consultation à :rate.',
    'employee_log_consultant_rate_destroyed' => 'A détruit le taux de :rate.',
    'employee_log_employee_added_to_group' => 'A été ajouté au groupe appelé :nom_du_groupe.',
    'employee_log_employee_removed_from_group' => 'A été retiré du groupe appelé :nom_du_groupe.',
    'employee_log_employee_marked_as_participant_in_meeting' => 'A été ajouté dans une réunion du groupe appelé :group_name.',
    'employee_log_employee_removed_from_meeting' => 'A été retiré d’une réunion du groupe appelé :group_name.',
    'employee_log_agenda_item_created' => 'A créé un point à l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'employee_log_agenda_item_updated' => 'A mis à jour un point à l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'employee_log_meeting_decision_created' => 'A crée une décision de réunion concernant un point à l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'employee_log_meeting_decision_destroyed' => 'A supprimé une décision de réunion concernant un point à l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'employee_log_meeting_decision_updated' => 'A mis à jour une décision de réunion concernant un point à l’ordre du jour dans une réunion du groupe appelé :group_name.',
    'employee_log_add_guest_to_meeting' => 'A été ajouté dans une réunion du projet appelé :nom_du_projet.',
    // team logs
    'team_log_team_created' => 'A crée l’équipe.',
    'team_log_team_updated' => 'A changé le nom de :old_name en :new_name.',
    'team_log_employee_added_to_team' => 'A ajouté :employee_name à l’équipe.',
    'team_log_employee_removed_from_team' => 'A supprimé :employee_name de l’équipe.',
    'team_log_team_leader_assigned' => 'A assigné :nom comme chef d’équipe.',
    'team_log_team_leader_removed' => 'A enlevé :name comme chef d’équipe.',
    'team_log_description_set' => 'A défini la description de l’équipe',
    'team_log_description_cleared' => 'A supprimé la description des équipes',
    'team_log_useful_link_created' => 'A ajouté un lien appelé :name.',
    'team_log_useful_link_updated' => 'A mis à jour le lien appelé :name.',
    'team_log_useful_link_destroyed' => 'A détruit le lien appelé :name.',
    'team_log_team_news_created' => 'A écrit une nouvelle intitulée :name.',
    'team_log_team_news_updated' => 'A mis à jour la nouvelle intitulée :title.',
    'team_log_team_news_destroyed' => 'A supprimé la nouvelle appelée :title.',
    'team_log_recent_ship_created' => 'A crée un nouvel accomplissement appelé :title.',
    'team_log_ship_destroyed' => 'A supprimé l’accomplissement appelé :title.',
    'notification_dummy_data_generated' => 'Des données factices ont été générées pour :name.',
    'notification_employee_added_to_company' => 'Vous avez été ajouté à :name.',
    'notification_employee_added_to_team' => 'Vous avez été ajouté à l’équipe appelée :name.',
    'notification_employee_removed_from_team' => 'Vous avez été retiré de l’équipe appelée : name.',
    'notification_team_lead_set' => 'Vous avez été désigné comme chef d’équipe pour l’équipe appelée :name.',
    'notification_team_lead_removed' => 'Vous n’êtes plus le chef d’équipe de l’équipe appelée :name.',
    'notification_employee_attached_to_recent_ship' => 'Vous avez été associé à l’accomplissement appelé :title.',
    'notification_task_assigned' => 'Vous avez été chargé de la tâche intitulée :title par :name.',
    'notification_expense_assigned_for_validation' => 'Vous avez une nouvelle note de frais à valider pour :name.',
    'notification_expense_accepted_by_manager' => 'Votre note de frais appelée :title a été acceptée par votre manager et est maintenant entre les mains du service comptable.',
    'notification_expense_rejected_by_manager' => 'Votre note de frais intitulée :title a été rejetée par votre manager.',
    'notification_employee_allowed_to_manage_expenses' => 'Vous êtes maintenant autorisé·e à gérer les notes de frais de l’entreprise.',
    'notification_expense_accepted_by_accounting' => 'Votre note de frais intitulée : title a été approuvée par le service comptable.',
    'notification_expense_rejected_by_accounting' => 'Votre note de frais intitulée :title a été rejetée par le service comptable.',
    'morale_1' => 'Positif',
    'morale_2' => 'Neutre',
    'morale_3' => 'Négatif',
    'company_news_title' => 'Nouvelles de l’entreprise',
    'company_news_blank' => 'Avez-vous besoin de diffuser une annonce ou une nouvelle à tous les employé·e·s de votre entreprise ? Vous pouvez le faire ici !',
    'company_news_number_news' => '{company} a {count} nouvelle de l’entreprise.|{company} a {count} nouvelles de l’entreprise.',
    'company_news_cta' => 'Ajouter une nouvelle',
    'company_news_written_by' => 'Écrit par {name} le {date}',
    'company_news_success_destroy' => 'La nouvelle a été supprimée avec succès.',
    'company_news_new_headline' => 'Ajouter une nouvelle',
    'company_news_new_title' => 'Titre de la nouvelle',
    'company_news_new_title_help' => 'Soyez bref et intéressant. Et ajoutez un emoji.',
    'company_news_new_content' => 'Écrivez quelque chose d’intéressant',
    'company_news_new_content_help' => 'Tout le monde dans l’entreprise pourra lire cette nouvelle. Assurez-vous que vous ne dites pas quelque chose de stupide.',
    'company_news_edit_headline' => 'Modifier une nouvelle',
    'company_news_create_success' => 'La nouvelle a été publiée',
    'company_news_update_success' => 'La nouvelle a été mise à jour',
    'pto_policies_edit_title_1' => 'En tant que fabricants de logiciels, nous pensons qu’il est de notre responsabilité de promouvoir une culture où les employés sont réellement en confiance et autonomes.',
    'pto_policies_edit_title_2' => 'Nous avons un ensemble très limité de fonctionnalités autour des congés payés. À dessein. Cliquez ici pour en savoir plus sur notre façon de penser.',
    'pto_policies_edit_title_3' => 'Le seul paramètre que nous devons connaître est le nombre de jours ouvrables de chaque année, afin de pouvoir calculer le nombre de jours de vacances que les employés obtiennent chaque jour.',
    'pto_policies_edit_title_4' => 'Vous devez simplement vous assurer que pour chacune des années ci-dessous, le nombre de jours effectivement travaillés est correct pour votre pays.',
    'pto_policies_edit_title' => 'Toutes les politiques de congé payé de {name}',
    'pto_policies_edit_year' => 'En {year}…',
    'pto_policies_stat_worked_days' => 'jours travaillés',
    'pto_policies_stat_default_holidays' => 'nombre de jours fériés par défaut par employé',
    'pto_policies_stat_default_sick_days' => 'le nombre de jours de maladie par défaut',
    'pto_policies_stat_default_ptos' => 'le nombre de jours de congés par défaut',
    'pto_policies_stat_days' => '{number} jours',
    'pto_policies_edit_default_employee_settings' => 'Ce sont les paramètres par défaut qui seront appliqués aux nouveaux employés. Ils n’affecteront pas les employés existants.',
    'pto_policies_edit_default_amount_of_allowed_holidays' => 'Vacances autorisées par an',
    'pto_policies_edit_default_amount_of_sick_days' => 'Jours de maladie autorisés par an',
    'pto_policies_edit_default_amount_of_pto_days' => 'Jours personnels autorisés par an',
    'pto_policies_edit_click_calendar' => 'Ajoutez/supprimez des jours fériés en cliquant sur un jour dans le calendrier ci-dessous',
    'pto_policies_edit_calendar_help' => 'Note : ceci affectera tous les employés. Nous recalculerons le solde des congés pour tous vos employés en fonction des changements que vous ferez ici.',
    'pto_policies_month' => 'Mois',
    'pto_policies_legend' => 'Légende :',
    'pto_policies_legend_weekend' => 'Fin de semaine',
    'pto_policies_legend_holiday' => 'Vacances',
    'pto_policies_legend_' => 'Ajoutez/supprimez des jours fériés en cliquant sur un jour dans le calendrier ci-dessous',
    'pto_policies_edit_total' => 'Les employés devront travailler un total de {totalWorkedDays} en {year}.',
    'pto_policies_update' => 'La politique a été mise à jour',
    'pronoun_he_him' => 'il/lui',
    'pronoun_she_her' => 'elle/elle',
    'pronoun_they_them' => 'iel/cellui',
    'pronoun_per_per' => 'per/per',
    'pronoun_ve_ver' => 've/ver',
    'pronoun_xe_xem' => 'xe/xem',
    'pronoun_ze_hir' => 'ze/hir',
    'pronoun_blank' => 'Pas de genre',
    'questions_number_questions' => '{company} has {count} question.|{company} has {count} questions.',
    'questions_blank' => 'Posez des questions sur vos collègues afin qu’iels puissent mieux se connaître.',
    'questions_title' => 'Des questions pour apprendre à connaître vos collègues',
    'questions_description' => 'Une seule question peut être active à un moment donné. La question actuellement active sera affichée sur la page d’accueil, et ce n’est que lorsqu’une question est active que vos employés peuvent ajouter des réponses à cette question.',
    'questions_cta' => 'Créer une nouvelle question',
    'questions_form_title_placeholder' => 'Quel est le film que vous appréciez le plus ?',
    'question_creation_success' => 'La question a été créée',
    'question_activate' => 'Set active',
    'question_deactivate' => 'Désactiver la question',
    'question_update_success' => 'La question a été mise à jour',
    'question_confirm_deletion' => 'En êtes-vous sûr ? Toutes les réponses écrites par les employés seront également supprimées définitivement.',
    'question_destroy_success' => 'La question a été supprimée',
    'question_activate_success' => 'La question est maintenant active',
    'question_deactivate_success' => 'La question est maintenant désactivée',
    'question_status_active' => 'actif',
    'question_status_inactive' => 'inactif',
    'question_number_of_answers' => '{count} réponse|{count} réponses',
    'hardware_title' => 'Gérer le matériel de l’entreprise',
    'hardware_blank' => 'Vous pouvez y suivre tout le matériel que votre entreprise achète, et savoir quel employé possède quoi.',
    'hardware_description' => 'Il s’agit de tout le matériel que vous avez dans votre entreprise.',
    'hardware_create_title' => 'Ajouter un nouveau matériel à votre inventaire',
    'hardware_all_hardware' => 'Tout le matériel',
    'hardware_available_hardware' => 'Matériel disponible',
    'hardware_lent_hardware' => 'Matériel prêté',
    'hardware_no_serial' => 'Pas de numéro de série',
    'hardware_not_lent' => 'Article pas encore prêté',
    'hardware_cta' => 'Ajouter un élément',
    'hardware_create_name_input' => 'Nom du matériel',
    'hardware_create_serial_input' => 'Numéro de série (ou toute autre information pertinente)',
    'hardware_create_serial_input_help' => 'Cela vous permettra d’identifier ce matériel de manière unique.',
    'hardware_create_lend_hardware' => 'Souhaitez-vous prêter cet article à un employé ?',
    'hardware_create_lend_name' => 'Choisir un employé',
    'hardware_create_success' => 'Le matériel a été ajouté à votre entreprise',
    'hardware_update_success' => 'Le matériel a été mis à jour avec succès.',
    'hardware_log_hardware_created' => 'A créé cet élément appelé :name',
    'hardware_log_hardware_updated' => 'A mis à jour du nom en :name',
    'hardware_log_hardware_lent' => 'A prêté cet élément à :name',
    'hardware_log_hardware_regained' => 'A repris l’objet à :name',
    'hardware_show_history' => 'Historique',
    'hardware_search_placeholder' => 'Recherche par nom d’article ou numéro de série',
    'hardware_edit_title' => 'Modifier un objet',
    'expense_categories_title' => 'Gestion des notes de frais',
    'expense_category_blank' => 'Vous n’avez pas encore configuré de catégorie de note de frais.',
    'expense_category_headline' => 'Catégories de note de frais',
    'expense_category_create_cta' => 'Créer une nouvelle catégorie de note de frais',
    'expense_category_create_placeholder' => 'Donnez un nom à la catégorie de note de frais',
    'expense_category_default_maintenance_and_repairs' => 'Entretien et réparations',
    'expense_category_default_meals_and_entertainment' => 'Repas et divertissements',
    'expense_category_default_office_expense' => 'Frais de bureau',
    'expense_category_default_travel' => 'Voyage',
    'expense_category_default_motor_vehicle_expenses' => 'Frais de véhicules à moteur',
    'expense_category_success' => 'La catégorie de note de frais a été créée.',
    'expense_category_update_success' => 'La catégorie de note de frais a été mise à jour.',
    'expense_category_delete_success' => 'La catégorie de note de frais a été supprimée.',
    'expense_employees_headline' => 'Employé·e·s capables de gérer les notes de frais',
    'expense_employees_blank' => 'Aucun·e employé·e n’a le droit de gérer les notes de frais à l’heure actuelle.',
    'expense_employees_create_cta' => 'Ajouter/supprimer des employé·e·s',
    'expense_employees_hide_cta' => 'Cacher l’édition',
    'expense_employees_create_label' => 'Ajoutez un employé en tapant son nom ci-dessous',
    'expense_employees_assign_success' => 'L’employé a été ajouté à la liste des employés autorisés.',
    'expense_employees_unassign_success' => 'L’employé a été retiré de la liste des employés autorisés.',
    'general_title' => 'Paramètres généraux',
    'general_information' => 'Informations du compte',
    'general_name' => 'Nom de l’entreprise',
    'general_administrators' => 'Administrateurs actuels',
    'general_creation_date' => 'Créé le',
    'general_creation_size' => 'Stockage des fichiers',
    'general_creation_size_kb' => '{size} Ko',
    'general_rename_company' => 'Changer le nom de l’entreprise',
    'general_rename_input' => 'Donner un nouveau nom à l’entreprise',
    'general_rename_success' => 'L’entreprise a été rebaptisée.',
    'general_currency_information' => 'Devise',
    'general_currency_information_table' => 'Devise principale de l’entreprise',
    'general_currency_update' => 'Mise à jour de la monnaie',
    'general_currency_change_label' => 'Choisir une nouvelle devise',
    'general_currency_rename_success' => 'La devise a été mise à jour.',
    'general_logo_title' => 'Logo',
    'general_logo_current' => 'Logo actuel',
    'general_logo_cta' => 'Téléverser un logo',
    'general_logo_success' => 'Le logo a été modifié.',
    'general_founded_date_information' => 'Date de création',
    'general_founded_date_label' => 'Date de création de l’entreprise',
    'general_founded_date_cta' => 'Changer la date',
    'general_founded_date_no_date' => 'Pas encore de date',
    'general_founded_date_success' => 'La date de création a été modifiée.',
    'ecoffee_title' => 'Sessions de café virtuel dans l’entreprise',
    'ecoffee_desc' => 'Les cafés virtuels sont un excellent moyen pour les employé·e·s de prendre du temps avec un·e autre collègue et de passer 15 minutes dans une semaine pour apprendre à le·a connaître. L’objectif est de parler de tout sauf du travail. Plus vous connaissez vos collègues, plus leurs liens sont puissants.',
    'ecoffee_enabled' => 'Les cafés virtuels sont activés',
    'ecoffee_disabled' => 'Les cafés virtuels sont désactivés',
    'import_employees_status_created' => 'créé',
    'import_employees_status_uploaded' => 'téléversé',
    'import_employees_status_imported' => 'importé',
    'import_employees_status_failed' => 'échec',
    'import_employees_archives_title' => 'Liste des importations précédentes des employés',
    'import_employees_archives_cta' => 'Importer une nouvelle liste',
    'import_employees_archives_blank_description' => 'Aucun employé n’a encore été importé.',
    'import_employees_archives_item_title' => '{count} entrée|{count} entrées',
    'import_employees_archives_item_date' => '{date} par {author}',
    'import_employees_archives_item_status_ok' => 'Valide',
    'import_employees_archives_item_status_invalid_email' => 'Courriel invalide',
    'import_employees_archives_item_status_email_already_taken' => 'Courriel déjà pris',
    'import_employees_archives_finalize_import' => 'Importer {count} entrée|Importer {count} entrées',
    'import_employees_archives_finalize_email_missing' => 'non fourni',
    'import_employees_import_title' => 'Importer des employés',
    'import_employees_import_cta' => 'Parcourir un CSV à télécharger',
    'import_employees_import_description' => 'Vous pouvez importer un groupe d’employés en une seule fois avec un fichier CSV.',
    'import_employees_import_note' => 'Remarque importante : votre fichier CSV doit respecter une structure spécifique pour que nous puissions l’importer correctement.',
    'import_employees_import_instructions' => 'Lisez les instructions complètes ici',
    'import_employees_show_title_uploaded' => 'Vous êtes sur le point d’importer de nouveaux employés',
    'import_employees_show_title_imported' => 'Entrées que vous avez importées le {date}',
    'import_employees_show_title_number_entries' => 'Nombre d’entrées dans le fichier',
    'import_employees_show_title_number_entries_errors' => 'Entrées en erreur',
    'import_employees_show_title_number_entries_import' => 'Les entrées que nous pouvons importer',
    'import_employees_import_success' => 'Les employés ont été importés',
    'import_employees_show_email' => 'Courriel',
    'import_employees_show_firstname' => 'Prénom',
    'import_employees_show_lastname' => 'Nom de famille',
    'import_employees_show_status' => 'Statut',
    'import_employees_show_first_five_entries' => 'Les cinq premières des {count} entrées du fichier',
    'import_employees_show_entries_errors' => '{count} entrée en erreur dans le fichier|Les {count} entrées en erreur dans le fichier',
    'cancel_account_title' => 'Êtes-vous sûr de vouloir fermer votre compte ?',
    'cancel_account_thanks' => 'Merci d’avoir donner une chance à OfficeLife !',
    'cancel_account_please_note' => 'Veuillez noter que…',
    'cancel_account_company_account_closed' => 'Le compte de cette entreprise sera immédiatement fermé.',
    'cancel_account_company_employee_deleted' => 'Toutes les informations relatives aux employés seront immédiatement supprimées.',
    'cancel_account_company_data_deleted' => 'Toutes les données de ce compte seront supprimées de nos serveurs immédiatement, et de nos sauvegardes dans 60 jours.',
    'cancel_account_company_subscription' => 'Si vous êtes abonné, votre abonnement sera immédiatement annulé.',
    'cancel_account_data_lost_forever' => 'Ce processus est irréversible. Vous perdrez toutes les données associées à cette entreprise, pour toujours.',
    'cancel_cta' => 'Fermer le compte',
    'general_invitation_code' => 'Code que les employés peuvent utiliser pour joindre l’entreprise',
    'software_new_order_number' => 'Numéro de commande',
    'software_new_licensed_to_email' => 'Courriel de la licence',
    'software_new_purchase_information_cta' => 'Ajouter des informations sur l’achat',
    'software_new_purchase_information' => 'Informations sur l’achat',
    'software_new_success' => 'Le logiciel a été créé.',
    'software_new_seats' => 'Places',
    'software_new_product_key' => 'Clé du produit',
    'software_new_name' => 'Nom du logiciel',
    'software_new_basic_information' => 'Informations essentielles',
    'software_new_title' => 'Ajouter un nouveau logiciel à {name}',
    'log_software_seat_given_to_employees' => 'A donné une licence pour le logiciel nommé :software_name à tous les employé·e·s de l’entreprise.',
    'log_software_seat_taken_from_employee' => 'A repris la licence du logiciel nommé :software_name à :employee_name.',
    'log_software_seat_given_to_employee' => 'A donné une licence pour le logiciel nommé :software_name à :employee_name.',
    'log_software_destroyed' => 'Supprimé le logiciel nommé :software_name.',
    'log_software_updated' => 'Mis à jour le logiciel nommé :software_name.',
    'log_software_created' => 'Créé un logiciel nommé :software_name.',
    'home_manage_software' => 'Gérer les logiciels',
    'software_edit_title' => 'Éditer le logiciel',
    'software_delete' => 'Le logiciel a été supprimé.',
    'software_show_stat' => '{localUsedSeats}/{seats} places utilisées',
    'software_show_who' => 'À qui souhaitez-vous donner une copie du logiciel ?',
    'software_show_not_enough_seats' => 'Notez que vous n’avez pas assez de places disponibles pour assigner tous ces employé·e·s. Vous pouvez tout de même poursuivre, mais à vos risques et périls.',
    'software_show_confirm' => 'Veuillez confirmer que vous voulez attribuer le logiciel à {count} employé·e qui n’a pas encore le logiciel.|Veuillez confirmer que vous voulez attribuer le logiciel aux {count} employé·e·s qui n’ont pas encore le logiciel.',
    'software_show_give_seat_specific' => 'Donner une place à un·e employé·e spécifique',
    'software_show_start' => 'Démarrer',
    'software_show_option_a' => 'Donner une place à chaque employé·e actif/active de l’entreprise qui ne possède pas encore ce logiciel ({count} total)',
    'software_show_two_options' => 'Vous avez deux options pour attribuer un logiciel à un·e employé·e :',
    'software_show_use_seat' => 'Utiliser un emplacement',
    'software_show_seats' => 'Places',
    'software_show_order_number' => 'Numéro de commande',
    'software_show_website' => 'Site Web',
    'software_show_purchase_date' => 'Date d’achat',
    'software_show_exchange_rate' => 'Taux de change :',
    'software_show_price' => 'Prix',
    'software_show_licensed_to' => 'Sous licence :',
    'software_show_purchase_information' => 'Informations sur l’achat',
    'software_show_product_key' => 'Clé du produit',
    'software_show_add_all_employees' => 'Tous les employé·e·s ont été ajouté·e·s.',
    'software_show_remove_employee' => 'L’employé·e a été supprimé·e.',
    'software_show_add_employee' => 'L’employé·e a été ajouté·e.',
    'software_index_count' => '{company} gère {count} logiciel.|{company} gère {count} logiciels.',
    'software_index_blank_description' => 'Gérez les logiciels que votre entreprise utilise.',
    'software_index_cta' => 'Ajouter un logiciel',
    'software_index_title' => 'Logiciels utilisés dans l’entreprise',
    'software_new_website' => 'Site Web',
    'software_new_expiration_date' => 'Date d’expiration',
    'software_new_purchase_date' => 'Date d’achat',
    'software_new_purchase_cost' => 'Coût d’achat',
    'software_new_licensed_to' => 'Sous licence pour',
    'import_employees_show_title_started' => 'Importation démarrée le {date}…',
    'import_employees_show_title_created' => 'Votre import est sur le point de démarrer…',
    'import_employees_status_importing' => 'en cours d’importation',
    'import_employees_status_started' => 'démarré',
    'software_show_files_blank' => 'Il n’y a pas encore de fichiers associés à ce logiciel.',
    'software_show_files' => 'Fichiers',
    'import_employees_show_title_failed' => 'L’importation a échoué',
    'expense_destroy_success' => 'La note de frais a été supprimée.',
    'employee_log_expense_destroyed' => 'Suppression de la note de frais appelée :expense_title.',
    'log_software_file_destroyed' => 'Suppression du fichier appelé :name qui était associé au logiciel appelé :software_name.',
    'log_file_added_to_software' => 'Téléversé un fichier appelé :name associé au logiciel appelé :software_name.',
    'log_expense_destroyed' => 'Suppression de la note de frais appelée :expense_title de :employee_name.',
    'work_from_home_disabled' => 'La fonction de télétravail est désactivée',
    'work_from_home_enabled' => 'La fonction de télétravail est activée',
    'work_from_home_desc' => 'Si votre entreprise n\'est pas à 100 % à distance, vous pouvez demander à vos employés d\'indiquer quand ils télétravaillent. Ceci vous permet d\'enregistrer ces informations, mais aussi d\'informer les membres de l\'équipe qu\'un de leurs collègues ne sera pas physiquement disponible au bureau.',
    'work_from_home_title' => 'Fonctionnalité de télé travail dans l\'entreprise',
    'log_toggle_work_from_home_process' => 'J\'ai changé le processus de télétravail dans l\'entreprise.',
    'log_worklog_destroyed' => 'Suppression du journal de travail pour :date.',
    'home_manage_work_from_home' => 'Gérer le télétravail',
    'employee_log_worklog_destroyed' => 'A supprimé le journal de travail du :date',
    'log_page_destroyed' => 'A supprimé la page nommée :page_title dans le wiki nommé :wiki_title.',
    'log_page_added_to_wiki' => 'A ajouté une page nommée :page_title dans le wiki nommé :wiki_title.',
    'log_page_updated' => 'A mis à jour la page nommée :page_title dans le wiki nommé :wiki_title.',
    'log_wiki_destroyed' => 'A supprimé le wiki nommé :wiki_title.',
    'log_wiki_updated' => 'A mis à jour le wiki nommé :wiki_title.',
    'log_wiki_created' => 'A créé un wiki nommé :wiki_title.',
    'billing_index_month' => 'Facturé pour {number} employé·e·s actif·ve·s',
    'billing_index_title' => 'Toutes vos factures',
    'billing_show_description' => 'En {month}, le jour avec le plus d’employé·e·s actif·ve·s dans l’entreprise était le {max_employees}, avec {number_active_employees} employé·e·s. C’est ce que nous utiliserons pour facturer votre compte.',
    'billing_show_title' => 'Détails de la facture pour {date}',
    'billing_show_blank' => 'Après un mois d’activité sur votre compte, vous trouverez ici vos factures.',
    'log_project_task_updated' => 'Mise à jour de la tâche appelée :project_task_title dans le projet appelé :project_name.',
    'home_account_usage' => 'Utilisation et facturation du compte',
    'log_job_opening_updated' => 'Mis à jour le poste nommé :job_opening_title',
    'log_job_opening_destroyed' => 'Supprimé un poste nommé :job_opening_title',
    'log_job_opening_created' => 'Créé un nouveau poste appelé :job_opening_title',
    'home_manage_recruitment' => 'Administrer les processus de recrutement',
];
