# Modern Python 101 - Workouts

!["Modern Python"](assets/octallium_modern_python_101_workouts_1.png)

Modern Python 101 - Workouts, is your playground to practice your basic python programming skills. This course contains carefully selected 20 workouts that cover all basic aspects of Python. If you have taken my earlier course [Modern Python 101](https://www.octallium.com/courses/modern-python-101/) then you know that the content is dense and packed with lots of information! 

This course is the exact opposite of [Modern Python 101](https://www.octallium.com/courses/modern-python-101/), in this course I am first going to throw a problem at you, may be a little difficult for starting and expect you to attempt it. If you can solve then its awesome, if not then still nothing to worry, the problems are intentionally designed so that you don't get them on first attempt!! And of-course each problem has a detailed explanation and a solution video.

I have also selected some problem from `Hacker Rank` just to give you an idea of how to approach these platforms. It would also help you to carry on solving problems with similar coding challenges platforms in the future.

## How To Approach Python Workouts

Think of it like this - It's your job to solve the problem and it's my job to make it as difficult as possible!

So, what really matters for you is to just `persist` throughout the course and by the end of the course you would have learned so much more than before! As I throw a problem at you, I would expect you to search online for additional concepts, browse articles from websites like stack overflow or official Python documentation and try to come up with a solution. 

Just solving or not solving the problem doesn't matter or how many step it took to solve the problem doesn't matter, what matters is - How did you approach the problem? How did you decompose the problem? Were you able to conceptually visualize the solution? Remember, a working program is much more important than concise or fast program!

I would advise you to not spend more than 45-60 mins on one problem, if you are able to get it partially right them maybe spending some more time could make sense. If you are spending much more time than that, then I would recommend you to watch the solution and try the problem again on your own.

At the end of you attempt you can always compare your answer with the solutions, but please remember that my solutions are not the only `solutions`, you may have a different approach which is completely acceptable, what matters is the outcome.

## Topic Covered

These workouts cover almost every topic we learnt in [Modern Python 101](https://www.octallium.com/courses/modern-python-101/) except for error handling and packages and the workouts are mainly designed to test your logic and reasoning.

## Audience

These workouts are designed for `Python Beginners` or for anyone who want's to practice their `fundamental` Python Programming skills.

Each `Workout` is specific to a particular Python topic and targets mostly one concept at a time.

## What To Practice Next -

1. OOP's
2. File & Folder Handling
3. Iterators & Generators
4. Data serialization and de-serialization
5. Decorators
6. Abstract Base Classes
7. Multi-Threading & Multi-Processing
8. Concurrency & Asyncio
9.  Testing
10. Web Frameworks - Django, Flask & Fastapi
11. Machine Learning & Deep Learning
12. Github

## Final Words

Just persist in your efforts, solutions will follow!

## Contact

I would love to hear your feedback! And would also love to know if you are interested in learning any other topics from me.

Website - [www.octallium.com](https://www.octallium.com)

Twitter - [@octallium](https://twitter.com/octallium)

YouTube - [Octallium](https://www.youtube.com/channel/UCd0MaWAxZklFtCyNPEpSl0w)