[%%shared
(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)
open Eliom_content.Html.D]

[%%client open Js_of_ocaml_lwt]

(* Timepicker demo *)

let%server s, f = Eliom_shared.React.S.create None

let%client action (h, m) =
  ~%f (Some (h, m));
  Lwt.return_unit

let%shared string_of_time = function
  | Some (h, m) ->
      [%i18n Demo.S.you_click_on_time ~h:(string_of_int h) ~m:(string_of_int m)]
  | None -> ""

let%server time_as_string () : string Eliom_shared.React.S.t =
  Eliom_shared.React.S.map [%shared string_of_time] s

let%rpc time_reactive () : string Eliom_shared.React.S.t Lwt.t =
  Lwt.return @@ time_as_string ()

(* Page for this demo *)
let%shared page () =
  let time_picker, _, back_f =
    Ot_time_picker.make ~h24:true ~action:[%client action] ()
  in
  let button =
    Eliom_content.Html.D.button [%i18n Demo.timepicker_back_to_hours]
  in
  ignore
    [%client
      (Lwt.async (fun () ->
         Lwt_js_events.clicks (Eliom_content.Html.To_dom.of_element ~%button)
           (fun _ _ -> ~%back_f (); Lwt.return_unit))
       : _)];
  let%lwt tr = time_reactive () in
  Lwt.return
    [ h1 [%i18n Demo.timepicker]
    ; p [%i18n Demo.timepicker_description]
    ; div [time_picker]
    ; p [Eliom_content.Html.R.txt tr]
    ; div [button] ]

(* Service registration is done on both sides (shared section),
   so that pages can be generated from the server
   (first request, crawling, search engines ...)
   or the client (subsequent link clicks, or mobile app ...). *)
let%shared () =
  %%%MODULE_NAME%%%_base.App.register ~service:Demo_services.demo_timepicker
    ( %%%MODULE_NAME%%%_page.Opt.connected_page @@ fun myid_o () () ->
      let%lwt p = page () in
      %%%MODULE_NAME%%%_container.page ~a:[a_class ["os-page-demo-timepicker"]] myid_o p )
