[%%client
(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)
(* Spinner demo *)
open Js_of_ocaml_lwt]

[%%shared open Eliom_content]
[%%shared open Html.D]

(* Build the spinner *)
let%client make_spinner () =
  (* [Ot_spinner.with_spinner_no_lwt] accepts an Lwt thread "slowly"
     producing HTML content *)
  Ot_spinner.with_spinner_no_lwt
    (* sleep for 5 seconds to simulate a delay, then return content *)
    (let%lwt () = Lwt_js.sleep 5. in
     Lwt.return
       Eliom_content.Html.D.
         [ txt [%i18n Demo.S.spinner_content_ready]
         ; txt " "
         ; txt [%i18n Demo.S.spinner_message_replace_spinner] ])

(* Page for this demo *)
let%shared page () : Html_types.div_content Eliom_content.Html.elt list Lwt.t =
  Lwt.return
    Eliom_content.Html.
      [ F.h1 [%i18n Demo.spinner]
      ; F.p [F.txt [%i18n Demo.S.spinner_description_ot]]
      ; F.p [F.txt [%i18n Demo.S.spinner_description_1]]
      ; F.p [F.txt [%i18n Demo.S.spinner_description_2]]
      ; F.p [F.txt [%i18n Demo.S.spinner_description_3]]
      ; F.p [F.txt [%i18n Demo.S.spinner_generated_client_side]]
      ; C.node [%client (make_spinner () : [> `Div] Eliom_content.Html.elt)] ]

(* Service registration is done on both sides (shared section),
   so that pages can be generated from the server
   (first request, crawling, search engines ...)
   or the client (subsequent link clicks, or mobile app ...). *)
let%shared () =
  %%%MODULE_NAME%%%_base.App.register ~service:Demo_services.demo_spinner
    ( %%%MODULE_NAME%%%_page.Opt.connected_page @@ fun myid_o () () ->
      let%lwt p = page () in
      %%%MODULE_NAME%%%_container.page ~a:[a_class ["os-page-demo-spinner"]] myid_o p )
