[%%shared
(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)
(* Demo for Eliom references and Os_date *)
open Eliom_content.Html.F]

(* An Eliom reference storing the last time the user visited the current
   page. It has scope Eliom_common.default_group_scope, which means that
   the value will be different for each user of the Web site, but the same
   for all the sessions of a same user.
   Ocsigen Start is creating a session group for each user.
*)
let%server last_visit =
  Eliom_reference.eref ~persistent:"demo_last_visit"
    ~scope:Eliom_common.default_group_scope None

(* Read & reset last_visit *)
let%rpc get_reset_last_visit () : Os_date.local_calendar option Lwt.t =
  let%lwt v = Eliom_reference.get last_visit in
  let%lwt () = Eliom_reference.set last_visit (Some (Os_date.now ())) in
  Lwt.return v

(* Call get_reset_last_visit and produce pretty message *)
let%shared get_reset_last_visit_message () =
  let%lwt last_visit = get_reset_last_visit () in
  match last_visit with
  | None -> Lwt.return [%i18n Demo.eliom_ref_first_visit]
  | Some last_visit ->
      Lwt.return
        ([%i18n Demo.eliom_ref_last_visit]
        @ [txt " "; txt (Os_date.smart_time last_visit)])

(* Generate page for this demo *)
let%shared page () =
  let%lwt last_visit_message = get_reset_last_visit_message () in
  Lwt.return
    [ h1 [%i18n Demo.eliom_ref]
    ; p [txt [%i18n Demo.S.eliom_ref_1]]
    ; p [txt [%i18n Demo.S.eliom_ref_2]]
    ; p last_visit_message
    ; p [txt [%i18n Demo.S.eliom_ref_3]] ]

(* Service registration is done on both sides (shared section),
   so that pages can be generated from the server
   (first request, crawling, search engines ...)
   or the client (subsequent link clicks, or mobile app ...). *)
let%shared () =
  %%%MODULE_NAME%%%_base.App.register ~service:Demo_services.demo_ref
    ( %%%MODULE_NAME%%%_page.Opt.connected_page @@ fun myid_o () () ->
      let%lwt p = page () in
      %%%MODULE_NAME%%%_container.page ~a:[a_class ["os-page-demo-ref"]] myid_o p )
