# Contributing

This project is [Apache 2.0 Licenced](LICENCE.txt) and welcomes external contributions. When contributing to this repository, please first discuss the change you wish to make via an [issue](https://github.com/ocp-power-automation/ocp4-upi-powervm/issues).

Please note we have a [code of conduct](CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

# Issues

 - If you find any issue with the code or documentation please submit an [issue](https://github.com/ocp-power-automation/ocp4-upi-powervm/issues).
 - It is best to check out existing issues first to see if a similar one is open or has already been discussed.


# Pull Request Process

 - To contribute code or documentation, please submit a [pull request](https://github.com/ocp-power-automation/ocp4-upi-powervm/pulls).
 - Always take the latest update from upstream/main before creating a pull request.
 - Ensure your changes work fine and have no syntax problems. Also, verify that it does not break the existing code flow.
 - Update the README.md or relevant documents with details of changes to the code. This includes variables change, added or updated feature, change in steps, dependencies change, etc.
 - Make use of proper commit message. Mention the issue# which you are planning to address eg: Fixes #38.
 - After creating the pull request ensure you implement all the review comments given if any. Pull request will be merged only when it has at least two approvals from the list of reviewers.
 - Please read [Developer Certificate of Origin](DCO1.1.txt) and sign-off your commit using command `git commit -s`.


# Spec Formatting Conventions
Documents in this repository will adhere to the following rules:

 - Lines are wrapped at 80 columns (when possible)
 - Use spaces to indent your code. Do not use tab character, instead can use 2/4 spaces.

