StylesElement = require '../../src/styles-element'
StyleManager = require '../../src/style-manager'

describe "StylesElement", ->
  [element, addedStyleElements, removedStyleElements, updatedStyleElements] = []

  beforeEach ->
    element = new StylesElement
    document.querySelector('#jasmine-content').appendChild(element)
    addedStyleElements = []
    removedStyleElements = []
    updatedStyleElements = []
    element.onDidAddStyleElement (element) -> addedStyleElements.push(element)
    element.onDidRemoveStyleElement (element) -> removedStyleElements.push(element)
    element.onDidUpdateStyleElement (element) -> updatedStyleElements.push(element)

  it "renders a style tag for all currently active stylesheets in the style manager", ->
    initialChildCount = element.children.length

    disposable1 = NylasEnv.styles.addStyleSheet("a {color: red;}")
    expect(element.children.length).toBe initialChildCount + 1
    expect(element.children[initialChildCount].textContent).toBe "a {color: red;}"
    expect(addedStyleElements).toEqual [element.children[initialChildCount]]

    disposable2 = NylasEnv.styles.addStyleSheet("a {color: blue;}")
    expect(element.children.length).toBe initialChildCount + 2
    expect(element.children[initialChildCount + 1].textContent).toBe "a {color: blue;}"
    expect(addedStyleElements).toEqual [element.children[initialChildCount], element.children[initialChildCount + 1]]

    disposable1.dispose()
    expect(element.children.length).toBe initialChildCount + 1
    expect(element.children[initialChildCount].textContent).toBe "a {color: blue;}"
    expect(removedStyleElements).toEqual [addedStyleElements[0]]

    disposable2.dispose()

  it "orders style elements by priority", ->
    initialChildCount = element.children.length

    NylasEnv.styles.addStyleSheet("a {color: red}", priority: 1)
    NylasEnv.styles.addStyleSheet("a {color: blue}", priority: 0)
    NylasEnv.styles.addStyleSheet("a {color: green}", priority: 2)
    NylasEnv.styles.addStyleSheet("a {color: yellow}", priority: 1)

    expect(element.children[initialChildCount].textContent).toBe "a {color: blue}"
    expect(element.children[initialChildCount + 1].textContent).toBe "a {color: red}"
    expect(element.children[initialChildCount + 2].textContent).toBe "a {color: yellow}"
    expect(element.children[initialChildCount + 3].textContent).toBe "a {color: green}"

  it "updates existing style nodes when style elements are updated", ->
    initialChildCount = element.children.length

    NylasEnv.styles.addStyleSheet("a {color: red;}", sourcePath: '/foo/bar')
    NylasEnv.styles.addStyleSheet("a {color: blue;}", sourcePath: '/foo/bar')

    expect(element.children.length).toBe initialChildCount + 1
    expect(element.children[initialChildCount].textContent).toBe "a {color: blue;}"
    expect(updatedStyleElements).toEqual [element.children[initialChildCount]]

  it "only includes style elements matching the 'context' attribute", ->
    initialChildCount = element.children.length

    NylasEnv.styles.addStyleSheet("a {color: red;}", context: 'test-context')
    NylasEnv.styles.addStyleSheet("a {color: green;}")

    expect(element.children.length).toBe initialChildCount + 2
    expect(element.children[initialChildCount].textContent).toBe "a {color: red;}"
    expect(element.children[initialChildCount + 1].textContent).toBe "a {color: green;}"

    element.setAttribute('context', 'test-context')

    expect(element.children.length).toBe 1
    expect(element.children[0].textContent).toBe "a {color: red;}"

    NylasEnv.styles.addStyleSheet("a {color: blue;}", context: 'test-context')
    NylasEnv.styles.addStyleSheet("a {color: yellow;}")

    expect(element.children.length).toBe 2
    expect(element.children[0].textContent).toBe "a {color: red;}"
    expect(element.children[1].textContent).toBe "a {color: blue;}"
