/*
 * Copyright 2013 Google Inc.
 * Copyright 2018 Michael Tuexen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
/*
 * Author: tuexen@fh-muenster.de (Michael Tuexen)
 *
 * Definitions of strace-style symbols for Solaris 11.4.
 * Allows us to map from symbolic strings to integers for system call inputs.
 */

#if defined(__SunOS_5_11)

#include "symbols.h"

#include <errno.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/sctp.h> /* XXX MT: Remove after uncomment in platforms.h */
#include <poll.h>
#include <stdlib.h>
#include <string.h>
#include <sys/filio.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "tcp.h"

/* A table of platform-specific string->int mappings. */
struct int_symbol platform_symbols_table[] = {

	/* /usr/include/sys/socket.h */
	{ SO_DEBUG,                         "SO_DEBUG"                        },
	{ SO_ACCEPTCONN,                    "SO_ACCEPTCONN"                   },
	{ SO_REUSEADDR,                     "SO_REUSEADDR"                    },
	{ SO_KEEPALIVE,                     "SO_KEEPALIVE"                    },
	{ SO_DONTROUTE,                     "SO_DONTROUTE"                    },
	{ SO_BROADCAST,                     "SO_BROADCAST"                    },
	{ SO_USELOOPBACK,                   "SO_USELOOPBACK"                  },
	{ SO_LINGER,                        "SO_LINGER"                       },
	{ SO_OOBINLINE,                     "SO_OOBINLINE"                    },
	{ SO_DGRAM_ERRIND,                  "SO_DGRAM_ERRIND"                 },
	{ SO_RECVUCRED,                     "SO_RECVUCRED"                    },
#ifdef SO_NOSIGPIPE
	{ SO_NOSIGPIPE,                     "SO_NOSIGPIPE"                    },
#endif
	{ SO_SNDBUF,                        "SO_SNDBUF"                       },
	{ SO_RCVBUF,                        "SO_RCVBUF"                       },
	{ SO_SNDLOWAT,                      "SO_SNDLOWAT"                     },
	{ SO_RCVLOWAT,                      "SO_RCVLOWAT"                     },
	{ SO_SNDTIMEO,                      "SO_SNDTIMEO"                     },
	{ SO_RCVTIMEO,                      "SO_RCVTIMEO"                     },
	{ SO_ERROR,                         "SO_ERROR"                        },
	{ SO_TYPE,                          "SO_TYPE"                         },
	{ SO_PROTOTYPE,                     "SO_PROTOTYPE"                    },
	{ SO_ANON_MLP,                      "SO_ANON_MLP"                     },
	{ SO_MAC_EXEMPT,                    "SO_MAC_EXEMPT"                   },
	{ SO_DOMAIN,                        "SO_DOMAIN"                       },
	{ SO_RCVPSH,                        "SO_RCVPSH"                       },
	{ SO_REUSEPORT,                     "SO_REUSEPORT"                    },
	{ SO_PASSIVE_CONNECT,               "SO_PASSIVE_CONNECT"              },
	{ SO_SECATTR,                       "SO_SECATTR"                      },
	{ SO_TIMESTAMP,                     "SO_TIMESTAMP"                    },
	{ SO_ALLZONES,                      "SO_ALLZONES"                     },
	{ SO_EXCLBIND,                      "SO_EXCLBIND"                     },
	{ SO_MAC_IMPLICIT,                  "SO_MAC_IMPLICIT"                 },
	{ SO_VRRP,                          "SO_VRRP"                         },
	{ SO_FLOW_SLA,                      "SO_FLOW_SLA"                     },
#ifdef SO_LISTENQLIMIT
	{ SO_LISTENQLIMIT,                  "SO_LISTENQLIMIT"                 },
#endif
#ifdef SO_FLOW_NAME
	{ SO_FLOW_NAME,                     "SO_FLOW_NAME"                    },
#endif
#ifdef SO_NET_KERNEL_BYPASS
	{ SO_NET_KERNEL_BYPASS,             "SO_NET_KERNEL_BYPASS"            },
#endif
#ifdef SO_NET_KERNEL_BYPASS_STATS
	{ SO_NET_KERNEL_BYPASS_STATS,       "SO_NET_KERNEL_BYPASS_STATS"      },
#endif

	/* /usr/include/netinet/in.h */
	{ IP_OPTIONS,                       "IP_OPTIONS"                      },
	{ IP_HDRINCL,                       "IP_HDRINCL"                      },
	{ IP_TOS,                           "IP_TOS"                          },
	{ IP_TTL,                           "IP_TTL"                          },
	{ IP_RECVOPTS,                      "IP_RECVOPTS"                     },
	{ IP_RECVRETOPTS,                   "IP_RECVRETOPTS"                  },
	{ IP_RECVDSTADDR,                   "IP_RECVDSTADDR"                  },
	{ IP_RETOPTS,                       "IP_RETOPTS"                      },
	{ IP_RECVIF,                        "IP_RECVIF"                       },
	{ IP_RECVTTL,                       "IP_RECVTTL"                      },
	{ IP_PKTINFO,                       "IP_PKTINFO,"                     },
	{ IP_RECVPKTINFO,                   "IP_RECVPKTINFO"                  },
	{ IP_DONTFRAG,                      "IP_DONTFRAG"                     },
	{ IP_BOUND_IF,                      "IP_BOUND_IF"                     },
	{ IP_UNSPEC_SRC,                    "IP_UNSPEC_SRC"                   },
	{ IP_REUSEADDR,                     "IP_REUSEADDR"                    },
	{ IP_DONTROUTE,                     "IP_DONTROUTE,"                   },
	{ IP_BROADCAST,                     "IP_BROADCAST"                    },
	{ IPV6_UNICAST_HOPS,                "IPV6_UNICAST_HOPS"               },
	{ IPV6_PKTINFO,                     "IPV6_PKTINFO"                    },
	{ IPV6_HOPLIMIT,                    "IPV6_HOPLIMIT"                   },
	{ IPV6_NEXTHOP,                     "IPV6_NEXTHOP"                    },
	{ IPV6_HOPOPTS,                     "IPV6_HOPOPTS"                    },
	{ IPV6_DSTOPTS,                     "IPV6_DSTOPTS"                    },
	{ IPV6_RTHDR,                       "IPV6_RTHDR"                      },
	{ IPV6_RTHDRDSTOPTS,                "IPV6_RTHDRDSTOPTS"               },
	{ IPV6_RECVPKTINFO,                 "IPV6_RECVPKTINFO"                },
	{ IPV6_RECVHOPLIMIT,                "IPV6_RECVHOPLIMIT"               },
	{ IPV6_RECVHOPOPTS,                 "IPV6_RECVHOPOPTS"                },
	{ IPV6_RECVRTHDR,                   "IPV6_RECVRTHDR"                  },
	{ IPV6_CHECKSUM,                    "IPV6_CHECKSUM"                   },
	{ IPV6_RECVTCLASS,                  "IPV6_RECVTCLASS"                 },
	{ IPV6_USE_MIN_MTU,                 "IPV6_USE_MIN_MTU"                },
	{ IPV6_DONTFRAG,                    "IPV6_DONTFRAG"                   },
	{ IPV6_SEC_OPT,                     "IPV6_SEC_OPT"                    },
	{ IPV6_SRC_PREFERENCES,             "IPV6_SRC_PREFERENCES"            },
	{ IPV6_RECVPATHMTU,                 "IPV6_RECVPATHMTU"                },
	{ IPV6_PATHMTU,                     "IPV6_PATHMTU"                    },
	{ IPV6_TCLASS,                      "IPV6_TCLASS"                     },
	{ IPV6_V6ONLY,                      "IPV6_V6ONLY"                     },
	{ IPV6_RECVDSTOPTS,                 "IPV6_RECVDSTOPTS"                },
	{ IPV6_BOUND_IF,                    "IPV6_BOUND_IF"                   },
	{ IPV6_UNSPEC_SRC,                  "IPV6_UNSPEC_SRC"                 },

	/* /usr/include/netinet/sctp.h */
	{ SCTP_RTOINFO,                     "SCTP_RTOINFO"                    },
	{ SCTP_ASSOCINFO,                   "SCTP_ASSOCINFO"                  },
	{ SCTP_INITMSG,                     "SCTP_INITMSG"                    },
	{ SCTP_NODELAY,                     "SCTP_NODELAY"                    },
	{ SCTP_AUTOCLOSE,                   "SCTP_AUTOCLOSE"                  },
	{ SCTP_SET_PEER_PRIMARY_ADDR,       "SCTP_SET_PEER_PRIMARY_ADDR"      },
	{ SCTP_PRIMARY_ADDR,                "SCTP_PRIMARY_ADDR"               },
	{ SCTP_ADAPTATION_LAYER,            "SCTP_ADAPTATION_LAYER"           },
	{ SCTP_DISABLE_FRAGMENTS,           "SCTP_DISABLE_FRAGMENTS"          },
	{ SCTP_PEER_ADDR_PARAMS,            "SCTP_PEER_ADDR_PARAMS"           },
	{ SCTP_EVENTS,                      "SCTP_EVENTS"                     },
	{ SCTP_I_WANT_MAPPED_V4_ADDR,       "SCTP_I_WANT_MAPPED_V4_ADDR"      },
	{ SCTP_MAXSEG,                      "SCTP_MAXSEG"                     },
	{ SCTP_STATUS,                      "SCTP_STATUS"                     },
	{ SCTP_GET_PEER_ADDR_INFO,          "SCTP_GET_PEER_ADDR_INFO"         },
	{ SCTP_PRSCTP,                      "SCTP_PRSCTP"                     },
	{ SCTP_GET_ASSOC_STATS,             "SCTP_GET_ASSOC_STATS"            },
	{ SCTP_CONGESTION,                  "SCTP_CONGESTION"                 },
	{ SCTP_EVENT,                       "SCTP_EVENT"                      },
	{ SCTP_HMAC_IDENT,                  "SCTP_HMAC_IDENT"                 },
	{ SCTP_DELAYED_SACK,                "SCTP_DELAYED_SACK"               },
	{ SCTP_FRAGMENT_INTERLEAVE,         "SCTP_FRAGMENT_INTERLEAVE"        },
	{ SCTP_PARTIAL_DELIVERY_POINT,      "SCTP_PARTIAL_DELIVERY_POINT"     },
	{ SCTP_MAX_BURST,                   "SCTP_MAX_BURST"                  },
	{ SCTP_CONTEXT,                     "SCTP_CONTEXT"                    },
	{ SCTP_EXPLICIT_EOR,                "SCTP_EXPLICIT_EOR"               },
	{ SCTP_REUSE_PORT,                  "SCTP_REUSE_PORT"                 },
	{ SCTP_RECVRCVINFO,                 "SCTP_RECVRCVINFO"                },
	{ SCTP_RECVNXTINFO,                 "SCTP_RECVNXTINFO"                },
	{ SCTP_DEFAULT_SNDINFO,             "SCTP_DEFAULT_SNDINFO"            },
	{ SCTP_GET_ASSOC_NUMBER,            "SCTP_GET_ASSOC_NUMBER"           },
	{ SCTP_NO_INTERLEAVE,               "SCTP_NO_INTERLEAVE"              },
	{ SCTP_ASSOC_INTERLEAVE,            "SCTP_ASSOC_INTERLEAVE"           },
	{ SCTP_COMPLETE_INTERLEAVE,         "SCTP_COMPLETE_INTERLEAVE"        },
	{ SCTP_SNDRCV,                      "SCTP_SNDRCV"                     },
	{ SCTP_INIT,                        "SCTP_INIT"                       },
	{ SCTP_SNDINFO,                     "SCTP_SNDINFO"                    },
	{ SCTP_RCVINFO,                     "SCTP_RCVINFO"                    },
	{ SCTP_NXTINFO,                     "SCTP_NXTINFO"                    },
	{ SCTP_PRINFO,                      "SCTP_PRINFO"                     },
	{ SCTP_AUTHINFO,                    "SCTP_AUTHINFO"                   },
	{ SCTP_DSTADDRV4,                   "SCTP_DSTADDRV4"                  },
	{ SCTP_DSTADDRV6,                   "SCTP_DSTADDRV6"                  },
	{ SCTP_UNORDERED,                   "SCTP_UNORDERED"                  },
	{ SCTP_ABORT,                       "SCTP_ABORT"                      },
	{ SCTP_EOF,                         "SCTP_EOF"                        },
	{ SCTP_ADDR_OVER,                   "SCTP_ADDR_OVER"                  },
	{ SCTP_SENDALL,                     "SCTP_SENDALL"                    },
	{ SCTP_EOR,                         "SCTP_EOR"                        },
	{ SCTP_COMPLETE,                    "SCTP_COMPLETE"                   },
	{ SCTP_NOTIFICATION,                "SCTP_NOTIFICATION"               },
	{ SCTP_PR_SCTP_NONE,                "SCTP_PR_SCTP_NONE"               },
	{ SCTP_PR_SCTP_TTL,                 "SCTP_PR_SCTP_TTL"                },
	{ SCTP_RECVV_NOINFO,                "SCTP_RECVV_NOINFO"               },
	{ SCTP_RECVV_RCVINFO,               "SCTP_RECVV_RCVINFO"              },
	{ SCTP_RECVV_NXTINFO,               "SCTP_RECVV_NXTINFO"              },
	{ SCTP_RECVV_RN,                    "SCTP_RECVV_RN"                   },
	{ SCTP_SEND_SNDINFO_VALID,          "SCTP_SEND_SNDINFO_VALID"         },
	{ SCTP_SEND_PRINFO_VALID,           "SCTP_SEND_PRINFO_VALID"          },
	{ SCTP_SEND_AUTHINFO_VALID,         "SCTP_SEND_AUTHINFO_VALID"        },
	{ SCTP_SENDV_SNDINFO,               "SCTP_SENDV_SNDINFO"              },
	{ SCTP_SENDV_PRINFO,                "SCTP_SENDV_PRINFO"               },
	{ SCTP_SENDV_AUTHINFO,              "SCTP_SENDV_AUTHINFO"             },
	{ SCTP_SENDV_SPA,                   "SCTP_SENDV_SPA"                  },
	{ SCTP_ASSOC_CHANGE,                "SCTP_ASSOC_CHANGE"               },
	{ SCTP_PEER_ADDR_CHANGE,            "SCTP_PEER_ADDR_CHANGE"           },
	{ SCTP_REMOTE_ERROR,                "SCTP_REMOTE_ERROR"               },
	{ SCTP_SEND_FAILED,                 "SCTP_SEND_FAILED"                },
	{ SCTP_SHUTDOWN_EVENT,              "SCTP_SHUTDOWN_EVENT"             },
	{ SCTP_ADAPTATION_INDICATION,       "SCTP_ADAPTATION_INDICATION"      },
	{ SCTP_PARTIAL_DELIVERY_EVENT,      "SCTP_PARTIAL_DELIVERY_EVENT"     },
	{ SCTP_AUTHENTICATION_EVENT,        "SCTP_AUTHENTICATION_EVENT"       },
	{ SCTP_SENDER_DRY_EVENT,            "SCTP_SENDER_DRY_EVENT"           },
	{ SCTP_NOTIFICATIONS_STOPPED_EVENT, "SCTP_NOTIFICATIONS_STOPPED_EVENT"},
	{ SCTP_SEND_FAILED_EVENT,           "SCTP_SEND_FAILED_EVENT"          },
	{ SCTP_COMM_UP,                     "SCTP_COMM_UP"                    },
	{ SCTP_COMM_LOST,                   "SCTP_COMM_LOST"                  },
	{ SCTP_RESTART,                     "SCTP_RESTART"                    },
	{ SCTP_SHUTDOWN_COMP,               "SCTP_SHUTDOWN_COMP"              },
	{ SCTP_CANT_STR_ASSOC,              "SCTP_CANT_STR_ASSOC"             },
	{ SCTP_PRSCTP_CAPABLE,              "SCTP_PRSCTP_CAPABLE"             },
	{ SCTP_ADDR_AVAILABLE,              "SCTP_ADDR_AVAILABLE"             },
	{ SCTP_ADDR_UNREACHABLE,            "SCTP_ADDR_UNREACHABLE"           },
	{ SCTP_ADDR_REMOVED,                "SCTP_ADDR_REMOVED"               },
	{ SCTP_ADDR_ADDED,                  "SCTP_ADDR_MADE_PRIM"             },
	{ SCTP_DATA_UNSENT,                 "SCTP_DATA_UNSENT"                },
	{ SCTP_DATA_SENT,                   "SCTP_DATA_SENT"                  },
	{ SCTP_INACTIVE,                    "SCTP_INACTIVE"                   },
	{ SCTP_ACTIVE,                      "SCTP_ACTIVE"                     },
	{ SCTP_UNCONFIRMED,                 "SCTP_UNCONFIRMED"                },
	{ SPP_HB_ENABLE,                    "SPP_HB_ENABLE"                   },
	{ SPP_HB_DISABLE,                   "SPP_HB_DISABLE"                  },
	{ SPP_HB_DEMAND,                    "SPP_HB_DEMAND"                   },
	{ SPP_HB_TIME_IS_ZERO,              "SPP_HB_TIME_IS_ZERO"             },
	{ SPP_PMTUD_ENABLE,                 "SPP_PMTUD_ENABLE"                },
	{ SPP_PMTUD_DISABLE,                "SPP_PMTUD_DISABLE"               },
	{ SPP_IPV6_FLOWLABEL,               "SPP_IPV6_FLOWLABEL"              },
	{ SPP_IPV4_TOS,                     "SPP_IPV4_TOS"                    },
	{ SCTP_CLOSED,                      "SCTP_CLOSED"                     },
	{ SCTP_BOUND,                       "SCTP_BOUND"                      },
	{ SCTP_LISTEN,                      "SCTP_LISTEN"                     },
	{ SCTP_COOKIE_WAIT,                 "SCTP_COOKIE_WAIT"                },
	{ SCTP_COOKIE_ECHOED,               "SCTP_COOKIE_ECHOED"              },
	{ SCTP_ESTABLISHED,                 "SCTP_ESTABLISHED"                },
	{ SCTP_SHUTDOWN_PENDING,            "SCTP_SHUTDOWN_PENDING"           },
	{ SCTP_SHUTDOWN_SENT,               "SCTP_SHUTDOWN_SENT"              },
	{ SCTP_SHUTDOWN_RECEIVED,           "SCTP_SHUTDOWN_RECEIVED"          },
	{ SCTP_SHUTDOWN_ACK_SENT,           "SCTP_SHUTDOWN_ACK_SENT"          },

	/* /usr/include/netinet/tcp.h */
	{ TCP_NODELAY,                      "TCP_NODELAY"                     },
	{ TCP_MAXSEG,                       "TCP_MAXSEG"                      },
	{ TCP_KEEPALIVE,                    "TCP_KEEPALIVE"                   },
	{ TCP_NOTIFY_THRESHOLD,             "TCP_NOTIFY_THRESHOLD"            },
	{ TCP_ABORT_THRESHOLD,              "TCP_ABORT_THRESHOLD"             },
	{ TCP_CONN_NOTIFY_THRESHOLD,        "TCP_CONN_NOTIFY_THRESHOLD"       },
	{ TCP_CONN_ABORT_THRESHOLD,         "TCP_CONN_ABORT_THRESHOLD"        },
	{ TCP_RECVDSTADDR,                  "TCP_RECVDSTADDR"                 },
	{ TCP_INIT_CWND,                    "TCP_INIT_CWND"                   },
	{ TCP_KEEPALIVE_THRESHOLD,          "TCP_KEEPALIVE_THRESHOLD"         },
	{ TCP_KEEPALIVE_ABORT_THRESHOLD,    "TCP_KEEPALIVE_ABORT_THRESHOLD"   },
	{ TCP_CORK,                         "TCP_CORK"                        },
	{ TCP_RTO_INITIAL,                  "TCP_RTO_INITIAL"                 },
	{ TCP_RTO_MIN,                      "TCP_RTO_MIN"                     },
	{ TCP_RTO_MAX,                      "TCP_RTO_MAX"                     },
	{ TCP_LINGER2,                      "TCP_LINGER2"                     },
#ifdef TCP_KEEPIDLE
	{ TCP_KEEPIDLE,                     "TCP_KEEPIDLE"                    },
#endif
#ifdef TCP_KEEPINTVL
	{ TCP_KEEPINTVL,                    "TCP_KEEPINTVL"                   },
#endif
#ifdef TCP_KEEPCNT
	{ TCP_KEEPCNT,                      "TCP_KEEPCNT"                     },
#endif
	{ TCP_INFO,                         "TCP_INFO"                        },
	{ TCP_CONGESTION,                   "TCP_CONGESTION"                  },
	{ TCP_MD5SIG,                       "TCP_MD5SIG"                      },

	/* /usr/include/sys/fcntl.h */
	{ O_RDONLY,                         "O_RDONLY"                        },
	{ O_WRONLY,                         "O_WRONLY"                        },
	{ O_RDWR,                           "O_RDWR"                          },
	{ O_SEARCH,                         "O_SEARCH"                        },
	{ O_EXEC,                           "O_EXEC"                          },
	{ O_NDELAY,                         "O_NDELAY"                        },
	{ O_APPEND,                         "O_APPEND"                        },
	{ O_SYNC,                           "O_SYNC"                          },
	{ O_DSYNC,                          "O_DSYNC"                         },
	{ O_RSYNC,                          "O_RSYNC"                         },
	{ O_NONBLOCK,                       "O_NONBLOCK"                      },
	{ O_LARGEFILE,                      "O_LARGEFILE"                     },
	{ O_CREAT,                          "O_CREAT"                         },
	{ O_TRUNC,                          "O_TRUNC"                         },
	{ O_EXCL,                           "O_EXCL"                          },
	{ O_NOCTTY,                         "O_NOCTTY"                        },
	{ O_XATTR,                          "O_XATTR"                         },
	{ O_NOFOLLOW,                       "O_NOFOLLOW"                      },
	{ O_NOLINKS,                        "O_NOLINKS"                       },
	{ O_CLOEXEC,                        "O_CLOEXEC"                       },
	{ O_DIRECTORY,                      "O_DIRECTORY"                     },
	{ O_TTY_INIT,                       "O_TTY_INIT"                      },
	{ O_TPDSAFE,                        "O_TPDSAFE"                       },
	{ O_XPG4OPEN,                       "O_XPG4OPEN"                      },
	{ O_CLOFORK,                        "O_CLOFORK"                       },
#ifdef O_NOSIGPIPE
	{ O_NOSIGPIPE,                      "O_NOSIGPIPE"                     },
#endif
	{ F_DUPFD,                          "F_DUPFD"                         },
	{ F_DUPFD_CLOEXEC,                  "F_DUPFD_CLOEXEC"                 },
	{ F_DUPFD_CLOFORK,                  "F_DUPFD_CLOFORK"                 },
	{ F_GETFD,                          "F_GETFD"                         },
	{ F_SETFD,                          "F_SETFD"                         },
	{ F_GETFL,                          "F_GETFL"                         },
	{ F_GETXFL,                         "F_GETXFL"                        },
	{ F_SETFL,                          "F_SETFL"                         },
	{ F_CHKFL,                          "F_CHKFL"                         },
	{ F_DUP2FD,                         "F_DUP2FD"                        },
	{ F_DUP2FD_CLOEXEC,                 "F_DUP2FD_CLOEXEC"                },
	{ F_DUP2FD_CLOFORK,                 "F_DUP2FD_CLOFORK"                },
	{ F_ISSTREAM,                       "F_ISSTREAM"                      },
	{ F_PRIV,                           "F_PRIV"                          },
	{ F_NPRIV,                          "F_NPRIV"                         },
	{ F_QUOTACTL,                       "F_QUOTACTL"                      },
	{ F_BLOCKS,                         "F_BLOCKS"                        },
	{ F_BLKSIZE,                        "F_BLKSIZE"                       },
	{ F_GETOWN,                         "F_GETOWN"                        },
	{ F_SETOWN,                         "F_SETOWN"                        },
	{ F_REVOKE,                         "F_REVOKE"                        },
	{ F_HASREMOTELOCKS,                 "F_HASREMOTELOCKS"                },
	{ F_SETLK,                          "F_SETLK"                         },
	{ F_SETLKW,                         "F_SETLKW"                        },
	{ F_ALLOCSP,                        "F_ALLOCSP"                       },
	{ F_FREESP,                         "F_FREESP"                        },
	{ F_GETLK,                          "F_GETLK"                         },
	{ F_SETLK_NBMAND,                   "F_SETLK_NBMAND"                  },
	{ F_SETLK64,                        "F_SETLK64"                       },
	{ F_SETLKW64,                       "F_SETLKW64"                      },
	{ F_ALLOCSP64,                      "F_ALLOCSP64"                     },
	{ F_FREESP64,                       "F_FREESP64"                      },
	{ F_GETLK64,                        "F_GETLK64"                       },
	{ F_SETLK64_NBMAND,                 "F_SETLK64_NBMAND"                },
	{ F_SHARE,                          "F_SHARE"                         },
	{ F_UNSHARE,                        "F_UNSHARE"                       },
	{ F_SHARE_NBMAND,                   "F_SHARE_NBMAND"                  },
	{ F_BADFD,                          "F_BADFD"                         },
#ifdef F_SETTPD
	{ F_SETTPD,                         "F_SETTPD"                        },
#endif
#ifdef F_GETTPD
	{ F_GETTPD,                         "F_GETTPD"                        },
#endif
#ifdef F_DUP3FD
	{ F_DUP3FD,                         "F_DUP3FD"                        },
#endif
#ifdef F_CLOSEFROM
	{ F_CLOSEFROM,                      "F_CLOSEFROM"                     },
#endif
	{ O_ACCMODE,                        "O_ACCMODE"                       },
	{ FD_CLOEXEC,                       "FD_CLOEXEC"                      },
	{ FD_CLOFORK,                       "FD_CLOFORK"                      },
	{ DIRECTIO_OFF,                     "DIRECTIO_OFF"                    },
	{ DIRECTIO_ON,                      "DIRECTIO_ON"                     },
	{ F_RDACC,                          "F_RDACC"                         },
	{ F_WRACC,                          "F_WRACC"                         },
	{ F_RWACC,                          "F_RWACC"                         },
	{ F_RMACC,                          "F_RMACC"                         },
	{ F_MDACC,                          "F_MDACC"                         },
	{ F_NODNY,                          "F_NODNY"                         },
	{ F_RDDNY,                          "F_RDDNY"                         },
	{ F_WRDNY,                          "F_WRDNY"                         },
	{ F_RWDNY,                          "F_RWDNY"                         },
	{ F_RMDNY,                          "F_RMDNY"                         },
	{ F_COMPAT,                         "F_COMPAT"                        },
	{ F_MANDDNY,                        "F_MANDDNY"                       },
	{ AT_FDCWD,                         "AT_FDCWD"                        },
	{ AT_SYMLINK_NOFOLLOW,              "AT_SYMLINK_NOFOLLOW"             },
	{ AT_SYMLINK_FOLLOW,                "AT_SYMLINK_FOLLOW"               },
	{ AT_REMOVEDIR,                     "AT_REMOVEDIR"                    },
	{ _AT_TRIGGER,                      "_AT_TRIGGER"                     },
	{ AT_EACCESS,                       "AT_EACCESS"                      },
	{ POSIX_FADV_NORMAL,                "POSIX_FADV_NORMAL"               },
	{ POSIX_FADV_RANDOM,                "POSIX_FADV_RANDOM"               },
	{ POSIX_FADV_SEQUENTIAL,            "POSIX_FADV_SEQUENTIAL"           },
	{ POSIX_FADV_WILLNEED,              "POSIX_FADV_WILLNEED"             },
	{ POSIX_FADV_DONTNEED,              "POSIX_FADV_DONTNEED"             },
	{ POSIX_FADV_NOREUSE,               "POSIX_FADV_NOREUSE"              },

	/* /usr/include/sys/socket.h */
	{ MSG_OOB,                          "MSG_OOB"                         },
	{ MSG_PEEK,                         "MSG_PEEK"                        },
	{ MSG_DONTROUTE,                    "MSG_DONTROUTE"                   },
	{ MSG_EOR,                          "MSG_EOR"                         },
	{ MSG_TRUNC,                        "MSG_TRUNC"                       },
	{ MSG_CTRUNC,                       "MSG_CTRUNC"                      },
	{ MSG_WAITALL,                      "MSG_WAITALL"                     },
	{ MSG_DUPCTRL,                      "MSG_DUPCTRL"                     },
	{ MSG_DONTWAIT,                     "MSG_DONTWAIT"                    },
	{ MSG_NOTIFICATION,                 "MSG_NOTIFICATION"                },
#ifdef MSG_NOSIGNAL
	{ MSG_NOSIGNAL,                     "MSG_NOSIGNAL"                    },
#endif
#ifdef MSG_WAITFORONE
	{ MSG_WAITFORONE,                   "MSG_WAITFORONE"                  },
#endif
	{ MSG_XPG4_2,                       "MSG_XPG4_2"                      },

	/* /usr/include/sys/filio.h */
	{ FIOCLEX,                          "FIOCLEX"                         },
	{ FIONCLEX,                         "FIONCLEX"                        },
	{ FIONREAD,                         "FIONREAD"                        },
	{ FIONBIO,                          "FIONBIO"                         },
	{ FIOASYNC,                         "FIOASYNC"                        },
	{ FIOSETOWN,                        "FIOSETOWN"                       },
	{ FIOGETOWN,                        "FIOGETOWN"                       },

	/* /usr/include/sys/poll.h */
	{ POLLIN,                           "POLLIN"                          },
	{ POLLPRI,                          "POLLPRI"                         },
	{ POLLOUT,                          "POLLOUT"                         },
	{ POLLRDNORM,                       "POLLRDNORM"                      },
	{ POLLWRNORM,                       "POLLWRNORM"                      },
	{ POLLRDBAND,                       "POLLRDBAND"                      },
	{ POLLWRBAND,                       "POLLWRBAND"                      },
	{ POLLERR,                          "POLLERR"                         },
	{ POLLHUP,                          "POLLHUP"                         },
	{ POLLNVAL,                         "POLLNVAL"                        },
	{ POLLREMOVE,                       "POLLREMOVE"                      },

	/* /usr/include/sys/errno.h */
	{ EPERM,                            "EPERM"                           },
	{ ENOENT,                           "ENOENT"                          },
	{ ESRCH,                            "ESRCH"                           },
	{ EINTR,                            "EINTR"                           },
	{ EIO,                              "EIO"                             },
	{ ENXIO,                            "ENXIO"                           },
	{ E2BIG,                            "E2BIG"                           },
	{ ENOEXEC,                          "ENOEXEC"                         },
	{ EBADF,                            "EBADF"                           },
	{ ECHILD,                           "ECHILD"                          },
	{ EAGAIN,                           "EAGAIN"                          },
	{ ENOMEM,                           "ENOMEM"                          },
	{ EACCES,                           "EACCES"                          },
	{ EFAULT,                           "EFAULT"                          },
	{ ENOTBLK,                          "ENOTBLK"                         },
	{ EBUSY,                            "EBUSY"                           },
	{ EEXIST,                           "EEXIST"                          },
	{ EXDEV,                            "EXDEV"                           },
	{ ENODEV,                           "ENODEV"                          },
	{ ENOTDIR,                          "ENOTDIR"                         },
	{ EISDIR,                           "EISDIR"                          },
	{ EINVAL,                           "EINVAL"                          },
	{ ENFILE,                           "ENFILE"                          },
	{ EMFILE,                           "EMFILE"                          },
	{ ENOTTY,                           "ENOTTY"                          },
	{ ETXTBSY,                          "ETXTBSY"                         },
	{ EFBIG,                            "EFBIG"                           },
	{ ENOSPC,                           "ENOSPC"                          },
	{ ESPIPE,                           "ESPIPE"                          },
	{ EROFS,                            "EROFS"                           },
	{ EMLINK,                           "EMLINK"                          },
	{ EPIPE,                            "EPIPE"                           },
	{ EDOM,                             "EDOM"                            },
	{ ERANGE,                           "ERANGE"                          },
	{ ENOMSG,                           "ENOMSG"                          },
	{ EIDRM,                            "EIDRM"                           },
	{ ECHRNG,                           "ECHRNG"                          },
	{ EL2NSYNC,                         "EL2NSYNC"                        },
	{ EL3HLT,                           "EL3HLT"                          },
	{ EL3RST,                           "EL3RST"                          },
	{ ELNRNG,                           "ELNRNG"                          },
	{ EUNATCH,                          "EUNATCH"                         },
	{ ENOCSI,                           "ENOCSI"                          },
	{ EL2HLT,                           "EL2HLT"                          },
	{ EDEADLK,                          "EDEADLK"                         },
	{ ENOLCK,                           "ENOLCK"                          },
	{ ECANCELED,                        "ECANCELED"                       },
	{ ENOTSUP,                          "ENOTSUP"                         },
	{ EDQUOT,                           "EDQUOT"                          },
	{ EBADE,                            "EBADE"                           },
	{ EBADR,                            "EBADR"                           },
	{ EXFULL,                           "EXFULL"                          },
	{ ENOANO,                           "ENOANO"                          },
	{ EBADRQC,                          "EBADRQC"                         },
	{ EBADSLT,                          "EBADSLT"                         },
	{ EDEADLOCK,                        "EDEADLOCK"                       },
	{ EBFONT,                           "EBFONT"                          },
	{ EOWNERDEAD,                       "EOWNERDEAD"                      },
	{ ENOTRECOVERABLE,                  "ENOTRECOVERABLE"                 },
	{ ENOSTR,                           "ENOSTR"                          },
	{ ENODATA,                          "ENODATA"                         },
	{ ETIME,                            "ETIME"                           },
	{ ENOSR,                            "ENOSR"                           },
	{ ENONET,                           "ENONET"                          },
	{ ENOPKG,                           "ENOPKG"                          },
	{ EREMOTE,                          "EREMOTE"                         },
	{ ENOLINK,                          "ENOLINK"                         },
	{ EADV,                             "EADV"                            },
	{ ESRMNT,                           "ESRMNT"                          },
	{ ECOMM,                            "ECOMM"                           },
	{ EPROTO,                           "EPROTO"                          },
	{ ELOCKUNMAPPED,                    "ELOCKUNMAPPED"                   },
	{ ENOTACTIVE,                       "ENOTACTIVE"                      },
	{ EMULTIHOP,                        "EMULTIHOP"                       },
	{ EADI,                             "EADI"                            },
	{ EBADMSG,                          "EBADMSG"                         },
	{ ENAMETOOLONG,                     "ENAMETOOLONG"                    },
	{ EOVERFLOW,                        "EOVERFLOW"                       },
	{ ENOTUNIQ,                         "ENOTUNIQ"                        },
	{ EBADFD,                           "EBADFD"                          },
	{ EREMCHG,                          "EREMCHG"                         },
	{ ELIBACC,                          "ELIBACC"                         },
	{ ELIBBAD,                          "ELIBBAD"                         },
	{ ELIBSCN,                          "ELIBSCN"                         },
	{ ELIBMAX,                          "ELIBMAX"                         },
	{ ELIBEXEC,                         "ELIBEXEC"                        },
	{ EILSEQ,                           "EILSEQ"                          },
	{ ENOSYS,                           "ENOSYS"                          },
	{ ELOOP,                            "ELOOP"                           },
	{ ERESTART,                         "ERESTART"                        },
	{ ESTRPIPE,                         "ESTRPIPE"                        },
	{ ENOTEMPTY,                        "ENOTEMPTY"                       },
	{ EUSERS,                           "EUSERS"                          },
	{ ENOTSOCK,                         "ENOTSOCK"                        },
	{ EDESTADDRREQ,                     "EDESTADDRREQ"                    },
	{ EMSGSIZE,                         "EMSGSIZE"                        },
	{ EPROTOTYPE,                       "EPROTOTYPE"                      },
	{ ENOPROTOOPT,                      "ENOPROTOOPT"                     },
	{ EPROTONOSUPPORT,                  "EPROTONOSUPPORT"                 },
	{ ESOCKTNOSUPPORT,                  "ESOCKTNOSUPPORT"                 },
	{ EOPNOTSUPP,                       "EOPNOTSUPP"                      },
	{ EPFNOSUPPORT,                     "EPFNOSUPPORT"                    },
	{ EAFNOSUPPORT,                     "EAFNOSUPPORT"                    },
	{ EADDRINUSE,                       "EADDRINUSE"                      },
	{ EADDRNOTAVAIL,                    "EADDRNOTAVAIL"                   },
	{ ENETDOWN,                         "ENETDOWN"                        },
	{ ENETUNREACH,                      "ENETUNREACH"                     },
	{ ENETRESET,                        "ENETRESET"                       },
	{ ECONNABORTED,                     "ECONNABORTED"                    },
	{ ECONNRESET,                       "ECONNRESET"                      },
	{ ENOBUFS,                          "ENOBUFS"                         },
	{ EISCONN,                          "EISCONN"                         },
	{ ENOTCONN,                         "ENOTCONN"                        },
	{ ESHUTDOWN,                        "ESHUTDOWN"                       },
	{ ETOOMANYREFS,                     "ETOOMANYREFS"                    },
	{ ETIMEDOUT,                        "ETIMEDOUT"                       },
	{ ECONNREFUSED,                     "ECONNREFUSED"                    },
	{ EHOSTDOWN,                        "EHOSTDOWN"                       },
	{ EHOSTUNREACH,                     "EHOSTUNREACH"                    },
	{ EWOULDBLOCK,                      "EWOULDBLOCK"                     },
	{ EALREADY,                         "EALREADY"                        },
	{ EINPROGRESS,                      "EINPROGRESS"                     },
	{ ESTALE,                           "ESTALE"                          },

	/* Sentinel marking the end of the table. */
	{ 0, NULL }
};

struct int_symbol *platform_symbols(void)
{
	return platform_symbols_table;
}

#endif  /* __SunOS_5_11 */
