package com.novoda.room.kata;

import android.arch.persistence.room.Room;
import android.content.Context;

import com.novoda.room.kata.dao.PhotoDAO;
import com.novoda.room.kata.database.RoomKataDatabase;
import com.novoda.room.kata.entity.Photo;

import java.util.List;

class RoomKata {
    private PhotoDAO photoDAO;

    public void initialize(Context context) {
        RoomKataDatabase db = Room.inMemoryDatabaseBuilder(
                context,
                RoomKataDatabase.class
        ).build();
        photoDAO = db.photoDAO();
    }

    public List<Photo> retrieveAll() {
        return photoDAO.getAll();
    }

    public void insert(Photo photo) {
        photoDAO.insert(photo);
    }

    public void insert(List<Photo> photos) {
        photoDAO.insertAll(photos);
    }

    public void delete(Photo photo) {
        photoDAO.delete(photo);
    }

    public Photo retrieveWithId(int id) {
        return photoDAO.loadWithId(id);
    }
}
