# Roman Numerals Kata

## Problem Description
The Romans were a clever bunch. They conquered most of Europe and ruled it for hundreds of years. They invented concrete and straight roads and even bikinis. One thing they never discovered though was the number zero. This made writing and dating extensive histories of their exploits slightly more challenging, but the system of numbers they came up with is still in use today. For example the BBC uses Roman numerals to date their programs.

The Romans wrote numbers using letters : I, V, X, L, C, D, M. (notice these letters have lots of straight lines and are hence easy to hack into stone tablets)  [Roman numbers](http://www.novaroma.org/via_romana/numbers.html)

### Part I
The Kata says you should write a function to convert from normal numbers to Roman Numerals: eg

```
1 --> I
10 --> X
7 --> VII
etc.`
```
There is no need to be able to convert numbers larger than about 3000. (The Romans themselves didn’t tend to go any higher)

### Part II
Write a function to convert in the other direction, ie numeral to digit

## Clues
- Can you make the code really beautiful and highly readable?
- Does it help to break out lots of small named functions from the main function, or is it better to keep it all in one function?
- if you don’t know an algorithm to do this already, can you derive one using strict TDD?
- Does the order you write the tests affect the final design of your algorithm?
- Would it be better to work out an algorithm first before starting with TDD?
- If you do know an algorithm already, can you implement it using strict TDD?
- Can you think of another algorithm?
- What are the best data structures for storing all the numeral letters? (I, V, D, M etc)
- Can you define the test cases in a csv file and use FIT, or generate test cases in xUnit?
- What is the best way to verify your tests are correct?

## Roman Numerals Basics

### I == 1
The easiest way to note down a number is to make that many marks - little I's. Thus I means 1, II means 2, III means 3. However, four strokes seemed like too many.

### V == 5

So the Romans moved on to the symbol for 5 - V. Placing I in front of the V — or placing any smaller number in front of any larger number — indicates subtraction. So IV means 4. After V comes a series of additions - VI means 6, VII means 7, VIII means 8.

### X == 10
X means 10. But wait — what about 9? Same deal. IX means to subtract I from X, leaving 9. Numbers in the teens, twenties and thirties follow the same form as the first set, only with X's indicating the number of tens. So XXXI is 31, and XXIV is 24.

### L == 50
L means 50. Based on what you've learned, I bet you can figure out what 40 is. If you guessed XL, you're right = 10 subtracted from 50. And thus 60, 70, and 80 are LX, LXX and LXXX.

### C	== 100
C stands for centum, the Latin word for 100. A centurion led 100 men. We still use this in words like "century" and "cent." The subtraction rule means 90 is written as XC. Like the X's and L's, the C's are tacked on to the beginning of numbers to indicate how many hundreds there are: CCCLXIX is 369.

### D == 500
D stands for 500. As you can probably guess by this time, CD means 400. So CDXLVIII is 448. (See why we switched systems?)

### M == 1000
M is 1,000. You see a lot of Ms because Roman numerals are used a lot to indicate dates. For instance, this page was written in the year of Nova Roma's founding, 1998 CE (Common Era; Christians use AD for Anno Domini, "year of our Lord"). That year is written as MCMXCVIII. But wait! Nova Roma counts years from the founding of Rome, ab urbe condita. By that reckoning Nova Roma was founded in 2751 a.u.c. or MMDCCLI.

### V
Larger numbers were indicated by putting a horizontal line over them, which meant to multiply the number by 1,000. Hence the V at left has a line over the top, which means 5,000. This usage is no longer current, because the largest numbers usually expressed in the Roman system are dates, as discussed above.
