Test Contribution Guidelines
----------------------------

This is a guide on how to contribute test cases to help with coverage testing for NodeGit.

## Getting Started ##

Currently there are a number of fields and functions in NodeGit that have no tests at all. A list of which files are missing and what fields and functions need tests can be generated by running

``` bash
npm run generateMissingTests
```

>You should have run already `npm install .` or it will complain about
> missing `nodegit-promise` or suchlike

This will make the file `generate/output/missing-tests.json` which will contain info for tests or files that are currently missing.

From this file you can find fields and functions that don't have any tests yet and pick one to work on.

## Adding a test ##

After you find a test that's missing the next step is to find or add the file that you need to add it into. You can always use other tests in the directory as a guide for writing more. All new files will be automatically added during a test run.

In the `missing-tests.json` file you'll see it formatted like so:

```json
{
  "{className}":{
    "fields": [],
    "functions": []
  }
}
```

In the file each `{className}` corresponds to a file found at `test/tests/{classname}`. Each entry in either `fields` or `functions` is a missing test for the respective field/function.

In the file that your test is going in you can just append it to the file inside the `describe` function block.

It can be helpful to reference the [libgit2 API docs](https://libgit2.github.com/libgit2/#v0.21.4) to know what the field or function is doing inside of libgit2 and referencing the [NodeGit API docs](http://www.nodegit.org/) can also help. Looking at examples inside of `/examples` can show you how we wrap the libgit2 library and how you can call into it from JavaScript.

The idea is to test the basic functionality of the field/function and to confirm that it's returning or setting the value(s) correctly. Bugs inside of libgit2 will have to either have a work-around or be ignored.

If a specific field or function is further wrapped via a file inside
of `/lib` then as long as that wrapper is called and tested it is OK.

You can mark something to be ignored inside of the `/generate/missing-tests-ignore.json` file.

After you write your test make sure to run `npm run generateMissingTests` again to confirm that the field/function that a test was written for no longer shows up.

## Test results ##

### The test passes ###

Excellent!! Make sure that the test is working correctly and testing what you're expecting it to test and then move onto the [next section](#making-a-pull-request).

### The test fails ###

This is also great! You just found something that wasn't properly covered in our generate scripts for wrapping libgit2. We'll have to further analyze what's going on and figure out how to fix it.

For bonus points you could also include a fix in your pull request but that step is optional.

## Making a pull request ##

So you made your self a new test for NodeGit and now you want to add it to the main repo? That's great! We'll try and make the process as simple and easy as possible for you.

So assuming that you have a fork of the repo make a new branch that's labeled `new-tests-{className}` where {className} is the name of the file you added the tests to. Also, make sure you check the [main repo's pull request list](https://github.com/nodegit/nodegit/pulls) and see if somebody else is editing that file before you make your PR. They might have added a test already that's waiting to get merged in.

So after you have your branch and your change is ready to go make sure your subjects for your commits contain the {className} of the tests you added and then list each new field/function being tested inside of the subject of the commit message.

Example:

```
Added tests for oid

fromString
allocfmt
inspect
```

This will help us know what each commit contains at a glance and should expedite merging your pull request.

If your test is failing, TravisCI should pick it up and note it on the PR. PR's that add failing tests will have to be handled on a case-by-case basis but please don't let that stop you from staring a PR.

Please don't start a PR until you're finished (no WIP test PRs please!).
