/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

export default {
  _isJSONSchemaObject: true,
  version: '2.0',
  type: 'void',
  'x-collection': 'collections',
  'x-decorator': 'ResourceActionProvider',
  'x-decorator-props': {
    collection: 't_j6omof6tza8',
    dragSort: false,
    request: {
      resource: 't_j6omof6tza8',
      action: 'list',
      params: {
        pageSize: 50,
        appends: [],
        sort: ['-f_f7txg1oc3nt'],
        filter: {
          $or: [
            { f_hpmvdltzs6m: { $eq: '67snt3e6yld' } },
            { f_hpmvdltzs6m: { $eq: 'ht963n365al' } },
            { f_hpmvdltzs6m: { $eq: null } },
          ],
        },
      },
    },
  },
  'x-designer': 'Table.Void.Designer',
  'x-component': 'CardItem',
  properties: {
    actions: {
      _isJSONSchemaObject: true,
      version: '2.0',
      type: 'void',
      'x-initializer': 'table:configureActions',
      'x-component': 'ActionBar',
      'x-component-props': { style: { marginBottom: 16 } },
      properties: {
        isbu85phv4w: {
          _isJSONSchemaObject: true,
          version: '2.0',
          'x-component': 'Action',
          'x-component-props': { popover: true },
          type: 'void',
          title: '{{ t("Filter") }}',
          'x-action': 'filter',
          'x-align': 'left',
          'x-designer': 'Action.Designer',
          properties: {
            popover: {
              _isJSONSchemaObject: true,
              version: '2.0',
              type: 'void',
              'x-decorator': 'Form',
              'x-decorator-props': {},
              'x-component': 'Action.Popover',
              'x-component-props': { trigger: 'click', placement: 'bottomLeft' },
              properties: {
                filter: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  type: 'object',
                  default: { $and: [] },
                  'x-component': 'Filter',
                  'x-component-props': { useDataSource: '{{cm.useFilterDataSource}}' },
                  'x-uid': '83tcwd8b87h',
                  'x-async': false,
                  'x-index': 1,
                },
                footer: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  type: 'void',
                  'x-component': 'Action.Popover.Footer',
                  properties: {
                    actions: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'ActionBar',
                      properties: {
                        saveDefault: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Filter.SaveDefaultValue',
                          'x-component-props': {},
                          'x-uid': '9o9vnzqz8n4',
                          'x-async': false,
                          'x-index': 1,
                        },
                        reset: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          title: '{{t("Reset")}}',
                          'x-component': 'Action',
                          'x-component-props': { useAction: '{{cm.useResetFilterAction}}' },
                          'x-uid': '40ifgzo3pks',
                          'x-async': false,
                          'x-index': 2,
                        },
                        submit: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          title: '{{t("Submit")}}',
                          'x-component': 'Action',
                          'x-component-props': { type: 'primary', useAction: '{{cm.useFilterAction}}' },
                          'x-uid': 'obf1j752ihd',
                          'x-async': false,
                          'x-index': 3,
                        },
                      },
                      'x-uid': 'ii5il9tl8td',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'bjjvidam17e',
                  'x-async': false,
                  'x-index': 2,
                },
              },
              'x-uid': '4patto9jy4f',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'boj6th09df1',
          'x-async': false,
          'x-index': 1,
        },
        gytwsh4j63z: {
          _isJSONSchemaObject: true,
          version: '2.0',
          title: '{{ t("Delete") }}',
          'x-action': 'destroy',
          'x-component': 'Action',
          'x-designer': 'Action.Designer',
          'x-component-props': {
            confirm: { title: "{{t('Delete record')}}", content: "{{t('Are you sure you want to delete it?')}}" },
            useAction: '{{ cm.useBulkDestroyAction }}',
          },
          type: 'void',
          'x-uid': 'kmqnst4w0l8',
          'x-async': false,
          'x-index': 3,
        },
        wbb242cclcy: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          title: '{{ t("Add new") }}',
          'x-action': 'create',
          'x-designer': 'Action.Designer',
          'x-component': 'Action',
          'x-component-props': { type: 'primary', openMode: 'drawer' },
          properties: {
            drawer: {
              _isJSONSchemaObject: true,
              version: '2.0',
              type: 'void',
              title: '{{ t("Add new record") }}',
              'x-component': 'Action.Container',
              'x-component-props': {},
              'x-decorator': 'Form',
              properties: {
                grid: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  type: 'void',
                  'x-component': 'Grid',
                  'x-initializer': 'GridFormItemInitializers',
                  properties: {
                    sjwib7sdug0: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      properties: {
                        '3gxapv67xe7': {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_g8j5jvalqh0: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
                              required: true,
                              'x-uid': 'nwgz4akshry',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'lxj0nla3rui',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': 'deu3pe2t45r',
                      'x-async': false,
                      'x-index': 33,
                    },
                    dqffohruw16: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      properties: {
                        '1jbcxo5ixfc': {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_tegyd222bcc: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_tegyd222bcc',
                              'x-uid': 'qptd30gyque',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': '895py3odzsx',
                          'x-async': false,
                          'x-index': 1,
                        },
                        col_a10rjh4fjuk: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 2,
                          properties: {
                            f_ooar0pto2ko: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_ooar0pto2ko',
                              'x-component-props': { mode: 'tags', fieldNames: { label: 'id', value: 'id' } },
                              properties: {
                                options: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.Options',
                                  type: 'void',
                                  title: 'Drawer Title',
                                  properties: {
                                    block: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-collection': 'collections',
                                      'x-decorator': 'ResourceActionProvider',
                                      'x-decorator-props': {
                                        collection: 'attachments',
                                        request: {
                                          resource: 'attachments',
                                          action: 'list',
                                          params: { pageSize: 20, filter: {}, appends: [] },
                                        },
                                      },
                                      'x-designer': 'Table.Void.Designer',
                                      'x-component': 'CardItem',
                                      properties: {
                                        table: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'Table.RowSelection',
                                          'x-component-props': {
                                            rowKey: 'id',
                                            objectValue: true,
                                            rowSelection: { type: 'checkbox' },
                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                          },
                                          'x-initializer': 'table:configureColumns',
                                          'x-uid': 'nd7c9jym6f9',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'qw15melzv8s',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '3o47lbu55cb',
                                  'x-async': false,
                                  'x-index': 19,
                                },
                                item: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.SelectedItem',
                                  properties: {
                                    drawer1: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-decorator': 'CollectionProvider_deprecated',
                                      'x-decorator-props': { name: 'attachments' },
                                      'x-component': 'Action.Drawer',
                                      'x-component-props': { className: 'nb-action-popup' },
                                      type: 'void',
                                      title: 'Drawer Title',
                                      properties: {
                                        tabs: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'Tabs',
                                          'x-component-props': {},
                                          'x-initializer': 'TabPaneInitializers',
                                          properties: {
                                            tab1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              title: '详情',
                                              'x-component': 'Tabs.TabPane',
                                              'x-designer': 'Tabs.Designer',
                                              'x-component-props': {},
                                              properties: {
                                                grid: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Grid',
                                                  'x-initializer': 'popup:common:addBlock',
                                                  'x-uid': '6vmvh862u5t',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 's1fbu25gxbb',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'ogyhah2bdd2',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'igtybpqzs1z',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'bqlfve38uv0',
                                  'x-async': false,
                                  'x-index': 20,
                                },
                              },
                              'x-uid': 'n71hstmsn4y',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'bg1flm7xlqb',
                          'x-async': false,
                        },
                      },
                      'x-uid': 'rpqhelo9nhq',
                      'x-async': false,
                      'x-index': 34,
                    },
                    '34hycnw3car': {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      properties: {
                        col_udhmczrizax: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 1,
                          properties: {
                            f_z27302tl2bf: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_z27302tl2bf',
                              'x-uid': 'd3d48uai27w',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'kgvcz6nw4yg',
                          'x-async': false,
                        },
                        col_9qlipaqkwdc: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 2,
                          properties: {
                            f_cht6rsiiiko: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              title: '分类',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_cht6rsiiiko',
                              'x-uid': 'sci52rq39qb',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'nkpzat8s17y',
                          'x-async': false,
                        },
                      },
                      'x-uid': 'djz8p7u6qix',
                      'x-async': false,
                      'x-index': 35,
                    },
                    row_0rsawx3b7kj: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      'x-index': 36,
                      properties: {
                        col_n49a866bnrr: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 1,
                          properties: {
                            f_ksgzy9vmgce: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_ksgzy9vmgce',
                              'x-component-props': { fieldNames: { label: 'f_zio9ewkxss7', value: 'id' } },
                              properties: {
                                options: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.Options',
                                  type: 'void',
                                  title: 'Drawer Title',
                                  properties: {
                                    block: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-collection': 'collections',
                                      'x-decorator': 'ResourceActionProvider',
                                      'x-decorator-props': {
                                        collection: 't_94rsj6kbzvn',
                                        request: {
                                          resource: 't_94rsj6kbzvn',
                                          action: 'list',
                                          params: { pageSize: 20, filter: {}, appends: [] },
                                        },
                                      },
                                      'x-designer': 'Table.Void.Designer',
                                      'x-component': 'CardItem',
                                      properties: {
                                        table: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'Table.RowSelection',
                                          'x-component-props': {
                                            rowKey: 'id',
                                            objectValue: true,
                                            rowSelection: { type: 'checkbox' },
                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                          },
                                          'x-initializer': 'table:configureColumns',
                                          properties: {
                                            gpysrsz6uw3: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'Table.Column.Decorator',
                                              'x-designer': 'Table.Column.Designer',
                                              'x-component': 'Table.Column',
                                              properties: {
                                                f_zio9ewkxss7: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-read-pretty': true,
                                                  'x-collection-field': 't_94rsj6kbzvn.f_zio9ewkxss7',
                                                  'x-component': 'CollectionField',
                                                  'x-component-props': { ellipsis: true },
                                                  'x-uid': '9voqf4ck78o',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'jx0cv5rip9s',
                                              'x-async': false,
                                              'x-index': 3,
                                            },
                                            rwqed9xotrw: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'Table.Column.Decorator',
                                              'x-designer': 'Table.Column.Designer',
                                              'x-component': 'Table.Column',
                                              properties: {
                                                f_ojboh2wxpju: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-read-pretty': true,
                                                  'x-collection-field': 't_94rsj6kbzvn.f_ojboh2wxpju',
                                                  'x-component': 'CollectionField',
                                                  'x-component-props': { ellipsis: true },
                                                  'x-uid': 'ra2y7qc7gry',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'cf5mdicu9iq',
                                              'x-async': false,
                                              'x-index': 4,
                                            },
                                          },
                                          'x-uid': 'vn505hjwciq',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': '9aekgw69wzo',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'tsr1ndfyyre',
                                  'x-async': false,
                                  'x-index': 7,
                                },
                                item: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.SelectedItem',
                                  properties: {
                                    drawer1: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-decorator': 'CollectionProvider_deprecated',
                                      'x-decorator-props': { name: 't_94rsj6kbzvn' },
                                      'x-component': 'Action.Drawer',
                                      'x-component-props': { className: 'nb-action-popup' },
                                      type: 'void',
                                      title: 'Drawer Title',
                                      properties: {
                                        tabs: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'Tabs',
                                          'x-component-props': {},
                                          'x-initializer': 'TabPaneInitializers',
                                          properties: {
                                            tab1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              title: '详情',
                                              'x-component': 'Tabs.TabPane',
                                              'x-designer': 'Tabs.Designer',
                                              'x-component-props': {},
                                              properties: {
                                                grid: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Grid',
                                                  'x-initializer': 'popup:common:addBlock',
                                                  'x-uid': 'q962oul9mfn',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'nwkmsbgr061',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'le62erpcx6s',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'exj9yp33tt0',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'etlkr22emkh',
                                  'x-async': false,
                                  'x-index': 8,
                                },
                              },
                              'x-uid': 'tmvpgq2beo8',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'hlhu82486r1',
                          'x-async': false,
                        },
                        i2x7embbyfi: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_u007sq2jg93: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_u007sq2jg93',
                              'x-component-props': { fieldNames: { label: 'nickname', value: 'id' } },
                              properties: {
                                options: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.Options',
                                  type: 'void',
                                  title: 'Drawer Title',
                                  properties: {
                                    block: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-collection': 'collections',
                                      'x-decorator': 'ResourceActionProvider',
                                      'x-decorator-props': {
                                        collection: 'users',
                                        request: {
                                          resource: 'users',
                                          action: 'list',
                                          params: { pageSize: 20, filter: {}, appends: [] },
                                        },
                                      },
                                      'x-designer': 'Table.Void.Designer',
                                      'x-component': 'CardItem',
                                      properties: {
                                        table: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'Table.RowSelection',
                                          'x-component-props': {
                                            rowKey: 'id',
                                            objectValue: true,
                                            rowSelection: { type: 'checkbox' },
                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                          },
                                          'x-initializer': 'table:configureColumns',
                                          properties: {
                                            ppttymwsr3d: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'Table.Column.Decorator',
                                              'x-designer': 'Table.Column.Designer',
                                              'x-component': 'Table.Column',
                                              properties: {
                                                nickname: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-read-pretty': true,
                                                  'x-collection-field': 'users.nickname',
                                                  'x-component': 'CollectionField',
                                                  'x-component-props': {},
                                                  'x-uid': 'l6gjgsl4rkf',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': '49kzrf8tjwi',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'zzhdmzj1p1w',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'uiaid4tq6lq',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'go8zfj0n3a7',
                                  'x-async': false,
                                  'x-index': 5,
                                },
                                item: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.SelectedItem',
                                  properties: {
                                    drawer1: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-decorator': 'CollectionProvider_deprecated',
                                      'x-decorator-props': { name: 'users' },
                                      'x-component': 'Action.Drawer',
                                      'x-component-props': { className: 'nb-action-popup' },
                                      type: 'void',
                                      title: 'Drawer Title',
                                      properties: {
                                        tabs: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'Tabs',
                                          'x-component-props': {},
                                          'x-initializer': 'TabPaneInitializers',
                                          properties: {
                                            tab1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              title: '详情',
                                              'x-component': 'Tabs.TabPane',
                                              'x-designer': 'Tabs.Designer',
                                              'x-component-props': {},
                                              properties: {
                                                grid: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Grid',
                                                  'x-initializer': 'popup:common:addBlock',
                                                  'x-uid': 'eoyjsxofwwp',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'bvguriy6fqd',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'm2iweenszns',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'ww19f6o4p84',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'twwd96qddmw',
                                  'x-async': false,
                                  'x-index': 6,
                                },
                              },
                              'x-uid': 'qnyrn99hs3f',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'hanjy9r1id2',
                          'x-async': false,
                          'x-index': 2,
                        },
                      },
                      'x-uid': 'j74ssy9g9g6',
                      'x-async': false,
                    },
                    row_n6hconqufuq: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      'x-index': 37,
                      properties: {
                        col_iar1zhjpur7: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 1,
                          properties: {
                            f_yc8jbfiqfvh: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_yc8jbfiqfvh',
                              'x-uid': 'ennybqyti3c',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'ipdgxcmxmvn',
                          'x-async': false,
                        },
                        col_k4je1g5zxha: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          'x-index': 3,
                          properties: {
                            f_hpmvdltzs6m: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_hpmvdltzs6m',
                              'x-uid': '9596j5ok0ml',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'x3mp5wh1dc3',
                          'x-async': false,
                        },
                      },
                      'x-uid': 'nh0niqfyw6k',
                      'x-async': false,
                    },
                    row_nzinx0ogano: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      'x-index': 38,
                      properties: {
                        dxaed68jtvf: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_47f2d9wgofm: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_47f2d9wgofm',
                              'x-component-props': { fieldNames: { label: 'f_g8j5jvalqh0', value: 'id' } },
                              properties: {
                                options: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.Options',
                                  type: 'void',
                                  title: 'Drawer Title',
                                  properties: {
                                    block: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-collection': 'collections',
                                      'x-decorator': 'ResourceActionProvider',
                                      'x-decorator-props': {
                                        collection: 't_j6omof6tza8',
                                        request: {
                                          resource: 't_j6omof6tza8',
                                          action: 'list',
                                          params: { pageSize: 20, filter: {}, appends: [] },
                                        },
                                      },
                                      'x-designer': 'Table.Void.Designer',
                                      'x-component': 'CardItem',
                                      properties: {
                                        table: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'Table.RowSelection',
                                          'x-component-props': {
                                            rowKey: 'id',
                                            objectValue: true,
                                            rowSelection: { type: 'checkbox' },
                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                          },
                                          'x-initializer': 'table:configureColumns',
                                          properties: {
                                            xfyrokl5xzu: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'Table.Column.Decorator',
                                              'x-designer': 'Table.Column.Designer',
                                              'x-component': 'Table.Column',
                                              properties: {
                                                f_g8j5jvalqh0: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-read-pretty': true,
                                                  'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
                                                  'x-component': 'CollectionField',
                                                  'x-component-props': { ellipsis: true },
                                                  'x-uid': '1fa7enk0da0',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'xzwb81jrm3f',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'ziddyuhfhw6',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'jbuxqbnepn4',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '5on5jux0ycr',
                                  'x-async': false,
                                  'x-index': 3,
                                },
                                item: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  'x-component': 'RecordPicker.SelectedItem',
                                  properties: {
                                    drawer1: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-decorator': 'CollectionProvider_deprecated',
                                      'x-decorator-props': { name: 't_j6omof6tza8' },
                                      'x-component': 'Action.Drawer',
                                      'x-component-props': { className: 'nb-action-popup' },
                                      type: 'void',
                                      title: 'Drawer Title',
                                      properties: {
                                        tabs: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'Tabs',
                                          'x-component-props': {},
                                          'x-initializer': 'TabPaneInitializers',
                                          properties: {
                                            tab1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              title: '详情',
                                              'x-component': 'Tabs.TabPane',
                                              'x-designer': 'Tabs.Designer',
                                              'x-component-props': {},
                                              properties: {
                                                grid: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Grid',
                                                  'x-initializer': 'popup:common:addBlock',
                                                  'x-uid': 'vooi5kwmy1y',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'ddb8asoov5x',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'xgeexz568uj',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': '1bqm2o0k9ta',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'ubgshncx9hb',
                                  'x-async': false,
                                  'x-index': 4,
                                },
                              },
                              'x-uid': 'f4tuv6i00j3',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': '7ex0v2jtadx',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': 'khql31usnbv',
                      'x-async': false,
                    },
                    rqek1xc93bi: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      properties: {
                        pfb8ib4u27c: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_jj9cyhron1d: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-designer': 'Table.Array.Designer',
                              'x-component': 'div',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_jj9cyhron1d',
                              properties: {
                                block: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'DataSourceProvider',
                                  'x-component-props': {
                                    collection: 't_ab12qiwruwk',
                                    association: {
                                      collectionName: 't_j6omof6tza8',
                                      name: 'f_jj9cyhron1d',
                                      sourceKey: 'id',
                                      targetKey: 'id',
                                    },
                                  },
                                  properties: {
                                    actions: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-component': 'ActionBar',
                                      'x-component-props': { style: { marginBottom: 16 } },
                                      properties: {
                                        delete: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          title: '{{ t("Delete") }}',
                                          'x-component': 'Action',
                                          'x-component-props': {
                                            useAction: '{{ ds.useBulkDestroyAction }}',
                                            confirm: {
                                              title: "{{t('Delete record')}}",
                                              content: "{{t('Are you sure you want to delete it?')}}",
                                            },
                                          },
                                          'x-uid': 'tiyf8uzayxa',
                                          'x-async': false,
                                          'x-index': 11,
                                        },
                                        create: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          title: '{{ t("Add new") }}',
                                          'x-action': 'create',
                                          'x-component': 'Action',
                                          'x-component-props': { type: 'primary', openMode: 'drawer' },
                                          properties: {
                                            drawer: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              title: '{{ t("Add new record") }}',
                                              'x-component': 'Action.Container',
                                              'x-component-props': {},
                                              'x-decorator': 'Form',
                                              properties: {
                                                grid: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Grid',
                                                  'x-initializer': 'GridFormItemInitializers',
                                                  properties: {
                                                    jxv7o65t1yx: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Grid.Row',
                                                      properties: {
                                                        '2kes8qsxrif': {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Col',
                                                          properties: {
                                                            f_m7ibo1vrvnm: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              'x-designer': 'FormItem.Designer',
                                                              'x-component': 'CollectionField',
                                                              'x-decorator': 'FormItem',
                                                              'x-collection-field': 't_ab12qiwruwk.f_m7ibo1vrvnm',
                                                              required: true,
                                                              'x-uid': 'tcncpgnr1ha',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'ilwlsvsmu8x',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'lqxg2wsc9cb',
                                                      'x-async': false,
                                                      'x-index': 21,
                                                    },
                                                    baujafikrdl: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Grid.Row',
                                                      properties: {
                                                        q3m6cj8vtsd: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Col',
                                                          properties: {
                                                            f_kukaw9kddyj: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              'x-designer': 'FormItem.Designer',
                                                              'x-component': 'CollectionField',
                                                              'x-decorator': 'FormItem',
                                                              'x-collection-field': 't_ab12qiwruwk.f_kukaw9kddyj',
                                                              'x-component-props': {
                                                                fieldNames: { label: 'nickname', value: 'id' },
                                                              },
                                                              properties: {
                                                                options: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-component': 'RecordPicker.Options',
                                                                  type: 'void',
                                                                  title: 'Drawer Title',
                                                                  properties: {
                                                                    block: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-collection': 'collections',
                                                                      'x-decorator': 'ResourceActionProvider',
                                                                      'x-decorator-props': {
                                                                        collection: 'users',
                                                                        request: {
                                                                          resource: 'users',
                                                                          action: 'list',
                                                                          params: {
                                                                            pageSize: 20,
                                                                            filter: {},
                                                                            appends: [],
                                                                          },
                                                                        },
                                                                      },
                                                                      'x-designer': 'Table.Void.Designer',
                                                                      'x-component': 'CardItem',
                                                                      properties: {
                                                                        table: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'Table.RowSelection',
                                                                          'x-component-props': {
                                                                            rowKey: 'id',
                                                                            objectValue: true,
                                                                            rowSelection: { type: 'checkbox' },
                                                                            useDataSource:
                                                                              '{{ cm.useDataSourceFromRAC }}',
                                                                          },
                                                                          'x-initializer': 'table:configureColumns',
                                                                          'x-uid': 'n1svf2lkvqd',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'w68a75wfn39',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': '3ip5oifecdm',
                                                                  'x-async': false,
                                                                  'x-index': 11,
                                                                },
                                                                item: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-component': 'RecordPicker.SelectedItem',
                                                                  properties: {
                                                                    drawer1: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-decorator': 'CollectionProvider_deprecated',
                                                                      'x-decorator-props': { name: 'users' },
                                                                      'x-component': 'Action.Drawer',
                                                                      'x-component-props': {
                                                                        className: 'nb-action-popup',
                                                                      },
                                                                      type: 'void',
                                                                      title: 'Drawer Title',
                                                                      properties: {
                                                                        tabs: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Tabs',
                                                                          'x-component-props': {},
                                                                          'x-initializer': 'TabPaneInitializers',
                                                                          properties: {
                                                                            tab1: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              title: '详情',
                                                                              'x-component': 'Tabs.TabPane',
                                                                              'x-designer': 'Tabs.Designer',
                                                                              'x-component-props': {},
                                                                              properties: {
                                                                                grid: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  'x-component': 'Grid',
                                                                                  'x-initializer':
                                                                                    'popup:common:addBlock',
                                                                                  'x-uid': 'tmlp8f9evtr',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'qkw0jzy21g7',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'clz0g4hipnn',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'd2v3al3guv8',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': '0i5d6k7ljgz',
                                                                  'x-async': false,
                                                                  'x-index': 12,
                                                                },
                                                              },
                                                              'x-uid': 'u1pta61ke87',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'o3av2hps7h3',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': '09z7i8v2w57',
                                                      'x-async': false,
                                                      'x-index': 22,
                                                    },
                                                    j2zrrumbgx7: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Grid.Row',
                                                      properties: {
                                                        lcah36xzimy: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Col',
                                                          properties: {
                                                            f_4mpiovytw4d: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              'x-designer': 'FormItem.Designer',
                                                              'x-component': 'CollectionField',
                                                              'x-decorator': 'FormItem',
                                                              'x-collection-field': 't_ab12qiwruwk.f_4mpiovytw4d',
                                                              'x-uid': 'mcgur3ogdhp',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': '81u9nt9j2ss',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'm1ghu8a6spg',
                                                      'x-async': false,
                                                      'x-index': 23,
                                                    },
                                                    '4qh7q0vj6q9': {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Grid.Row',
                                                      properties: {
                                                        '1vkfl4t95um': {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Col',
                                                          properties: {
                                                            f_lxsum89wkzd: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              'x-designer': 'FormItem.Designer',
                                                              'x-component': 'CollectionField',
                                                              'x-decorator': 'FormItem',
                                                              'x-collection-field': 't_ab12qiwruwk.f_lxsum89wkzd',
                                                              'x-component-props': {
                                                                mode: 'tags',
                                                                fieldNames: { label: 'id', value: 'id' },
                                                              },
                                                              properties: {
                                                                options: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-component': 'RecordPicker.Options',
                                                                  type: 'void',
                                                                  title: 'Drawer Title',
                                                                  properties: {
                                                                    block: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-collection': 'collections',
                                                                      'x-decorator': 'ResourceActionProvider',
                                                                      'x-decorator-props': {
                                                                        collection: 'attachments',
                                                                        request: {
                                                                          resource: 'attachments',
                                                                          action: 'list',
                                                                          params: {
                                                                            pageSize: 20,
                                                                            filter: {},
                                                                            appends: [],
                                                                          },
                                                                        },
                                                                      },
                                                                      'x-designer': 'Table.Void.Designer',
                                                                      'x-component': 'CardItem',
                                                                      properties: {
                                                                        table: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'Table.RowSelection',
                                                                          'x-component-props': {
                                                                            rowKey: 'id',
                                                                            objectValue: true,
                                                                            rowSelection: { type: 'checkbox' },
                                                                            useDataSource:
                                                                              '{{ cm.useDataSourceFromRAC }}',
                                                                          },
                                                                          'x-initializer': 'table:configureColumns',
                                                                          'x-uid': 'ymddh2e0ufc',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'uobp4y47i0e',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'c0nx3mkytao',
                                                                  'x-async': false,
                                                                  'x-index': 11,
                                                                },
                                                                item: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-component': 'RecordPicker.SelectedItem',
                                                                  properties: {
                                                                    drawer1: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-decorator': 'CollectionProvider_deprecated',
                                                                      'x-decorator-props': { name: 'attachments' },
                                                                      'x-component': 'Action.Drawer',
                                                                      'x-component-props': {
                                                                        className: 'nb-action-popup',
                                                                      },
                                                                      type: 'void',
                                                                      title: 'Drawer Title',
                                                                      properties: {
                                                                        tabs: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Tabs',
                                                                          'x-component-props': {},
                                                                          'x-initializer': 'TabPaneInitializers',
                                                                          properties: {
                                                                            tab1: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              title: '详情',
                                                                              'x-component': 'Tabs.TabPane',
                                                                              'x-designer': 'Tabs.Designer',
                                                                              'x-component-props': {},
                                                                              properties: {
                                                                                grid: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  'x-component': 'Grid',
                                                                                  'x-initializer':
                                                                                    'popup:common:addBlock',
                                                                                  'x-uid': 'i4skuxv9uvn',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '2lmcjg6g6cn',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'ldtd7a3c5sn',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'dmg3qsoy925',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': '2eqfxsjf1sz',
                                                                  'x-async': false,
                                                                  'x-index': 12,
                                                                },
                                                              },
                                                              'x-uid': 'v2gqkdauq74',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'hu3oqphpy0e',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': '9egomixwwuc',
                                                      'x-async': false,
                                                      'x-index': 24,
                                                    },
                                                  },
                                                  'x-uid': 'glugsigfihc',
                                                  'x-async': false,
                                                  'x-index': 11,
                                                },
                                                footer: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Action.Container.Footer',
                                                  properties: {
                                                    actions: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'ActionBar',
                                                      'x-component-props': { layout: 'one-column' },
                                                      properties: {
                                                        cancel: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          title: '{{ t("Cancel") }}',
                                                          'x-action': 'cancel',
                                                          'x-component': 'Action',
                                                          'x-component-props': {
                                                            useAction: '{{ cm.useCancelAction }}',
                                                          },
                                                          'x-uid': 'ml0ukfglo0o',
                                                          'x-async': false,
                                                          'x-index': 11,
                                                        },
                                                        submit: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          title: '{{ t("Submit") }}',
                                                          'x-action': 'submit',
                                                          'x-component': 'Action',
                                                          'x-component-props': {
                                                            type: 'primary',
                                                            useAction: '{{ ds.useCreateAction }}',
                                                          },
                                                          'x-uid': 'q06uhuzl100',
                                                          'x-async': false,
                                                          'x-index': 12,
                                                        },
                                                      },
                                                      'x-uid': 'khi4j7kcg8z',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'ud0wnvt35dn',
                                                  'x-async': false,
                                                  'x-index': 12,
                                                },
                                              },
                                              'x-uid': 'tjku4wgzl01',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'ykkmjfbymfu',
                                          'x-async': false,
                                          'x-index': 12,
                                        },
                                      },
                                      'x-uid': 'aj06yxyjmi1',
                                      'x-async': false,
                                      'x-index': 11,
                                    },
                                    f_jj9cyhron1d: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'array',
                                      title: '{{t("Fields")}}',
                                      'x-component': 'Table.Array',
                                      'x-initializer': 'table:configureColumns',
                                      'x-component-props': {
                                        pagination: false,
                                        expandable: { childrenColumnName: '__nochildren__' },
                                        rowSelection: { type: 'checkbox' },
                                        useSelectedRowKeys: '{{ ds.useSelectedRowKeys }}',
                                        useDataSource: '{{ ds.useDataSource }}',
                                      },
                                      properties: {
                                        actions: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          title: '{{ t("Actions") }}',
                                          'x-decorator': 'Table.Column.ActionBar',
                                          'x-component': 'Table.Column',
                                          'x-designer': 'Table.RowActionDesigner',
                                          'x-initializer': 'TableFieldRecordActionInitializers',
                                          properties: {
                                            actions: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'DndContext',
                                              'x-component': 'Space',
                                              'x-component-props': { split: '|' },
                                              properties: {
                                                '8hr6690k12m': {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  title: '{{ t("View") }}',
                                                  type: 'void',
                                                  'x-action': 'view',
                                                  'x-designer': 'Action.Designer',
                                                  'x-component': 'Action.Link',
                                                  'x-component-props': {},
                                                  properties: {
                                                    drawer: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Action.Drawer',
                                                      title: '{{ t("View record") }}',
                                                      properties: {
                                                        tabs: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Tabs',
                                                          'x-component-props': {},
                                                          properties: {
                                                            tab1: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              title: '详情',
                                                              'x-component': 'Tabs.TabPane',
                                                              'x-component-props': {},
                                                              properties: {
                                                                grid: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-decorator': 'Form',
                                                                  'x-component': 'Grid',
                                                                  'x-read-pretty': true,
                                                                  'x-item-initializer': 'RecordBlockInitializer',
                                                                  'x-uid': 'rusecomnads',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': '7rwilkny7r2',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'qn4km73amn9',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'mc6jj62cz7m',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'b4pd7e5tpv9',
                                                  'x-async': false,
                                                  'x-index': 11,
                                                },
                                                klytvy757ld: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  title: '{{ t("Edit") }}',
                                                  type: 'void',
                                                  'x-action': 'update',
                                                  'x-designer': 'Action.Designer',
                                                  'x-component': 'Action.Link',
                                                  'x-component-props': {},
                                                  properties: {
                                                    drawer: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'Form',
                                                      'x-decorator-props': {
                                                        useValues: '{{ cm.useValuesFromRecord }}',
                                                      },
                                                      'x-component': 'Action.Drawer',
                                                      title: '{{ t("Edit record") }}',
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'GridFormItemInitializers',
                                                          'x-uid': 'd1juv6kkunt',
                                                          'x-async': false,
                                                          'x-index': 11,
                                                        },
                                                        footer: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Action.Drawer.Footer',
                                                          properties: {
                                                            actions: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-decorator': 'DndContext',
                                                              'x-component': 'ActionBar',
                                                              'x-component-props': { layout: 'one-column' },
                                                              properties: {
                                                                cancel: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '{{ t("Cancel") }}',
                                                                  'x-action': 'cancel',
                                                                  'x-component': 'Action',
                                                                  'x-component-props': {
                                                                    useAction: '{{ cm.useCancelAction }}',
                                                                  },
                                                                  'x-uid': 'l84o4eyfu35',
                                                                  'x-async': false,
                                                                  'x-index': 11,
                                                                },
                                                                submit: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '{{ t("Submit") }}',
                                                                  'x-action': 'submit',
                                                                  'x-component': 'Action',
                                                                  'x-component-props': {
                                                                    type: 'primary',
                                                                    useAction: '{{ ds.useUpdateAction }}',
                                                                  },
                                                                  'x-uid': '6q8nnu3ety6',
                                                                  'x-async': false,
                                                                  'x-index': 12,
                                                                },
                                                              },
                                                              'x-uid': 'f2fq4k157el',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'drnq4azm7vj',
                                                          'x-async': false,
                                                          'x-index': 12,
                                                        },
                                                      },
                                                      'x-uid': '7k934q6itvf',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '9td88abg0re',
                                                  'x-async': false,
                                                  'x-index': 12,
                                                },
                                              },
                                              'x-uid': 'hoh8v64cinp',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': '7hxypmj5v9o',
                                          'x-async': false,
                                          'x-index': 26,
                                        },
                                        tlz1x8jbzbo: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-decorator': 'Table.Column.Decorator',
                                          'x-designer': 'Table.Column.Designer',
                                          'x-component': 'Table.Column',
                                          properties: {
                                            f_m7ibo1vrvnm: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-read-pretty': true,
                                              'x-collection-field': 't_ab12qiwruwk.f_m7ibo1vrvnm',
                                              'x-component': 'CollectionField',
                                              'x-component-props': {},
                                              'x-uid': 'b2xg3v83a70',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'jxtsnuozqm4',
                                          'x-async': false,
                                          'x-index': 27,
                                        },
                                        erx3j87t4fe: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-decorator': 'Table.Column.Decorator',
                                          'x-designer': 'Table.Column.Designer',
                                          'x-component': 'Table.Column',
                                          properties: {
                                            f_kukaw9kddyj: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-read-pretty': true,
                                              'x-collection-field': 't_ab12qiwruwk.f_kukaw9kddyj',
                                              'x-component': 'CollectionField',
                                              'x-component-props': {
                                                mode: 'tags',
                                                fieldNames: { label: 'id', value: 'id' },
                                              },
                                              properties: {
                                                options: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'RecordPicker.Options',
                                                  type: 'void',
                                                  title: 'Drawer Title',
                                                  properties: {
                                                    block: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-collection': 'collections',
                                                      'x-decorator': 'ResourceActionProvider',
                                                      'x-decorator-props': {
                                                        collection: 'users',
                                                        request: {
                                                          resource: 'users',
                                                          action: 'list',
                                                          params: { pageSize: 20, filter: {}, appends: [] },
                                                        },
                                                      },
                                                      'x-designer': 'Table.Void.Designer',
                                                      'x-component': 'CardItem',
                                                      properties: {
                                                        table: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-component': 'Table.RowSelection',
                                                          'x-component-props': {
                                                            rowKey: 'id',
                                                            objectValue: true,
                                                            rowSelection: { type: 'checkbox' },
                                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                          },
                                                          'x-initializer': 'table:configureColumns',
                                                          'x-uid': '0d2h3ova480',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 's67qpcgo930',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'waq506j72r8',
                                                  'x-async': false,
                                                  'x-index': 11,
                                                },
                                                item: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'RecordPicker.SelectedItem',
                                                  properties: {
                                                    drawer1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-decorator': 'CollectionProvider_deprecated',
                                                      'x-decorator-props': { name: 'users' },
                                                      'x-component': 'Action.Drawer',
                                                      'x-component-props': { className: 'nb-action-popup' },
                                                      type: 'void',
                                                      title: 'Drawer Title',
                                                      properties: {
                                                        tabs: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Tabs',
                                                          'x-component-props': {},
                                                          'x-initializer': 'TabPaneInitializers',
                                                          properties: {
                                                            tab1: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              title: '详情',
                                                              'x-component': 'Tabs.TabPane',
                                                              'x-designer': 'Tabs.Designer',
                                                              'x-component-props': {},
                                                              properties: {
                                                                grid: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid',
                                                                  'x-initializer': 'popup:common:addBlock',
                                                                  'x-uid': 'bi0stpkdqj6',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'vdp4npxkfw8',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': '930iw98uh6b',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': '9clga2eg720',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'r81933r9iiy',
                                                  'x-async': false,
                                                  'x-index': 12,
                                                },
                                              },
                                              'x-uid': 'ulhbl76dr96',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': '253vtk2uxyn',
                                          'x-async': false,
                                          'x-index': 28,
                                        },
                                        '7xa1l99d4zu': {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-decorator': 'Table.Column.Decorator',
                                          'x-designer': 'Table.Column.Designer',
                                          'x-component': 'Table.Column',
                                          properties: {
                                            f_4mpiovytw4d: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-read-pretty': true,
                                              'x-collection-field': 't_ab12qiwruwk.f_4mpiovytw4d',
                                              'x-component': 'CollectionField',
                                              'x-component-props': {},
                                              'x-uid': 'o6u4piqr4lb',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'yal3dg6zbqv',
                                          'x-async': false,
                                          'x-index': 29,
                                        },
                                        c9yfgt81i08: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-decorator': 'Table.Column.Decorator',
                                          'x-designer': 'Table.Column.Designer',
                                          'x-component': 'Table.Column',
                                          properties: {
                                            f_lxsum89wkzd: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-read-pretty': true,
                                              'x-collection-field': 't_ab12qiwruwk.f_lxsum89wkzd',
                                              'x-component': 'CollectionField',
                                              'x-component-props': {
                                                mode: 'tags',
                                                fieldNames: { label: 'id', value: 'id' },
                                              },
                                              properties: {
                                                options: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'RecordPicker.Options',
                                                  type: 'void',
                                                  title: 'Drawer Title',
                                                  properties: {
                                                    block: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-collection': 'collections',
                                                      'x-decorator': 'ResourceActionProvider',
                                                      'x-decorator-props': {
                                                        collection: 'attachments',
                                                        request: {
                                                          resource: 'attachments',
                                                          action: 'list',
                                                          params: { pageSize: 20, filter: {}, appends: [] },
                                                        },
                                                      },
                                                      'x-designer': 'Table.Void.Designer',
                                                      'x-component': 'CardItem',
                                                      properties: {
                                                        table: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-component': 'Table.RowSelection',
                                                          'x-component-props': {
                                                            rowKey: 'id',
                                                            objectValue: true,
                                                            rowSelection: { type: 'checkbox' },
                                                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                          },
                                                          'x-initializer': 'table:configureColumns',
                                                          'x-uid': 'z4rlx8hfjtq',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'n9p7a03hil9',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '74qrops35i3',
                                                  'x-async': false,
                                                  'x-index': 11,
                                                },
                                                item: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'RecordPicker.SelectedItem',
                                                  properties: {
                                                    drawer1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-decorator': 'CollectionProvider_deprecated',
                                                      'x-decorator-props': { name: 'attachments' },
                                                      'x-component': 'Action.Drawer',
                                                      'x-component-props': { className: 'nb-action-popup' },
                                                      type: 'void',
                                                      title: 'Drawer Title',
                                                      properties: {
                                                        tabs: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Tabs',
                                                          'x-component-props': {},
                                                          'x-initializer': 'TabPaneInitializers',
                                                          properties: {
                                                            tab1: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              title: '详情',
                                                              'x-component': 'Tabs.TabPane',
                                                              'x-designer': 'Tabs.Designer',
                                                              'x-component-props': {},
                                                              properties: {
                                                                grid: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid',
                                                                  'x-initializer': 'popup:common:addBlock',
                                                                  'x-uid': 'z7glgapwa3g',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'uiln1eftrl5',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'zj2utjfgbv7',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': '35x9dh9ut4s',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '1wr1i0yihqb',
                                                  'x-async': false,
                                                  'x-index': 12,
                                                },
                                              },
                                              'x-uid': 'jergu7xadsu',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'plodbfw8v3g',
                                          'x-async': false,
                                          'x-index': 30,
                                        },
                                      },
                                      'x-uid': '9g4atk2yaxq',
                                      'x-async': false,
                                      'x-index': 12,
                                    },
                                  },
                                  'x-uid': 'lk2ir7qkubl',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'rbzcxevhuyo',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'avex6rr3qyb',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': 'k6zl28meupn',
                      'x-async': false,
                      'x-index': 42,
                    },
                    row_irfj5lt3j19: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Grid.Row',
                      'x-index': 43,
                      properties: {
                        '82ajtplhy7l': {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid.Col',
                          properties: {
                            f_bwf3d9caoj6: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              'x-designer': 'FormItem.Designer',
                              'x-component': 'CollectionField',
                              'x-decorator': 'FormItem',
                              'x-collection-field': 't_j6omof6tza8.f_bwf3d9caoj6',
                              'x-uid': '8eoamxi81pa',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'j9ftjnqcqjp',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': 'w5c92m33y40',
                      'x-async': false,
                    },
                  },
                  'x-uid': 'r47wsjr61zc',
                  'x-async': false,
                  'x-index': 11,
                },
                footer: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  type: 'void',
                  'x-component': 'Action.Container.Footer',
                  properties: {
                    actions: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-initializer': 'PopupFormActionInitializers',
                      'x-decorator': 'DndContext',
                      'x-component': 'ActionBar',
                      'x-component-props': { layout: 'one-column' },
                      properties: {
                        j1ixqn2h3l9: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          title: '{{ t("Cancel") }}',
                          'x-action': 'cancel',
                          'x-component': 'Action',
                          'x-designer': 'Action.Designer',
                          'x-component-props': { useAction: '{{ cm.useCancelAction }}' },
                          type: 'void',
                          'x-uid': 'ooxst0mt2jl',
                          'x-async': false,
                          'x-index': 12,
                        },
                        '6k91ad0u0v9': {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          title: '{{ t("Submit") }}',
                          'x-action': 'submit',
                          'x-component': 'Action',
                          'x-designer': 'Action.Designer',
                          'x-component-props': { type: 'primary', useAction: '{{ cm.useCreateAction }}' },
                          type: 'void',
                          'x-uid': 'm8s9fvs0pse',
                          'x-async': false,
                          'x-index': 13,
                        },
                      },
                      'x-uid': 'dmgqw5eimo9',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'q7v6k09ab5o',
                  'x-async': false,
                  'x-index': 12,
                },
              },
              'x-uid': 'ofwfhaoxek0',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'pqizxc7kx2m',
          'x-async': false,
          'x-index': 4,
        },
      },
      'x-uid': 'iq83iqyqt44',
      'x-async': false,
      'x-index': 1,
    },
    table: {
      _isJSONSchemaObject: true,
      version: '2.0',
      type: 'void',
      'x-component': 'Table.Void',
      'x-component-props': {
        rowKey: 'id',
        rowSelection: { type: 'checkbox' },
        useAction: '{{cm.useMoveAction}}',
        useDataSource: '{{cm.useDataSourceFromRAC}}',
      },
      'x-initializer': 'table:configureColumns',
      properties: {
        actions: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          title: '{{ t("Actions") }}',
          'x-decorator': 'Table.Column.ActionBar',
          'x-component': 'Table.Column',
          'x-designer': 'Table.RowActionDesigner',
          'x-initializer': 'TableRecordActionInitializers',
          properties: {
            actions: {
              _isJSONSchemaObject: true,
              version: '2.0',
              type: 'void',
              'x-decorator': 'DndContext',
              'x-component': 'Space',
              'x-component-props': { split: '|' },
              properties: {
                rmknij6wfz2: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  title: '{{ t("View") }}',
                  type: 'void',
                  'x-action': 'view',
                  'x-designer': 'Action.Designer',
                  'x-component': 'Action.Link',
                  'x-component-props': { openMode: 'drawer' },
                  properties: {
                    drawer: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-component': 'Action.Container',
                      'x-component-props': { className: 'nb-action-popup' },
                      title: '{{ t("View record") }}',
                      properties: {
                        tabs: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Tabs',
                          'x-component-props': {},
                          'x-initializer': 'TabPaneInitializers',
                          properties: {
                            tab1: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              title: '详情',
                              'x-component': 'Tabs.TabPane',
                              'x-designer': 'Tabs.Designer',
                              'x-component-props': {},
                              properties: {
                                grid: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid',
                                  'x-initializer': 'popup:common:addBlock',
                                  properties: {
                                    mcadrj0ivmq: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-component': 'Grid.Row',
                                      properties: {
                                        i27ow3g3ukd: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'Grid.Col',
                                          properties: {
                                            '05gn9zkb0bt': {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-decorator': 'ResourceActionProvider',
                                              'x-decorator-props': {
                                                collection: 't_j6omof6tza8',
                                                request: { resource: 't_j6omof6tza8', action: 'get', params: {} },
                                              },
                                              'x-designer': 'Form.Designer',
                                              'x-component': 'CardItem',
                                              properties: {
                                                form: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-decorator': 'Form',
                                                  'x-decorator-props': { useValues: '{{ cm.useValuesFromRA }}' },
                                                  properties: {
                                                    actions: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-initializer': 'RecordDetailsActionInitializers',
                                                      'x-component': 'ActionBar',
                                                      'x-component-props': { style: { marginBottom: 24 } },
                                                      'x-uid': 'ivo3c18sgh4',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                    grid: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-component': 'Grid',
                                                      'x-read-pretty': true,
                                                      'x-initializer': 'GridFormItemInitializers',
                                                      properties: {
                                                        '63f1384fq5m': {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          properties: {
                                                            cufqlfkrax8: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              properties: {
                                                                f_g8j5jvalqh0: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
                                                                  'x-uid': 'r3lfr2jnxo3',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'px77qqaczxz',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'fvqkaiewehx',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                        row_rjf95na375k: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          'x-index': 2,
                                                          properties: {
                                                            '7t22azumef3': {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              properties: {
                                                                f_tegyd222bcc: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_tegyd222bcc',
                                                                  'x-uid': '12znn8gp3g7',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'kkda8z5pdom',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                            col_jsjthsgwyuw: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 2,
                                                              properties: {
                                                                f_ooar0pto2ko: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_ooar0pto2ko',
                                                                  'x-component-props': {
                                                                    mode: 'tags',
                                                                    fieldNames: { label: 'id', value: 'id' },
                                                                  },
                                                                  properties: {
                                                                    options: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.Options',
                                                                      type: 'void',
                                                                      title: 'Drawer Title',
                                                                      properties: {
                                                                        block: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-collection': 'collections',
                                                                          'x-decorator': 'ResourceActionProvider',
                                                                          'x-decorator-props': {
                                                                            collection: 'attachments',
                                                                            request: {
                                                                              resource: 'attachments',
                                                                              action: 'list',
                                                                              params: {
                                                                                pageSize: 20,
                                                                                filter: {},
                                                                                appends: [],
                                                                              },
                                                                            },
                                                                          },
                                                                          'x-designer': 'Table.Void.Designer',
                                                                          'x-component': 'CardItem',
                                                                          properties: {
                                                                            table: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-component': 'Table.RowSelection',
                                                                              'x-component-props': {
                                                                                rowKey: 'id',
                                                                                objectValue: true,
                                                                                rowSelection: { type: 'checkbox' },
                                                                                useDataSource:
                                                                                  '{{ cm.useDataSourceFromRAC }}',
                                                                              },
                                                                              'x-initializer': 'table:configureColumns',
                                                                              'x-uid': '4ytlnx3h4r8',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 't9urhgk2kye',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'i7kxwrc09qa',
                                                                      'x-async': false,
                                                                      'x-index': 7,
                                                                    },
                                                                    item: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.SelectedItem',
                                                                      properties: {
                                                                        drawer1: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-decorator':
                                                                            'CollectionProvider_deprecated',
                                                                          'x-decorator-props': {
                                                                            name: 'attachments',
                                                                          },
                                                                          'x-component': 'Action.Drawer',
                                                                          'x-component-props': {
                                                                            className: 'nb-action-popup',
                                                                          },
                                                                          type: 'void',
                                                                          title: 'Drawer Title',
                                                                          properties: {
                                                                            tabs: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-component': 'Tabs',
                                                                              'x-component-props': {},
                                                                              'x-initializer': 'TabPaneInitializers',
                                                                              properties: {
                                                                                tab1: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  title: '详情',
                                                                                  'x-component': 'Tabs.TabPane',
                                                                                  'x-designer': 'Tabs.Designer',
                                                                                  'x-component-props': {},
                                                                                  properties: {
                                                                                    grid: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-component': 'Grid',
                                                                                      'x-initializer':
                                                                                        'popup:common:addBlock',
                                                                                      'x-uid': 're1atuqva6w',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'lsw4mzii2qx',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'd41fbdw8s78',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'h89rv1dj49z',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'mup2gfwo9nf',
                                                                      'x-async': false,
                                                                      'x-index': 8,
                                                                    },
                                                                  },
                                                                  'x-uid': 'qacx1eu0pu6',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'esht49wyfyn',
                                                              'x-async': false,
                                                            },
                                                          },
                                                          'x-uid': 'ibw4y2spvwb',
                                                          'x-async': false,
                                                        },
                                                        row_5obitmk0s28: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          'x-index': 3,
                                                          properties: {
                                                            col_bq53unjhh9n: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 2,
                                                              properties: {
                                                                f_z27302tl2bf: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '类型',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_z27302tl2bf',
                                                                  'x-uid': 'gsajfddnaoe',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': '6hsxag4oe58',
                                                              'x-async': false,
                                                            },
                                                            col_y81gfkj7apo: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 3,
                                                              properties: {
                                                                f_cht6rsiiiko: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '分类',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_cht6rsiiiko',
                                                                  'x-uid': 'ahnzep4yoq9',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'yv8dmr6yshd',
                                                              'x-async': false,
                                                            },
                                                          },
                                                          'x-uid': 'f5jewl1fh87',
                                                          'x-async': false,
                                                        },
                                                        row_7mwvro4heg3: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          'x-index': 4,
                                                          properties: {
                                                            col_w5lm00ata8v: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 2,
                                                              properties: {
                                                                f_ksgzy9vmgce: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_ksgzy9vmgce',
                                                                  'x-component-props': {
                                                                    fieldNames: {
                                                                      label: 'f_zio9ewkxss7',
                                                                      value: 'id',
                                                                    },
                                                                  },
                                                                  properties: {
                                                                    options: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.Options',
                                                                      type: 'void',
                                                                      title: 'Drawer Title',
                                                                      properties: {
                                                                        block: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-collection': 'collections',
                                                                          'x-decorator': 'ResourceActionProvider',
                                                                          'x-decorator-props': {
                                                                            collection: 't_94rsj6kbzvn',
                                                                            request: {
                                                                              resource: 't_94rsj6kbzvn',
                                                                              action: 'list',
                                                                              params: {
                                                                                pageSize: 20,
                                                                                filter: {},
                                                                                appends: [],
                                                                              },
                                                                            },
                                                                          },
                                                                          'x-designer': 'Table.Void.Designer',
                                                                          'x-component': 'CardItem',
                                                                          properties: {
                                                                            table: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-component': 'Table.RowSelection',
                                                                              'x-component-props': {
                                                                                rowKey: 'id',
                                                                                objectValue: true,
                                                                                rowSelection: { type: 'checkbox' },
                                                                                useDataSource:
                                                                                  '{{ cm.useDataSourceFromRAC }}',
                                                                              },
                                                                              'x-initializer': 'table:configureColumns',
                                                                              'x-uid': 'v25lnvhyzzf',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': '0kybp4skmob',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'tkworqjmi9n',
                                                                      'x-async': false,
                                                                      'x-index': 5,
                                                                    },
                                                                    item: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.SelectedItem',
                                                                      properties: {
                                                                        drawer1: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-decorator':
                                                                            'CollectionProvider_deprecated',
                                                                          'x-decorator-props': {
                                                                            name: 't_94rsj6kbzvn',
                                                                          },
                                                                          'x-component': 'Action.Drawer',
                                                                          'x-component-props': {
                                                                            className: 'nb-action-popup',
                                                                          },
                                                                          type: 'void',
                                                                          title: 'Drawer Title',
                                                                          properties: {
                                                                            tabs: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-component': 'Tabs',
                                                                              'x-component-props': {},
                                                                              'x-initializer': 'TabPaneInitializers',
                                                                              properties: {
                                                                                tab1: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  title: '详情',
                                                                                  'x-component': 'Tabs.TabPane',
                                                                                  'x-designer': 'Tabs.Designer',
                                                                                  'x-component-props': {},
                                                                                  properties: {
                                                                                    grid: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-component': 'Grid',
                                                                                      'x-initializer':
                                                                                        'popup:common:addBlock',
                                                                                      'x-uid': 'evaiu0uig7k',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': '5gpfdfbttt8',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'odhnlcjwzku',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'ti0o2cifeo2',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 's5383slscq7',
                                                                      'x-async': false,
                                                                      'x-index': 6,
                                                                    },
                                                                  },
                                                                  'x-uid': 'i8jb60ppaiz',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': '0sj1m9mwv39',
                                                              'x-async': false,
                                                            },
                                                            col_da8c3mdq79u: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 3,
                                                              properties: {
                                                                f_u007sq2jg93: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_u007sq2jg93',
                                                                  'x-component-props': {
                                                                    fieldNames: { label: 'nickname', value: 'id' },
                                                                  },
                                                                  properties: {
                                                                    options: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.Options',
                                                                      type: 'void',
                                                                      title: 'Drawer Title',
                                                                      properties: {
                                                                        block: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-collection': 'collections',
                                                                          'x-decorator': 'ResourceActionProvider',
                                                                          'x-decorator-props': {
                                                                            collection: 'users',
                                                                            request: {
                                                                              resource: 'users',
                                                                              action: 'list',
                                                                              params: {
                                                                                pageSize: 20,
                                                                                filter: {},
                                                                                appends: [],
                                                                              },
                                                                            },
                                                                          },
                                                                          'x-designer': 'Table.Void.Designer',
                                                                          'x-component': 'CardItem',
                                                                          properties: {
                                                                            table: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-component': 'Table.RowSelection',
                                                                              'x-component-props': {
                                                                                rowKey: 'id',
                                                                                objectValue: true,
                                                                                rowSelection: { type: 'checkbox' },
                                                                                useDataSource:
                                                                                  '{{ cm.useDataSourceFromRAC }}',
                                                                              },
                                                                              'x-initializer': 'table:configureColumns',
                                                                              'x-uid': 'zpvg0dqa6ah',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'epq0fa3q0pk',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': '32eybnl72u8',
                                                                      'x-async': false,
                                                                      'x-index': 5,
                                                                    },
                                                                    item: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-component': 'RecordPicker.SelectedItem',
                                                                      properties: {
                                                                        drawer1: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-decorator':
                                                                            'CollectionProvider_deprecated',
                                                                          'x-decorator-props': { name: 'users' },
                                                                          'x-component': 'Action.Drawer',
                                                                          'x-component-props': {
                                                                            className: 'nb-action-popup',
                                                                          },
                                                                          type: 'void',
                                                                          title: 'Drawer Title',
                                                                          properties: {
                                                                            tabs: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-component': 'Tabs',
                                                                              'x-component-props': {},
                                                                              'x-initializer': 'TabPaneInitializers',
                                                                              properties: {
                                                                                tab1: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  title: '详情',
                                                                                  'x-component': 'Tabs.TabPane',
                                                                                  'x-designer': 'Tabs.Designer',
                                                                                  'x-component-props': {},
                                                                                  properties: {
                                                                                    grid: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-component': 'Grid',
                                                                                      'x-initializer':
                                                                                        'popup:common:addBlock',
                                                                                      'x-uid': 'e5rinu1bklz',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'fkx64ra2j67',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'gotkzfwcnv1',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'qlh099y7adq',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': '11l12a170ig',
                                                                      'x-async': false,
                                                                      'x-index': 6,
                                                                    },
                                                                  },
                                                                  'x-uid': 'gsu6s4xa87k',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'lrm2aq462sd',
                                                              'x-async': false,
                                                            },
                                                          },
                                                          'x-uid': 'jh3za2qlv7q',
                                                          'x-async': false,
                                                        },
                                                        row_l0d7ewamrk4: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          'x-index': 5,
                                                          properties: {
                                                            ri7igv40aw9: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              properties: {
                                                                f_yc8jbfiqfvh: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '优先级',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_yc8jbfiqfvh',
                                                                  'x-uid': '273vg239c03',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'k761v960ygo',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                            col_xav1170vdwy: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              'x-index': 2,
                                                              properties: {
                                                                f_hpmvdltzs6m: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '状态',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_hpmvdltzs6m',
                                                                  'x-uid': 'z9zd3upkxpr',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': '6hnmomuo06m',
                                                              'x-async': false,
                                                            },
                                                          },
                                                          'x-uid': 'k5phfblundo',
                                                          'x-async': false,
                                                        },
                                                        lgzar02d5j6: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          properties: {
                                                            o5zzcu27i23: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              properties: {
                                                                f_jj9cyhron1d: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-designer': 'Table.Array.Designer',
                                                                  'x-component': 'div',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_jj9cyhron1d',
                                                                  properties: {
                                                                    block: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-component': 'DataSourceProvider',
                                                                      'x-component-props': {
                                                                        collection: 't_ab12qiwruwk',
                                                                        association: {
                                                                          collectionName: 't_j6omof6tza8',
                                                                          name: 'f_jj9cyhron1d',
                                                                          sourceKey: 'id',
                                                                          targetKey: 'id',
                                                                        },
                                                                      },
                                                                      properties: {
                                                                        actions: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'ActionBar',
                                                                          'x-component-props': {
                                                                            style: { marginBottom: 16 },
                                                                          },
                                                                          properties: {
                                                                            delete: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              title: '{{ t("Delete") }}',
                                                                              'x-component': 'Action',
                                                                              'x-component-props': {
                                                                                useAction:
                                                                                  '{{ ds.useBulkDestroyAction }}',
                                                                                confirm: {
                                                                                  title: "{{t('Delete record')}}",
                                                                                  content:
                                                                                    "{{t('Are you sure you want to delete it?')}}",
                                                                                },
                                                                              },
                                                                              'x-uid': '2wuvm6oakgc',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                            create: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              title: '{{ t("Add new") }}',
                                                                              'x-action': 'create',
                                                                              'x-component': 'Action',
                                                                              'x-component-props': {
                                                                                type: 'primary',
                                                                                openMode: 'drawer',
                                                                              },
                                                                              properties: {
                                                                                drawer: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  title: '{{ t("Add new record") }}',
                                                                                  'x-component': 'Action.Container',
                                                                                  'x-component-props': {},
                                                                                  'x-decorator': 'Form',
                                                                                  properties: {
                                                                                    grid: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-component': 'Grid',
                                                                                      'x-initializer':
                                                                                        'GridFormItemInitializers',
                                                                                      'x-uid': '1byv8p1zbrg',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                    footer: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-component':
                                                                                        'Action.Container.Footer',
                                                                                      properties: {
                                                                                        actions: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-component': 'ActionBar',
                                                                                          'x-component-props': {
                                                                                            layout: 'one-column',
                                                                                          },
                                                                                          properties: {
                                                                                            cancel: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              title:
                                                                                                '{{ t("Cancel") }}',
                                                                                              'x-action': 'cancel',
                                                                                              'x-component': 'Action',
                                                                                              'x-component-props': {
                                                                                                useAction:
                                                                                                  '{{ cm.useCancelAction }}',
                                                                                              },
                                                                                              'x-uid': 'rc84urljc0f',
                                                                                              'x-async': false,
                                                                                              'x-index': 1,
                                                                                            },
                                                                                            submit: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              title:
                                                                                                '{{ t("Submit") }}',
                                                                                              'x-action': 'submit',
                                                                                              'x-component': 'Action',
                                                                                              'x-component-props': {
                                                                                                type: 'primary',
                                                                                                useAction:
                                                                                                  '{{ ds.useCreateAction }}',
                                                                                              },
                                                                                              'x-uid': 't4n5jtm175s',
                                                                                              'x-async': false,
                                                                                              'x-index': 2,
                                                                                            },
                                                                                          },
                                                                                          'x-uid': '7e1aw0u3nrg',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'h0crlkx0o0g',
                                                                                      'x-async': false,
                                                                                      'x-index': 2,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'xpj4luaztnj',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '8743rtm864g',
                                                                              'x-async': false,
                                                                              'x-index': 2,
                                                                            },
                                                                          },
                                                                          'x-uid': 'fycuu2ty0pg',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                        f_jj9cyhron1d: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'array',
                                                                          title: '{{t("Fields")}}',
                                                                          'x-component': 'Table.Array',
                                                                          'x-initializer': 'table:configureColumns',
                                                                          'x-component-props': {
                                                                            pagination: false,
                                                                            expandable: {
                                                                              childrenColumnName: '__nochildren__',
                                                                            },
                                                                            rowSelection: { type: 'checkbox' },
                                                                            useSelectedRowKeys:
                                                                              '{{ ds.useSelectedRowKeys }}',
                                                                            useDataSource: '{{ ds.useDataSource }}',
                                                                          },
                                                                          properties: {
                                                                            actions: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              title: '{{ t("Actions") }}',
                                                                              'x-decorator': 'Table.Column.ActionBar',
                                                                              'x-component': 'Table.Column',
                                                                              'x-designer': 'Table.RowActionDesigner',
                                                                              'x-initializer':
                                                                                'TableFieldRecordActionInitializers',
                                                                              properties: {
                                                                                actions: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  'x-decorator': 'DndContext',
                                                                                  'x-component': 'Space',
                                                                                  'x-component-props': { split: '|' },
                                                                                  'x-uid': 'obzbu23cyj2',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'uzudnpmbf0w',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                            '21wayhqcr6s': {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-decorator': 'Table.Column.Decorator',
                                                                              'x-designer': 'Table.Column.Designer',
                                                                              'x-component': 'Table.Column',
                                                                              properties: {
                                                                                f_m7ibo1vrvnm: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-read-pretty': true,
                                                                                  'x-collection-field':
                                                                                    't_ab12qiwruwk.f_m7ibo1vrvnm',
                                                                                  'x-component': 'CollectionField',
                                                                                  'x-component-props': {},
                                                                                  'x-uid': '4a3jcuj83xd',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'lqen8jhkjwu',
                                                                              'x-async': false,
                                                                              'x-index': 2,
                                                                            },
                                                                            xhtov2ldmk9: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-decorator': 'Table.Column.Decorator',
                                                                              'x-designer': 'Table.Column.Designer',
                                                                              'x-component': 'Table.Column',
                                                                              properties: {
                                                                                f_kukaw9kddyj: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-read-pretty': true,
                                                                                  'x-collection-field':
                                                                                    't_ab12qiwruwk.f_kukaw9kddyj',
                                                                                  'x-component': 'CollectionField',
                                                                                  'x-component-props': {
                                                                                    mode: 'tags',
                                                                                    fieldNames: {
                                                                                      label: 'id',
                                                                                      value: 'id',
                                                                                    },
                                                                                  },
                                                                                  properties: {
                                                                                    options: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      'x-component':
                                                                                        'RecordPicker.Options',
                                                                                      type: 'void',
                                                                                      title: 'Drawer Title',
                                                                                      properties: {
                                                                                        block: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-collection': 'collections',
                                                                                          'x-decorator':
                                                                                            'ResourceActionProvider',
                                                                                          'x-decorator-props': {
                                                                                            collection: 'users',
                                                                                            request: {
                                                                                              resource: 'users',
                                                                                              action: 'list',
                                                                                              params: {
                                                                                                pageSize: 20,
                                                                                                filter: {},
                                                                                                appends: [],
                                                                                              },
                                                                                            },
                                                                                          },
                                                                                          'x-designer':
                                                                                            'Table.Void.Designer',
                                                                                          'x-component': 'CardItem',
                                                                                          properties: {
                                                                                            table: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              'x-component':
                                                                                                'Table.RowSelection',
                                                                                              'x-component-props': {
                                                                                                rowKey: 'id',
                                                                                                objectValue: true,
                                                                                                rowSelection: {
                                                                                                  type: 'checkbox',
                                                                                                },
                                                                                                useDataSource:
                                                                                                  '{{ cm.useDataSourceFromRAC }}',
                                                                                              },
                                                                                              'x-initializer':
                                                                                                'table:configureColumns',
                                                                                              'x-uid': 'cobw3nz2wb7',
                                                                                              'x-async': false,
                                                                                              'x-index': 1,
                                                                                            },
                                                                                          },
                                                                                          'x-uid': '32a57x0k7f5',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': '3yhu4dp6ape',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                    item: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      'x-component':
                                                                                        'RecordPicker.SelectedItem',
                                                                                      properties: {
                                                                                        drawer1: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          'x-decorator':
                                                                                            'CollectionProvider_deprecated',
                                                                                          'x-decorator-props': {
                                                                                            name: 'users',
                                                                                          },
                                                                                          'x-component':
                                                                                            'Action.Drawer',
                                                                                          'x-component-props': {
                                                                                            className:
                                                                                              'nb-action-popup',
                                                                                          },
                                                                                          type: 'void',
                                                                                          title: 'Drawer Title',
                                                                                          properties: {
                                                                                            tabs: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              type: 'void',
                                                                                              'x-component': 'Tabs',
                                                                                              'x-component-props': {},
                                                                                              'x-initializer':
                                                                                                'TabPaneInitializers',
                                                                                              properties: {
                                                                                                tab1: {
                                                                                                  _isJSONSchemaObject:
                                                                                                    true,
                                                                                                  version: '2.0',
                                                                                                  type: 'void',
                                                                                                  title: '详情',
                                                                                                  'x-component':
                                                                                                    'Tabs.TabPane',
                                                                                                  'x-designer':
                                                                                                    'Tabs.Designer',
                                                                                                  'x-component-props':
                                                                                                    {},
                                                                                                  properties: {
                                                                                                    grid: {
                                                                                                      _isJSONSchemaObject:
                                                                                                        true,
                                                                                                      version: '2.0',
                                                                                                      type: 'void',
                                                                                                      'x-component':
                                                                                                        'Grid',
                                                                                                      'x-initializer':
                                                                                                        'popup:common:addBlock',
                                                                                                      'x-uid':
                                                                                                        'wyk0354iblf',
                                                                                                      'x-async': false,
                                                                                                      'x-index': 1,
                                                                                                    },
                                                                                                  },
                                                                                                  'x-uid':
                                                                                                    '5njad6vcik1',
                                                                                                  'x-async': false,
                                                                                                  'x-index': 1,
                                                                                                },
                                                                                              },
                                                                                              'x-uid': '960gmdv30hn',
                                                                                              'x-async': false,
                                                                                              'x-index': 1,
                                                                                            },
                                                                                          },
                                                                                          'x-uid': 'poc5943iwcm',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'eces95ug7b9',
                                                                                      'x-async': false,
                                                                                      'x-index': 2,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'k99rg29faq6',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '66lnt4qsd90',
                                                                              'x-async': false,
                                                                              'x-index': 3,
                                                                            },
                                                                            o62wxmx9srp: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-decorator': 'Table.Column.Decorator',
                                                                              'x-designer': 'Table.Column.Designer',
                                                                              'x-component': 'Table.Column',
                                                                              properties: {
                                                                                f_4mpiovytw4d: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-read-pretty': true,
                                                                                  'x-collection-field':
                                                                                    't_ab12qiwruwk.f_4mpiovytw4d',
                                                                                  'x-component': 'CollectionField',
                                                                                  'x-component-props': {},
                                                                                  'x-uid': 'yfi4eh21sm7',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'aiqqnr8jtiz',
                                                                              'x-async': false,
                                                                              'x-index': 4,
                                                                            },
                                                                            yzrjoq60t2z: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-decorator': 'Table.Column.Decorator',
                                                                              'x-designer': 'Table.Column.Designer',
                                                                              'x-component': 'Table.Column',
                                                                              properties: {
                                                                                f_lxsum89wkzd: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-read-pretty': true,
                                                                                  'x-collection-field':
                                                                                    't_ab12qiwruwk.f_lxsum89wkzd',
                                                                                  'x-component': 'CollectionField',
                                                                                  'x-component-props': {
                                                                                    size: 'small',
                                                                                  },
                                                                                  'x-uid': 'zogb1cn5079',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '53jxymisccg',
                                                                              'x-async': false,
                                                                              'x-index': 5,
                                                                            },
                                                                          },
                                                                          'x-uid': 'vubstjl0zm9',
                                                                          'x-async': false,
                                                                          'x-index': 2,
                                                                        },
                                                                      },
                                                                      'x-uid': 'kg3l0yeadau',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'kp9xub7p0ls',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'fadg5gz2dh1',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'qxrxoxrjwlg',
                                                          'x-async': false,
                                                          'x-index': 12,
                                                        },
                                                        row_teea1c2pinj: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid.Row',
                                                          'x-index': 14,
                                                          properties: {
                                                            bik69enqpjs: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Col',
                                                              properties: {
                                                                f_bwf3d9caoj6: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-designer': 'FormItem.Designer',
                                                                  'x-component': 'CollectionField',
                                                                  'x-decorator': 'FormItem',
                                                                  'x-collection-field': 't_j6omof6tza8.f_bwf3d9caoj6',
                                                                  'x-uid': 'fpy77wn14m6',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'sznfxn5ra5n',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': '5ovbkt78u1o',
                                                          'x-async': false,
                                                        },
                                                      },
                                                      'x-uid': 'lwwwykw3sw7',
                                                      'x-async': false,
                                                      'x-index': 2,
                                                    },
                                                  },
                                                  'x-uid': '6dd90fi4bu4',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': '0jo3by0qcue',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': '6iobikiagw5',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'w25f2fmvpl1',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '0t00iv124kk',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'i25kong0u1o',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': '4dfotke1zie',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': 'sr1oz02qs1t',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'xw5h4zkw1o0',
                  'x-async': false,
                  'x-index': 1,
                },
                caf9h9ddkbc: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  title: '{{ t("Edit") }}',
                  type: 'void',
                  'x-action': 'update',
                  'x-designer': 'Action.Designer',
                  'x-component': 'Action.Link',
                  'x-component-props': { openMode: 'drawer' },
                  properties: {
                    drawer: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-decorator': 'Form',
                      'x-decorator-props': { useValues: '{{ cm.useValuesFromRecord }}' },
                      'x-component': 'Action.Container',
                      title: '{{ t("Edit record") }}',
                      properties: {
                        grid: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Grid',
                          'x-initializer': 'GridFormItemInitializers',
                          properties: {
                            kwkuoziqi77: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                zzcgianiivw: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_g8j5jvalqh0: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
                                      required: true,
                                      'x-uid': 'cb1pav91zjt',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '1d4957ic432',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'gg3rgey74lh',
                              'x-async': false,
                              'x-index': 1,
                            },
                            qb9mtsxqgkd: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                ppdm2zkcuoq: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_tegyd222bcc: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_tegyd222bcc',
                                      'x-uid': 'uhgj0d7bbbn',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'z26eeee5org',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                                col_ssc5awxb5dm: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 2,
                                  properties: {
                                    f_ooar0pto2ko: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_ooar0pto2ko',
                                      'x-component-props': { mode: 'tags', fieldNames: { label: 'id', value: 'id' } },
                                      required: false,
                                      properties: {
                                        options: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.Options',
                                          type: 'void',
                                          title: 'Drawer Title',
                                          properties: {
                                            block: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-collection': 'collections',
                                              'x-decorator': 'ResourceActionProvider',
                                              'x-decorator-props': {
                                                collection: 'attachments',
                                                request: {
                                                  resource: 'attachments',
                                                  action: 'list',
                                                  params: { pageSize: 20, filter: {}, appends: [] },
                                                },
                                              },
                                              'x-designer': 'Table.Void.Designer',
                                              'x-component': 'CardItem',
                                              properties: {
                                                table: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'Table.RowSelection',
                                                  'x-component-props': {
                                                    rowKey: 'id',
                                                    objectValue: true,
                                                    rowSelection: { type: 'checkbox' },
                                                    useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                  },
                                                  'x-initializer': 'table:configureColumns',
                                                  'x-uid': 'je1aq3fa393',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'gmx7cbnf5dp',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'zwcm5ly9u7o',
                                          'x-async': false,
                                          'x-index': 5,
                                        },
                                        item: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.SelectedItem',
                                          properties: {
                                            drawer1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-decorator': 'CollectionProvider_deprecated',
                                              'x-decorator-props': { name: 'attachments' },
                                              'x-component': 'Action.Drawer',
                                              'x-component-props': { className: 'nb-action-popup' },
                                              type: 'void',
                                              title: 'Drawer Title',
                                              properties: {
                                                tabs: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Tabs',
                                                  'x-component-props': {},
                                                  'x-initializer': 'TabPaneInitializers',
                                                  properties: {
                                                    tab1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      title: '详情',
                                                      'x-component': 'Tabs.TabPane',
                                                      'x-designer': 'Tabs.Designer',
                                                      'x-component-props': {},
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'popup:common:addBlock',
                                                          'x-uid': 'sv7t2pdx2vn',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'urelkefvtwl',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'u1wf0lheei1',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'e75ldlwappu',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': '7v7vfhknfxt',
                                          'x-async': false,
                                          'x-index': 6,
                                        },
                                      },
                                      'x-uid': '9erj088cxoo',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'fjgzaz5xf6k',
                                  'x-async': false,
                                },
                              },
                              'x-uid': '45iz30t6zi5',
                              'x-async': false,
                              'x-index': 2,
                            },
                            uwx0vhgmvwx: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                col_eioxpwpgmc7: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 1,
                                  properties: {
                                    f_z27302tl2bf: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_z27302tl2bf',
                                      required: false,
                                      'x-uid': 'sg6ti2b9kjy',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'wq64edaw2tv',
                                  'x-async': false,
                                },
                                col_min1xdw2bd5: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 2,
                                  properties: {
                                    f_cht6rsiiiko: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      title: '分类',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_cht6rsiiiko',
                                      'x-uid': '15a0vhqjc6x',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'i1ect8ds7k5',
                                  'x-async': false,
                                },
                              },
                              'x-uid': '575xos92uc2',
                              'x-async': false,
                              'x-index': 3,
                            },
                            '4yrxpeztr71': {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                col_pgnnr4f8dfj: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 1,
                                  properties: {
                                    f_ksgzy9vmgce: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_ksgzy9vmgce',
                                      'x-component-props': { fieldNames: { label: 'f_zio9ewkxss7', value: 'id' } },
                                      properties: {
                                        options: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.Options',
                                          type: 'void',
                                          title: 'Drawer Title',
                                          properties: {
                                            block: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-collection': 'collections',
                                              'x-decorator': 'ResourceActionProvider',
                                              'x-decorator-props': {
                                                collection: 't_94rsj6kbzvn',
                                                request: {
                                                  resource: 't_94rsj6kbzvn',
                                                  action: 'list',
                                                  params: { pageSize: 20, filter: {}, appends: [] },
                                                },
                                              },
                                              'x-designer': 'Table.Void.Designer',
                                              'x-component': 'CardItem',
                                              properties: {
                                                table: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'Table.RowSelection',
                                                  'x-component-props': {
                                                    rowKey: 'id',
                                                    objectValue: true,
                                                    rowSelection: { type: 'checkbox' },
                                                    useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                  },
                                                  'x-initializer': 'table:configureColumns',
                                                  properties: {
                                                    cj30vjztnkq: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'Table.Column.Decorator',
                                                      'x-designer': 'Table.Column.Designer',
                                                      'x-component': 'Table.Column',
                                                      properties: {
                                                        f_zio9ewkxss7: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-read-pretty': true,
                                                          'x-collection-field': 't_94rsj6kbzvn.f_zio9ewkxss7',
                                                          'x-component': 'CollectionField',
                                                          'x-component-props': { ellipsis: true },
                                                          'x-uid': 'jvshk2eqgwv',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'dqfla050yp4',
                                                      'x-async': false,
                                                      'x-index': 5,
                                                    },
                                                    gct1npfyqpy: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'Table.Column.Decorator',
                                                      'x-designer': 'Table.Column.Designer',
                                                      'x-component': 'Table.Column',
                                                      properties: {
                                                        f_ojboh2wxpju: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-read-pretty': true,
                                                          'x-collection-field': 't_94rsj6kbzvn.f_ojboh2wxpju',
                                                          'x-component': 'CollectionField',
                                                          'x-component-props': { ellipsis: true },
                                                          'x-uid': 'iyjtp1y5b7h',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'kj8hv9qhcn8',
                                                      'x-async': false,
                                                      'x-index': 6,
                                                    },
                                                  },
                                                  'x-uid': '1a1pyjlsx2a',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': '3g7b8yky2v3',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'koyvewdjqqs',
                                          'x-async': false,
                                          'x-index': 9,
                                        },
                                        item: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.SelectedItem',
                                          properties: {
                                            drawer1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-decorator': 'CollectionProvider_deprecated',
                                              'x-decorator-props': { name: 't_94rsj6kbzvn' },
                                              'x-component': 'Action.Drawer',
                                              'x-component-props': { className: 'nb-action-popup' },
                                              type: 'void',
                                              title: 'Drawer Title',
                                              properties: {
                                                tabs: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Tabs',
                                                  'x-component-props': {},
                                                  'x-initializer': 'TabPaneInitializers',
                                                  properties: {
                                                    tab1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      title: '详情',
                                                      'x-component': 'Tabs.TabPane',
                                                      'x-designer': 'Tabs.Designer',
                                                      'x-component-props': {},
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'popup:common:addBlock',
                                                          'x-uid': 'rk1xp8n54cg',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'fj9z3ai9oge',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '0yib81v64ld',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'szt4km5rni3',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'jiub59dvrtz',
                                          'x-async': false,
                                          'x-index': 10,
                                        },
                                      },
                                      'x-uid': '4mof861ex87',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'q50v23kqian',
                                  'x-async': false,
                                },
                                col_1colstj9xtp: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 2,
                                  properties: {
                                    f_u007sq2jg93: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_u007sq2jg93',
                                      'x-component-props': { fieldNames: { label: 'nickname', value: 'id' } },
                                      properties: {
                                        options: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.Options',
                                          type: 'void',
                                          title: 'Drawer Title',
                                          properties: {
                                            block: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-collection': 'collections',
                                              'x-decorator': 'ResourceActionProvider',
                                              'x-decorator-props': {
                                                collection: 'users',
                                                request: {
                                                  resource: 'users',
                                                  action: 'list',
                                                  params: { pageSize: 20, filter: {}, appends: [] },
                                                },
                                              },
                                              'x-designer': 'Table.Void.Designer',
                                              'x-component': 'CardItem',
                                              properties: {
                                                table: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'Table.RowSelection',
                                                  'x-component-props': {
                                                    rowKey: 'id',
                                                    objectValue: true,
                                                    rowSelection: { type: 'checkbox' },
                                                    useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                  },
                                                  'x-initializer': 'table:configureColumns',
                                                  properties: {
                                                    dvv0tf3p4o9: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'Table.Column.Decorator',
                                                      'x-designer': 'Table.Column.Designer',
                                                      'x-component': 'Table.Column',
                                                      properties: {
                                                        nickname: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-read-pretty': true,
                                                          'x-collection-field': 'users.nickname',
                                                          'x-component': 'CollectionField',
                                                          'x-component-props': { ellipsis: true },
                                                          'x-uid': 'inybcir2e0s',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'ihpgxi73n1g',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '03yhn63xm0g',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': '80l9m943q31',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'zy1krp9zcaw',
                                          'x-async': false,
                                          'x-index': 3,
                                        },
                                        item: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.SelectedItem',
                                          properties: {
                                            drawer1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-decorator': 'CollectionProvider_deprecated',
                                              'x-decorator-props': { name: 'users' },
                                              'x-component': 'Action.Drawer',
                                              'x-component-props': { className: 'nb-action-popup' },
                                              type: 'void',
                                              title: 'Drawer Title',
                                              properties: {
                                                tabs: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Tabs',
                                                  'x-component-props': {},
                                                  'x-initializer': 'TabPaneInitializers',
                                                  properties: {
                                                    tab1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      title: '详情',
                                                      'x-component': 'Tabs.TabPane',
                                                      'x-designer': 'Tabs.Designer',
                                                      'x-component-props': {},
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'popup:common:addBlock',
                                                          'x-uid': 'lbv3i0i3j8v',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'q68120hbwpn',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'dbu8rkkxiek',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'k3ic1mhbxg2',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'g7qtltj5448',
                                          'x-async': false,
                                          'x-index': 4,
                                        },
                                      },
                                      'x-uid': 'xqzs73c4hz2',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '3hluh7j06te',
                                  'x-async': false,
                                },
                              },
                              'x-uid': 'fhayw0e1174',
                              'x-async': false,
                              'x-index': 4,
                            },
                            row_vrsgzqb6wtt: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              'x-index': 5,
                              properties: {
                                '5fp561h1z83': {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_yc8jbfiqfvh: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_yc8jbfiqfvh',
                                      'x-uid': 'v4lac2p90ob',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'gqzt7hm6tpk',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                                col_zvfj9cqatvg: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  'x-index': 2,
                                  properties: {
                                    f_hpmvdltzs6m: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_hpmvdltzs6m',
                                      'x-uid': '1fkkq3ld4kt',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '1vf3ea7aym7',
                                  'x-async': false,
                                },
                              },
                              'x-uid': 'myb8sedi17f',
                              'x-async': false,
                            },
                            row_21424xej88l: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              'x-index': 6,
                              properties: {
                                sktdv49s8hm: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_47f2d9wgofm: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_47f2d9wgofm',
                                      'x-component-props': { fieldNames: { label: 'f_g8j5jvalqh0', value: 'id' } },
                                      properties: {
                                        options: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.Options',
                                          type: 'void',
                                          title: 'Drawer Title',
                                          properties: {
                                            block: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-collection': 'collections',
                                              'x-decorator': 'ResourceActionProvider',
                                              'x-decorator-props': {
                                                collection: 't_j6omof6tza8',
                                                request: {
                                                  resource: 't_j6omof6tza8',
                                                  action: 'list',
                                                  params: { pageSize: 20, filter: {}, appends: [] },
                                                },
                                              },
                                              'x-designer': 'Table.Void.Designer',
                                              'x-component': 'CardItem',
                                              properties: {
                                                table: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  'x-component': 'Table.RowSelection',
                                                  'x-component-props': {
                                                    rowKey: 'id',
                                                    objectValue: true,
                                                    rowSelection: { type: 'checkbox' },
                                                    useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                  },
                                                  'x-initializer': 'table:configureColumns',
                                                  properties: {
                                                    dncah8wtscx: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'Table.Column.Decorator',
                                                      'x-designer': 'Table.Column.Designer',
                                                      'x-component': 'Table.Column',
                                                      properties: {
                                                        f_g8j5jvalqh0: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-read-pretty': true,
                                                          'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
                                                          'x-component': 'CollectionField',
                                                          'x-component-props': { ellipsis: true },
                                                          'x-uid': 'fmovl4tiah0',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'ewgtbmaxloh',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'xlnac4l0vzq',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'skpijqejtfj',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'mc6uzys8d4r',
                                          'x-async': false,
                                          'x-index': 3,
                                        },
                                        item: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          'x-component': 'RecordPicker.SelectedItem',
                                          properties: {
                                            drawer1: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              'x-decorator': 'CollectionProvider_deprecated',
                                              'x-decorator-props': { name: 't_j6omof6tza8' },
                                              'x-component': 'Action.Drawer',
                                              'x-component-props': { className: 'nb-action-popup' },
                                              type: 'void',
                                              title: 'Drawer Title',
                                              properties: {
                                                tabs: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-component': 'Tabs',
                                                  'x-component-props': {},
                                                  'x-initializer': 'TabPaneInitializers',
                                                  properties: {
                                                    tab1: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      title: '详情',
                                                      'x-component': 'Tabs.TabPane',
                                                      'x-designer': 'Tabs.Designer',
                                                      'x-component-props': {},
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'popup:common:addBlock',
                                                          'x-uid': 'ilkn8wpnox9',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': 'tjz7wiwbq7p',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '3eiq9mqo3gy',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                              },
                                              'x-uid': 'nvoigxothgy',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                          },
                                          'x-uid': 'yatfzz7kdfl',
                                          'x-async': false,
                                          'x-index': 4,
                                        },
                                      },
                                      'x-uid': 'lui61bev3z4',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '0xfw4ufehjf',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': '9gu0d3wcutt',
                              'x-async': false,
                            },
                            a1ju4grjnlw: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                yekwc0cliyq: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_jj9cyhron1d: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      type: 'void',
                                      'x-designer': 'Table.Array.Designer',
                                      'x-component': 'div',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_jj9cyhron1d',
                                      properties: {
                                        block: {
                                          _isJSONSchemaObject: true,
                                          version: '2.0',
                                          type: 'void',
                                          'x-component': 'DataSourceProvider',
                                          'x-component-props': {
                                            collection: 't_ab12qiwruwk',
                                            association: {
                                              collectionName: 't_j6omof6tza8',
                                              name: 'f_jj9cyhron1d',
                                              sourceKey: 'id',
                                              targetKey: 'id',
                                            },
                                          },
                                          properties: {
                                            actions: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'void',
                                              'x-component': 'ActionBar',
                                              'x-component-props': { style: { marginBottom: 16 } },
                                              properties: {
                                                delete: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  title: '{{ t("Delete") }}',
                                                  'x-component': 'Action',
                                                  'x-component-props': {
                                                    useAction: '{{ ds.useBulkDestroyAction }}',
                                                    confirm: {
                                                      title: "{{t('Delete record')}}",
                                                      content: "{{t('Are you sure you want to delete it?')}}",
                                                    },
                                                  },
                                                  'x-uid': 'dz6o2fl7voh',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                                create: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  title: '{{ t("Add new") }}',
                                                  'x-action': 'create',
                                                  'x-component': 'Action',
                                                  'x-component-props': { type: 'primary', openMode: 'drawer' },
                                                  properties: {
                                                    drawer: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      title: '{{ t("Add new record") }}',
                                                      'x-component': 'Action.Container',
                                                      'x-component-props': {},
                                                      'x-decorator': 'Form',
                                                      properties: {
                                                        grid: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Grid',
                                                          'x-initializer': 'GridFormItemInitializers',
                                                          properties: {
                                                            '8qclzttzelf': {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Row',
                                                              properties: {
                                                                pk0qp4hn2vn: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid.Col',
                                                                  properties: {
                                                                    f_m7ibo1vrvnm: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-designer': 'FormItem.Designer',
                                                                      'x-component': 'CollectionField',
                                                                      'x-decorator': 'FormItem',
                                                                      'x-collection-field':
                                                                        't_ab12qiwruwk.f_m7ibo1vrvnm',
                                                                      required: true,
                                                                      'x-uid': 'ssosrruvafl',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'hc40c2escc7',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'rw64ln3jdc6',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                            px4ykkps9hp: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Row',
                                                              properties: {
                                                                radqywecqyn: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid.Col',
                                                                  properties: {
                                                                    f_kukaw9kddyj: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-designer': 'FormItem.Designer',
                                                                      'x-component': 'CollectionField',
                                                                      'x-decorator': 'FormItem',
                                                                      'x-collection-field':
                                                                        't_ab12qiwruwk.f_kukaw9kddyj',
                                                                      'x-component-props': {
                                                                        mode: 'tags',
                                                                        fieldNames: { label: 'id', value: 'id' },
                                                                      },
                                                                      properties: {
                                                                        options: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'RecordPicker.Options',
                                                                          type: 'void',
                                                                          title: 'Drawer Title',
                                                                          properties: {
                                                                            block: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-collection': 'collections',
                                                                              'x-decorator': 'ResourceActionProvider',
                                                                              'x-decorator-props': {
                                                                                collection: 'users',
                                                                                request: {
                                                                                  resource: 'users',
                                                                                  action: 'list',
                                                                                  params: {
                                                                                    pageSize: 20,
                                                                                    filter: {},
                                                                                    appends: [],
                                                                                  },
                                                                                },
                                                                              },
                                                                              'x-designer': 'Table.Void.Designer',
                                                                              'x-component': 'CardItem',
                                                                              properties: {
                                                                                table: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component': 'Table.RowSelection',
                                                                                  'x-component-props': {
                                                                                    rowKey: 'id',
                                                                                    objectValue: true,
                                                                                    rowSelection: {
                                                                                      type: 'checkbox',
                                                                                    },
                                                                                    useDataSource:
                                                                                      '{{ cm.useDataSourceFromRAC }}',
                                                                                  },
                                                                                  'x-initializer':
                                                                                    'table:configureColumns',
                                                                                  'x-uid': 's8hao0uqg8g',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'f4k906r8qjf',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': '39twaqrbbx2',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                        item: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'RecordPicker.SelectedItem',
                                                                          properties: {
                                                                            drawer1: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-decorator':
                                                                                'CollectionProvider_deprecated',
                                                                              'x-decorator-props': { name: 'users' },
                                                                              'x-component': 'Action.Drawer',
                                                                              'x-component-props': {
                                                                                className: 'nb-action-popup',
                                                                              },
                                                                              type: 'void',
                                                                              title: 'Drawer Title',
                                                                              properties: {
                                                                                tabs: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  'x-component': 'Tabs',
                                                                                  'x-component-props': {},
                                                                                  'x-initializer':
                                                                                    'TabPaneInitializers',
                                                                                  properties: {
                                                                                    tab1: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      title: '详情',
                                                                                      'x-component': 'Tabs.TabPane',
                                                                                      'x-designer': 'Tabs.Designer',
                                                                                      'x-component-props': {},
                                                                                      properties: {
                                                                                        grid: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-component': 'Grid',
                                                                                          'x-initializer':
                                                                                            'popup:common:addBlock',
                                                                                          'x-uid': 'hzvevuvhee7',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'qad49yvm1e7',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'g61od9v05rv',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': 'gxpodwgqsnk',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'wjaveb5qzzi',
                                                                          'x-async': false,
                                                                          'x-index': 2,
                                                                        },
                                                                      },
                                                                      'x-uid': '4ef365vw6cs',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'nksnwithgcx',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'bzm3r4yl532',
                                                              'x-async': false,
                                                              'x-index': 2,
                                                            },
                                                            '8fhtawbcvdo': {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Row',
                                                              properties: {
                                                                '2k6azu4kyin': {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid.Col',
                                                                  properties: {
                                                                    f_4mpiovytw4d: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-designer': 'FormItem.Designer',
                                                                      'x-component': 'CollectionField',
                                                                      'x-decorator': 'FormItem',
                                                                      'x-collection-field':
                                                                        't_ab12qiwruwk.f_4mpiovytw4d',
                                                                      'x-uid': 'dlwbo6pq11c',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'el0dpa39gr7',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'h4hk9jpv6k6',
                                                              'x-async': false,
                                                              'x-index': 3,
                                                            },
                                                            sy7jttnleap: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'Grid.Row',
                                                              properties: {
                                                                hqbgstxx40n: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid.Col',
                                                                  properties: {
                                                                    f_lxsum89wkzd: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      'x-designer': 'FormItem.Designer',
                                                                      'x-component': 'CollectionField',
                                                                      'x-decorator': 'FormItem',
                                                                      'x-collection-field':
                                                                        't_ab12qiwruwk.f_lxsum89wkzd',
                                                                      'x-component-props': {
                                                                        mode: 'tags',
                                                                        fieldNames: { label: 'id', value: 'id' },
                                                                      },
                                                                      properties: {
                                                                        options: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'RecordPicker.Options',
                                                                          type: 'void',
                                                                          title: 'Drawer Title',
                                                                          properties: {
                                                                            block: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              type: 'void',
                                                                              'x-collection': 'collections',
                                                                              'x-decorator': 'ResourceActionProvider',
                                                                              'x-decorator-props': {
                                                                                collection: 'attachments',
                                                                                request: {
                                                                                  resource: 'attachments',
                                                                                  action: 'list',
                                                                                  params: {
                                                                                    pageSize: 20,
                                                                                    filter: {},
                                                                                    appends: [],
                                                                                  },
                                                                                },
                                                                              },
                                                                              'x-designer': 'Table.Void.Designer',
                                                                              'x-component': 'CardItem',
                                                                              properties: {
                                                                                table: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component': 'Table.RowSelection',
                                                                                  'x-component-props': {
                                                                                    rowKey: 'id',
                                                                                    objectValue: true,
                                                                                    rowSelection: {
                                                                                      type: 'checkbox',
                                                                                    },
                                                                                    useDataSource:
                                                                                      '{{ cm.useDataSourceFromRAC }}',
                                                                                  },
                                                                                  'x-initializer':
                                                                                    'table:configureColumns',
                                                                                  'x-uid': '0v1u8mu6z1p',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '17y1lqksdrs',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'zljwnfkkf08',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                        item: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          'x-component': 'RecordPicker.SelectedItem',
                                                                          properties: {
                                                                            drawer1: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-decorator':
                                                                                'CollectionProvider_deprecated',
                                                                              'x-decorator-props': {
                                                                                name: 'attachments',
                                                                              },
                                                                              'x-component': 'Action.Drawer',
                                                                              'x-component-props': {
                                                                                className: 'nb-action-popup',
                                                                              },
                                                                              type: 'void',
                                                                              title: 'Drawer Title',
                                                                              properties: {
                                                                                tabs: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  type: 'void',
                                                                                  'x-component': 'Tabs',
                                                                                  'x-component-props': {},
                                                                                  'x-initializer':
                                                                                    'TabPaneInitializers',
                                                                                  properties: {
                                                                                    tab1: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      title: '详情',
                                                                                      'x-component': 'Tabs.TabPane',
                                                                                      'x-designer': 'Tabs.Designer',
                                                                                      'x-component-props': {},
                                                                                      properties: {
                                                                                        grid: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-component': 'Grid',
                                                                                          'x-initializer':
                                                                                            'popup:common:addBlock',
                                                                                          'x-uid': '463r6uyvf67',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'jtttc1qtffz',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'm4txbt788vn',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                              },
                                                                              'x-uid': '9iw4qkyp4ec',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'ke8ndgcg655',
                                                                          'x-async': false,
                                                                          'x-index': 2,
                                                                        },
                                                                      },
                                                                      'x-uid': 'uqsxo1orm74',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'a9mrpc7t3t6',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'pntbeef58af',
                                                              'x-async': false,
                                                              'x-index': 4,
                                                            },
                                                          },
                                                          'x-uid': 'x40ap0vf5v1',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                        footer: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          type: 'void',
                                                          'x-component': 'Action.Container.Footer',
                                                          properties: {
                                                            actions: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-component': 'ActionBar',
                                                              'x-component-props': { layout: 'one-column' },
                                                              properties: {
                                                                cancel: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '{{ t("Cancel") }}',
                                                                  'x-action': 'cancel',
                                                                  'x-component': 'Action',
                                                                  'x-component-props': {
                                                                    useAction: '{{ cm.useCancelAction }}',
                                                                  },
                                                                  'x-uid': '6j0b0kk6uys',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                                submit: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  title: '{{ t("Submit") }}',
                                                                  'x-action': 'submit',
                                                                  'x-component': 'Action',
                                                                  'x-component-props': {
                                                                    type: 'primary',
                                                                    useAction: '{{ ds.useCreateAction }}',
                                                                  },
                                                                  'x-uid': 'yto0pq748zr',
                                                                  'x-async': false,
                                                                  'x-index': 2,
                                                                },
                                                              },
                                                              'x-uid': 'qa1sz40kxtx',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': '0pto2skgvci',
                                                          'x-async': false,
                                                          'x-index': 2,
                                                        },
                                                      },
                                                      'x-uid': 'omj70shtr1y',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 'u7lrxvrxsar',
                                                  'x-async': false,
                                                  'x-index': 2,
                                                },
                                              },
                                              'x-uid': '0b4ry80w8x6',
                                              'x-async': false,
                                              'x-index': 1,
                                            },
                                            f_jj9cyhron1d: {
                                              _isJSONSchemaObject: true,
                                              version: '2.0',
                                              type: 'array',
                                              title: '{{t("Fields")}}',
                                              'x-component': 'Table.Array',
                                              'x-initializer': 'table:configureColumns',
                                              'x-component-props': {
                                                pagination: false,
                                                expandable: { childrenColumnName: '__nochildren__' },
                                                rowSelection: { type: 'checkbox' },
                                                useSelectedRowKeys: '{{ ds.useSelectedRowKeys }}',
                                                useDataSource: '{{ ds.useDataSource }}',
                                              },
                                              properties: {
                                                actions: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  title: '{{ t("Actions") }}',
                                                  'x-decorator': 'Table.Column.ActionBar',
                                                  'x-component': 'Table.Column',
                                                  'x-designer': 'Table.RowActionDesigner',
                                                  'x-initializer': 'TableFieldRecordActionInitializers',
                                                  properties: {
                                                    actions: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      type: 'void',
                                                      'x-decorator': 'DndContext',
                                                      'x-component': 'Space',
                                                      'x-component-props': { split: '|' },
                                                      properties: {
                                                        cji417dhn88: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          title: '{{ t("Edit") }}',
                                                          type: 'void',
                                                          'x-action': 'update',
                                                          'x-designer': 'Action.Designer',
                                                          'x-component': 'Action.Link',
                                                          'x-component-props': {},
                                                          properties: {
                                                            drawer: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-decorator': 'Form',
                                                              'x-decorator-props': {
                                                                useValues: '{{ cm.useValuesFromRecord }}',
                                                              },
                                                              'x-component': 'Action.Drawer',
                                                              title: '{{ t("Edit record") }}',
                                                              properties: {
                                                                grid: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Grid',
                                                                  'x-initializer': 'GridFormItemInitializers',
                                                                  properties: {
                                                                    jp60g9emxci: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-component': 'Grid.Row',
                                                                      properties: {
                                                                        '3165xoudipa': {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Grid.Col',
                                                                          properties: {
                                                                            f_m7ibo1vrvnm: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-designer': 'FormItem.Designer',
                                                                              'x-component': 'CollectionField',
                                                                              'x-decorator': 'FormItem',
                                                                              'x-collection-field':
                                                                                't_ab12qiwruwk.f_m7ibo1vrvnm',
                                                                              required: true,
                                                                              'x-uid': '998pytqjchb',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'pspdwsfzbsf',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 't16f1k8g21e',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                    gvjym37xafd: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-component': 'Grid.Row',
                                                                      properties: {
                                                                        vqiaoht00tw: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Grid.Col',
                                                                          properties: {
                                                                            f_kukaw9kddyj: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-designer': 'FormItem.Designer',
                                                                              'x-component': 'CollectionField',
                                                                              'x-decorator': 'FormItem',
                                                                              'x-collection-field':
                                                                                't_ab12qiwruwk.f_kukaw9kddyj',
                                                                              'x-component-props': {
                                                                                fieldNames: {
                                                                                  label: 'nickname',
                                                                                  value: 'id',
                                                                                },
                                                                              },
                                                                              properties: {
                                                                                options: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component': 'RecordPicker.Options',
                                                                                  type: 'void',
                                                                                  title: 'Drawer Title',
                                                                                  properties: {
                                                                                    block: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-collection': 'collections',
                                                                                      'x-decorator':
                                                                                        'ResourceActionProvider',
                                                                                      'x-decorator-props': {
                                                                                        collection: 'users',
                                                                                        request: {
                                                                                          resource: 'users',
                                                                                          action: 'list',
                                                                                          params: {
                                                                                            pageSize: 20,
                                                                                            filter: {},
                                                                                            appends: [],
                                                                                          },
                                                                                        },
                                                                                      },
                                                                                      'x-designer':
                                                                                        'Table.Void.Designer',
                                                                                      'x-component': 'CardItem',
                                                                                      properties: {
                                                                                        table: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          'x-component':
                                                                                            'Table.RowSelection',
                                                                                          'x-component-props': {
                                                                                            rowKey: 'id',
                                                                                            objectValue: true,
                                                                                            rowSelection: {
                                                                                              type: 'checkbox',
                                                                                            },
                                                                                            useDataSource:
                                                                                              '{{ cm.useDataSourceFromRAC }}',
                                                                                          },
                                                                                          'x-initializer':
                                                                                            'table:configureColumns',
                                                                                          'x-uid': '369iecwk6gw',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': '8j6dmhx5j7s',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'qicxbhpy94b',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                                item: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component':
                                                                                    'RecordPicker.SelectedItem',
                                                                                  properties: {
                                                                                    drawer1: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      'x-decorator':
                                                                                        'CollectionProvider_deprecated',
                                                                                      'x-decorator-props': {
                                                                                        name: 'users',
                                                                                      },
                                                                                      'x-component': 'Action.Drawer',
                                                                                      'x-component-props': {
                                                                                        className: 'nb-action-popup',
                                                                                      },
                                                                                      type: 'void',
                                                                                      title: 'Drawer Title',
                                                                                      properties: {
                                                                                        tabs: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-component': 'Tabs',
                                                                                          'x-component-props': {},
                                                                                          'x-initializer':
                                                                                            'TabPaneInitializers',
                                                                                          properties: {
                                                                                            tab1: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              type: 'void',
                                                                                              title: '详情',
                                                                                              'x-component':
                                                                                                'Tabs.TabPane',
                                                                                              'x-designer':
                                                                                                'Tabs.Designer',
                                                                                              'x-component-props': {},
                                                                                              properties: {
                                                                                                grid: {
                                                                                                  _isJSONSchemaObject:
                                                                                                    true,
                                                                                                  version: '2.0',
                                                                                                  type: 'void',
                                                                                                  'x-component': 'Grid',
                                                                                                  'x-initializer':
                                                                                                    'popup:common:addBlock',
                                                                                                  'x-uid':
                                                                                                    'o7g549xc7k9',
                                                                                                  'x-async': false,
                                                                                                  'x-index': 1,
                                                                                                },
                                                                                              },
                                                                                              'x-uid': 'c77ynwx8rqp',
                                                                                              'x-async': false,
                                                                                              'x-index': 1,
                                                                                            },
                                                                                          },
                                                                                          'x-uid': '6xbqkngspqh',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'q22pw964rby',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': '00jdrydy5vz',
                                                                                  'x-async': false,
                                                                                  'x-index': 2,
                                                                                },
                                                                              },
                                                                              'x-uid': 'x9dgfov77rc',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': '0yoegbpuurm',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': '86ejduellve',
                                                                      'x-async': false,
                                                                      'x-index': 2,
                                                                    },
                                                                    bt7aiczcmcg: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-component': 'Grid.Row',
                                                                      properties: {
                                                                        '739ie1depry': {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Grid.Col',
                                                                          properties: {
                                                                            f_4mpiovytw4d: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-designer': 'FormItem.Designer',
                                                                              'x-component': 'CollectionField',
                                                                              'x-decorator': 'FormItem',
                                                                              'x-collection-field':
                                                                                't_ab12qiwruwk.f_4mpiovytw4d',
                                                                              'x-uid': 'q6dhw4dm5p2',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': 'q2phshteybb',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'syi0cprsweg',
                                                                      'x-async': false,
                                                                      'x-index': 3,
                                                                    },
                                                                    t28l1axqts7: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-component': 'Grid.Row',
                                                                      properties: {
                                                                        o4n78r50icc: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Grid.Col',
                                                                          properties: {
                                                                            f_lxsum89wkzd: {
                                                                              _isJSONSchemaObject: true,
                                                                              version: '2.0',
                                                                              'x-designer': 'FormItem.Designer',
                                                                              'x-component': 'CollectionField',
                                                                              'x-decorator': 'FormItem',
                                                                              'x-collection-field':
                                                                                't_ab12qiwruwk.f_lxsum89wkzd',
                                                                              'x-component-props': {
                                                                                mode: 'tags',
                                                                                fieldNames: {
                                                                                  label: 'id',
                                                                                  value: 'id',
                                                                                },
                                                                              },
                                                                              properties: {
                                                                                options: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component': 'RecordPicker.Options',
                                                                                  type: 'void',
                                                                                  title: 'Drawer Title',
                                                                                  properties: {
                                                                                    block: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      type: 'void',
                                                                                      'x-collection': 'collections',
                                                                                      'x-decorator':
                                                                                        'ResourceActionProvider',
                                                                                      'x-decorator-props': {
                                                                                        collection: 'attachments',
                                                                                        request: {
                                                                                          resource: 'attachments',
                                                                                          action: 'list',
                                                                                          params: {
                                                                                            pageSize: 20,
                                                                                            filter: {},
                                                                                            appends: [],
                                                                                          },
                                                                                        },
                                                                                      },
                                                                                      'x-designer':
                                                                                        'Table.Void.Designer',
                                                                                      'x-component': 'CardItem',
                                                                                      properties: {
                                                                                        table: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          'x-component':
                                                                                            'Table.RowSelection',
                                                                                          'x-component-props': {
                                                                                            rowKey: 'id',
                                                                                            objectValue: true,
                                                                                            rowSelection: {
                                                                                              type: 'checkbox',
                                                                                            },
                                                                                            useDataSource:
                                                                                              '{{ cm.useDataSourceFromRAC }}',
                                                                                          },
                                                                                          'x-initializer':
                                                                                            'table:configureColumns',
                                                                                          'x-uid': 'jffadc6g4j0',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': 'hc0z147qsai',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': 'rps2ch47kuc',
                                                                                  'x-async': false,
                                                                                  'x-index': 1,
                                                                                },
                                                                                item: {
                                                                                  _isJSONSchemaObject: true,
                                                                                  version: '2.0',
                                                                                  'x-component':
                                                                                    'RecordPicker.SelectedItem',
                                                                                  properties: {
                                                                                    drawer1: {
                                                                                      _isJSONSchemaObject: true,
                                                                                      version: '2.0',
                                                                                      'x-decorator':
                                                                                        'CollectionProvider_deprecated',
                                                                                      'x-decorator-props': {
                                                                                        name: 'attachments',
                                                                                      },
                                                                                      'x-component': 'Action.Drawer',
                                                                                      'x-component-props': {
                                                                                        className: 'nb-action-popup',
                                                                                      },
                                                                                      type: 'void',
                                                                                      title: 'Drawer Title',
                                                                                      properties: {
                                                                                        tabs: {
                                                                                          _isJSONSchemaObject: true,
                                                                                          version: '2.0',
                                                                                          type: 'void',
                                                                                          'x-component': 'Tabs',
                                                                                          'x-component-props': {},
                                                                                          'x-initializer':
                                                                                            'TabPaneInitializers',
                                                                                          properties: {
                                                                                            tab1: {
                                                                                              _isJSONSchemaObject: true,
                                                                                              version: '2.0',
                                                                                              type: 'void',
                                                                                              title: '详情',
                                                                                              'x-component':
                                                                                                'Tabs.TabPane',
                                                                                              'x-designer':
                                                                                                'Tabs.Designer',
                                                                                              'x-component-props': {},
                                                                                              properties: {
                                                                                                grid: {
                                                                                                  _isJSONSchemaObject:
                                                                                                    true,
                                                                                                  version: '2.0',
                                                                                                  type: 'void',
                                                                                                  'x-component': 'Grid',
                                                                                                  'x-initializer':
                                                                                                    'popup:common:addBlock',
                                                                                                  'x-uid':
                                                                                                    'luefvfv1esl',
                                                                                                  'x-async': false,
                                                                                                  'x-index': 1,
                                                                                                },
                                                                                              },
                                                                                              'x-uid': 't1a6joj9pt5',
                                                                                              'x-async': false,
                                                                                              'x-index': 1,
                                                                                            },
                                                                                          },
                                                                                          'x-uid': 'i0babnjmjvm',
                                                                                          'x-async': false,
                                                                                          'x-index': 1,
                                                                                        },
                                                                                      },
                                                                                      'x-uid': '36jeyu4tx2i',
                                                                                      'x-async': false,
                                                                                      'x-index': 1,
                                                                                    },
                                                                                  },
                                                                                  'x-uid': '790e599bypg',
                                                                                  'x-async': false,
                                                                                  'x-index': 2,
                                                                                },
                                                                              },
                                                                              'x-uid': 'p49ew2izjiv',
                                                                              'x-async': false,
                                                                              'x-index': 1,
                                                                            },
                                                                          },
                                                                          'x-uid': '1dwryi88jej',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': '0ynvih29obe',
                                                                      'x-async': false,
                                                                      'x-index': 4,
                                                                    },
                                                                  },
                                                                  'x-uid': '8e58ud3wzj9',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                                footer: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Action.Drawer.Footer',
                                                                  properties: {
                                                                    actions: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      'x-decorator': 'DndContext',
                                                                      'x-component': 'ActionBar',
                                                                      'x-component-props': { layout: 'one-column' },
                                                                      properties: {
                                                                        cancel: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          title: '{{ t("Cancel") }}',
                                                                          'x-action': 'cancel',
                                                                          'x-component': 'Action',
                                                                          'x-component-props': {
                                                                            useAction: '{{ cm.useCancelAction }}',
                                                                          },
                                                                          'x-uid': '4pch28zs3p1',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                        submit: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          title: '{{ t("Submit") }}',
                                                                          'x-action': 'submit',
                                                                          'x-component': 'Action',
                                                                          'x-component-props': {
                                                                            type: 'primary',
                                                                            useAction: '{{ ds.useUpdateAction }}',
                                                                          },
                                                                          'x-uid': 'hkwjup578is',
                                                                          'x-async': false,
                                                                          'x-index': 2,
                                                                        },
                                                                      },
                                                                      'x-uid': 'y8afpowldpd',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'q4ndr5s7n5i',
                                                                  'x-async': false,
                                                                  'x-index': 2,
                                                                },
                                                              },
                                                              'x-uid': 'vlx3y597gew',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'o87v3q2zkbx',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                      },
                                                      'x-uid': '9tokbjb03vm',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '7bw1i0kuvd3',
                                                  'x-async': false,
                                                  'x-index': 1,
                                                },
                                                eb529qf5qqv: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-decorator': 'Table.Column.Decorator',
                                                  'x-designer': 'Table.Column.Designer',
                                                  'x-component': 'Table.Column',
                                                  properties: {
                                                    f_m7ibo1vrvnm: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-read-pretty': true,
                                                      'x-collection-field': 't_ab12qiwruwk.f_m7ibo1vrvnm',
                                                      'x-component': 'CollectionField',
                                                      'x-component-props': {},
                                                      'x-uid': 'ddfjn6tojd5',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '4olszfw1cjy',
                                                  'x-async': false,
                                                  'x-index': 2,
                                                },
                                                hy1zgcs7f5y: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-decorator': 'Table.Column.Decorator',
                                                  'x-designer': 'Table.Column.Designer',
                                                  'x-component': 'Table.Column',
                                                  properties: {
                                                    f_kukaw9kddyj: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-read-pretty': true,
                                                      'x-collection-field': 't_ab12qiwruwk.f_kukaw9kddyj',
                                                      'x-component': 'CollectionField',
                                                      'x-component-props': {
                                                        mode: 'tags',
                                                        fieldNames: { label: 'id', value: 'id' },
                                                      },
                                                      properties: {
                                                        options: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-component': 'RecordPicker.Options',
                                                          type: 'void',
                                                          title: 'Drawer Title',
                                                          properties: {
                                                            block: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              type: 'void',
                                                              'x-collection': 'collections',
                                                              'x-decorator': 'ResourceActionProvider',
                                                              'x-decorator-props': {
                                                                collection: 'users',
                                                                request: {
                                                                  resource: 'users',
                                                                  action: 'list',
                                                                  params: { pageSize: 20, filter: {}, appends: [] },
                                                                },
                                                              },
                                                              'x-designer': 'Table.Void.Designer',
                                                              'x-component': 'CardItem',
                                                              properties: {
                                                                table: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  'x-component': 'Table.RowSelection',
                                                                  'x-component-props': {
                                                                    rowKey: 'id',
                                                                    objectValue: true,
                                                                    rowSelection: { type: 'checkbox' },
                                                                    useDataSource: '{{ cm.useDataSourceFromRAC }}',
                                                                  },
                                                                  'x-initializer': 'table:configureColumns',
                                                                  'x-uid': 'i9y89citemg',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'ewajce1mzza',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'v2cpez8utum',
                                                          'x-async': false,
                                                          'x-index': 1,
                                                        },
                                                        item: {
                                                          _isJSONSchemaObject: true,
                                                          version: '2.0',
                                                          'x-component': 'RecordPicker.SelectedItem',
                                                          properties: {
                                                            drawer1: {
                                                              _isJSONSchemaObject: true,
                                                              version: '2.0',
                                                              'x-decorator': 'CollectionProvider_deprecated',
                                                              'x-decorator-props': { name: 'users' },
                                                              'x-component': 'Action.Drawer',
                                                              'x-component-props': { className: 'nb-action-popup' },
                                                              type: 'void',
                                                              title: 'Drawer Title',
                                                              properties: {
                                                                tabs: {
                                                                  _isJSONSchemaObject: true,
                                                                  version: '2.0',
                                                                  type: 'void',
                                                                  'x-component': 'Tabs',
                                                                  'x-component-props': {},
                                                                  'x-initializer': 'TabPaneInitializers',
                                                                  properties: {
                                                                    tab1: {
                                                                      _isJSONSchemaObject: true,
                                                                      version: '2.0',
                                                                      type: 'void',
                                                                      title: '详情',
                                                                      'x-component': 'Tabs.TabPane',
                                                                      'x-designer': 'Tabs.Designer',
                                                                      'x-component-props': {},
                                                                      properties: {
                                                                        grid: {
                                                                          _isJSONSchemaObject: true,
                                                                          version: '2.0',
                                                                          type: 'void',
                                                                          'x-component': 'Grid',
                                                                          'x-initializer': 'popup:common:addBlock',
                                                                          'x-uid': 'dh01zz2bsk9',
                                                                          'x-async': false,
                                                                          'x-index': 1,
                                                                        },
                                                                      },
                                                                      'x-uid': 'jwwngt79ia0',
                                                                      'x-async': false,
                                                                      'x-index': 1,
                                                                    },
                                                                  },
                                                                  'x-uid': 'y1n4w2jsxsm',
                                                                  'x-async': false,
                                                                  'x-index': 1,
                                                                },
                                                              },
                                                              'x-uid': 'ty1kmg2jbut',
                                                              'x-async': false,
                                                              'x-index': 1,
                                                            },
                                                          },
                                                          'x-uid': 'cntirie06cm',
                                                          'x-async': false,
                                                          'x-index': 2,
                                                        },
                                                      },
                                                      'x-uid': 'cbs3y5963xi',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '2ivbzed73mq',
                                                  'x-async': false,
                                                  'x-index': 3,
                                                },
                                                xdgjroykfb8: {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-decorator': 'Table.Column.Decorator',
                                                  'x-designer': 'Table.Column.Designer',
                                                  'x-component': 'Table.Column',
                                                  properties: {
                                                    f_4mpiovytw4d: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-read-pretty': true,
                                                      'x-collection-field': 't_ab12qiwruwk.f_4mpiovytw4d',
                                                      'x-component': 'CollectionField',
                                                      'x-component-props': {},
                                                      'x-uid': 'xmzgisqk8yj',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': '0tuwdqvj47q',
                                                  'x-async': false,
                                                  'x-index': 4,
                                                },
                                                '458fa242xbi': {
                                                  _isJSONSchemaObject: true,
                                                  version: '2.0',
                                                  type: 'void',
                                                  'x-decorator': 'Table.Column.Decorator',
                                                  'x-designer': 'Table.Column.Designer',
                                                  'x-component': 'Table.Column',
                                                  properties: {
                                                    f_lxsum89wkzd: {
                                                      _isJSONSchemaObject: true,
                                                      version: '2.0',
                                                      'x-read-pretty': true,
                                                      'x-collection-field': 't_ab12qiwruwk.f_lxsum89wkzd',
                                                      'x-component': 'CollectionField',
                                                      'x-component-props': { size: 'small' },
                                                      'x-uid': 'aria7vnp9up',
                                                      'x-async': false,
                                                      'x-index': 1,
                                                    },
                                                  },
                                                  'x-uid': 's0vcq6ue1po',
                                                  'x-async': false,
                                                  'x-index': 5,
                                                },
                                              },
                                              'x-uid': '7hhuwpzpjjj',
                                              'x-async': false,
                                              'x-index': 2,
                                            },
                                          },
                                          'x-uid': 'tfrbg7lig5p',
                                          'x-async': false,
                                          'x-index': 1,
                                        },
                                      },
                                      'x-uid': 'm4gv20hti0j',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': 'gxh79mv75zh',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': '2tpyjn83jgf',
                              'x-async': false,
                              'x-index': 10,
                            },
                            jqgt0895rco: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'Grid.Row',
                              properties: {
                                '45jxkag9d2n': {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid.Col',
                                  properties: {
                                    f_o8dmiub9tp9: {
                                      _isJSONSchemaObject: true,
                                      version: '2.0',
                                      title: '{{t("Multiple select")}}',
                                      'x-designer': 'FormItem.Designer',
                                      'x-component': 'CollectionField',
                                      'x-decorator': 'FormItem',
                                      'x-collection-field': 't_j6omof6tza8.f_o8dmiub9tp9',
                                      'x-uid': 'p9bs5a630e0',
                                      'x-async': false,
                                      'x-index': 1,
                                    },
                                  },
                                  'x-uid': '6hhy52qwlas',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'nsedffngny7',
                              'x-async': false,
                              'x-index': 11,
                            },
                          },
                          'x-uid': 'rn41gmcv5ux',
                          'x-async': false,
                          'x-index': 1,
                        },
                        footer: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Action.Container.Footer',
                          properties: {
                            actions: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              'x-component': 'ActionBar',
                              'x-component-props': { layout: 'one-column' },
                              properties: {
                                cancel: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  title: '{{ t("Cancel") }}',
                                  'x-action': 'cancel',
                                  'x-component': 'Action',
                                  'x-component-props': { useAction: '{{ cm.useCancelAction }}' },
                                  'x-uid': 'fogfh0n8tm5',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                                submit: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  title: '{{ t("Submit") }}',
                                  'x-action': 'submit',
                                  'x-component': 'Action',
                                  'x-component-props': { type: 'primary', useAction: '{{ cm.useUpdateAction }}' },
                                  'x-uid': '8738jfy3v7y',
                                  'x-async': false,
                                  'x-index': 2,
                                },
                              },
                              'x-uid': 'q1kfsoocbcj',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': '3yo3qyj5517',
                          'x-async': false,
                          'x-index': 2,
                        },
                      },
                      'x-uid': 'n9alqbirm1t',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'x850sl38dtc',
                  'x-async': false,
                  'x-index': 2,
                },
              },
              'x-uid': '324q5tz5eh6',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'jw2cojzspnp',
          'x-async': false,
          'x-index': 1,
        },
        wr5tw5nt56s: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_g8j5jvalqh0: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_g8j5jvalqh0',
              'x-component': 'CollectionField',
              'x-component-props': { ellipsis: true },
              'x-uid': 'xgz9z5yq68f',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'cmp40f7xmwr',
          'x-async': false,
          'x-index': 4,
        },
        wlt8aafizat: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_tegyd222bcc: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_tegyd222bcc',
              'x-component': 'CollectionField',
              'x-component-props': { ellipsis: true },
              'x-uid': '7o7jgoge0k9',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'uoytgwljbro',
          'x-async': false,
          'x-index': 5,
        },
        '25gk74kf0y5': {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_ooar0pto2ko: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_ooar0pto2ko',
              'x-component': 'CollectionField',
              'x-component-props': { size: 'small' },
              'x-uid': 'mtc0s1641bj',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'dzt6kbm8gho',
          'x-async': false,
          'x-index': 7,
        },
        g1qop86bu4b: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_ksgzy9vmgce: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_ksgzy9vmgce',
              'x-component': 'CollectionField',
              'x-component-props': { fieldNames: { label: 'f_zio9ewkxss7', value: 'id' } },
              properties: {
                options: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  'x-component': 'RecordPicker.Options',
                  type: 'void',
                  title: 'Drawer Title',
                  properties: {
                    block: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-collection': 'collections',
                      'x-decorator': 'ResourceActionProvider',
                      'x-decorator-props': {
                        collection: 't_94rsj6kbzvn',
                        request: {
                          resource: 't_94rsj6kbzvn',
                          action: 'list',
                          params: { pageSize: 20, filter: {}, appends: [] },
                        },
                      },
                      'x-designer': 'Table.Void.Designer',
                      'x-component': 'CardItem',
                      properties: {
                        table: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          'x-component': 'Table.RowSelection',
                          'x-component-props': {
                            rowKey: 'id',
                            objectValue: true,
                            rowSelection: { type: 'checkbox' },
                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                          },
                          'x-initializer': 'table:configureColumns',
                          'x-uid': 'v3abytn9e51',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': '4698x56mnqs',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'e4mgbfpuxwg',
                  'x-async': false,
                  'x-index': 3,
                },
                item: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  'x-component': 'RecordPicker.SelectedItem',
                  properties: {
                    drawer1: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      'x-decorator': 'CollectionProvider_deprecated',
                      'x-decorator-props': { name: 't_94rsj6kbzvn' },
                      'x-component': 'Action.Drawer',
                      'x-component-props': { className: 'nb-action-popup' },
                      type: 'void',
                      title: 'Drawer Title',
                      properties: {
                        tabs: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Tabs',
                          'x-component-props': {},
                          'x-initializer': 'TabPaneInitializers',
                          properties: {
                            tab1: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              title: '详情',
                              'x-component': 'Tabs.TabPane',
                              'x-designer': 'Tabs.Designer',
                              'x-component-props': {},
                              properties: {
                                grid: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid',
                                  'x-initializer': 'popup:common:addBlock',
                                  'x-uid': 'l5758k9k08c',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'sidxuvg0gji',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'xm2rfk766iw',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': '9xzudyy0uxb',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'i9wfwfl4340',
                  'x-async': false,
                  'x-index': 4,
                },
              },
              'x-uid': '79wu8p4zm3w',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': '5d3z9smxrim',
          'x-async': false,
          'x-index': 8,
        },
        t7pobtqthjj: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_z27302tl2bf: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_z27302tl2bf',
              'x-component': 'CollectionField',
              'x-component-props': {},
              'x-uid': 'iwm04ayb5gj',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': '25vsp20fxvu',
          'x-async': false,
          'x-index': 9,
        },
        m8soy98oqim: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_yc8jbfiqfvh: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_yc8jbfiqfvh',
              'x-component': 'CollectionField',
              'x-component-props': {},
              'x-uid': 'cypnhowgi2f',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'pd7k2pkb57k',
          'x-async': false,
          'x-index': 12,
        },
        k4d2sqomlrq: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_u007sq2jg93: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_u007sq2jg93',
              'x-component': 'CollectionField',
              'x-component-props': { fieldNames: { label: 'nickname', value: 'id' } },
              properties: {
                options: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  'x-component': 'RecordPicker.Options',
                  type: 'void',
                  title: 'Drawer Title',
                  properties: {
                    block: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      type: 'void',
                      'x-collection': 'collections',
                      'x-decorator': 'ResourceActionProvider',
                      'x-decorator-props': {
                        collection: 'users',
                        request: {
                          resource: 'users',
                          action: 'list',
                          params: { pageSize: 20, filter: {}, appends: [] },
                        },
                      },
                      'x-designer': 'Table.Void.Designer',
                      'x-component': 'CardItem',
                      properties: {
                        table: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          'x-component': 'Table.RowSelection',
                          'x-component-props': {
                            rowKey: 'id',
                            objectValue: true,
                            rowSelection: { type: 'checkbox' },
                            useDataSource: '{{ cm.useDataSourceFromRAC }}',
                          },
                          'x-initializer': 'table:configureColumns',
                          'x-uid': 'p1tbjz52j84',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': '46oya59gsnl',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'pynoyu1xqar',
                  'x-async': false,
                  'x-index': 3,
                },
                item: {
                  _isJSONSchemaObject: true,
                  version: '2.0',
                  'x-component': 'RecordPicker.SelectedItem',
                  properties: {
                    drawer1: {
                      _isJSONSchemaObject: true,
                      version: '2.0',
                      'x-decorator': 'CollectionProvider_deprecated',
                      'x-decorator-props': { name: 'users' },
                      'x-component': 'Action.Drawer',
                      'x-component-props': { className: 'nb-action-popup' },
                      type: 'void',
                      title: 'Drawer Title',
                      properties: {
                        tabs: {
                          _isJSONSchemaObject: true,
                          version: '2.0',
                          type: 'void',
                          'x-component': 'Tabs',
                          'x-component-props': {},
                          'x-initializer': 'TabPaneInitializers',
                          properties: {
                            tab1: {
                              _isJSONSchemaObject: true,
                              version: '2.0',
                              type: 'void',
                              title: '详情',
                              'x-component': 'Tabs.TabPane',
                              'x-designer': 'Tabs.Designer',
                              'x-component-props': {},
                              properties: {
                                grid: {
                                  _isJSONSchemaObject: true,
                                  version: '2.0',
                                  type: 'void',
                                  'x-component': 'Grid',
                                  'x-initializer': 'popup:common:addBlock',
                                  'x-uid': 'skaxuehn8rd',
                                  'x-async': false,
                                  'x-index': 1,
                                },
                              },
                              'x-uid': 'ndcngwbv5kb',
                              'x-async': false,
                              'x-index': 1,
                            },
                          },
                          'x-uid': 'vvb9fb2odx8',
                          'x-async': false,
                          'x-index': 1,
                        },
                      },
                      'x-uid': '4imooyo9j50',
                      'x-async': false,
                      'x-index': 1,
                    },
                  },
                  'x-uid': 'q1dpbp2bnp1',
                  'x-async': false,
                  'x-index': 4,
                },
              },
              'x-uid': 'adx4ifxxkcl',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': '2wwe5ja4a4g',
          'x-async': false,
          'x-index': 13,
        },
        tsh1e5o6jjk: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_hpmvdltzs6m: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_hpmvdltzs6m',
              'x-component': 'CollectionField',
              'x-component-props': {},
              'x-uid': '0pcttcqp5x0',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'lm9lbaj0ls3',
          'x-async': false,
          'x-index': 14,
        },
        yskrn3xc0xn: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_cht6rsiiiko: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_cht6rsiiiko',
              'x-component': 'CollectionField',
              'x-component-props': {},
              'x-uid': '3tguqkhsnse',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 'gm0ohib1gf8',
          'x-async': false,
          'x-index': 15,
        },
        x5dlcnm8r33: {
          _isJSONSchemaObject: true,
          version: '2.0',
          type: 'void',
          'x-decorator': 'Table.Column.Decorator',
          'x-designer': 'Table.Column.Designer',
          'x-component': 'Table.Column',
          properties: {
            f_o8dmiub9tp9: {
              _isJSONSchemaObject: true,
              version: '2.0',
              'x-read-pretty': true,
              'x-collection-field': 't_j6omof6tza8.f_o8dmiub9tp9',
              'x-component': 'CollectionField',
              'x-component-props': {},
              'x-uid': 'bsr9zky8dsg',
              'x-async': false,
              'x-index': 1,
            },
          },
          'x-uid': 't94192ebk04',
          'x-async': false,
          'x-index': 16,
        },
      },
      'x-uid': 'ff9drvwlysk',
      'x-async': false,
      'x-index': 2,
    },
  },
  name: 'lqu8rih6i93',
  'x-uid': '71p225blxax',
  'x-async': false,
};
