/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import * as React from 'react';

function Pick(props) {
  return /*#__PURE__*/ React.createElement(
    'svg',
    Object.assign(
      {
        width: '1em',
        height: '1em',
        viewBox: '0 0 14 14',
        xmlns: 'http://www.w3.org/2000/svg',
        xmlnsXlink: 'http://www.w3.org/1999/xlink',
      },
      props,
      {
        style: Object.assign(
          {
            verticalAlign: '-0.125em',
          },
          props.style,
        ),
        className: ['nanqu-token-panel-icon', props.className].filter(Boolean).join(' '),
      },
    ),
    /*#__PURE__*/ React.createElement(
      'g',
      {
        id: 'Pick-\u9875\u9762-1',
        stroke: 'none',
        strokeWidth: 1,
        fill: 'none',
        fillRule: 'evenodd',
        fillOpacity: 0.65,
      },
      /*#__PURE__*/ React.createElement(
        'g',
        {
          id: 'Pick-\u4E3B\u9898\u7F16\u8F91\u5668---\u591A\u4E3B\u9898',
          transform: 'translate(-541.000000, -387.000000)',
          fill: 'currentColor',
          fillRule: 'nonzero',
        },
        /*#__PURE__*/ React.createElement(
          'g',
          {
            id: 'Pick-\u7F16\u7EC4-11',
            transform: 'translate(76.000000, 340.000000)',
          },
          /*#__PURE__*/ React.createElement(
            'g',
            {
              id: 'Pick-Map-Token-\u9762\u677F',
              transform: 'translate(0.000000, 27.000000)',
            },
            /*#__PURE__*/ React.createElement(
              'g',
              {
                id: 'Pick-token-\u663E\u793A',
                transform: 'translate(-1.002041, -1.000000)',
              },
              /*#__PURE__*/ React.createElement(
                'g',
                {
                  id: 'Pick-\u7F16\u7EC4-2',
                  transform: 'translate(12.024490, 20.000000)',
                },
                /*#__PURE__*/ React.createElement(
                  'g',
                  {
                    id: 'Pick-shangyeguanxi',
                    transform: 'translate(453.924490, 1.000000)',
                  },
                  /*#__PURE__*/ React.createElement('path', {
                    d:
                      'M12.6274816,8.17204883 C12.6358384,8.04673242 12.6401539,7.92030859 12.6401539,7.79288672 C12.6401539,5.50309375 11.2701899,3.53286719 9.30406641,2.65472266 C9.31862927,2.54983203 9.32632854,2.44274023 9.32632854,2.33384375 C9.32632854,1.05430664 8.28750187,0.0169394531 7.00623025,0.0169394531 C5.72484902,0.0169394531 4.68607715,1.05430664 4.68607715,2.33384375 C4.68607715,2.44267188 4.69376272,2.54968164 4.70829819,2.65451758 C2.74188703,3.53256641 1.37158055,5.50290234 1.37158055,7.79288672 C1.37158055,7.92044531 1.37592338,8.04699219 1.38428025,8.17243164 C0.593775725,8.54169531 0.0460860491,9.34289453 0.0460860491,10.2719531 C0.0460860491,11.5515449 1.08474833,12.5888574 2.36612955,12.5888574 C2.80723496,12.5888574 3.21958454,12.4658926 3.57069612,12.2524336 C4.52158393,12.9838105 5.71288912,13.4188223 7.00595625,13.4188223 C8.30016046,13.4188223 9.49238354,12.9830449 10.4436412,12.2505195 C10.7943281,12.4630762 11.2059516,12.5854668 11.6462213,12.5854668 C12.9274382,12.5854668 13.9661004,11.5489746 13.9661004,10.2703672 C13.9661004,9.34171875 13.4181916,8.54095703 12.6274816,8.17204883 Z M7.00623025,1.00913477 C7.73549676,1.00913477 8.32698463,1.59684766 8.33166995,2.32357617 C8.33168365,2.32647461 8.33177955,2.32935938 8.33177955,2.33225781 C8.33177955,2.69178711 8.18805519,3.01775195 7.95488499,3.25620313 C7.71417991,3.50236523 7.37813809,3.65527148 7.00623025,3.65527148 C6.6343361,3.65527148 6.29829428,3.50236523 6.0575618,3.25620313 C5.8243779,3.01775195 5.68062614,2.69178711 5.68062614,2.33225781 C5.68062614,2.32931836 5.68072204,2.32639258 5.68073574,2.32345313 C5.68547586,1.59679297 6.27704593,1.00913477 7.00623025,1.00913477 Z M2.36612955,11.5993965 C1.63399978,11.5993965 1.04047065,11.0058047 1.04047065,10.2734297 C1.04047065,9.84645703 1.24229576,9.46667969 1.55566445,9.22416797 C1.7797654,9.05074023 2.06088482,8.94746289 2.36614325,8.94746289 C2.41639403,8.94746289 2.46597352,8.95036133 2.51477213,8.95580273 C3.17696454,9.02969922 3.69181585,9.59136719 3.69181585,10.273416 C3.69181585,10.4903613 3.6397293,10.6951113 3.5473928,10.8758809 C3.39166744,11.1807637 3.12143934,11.4173555 2.79339819,11.5289863 C2.65931847,11.574623 2.51562151,11.5993965 2.36612955,11.5993965 Z M7.00127093,12.4178633 C5.99141928,12.4178633 5.0570808,12.0957402 4.29537321,11.549084 C4.53905114,11.1824316 4.68111783,10.7425937 4.68111783,10.2695605 C4.68111783,8.99117188 3.64429132,7.95466602 2.36460887,7.95280664 C2.3626772,7.89787305 2.36134833,7.84278906 2.36134833,7.78737695 C2.36134833,5.92565039 3.46242679,4.32079102 5.05001172,3.58529883 C5.46299149,4.22481445 6.18258597,4.64830078 7.00128463,4.64830078 C7.81990109,4.64830078 8.53950926,4.22481445 8.95248903,3.58529883 C10.5400329,4.32079102 11.6411113,5.92565039 11.6411113,7.78737695 C11.6411113,7.84277539 11.6397824,7.89787305 11.6378508,7.95280664 C10.3582094,7.95465234 9.32139662,8.99040625 9.32139662,10.2679746 C9.32139662,10.7413906 9.4639017,11.1815293 9.70827832,11.5482363 C8.94635153,12.0953848 8.01158836,12.4178633 7.00127093,12.4178633 Z M11.6459473,8.94746289 C11.9510962,8.94746289 12.2321197,9.0506582 12.4561658,9.22397656 C12.7696578,9.46647461 12.9715652,9.84632031 12.9715652,10.273375 C12.9715652,11.0056953 12.3780634,11.5993418 11.6459473,11.5993418 C11.4964143,11.5993418 11.3526762,11.574541 11.2185828,11.528877 C10.8907472,11.4172324 10.6206287,11.1807227 10.464917,10.8759902 C10.3725257,10.6951797 10.320398,10.490375 10.320398,10.273375 C10.320398,9.59128516 10.8354138,9.0295625 11.4976062,8.95577539 C11.5463226,8.95034766 11.5957925,8.94746289 11.6459473,8.94746289 Z M7.00557266,6.21029883 C7.91351399,6.21029883 8.64954587,6.94483166 8.64954587,7.85092383 C8.64954587,8.757016 7.91351399,9.49154883 7.00557266,9.49154883 C6.09763132,9.49154883 5.36159944,8.757016 5.36159944,7.85092383 C5.36159944,6.94483166 6.09763132,6.21029883 7.00557266,6.21029883 Z',
                    id: 'Pick-\u5F62\u72B6',
                  }),
                ),
              ),
            ),
          ),
        ),
      ),
    ),
  );
}

export default Pick;
