/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import * as React from 'react';

function Control(props) {
  return /*#__PURE__*/ React.createElement(
    'svg',
    Object.assign(
      {
        width: '1em',
        height: '1em',
        viewBox: '0 0 16 16',
        xmlns: 'http://www.w3.org/2000/svg',
        xmlnsXlink: 'http://www.w3.org/1999/xlink',
      },
      props,
      {
        style: Object.assign(
          {
            verticalAlign: '-0.125em',
          },
          props.style,
        ),
        className: ['nanqu-token-panel-icon', props.className].filter(Boolean).join(' '),
      },
    ),
    /*#__PURE__*/ React.createElement(
      'g',
      {
        id: 'Control-\u9875\u9762-1',
        stroke: 'none',
        strokeWidth: 1,
        fill: 'none',
        fillRule: 'evenodd',
      },
      /*#__PURE__*/ React.createElement(
        'g',
        {
          id: 'Control-\u4E3B\u9898\u9884\u89C8\u5668---\u7EC4\u4EF6\u9884\u89C8',
          transform: 'translate(-1372.000000, -505.000000)',
          fillRule: 'nonzero',
        },
        /*#__PURE__*/ React.createElement(
          'g',
          {
            id: 'Control-\u7F16\u7EC4-18',
            transform: 'translate(0.000000, 70.000000)',
          },
          /*#__PURE__*/ React.createElement(
            'g',
            {
              id: 'Control-\u7F16\u7EC4-14',
              transform: 'translate(536.000000, 420.000000)',
            },
            /*#__PURE__*/ React.createElement(
              'g',
              {
                id: 'Control-\u7CFB\u7EDF\u63A7\u5236',
                transform: 'translate(836.000000, 15.000000)',
              },
              /*#__PURE__*/ React.createElement('rect', {
                id: 'Control-\u77E9\u5F62',
                fill: '#000000',
                opacity: 0,
                x: 0,
                y: 0,
                width: 16,
                height: 16,
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M6,3.5625 L13.75,3.5625 L13.75,4.1875 L6,4.1875 L6,3.5625 Z M2.1875,3.5625 L3.8125,3.5625 L3.8125,4.1875 L2.1875,4.1875 L2.1875,3.5625 Z M8.3125,11.8125 L13.75,11.8125 L13.75,12.4375 L8.3125,12.4375 L8.3125,11.8125 Z M2.1875,11.8125 L6.125,11.8125 L6.125,12.4375 L2.1875,12.4375 L2.1875,11.8125 Z M12.625,7.6875 L13.75,7.6875 L13.75,8.3125 L12.625,8.3125 L12.625,7.6875 Z M2.1875,7.6875 L10.4375,7.6875 L10.4375,8.3125 L2.1875,8.3125 L2.1875,7.6875 Z',
                id: 'Control-\u5F62\u72B6',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M1.875,3.875 C1.875,4.04758898 2.01491102,4.1875 2.1875,4.1875 C2.36008898,4.1875 2.5,4.04758898 2.5,3.875 C2.5,3.70241102 2.36008898,3.5625 2.1875,3.5625 C2.01491102,3.5625 1.875,3.70241102 1.875,3.875 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M13.4375,3.875 C13.4375,4.04758898 13.577411,4.1875 13.75,4.1875 C13.922589,4.1875 14.0625,4.04758898 14.0625,3.875 C14.0625,3.70241102 13.922589,3.5625 13.75,3.5625 C13.577411,3.5625 13.4375,3.70241102 13.4375,3.875 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M13.4375,8 C13.4375,8.17258898 13.577411,8.3125 13.75,8.3125 C13.922589,8.3125 14.0625,8.17258898 14.0625,8 C14.0625,7.82741102 13.922589,7.6875 13.75,7.6875 C13.577411,7.6875 13.4375,7.82741102 13.4375,8 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M13.4375,12.125 C13.4375,12.297589 13.577411,12.4375 13.75,12.4375 C13.922589,12.4375 14.0625,12.297589 14.0625,12.125 C14.0625,11.952411 13.922589,11.8125 13.75,11.8125 C13.577411,11.8125 13.4375,11.952411 13.4375,12.125 L13.4375,12.125 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M1.875,8 C1.875,8.17258898 2.01491102,8.3125 2.1875,8.3125 C2.36008898,8.3125 2.5,8.17258898 2.5,8 C2.5,7.82741102 2.36008898,7.6875 2.1875,7.6875 C2.01491102,7.6875 1.875,7.82741102 1.875,8 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M1.875,12.125 C1.875,12.297589 2.01491102,12.4375 2.1875,12.4375 C2.36008898,12.4375 2.5,12.297589 2.5,12.125 C2.5,11.952411 2.36008898,11.8125 2.1875,11.8125 C2.01491102,11.8125 1.875,11.952411 1.875,12.125 L1.875,12.125 Z',
                id: 'Control-\u8DEF\u5F84',
                fill: 'currentColor',
              }),
              /*#__PURE__*/ React.createElement('path', {
                d:
                  'M4.90625,5.25 C4.13125,5.25 3.5,4.61875 3.5,3.84375 C3.5,3.06875 4.13125,2.4375 4.90625,2.4375 C5.68125,2.4375 6.3125,3.06875 6.3125,3.84375 C6.3125,4.61875 5.68125,5.25 4.90625,5.25 Z M4.90625,3.0625 C4.475,3.0625 4.125,3.4125 4.125,3.84375 C4.125,4.275 4.475,4.625 4.90625,4.625 C5.3375,4.625 5.6875,4.275 5.6875,3.84375 C5.6875,3.4125 5.3375,3.0625 4.90625,3.0625 Z M11.53125,9.4375 C10.75625,9.4375 10.125,8.80625 10.125,8.03125 C10.125,7.25625 10.75625,6.625 11.53125,6.625 C12.30625,6.625 12.9375,7.25625 12.9375,8.03125 C12.9375,8.80625 12.30625,9.4375 11.53125,9.4375 Z M11.53125,7.25 C11.1,7.25 10.75,7.6 10.75,8.03125 C10.75,8.4625 11.1,8.8125 11.53125,8.8125 C11.9625,8.8125 12.3125,8.4625 12.3125,8.03125 C12.3125,7.6 11.9625,7.25 11.53125,7.25 Z M7.21875,13.5 C6.44375,13.5 5.8125,12.86875 5.8125,12.09375 C5.8125,11.31875 6.44375,10.6875 7.21875,10.6875 C7.99375,10.6875 8.625,11.31875 8.625,12.09375 C8.625,12.86875 7.99375,13.5 7.21875,13.5 Z M7.21875,11.3125 C6.7875,11.3125 6.4375,11.6625 6.4375,12.09375 C6.4375,12.525 6.7875,12.875 7.21875,12.875 C7.65,12.875 8,12.525 8,12.09375 C8,11.6625 7.65,11.3125 7.21875,11.3125 Z',
                id: 'Control-\u5F62\u72B6',
                fill: 'currentColor',
              }),
            ),
          ),
        ),
      ),
    ),
  );
}

export default Control;
