/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

import Alert from './alert';
import Anchor from './anchor';
import AutoComplete from './autoComplete';
import Avatar from './avatar';
import Badge from './badge';
import Breadcrumb from './breadcrumb';
import Button from './button';
import Calendar from './calendar';
import Card from './card';
import Carousel from './carousel';
import Cascader from './cascader';
import Checkbox from './checkbox';
import Collapse from './collapse';
import DatePicker from './datePicker';
import Descriptions from './descriptions';
import Divider from './divider';
import Drawer from './drawer';
import Dropdown from './dropdown';
import Empty from './empty';
import Form from './form';
import Grid from './grid';
import Icon from './icon';
import Image from './image';
import Input from './input';
import InputNumber from './inputNumber';
import List from './list';
import Mentions from './mentions';
import Menu from './menu';
import Message from './message';
import Modal from './modal';
import Notification from './notification';
import Pagination from './pagination';
import Popconfirm from './popconfirm';
import Popover from './popover';
import Progress from './progress';
import Radio from './radio';
import Rate from './rate';
import Result from './result';
import Segmented from './segmented';
import Select from './select';
import Skeleton from './skeleton';
import Slider from './slider';
import Space from './space';
import Spin from './spin';
import Statistic from './statistic';
import Steps from './steps';
import Switch from './switch';
import Table from './table';
import Tabs from './tabs';
import Tag from './tag';
import TimePicker from './timePicker';
import Timeline from './timeline';
import Tooltip from './tooltip';
import Transfer from './transfer';
import Tree from './tree';
import TreeSelect from './treeSelect';
import Typography from './typography';
import Upload from './upload';

import type { ComponentDemo } from '../interface';

export type PreviewerDemos = Record<string, ComponentDemo[]>;

const ComponentDemos: PreviewerDemos = {
  Alert,
  Anchor,
  AutoComplete,
  Avatar,
  Badge,
  Breadcrumb,
  Button,
  Calendar,
  Card,
  Carousel,
  Cascader,
  Checkbox,
  Collapse,
  DatePicker,
  Descriptions,
  Dropdown,
  Empty,
  Form,
  Grid,
  Icon,
  Image,
  InputNumber,
  Input,
  List,
  Mentions,
  Modal,
  Notification,
  Pagination,
  Popconfirm,
  Popover,
  Radio,
  Rate,
  Select,
  Skeleton,
  Slider,
  Spin,
  Statistic,
  Switch,
  Table,
  Tabs,
  Tag,
  TimePicker,
  Timeline,
  Tooltip,
  Transfer,
  TreeSelect,
  Tree,
  Typography,
  Upload,
  Divider,
  Space,
  Menu,
  Steps,
  Segmented,
  Drawer,
  Message,
  Result,
  Progress,
};

export default ComponentDemos;
