/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

export const oneTableWithMap = {
  collections: [
    {
      name: 'map',
      fields: [
        {
          name: 'point',
          interface: 'point',
        },
      ],
    },
  ],
  pageSchema: {
    _isJSONSchemaObject: true,
    version: '2.0',
    type: 'void',
    'x-component': 'Page',
    'x-app-version': '0.21.0-alpha.15',
    properties: {
      kkw0yhoj2v7: {
        _isJSONSchemaObject: true,
        version: '2.0',
        type: 'void',
        'x-component': 'Grid',
        'x-initializer': 'page:addBlock',
        'x-app-version': '0.21.0-alpha.15',
        properties: {
          '9i8fyfb05dd': {
            _isJSONSchemaObject: true,
            version: '2.0',
            type: 'void',
            'x-component': 'Grid.Row',
            'x-app-version': '0.21.0-alpha.15',
            properties: {
              '608qygaww2u': {
                _isJSONSchemaObject: true,
                version: '2.0',
                type: 'void',
                'x-component': 'Grid.Col',
                'x-app-version': '0.21.0-alpha.15',
                properties: {
                  nokibo5w37z: {
                    _isJSONSchemaObject: true,
                    version: '2.0',
                    type: 'void',
                    'x-decorator': 'TableBlockProvider',
                    'x-acl-action': 'map:list',
                    'x-use-decorator-props': 'useTableBlockDecoratorProps',
                    'x-decorator-props': {
                      collection: 'map',
                      dataSource: 'main',
                      action: 'list',
                      params: {
                        pageSize: 20,
                      },
                      rowKey: 'id',
                      showIndex: true,
                      dragSort: false,
                    },
                    'x-toolbar': 'BlockSchemaToolbar',
                    'x-settings': 'blockSettings:table',
                    'x-component': 'CardItem',
                    'x-filter-targets': [],
                    'x-app-version': '0.21.0-alpha.15',
                    properties: {
                      actions: {
                        _isJSONSchemaObject: true,
                        version: '2.0',
                        type: 'void',
                        'x-initializer': 'table:configureActions',
                        'x-component': 'ActionBar',
                        'x-component-props': {
                          style: {
                            marginBottom: 'var(--nb-spacing)',
                          },
                        },
                        'x-app-version': '0.21.0-alpha.15',
                        properties: {
                          uip6al0wpnq: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            'x-action': 'create',
                            'x-acl-action': 'create',
                            title: "{{t('Add new')}}",
                            'x-toolbar': 'ActionSchemaToolbar',
                            'x-settings': 'actionSettings:addNew',
                            'x-component': 'Action',
                            'x-decorator': 'ACLActionProvider',
                            'x-component-props': {
                              openMode: 'drawer',
                              type: 'primary',
                              component: 'CreateRecordAction',
                              icon: 'PlusOutlined',
                            },
                            'x-align': 'right',
                            'x-acl-action-props': {
                              skipScopeCheck: true,
                            },
                            'x-app-version': '0.21.0-alpha.15',
                            properties: {
                              drawer: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                title: '{{ t("Add record") }}',
                                'x-component': 'Action.Container',
                                'x-component-props': {
                                  className: 'nb-action-popup',
                                },
                                'x-app-version': '0.21.0-alpha.15',
                                properties: {
                                  tabs: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Tabs',
                                    'x-component-props': {},
                                    'x-initializer': 'popup:addTab',
                                    'x-initializer-props': {
                                      gridInitializer: 'popup:addNew:addBlock',
                                    },
                                    'x-app-version': '0.21.0-alpha.15',
                                    properties: {
                                      tab1: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'void',
                                        title: '{{t("Add new")}}',
                                        'x-component': 'Tabs.TabPane',
                                        'x-designer': 'Tabs.Designer',
                                        'x-component-props': {},
                                        'x-app-version': '0.21.0-alpha.15',
                                        properties: {
                                          grid: {
                                            _isJSONSchemaObject: true,
                                            version: '2.0',
                                            type: 'void',
                                            'x-component': 'Grid',
                                            'x-initializer': 'popup:addNew:addBlock',
                                            'x-app-version': '0.21.0-alpha.15',
                                            properties: {
                                              kb4pfm2qld1: {
                                                _isJSONSchemaObject: true,
                                                version: '2.0',
                                                type: 'void',
                                                'x-component': 'Grid.Row',
                                                'x-app-version': '0.21.0-alpha.15',
                                                properties: {
                                                  hoexd0g3zng: {
                                                    _isJSONSchemaObject: true,
                                                    version: '2.0',
                                                    type: 'void',
                                                    'x-component': 'Grid.Col',
                                                    'x-app-version': '0.21.0-alpha.15',
                                                    properties: {
                                                      '3dmeorgypjr': {
                                                        _isJSONSchemaObject: true,
                                                        version: '2.0',
                                                        type: 'void',
                                                        'x-acl-action-props': {
                                                          skipScopeCheck: true,
                                                        },
                                                        'x-acl-action': 'map:create',
                                                        'x-decorator': 'FormBlockProvider',
                                                        'x-use-decorator-props': 'useCreateFormBlockDecoratorProps',
                                                        'x-decorator-props': {
                                                          dataSource: 'main',
                                                          collection: 'map',
                                                        },
                                                        'x-toolbar': 'BlockSchemaToolbar',
                                                        'x-settings': 'blockSettings:createForm',
                                                        'x-component': 'CardItem',
                                                        'x-app-version': '0.21.0-alpha.15',
                                                        properties: {
                                                          '8ijqvnv7ipr': {
                                                            _isJSONSchemaObject: true,
                                                            version: '2.0',
                                                            type: 'void',
                                                            'x-component': 'FormV2',
                                                            'x-use-component-props': 'useCreateFormBlockProps',
                                                            'x-app-version': '0.21.0-alpha.15',
                                                            properties: {
                                                              grid: {
                                                                _isJSONSchemaObject: true,
                                                                version: '2.0',
                                                                type: 'void',
                                                                'x-component': 'Grid',
                                                                'x-initializer': 'form:configureFields',
                                                                'x-app-version': '0.21.0-alpha.15',
                                                                'x-uid': 'nhb5ckrojg8',
                                                                'x-async': false,
                                                                'x-index': 1,
                                                              },
                                                              cn3spxefyf0: {
                                                                _isJSONSchemaObject: true,
                                                                version: '2.0',
                                                                type: 'void',
                                                                'x-initializer': 'createForm:configureActions',
                                                                'x-component': 'ActionBar',
                                                                'x-component-props': {
                                                                  layout: 'one-column',
                                                                  style: {
                                                                    marginTop: 24,
                                                                  },
                                                                },
                                                                'x-app-version': '0.21.0-alpha.15',
                                                                'x-uid': 'rowvzprfdip',
                                                                'x-async': false,
                                                                'x-index': 2,
                                                              },
                                                            },
                                                            'x-uid': 't3zwje8con4',
                                                            'x-async': false,
                                                            'x-index': 1,
                                                          },
                                                        },
                                                        'x-uid': 'hzqxhqtd8md',
                                                        'x-async': false,
                                                        'x-index': 1,
                                                      },
                                                    },
                                                    'x-uid': 'q6urn5p0yw4',
                                                    'x-async': false,
                                                    'x-index': 1,
                                                  },
                                                },
                                                'x-uid': '5209bo4teha',
                                                'x-async': false,
                                                'x-index': 1,
                                              },
                                            },
                                            'x-uid': '50pylphuf3x',
                                            'x-async': false,
                                            'x-index': 1,
                                          },
                                        },
                                        'x-uid': '45exb2qrbi9',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'ut9rhesppap',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'aiwsk6sq0wx',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': 'f04owvm9t0f',
                            'x-async': false,
                            'x-index': 1,
                          },
                        },
                        'x-uid': 'nmpjxsgfxgc',
                        'x-async': false,
                        'x-index': 1,
                      },
                      fll1bh8w93y: {
                        _isJSONSchemaObject: true,
                        version: '2.0',
                        type: 'array',
                        'x-initializer': 'table:configureColumns',
                        'x-component': 'TableV2',
                        'x-use-component-props': 'useTableBlockProps',
                        'x-component-props': {
                          rowKey: 'id',
                          rowSelection: {
                            type: 'checkbox',
                          },
                        },
                        'x-app-version': '0.21.0-alpha.15',
                        properties: {
                          actions: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            title: '{{ t("Actions") }}',
                            'x-action-column': 'actions',
                            'x-decorator': 'TableV2.Column.ActionBar',
                            'x-component': 'TableV2.Column',
                            'x-designer': 'TableV2.ActionColumnDesigner',
                            'x-initializer': 'table:configureItemActions',
                            'x-app-version': '0.21.0-alpha.15',
                            properties: {
                              qyh8y3u567i: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-decorator': 'DndContext',
                                'x-component': 'Space',
                                'x-component-props': {
                                  split: '|',
                                },
                                'x-app-version': '0.21.0-alpha.15',
                                'x-uid': 'suuyf9afqcg',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': 'l49nwyyppfy',
                            'x-async': false,
                            'x-index': 1,
                          },
                        },
                        'x-uid': 'vrdlfpoa7c6',
                        'x-async': false,
                        'x-index': 2,
                      },
                    },
                    'x-uid': 'ifxjep3ugit',
                    'x-async': false,
                    'x-index': 1,
                  },
                },
                'x-uid': 'tnw8n4rbwhh',
                'x-async': false,
                'x-index': 1,
              },
            },
            'x-uid': 'yrjjp3jl2rg',
            'x-async': false,
            'x-index': 1,
          },
        },
        'x-uid': 'sp05st5arhk',
        'x-async': false,
        'x-index': 1,
      },
    },
    'x-uid': '4h4z7pw7j7v',
    'x-async': true,
    'x-index': 1,
  },
};
export const oneMapUsedToTestSettings = {
  collections: [
    {
      name: 'map',
      fields: [
        {
          name: 'point',
          interface: 'point',
        },
      ],
    },
  ],
  pageSchema: {
    _isJSONSchemaObject: true,
    version: '2.0',
    type: 'void',
    'x-component': 'Page',
    properties: {
      '8d5kk0rt54w': {
        _isJSONSchemaObject: true,
        version: '2.0',
        type: 'void',
        'x-component': 'Grid',
        'x-initializer': 'page:addBlock',
        properties: {
          '8sia51xaucx': {
            _isJSONSchemaObject: true,
            version: '2.0',
            type: 'void',
            'x-component': 'Grid.Row',
            'x-app-version': '0.21.0-alpha.15',
            properties: {
              elij0klumzf: {
                _isJSONSchemaObject: true,
                version: '2.0',
                type: 'void',
                'x-component': 'Grid.Col',
                'x-app-version': '0.21.0-alpha.15',
                properties: {
                  '05gsh93kbeg': {
                    _isJSONSchemaObject: true,
                    version: '2.0',
                    type: 'void',
                    'x-acl-action': 'map:list',
                    'x-decorator': 'MapBlockProvider',
                    'x-decorator-props': {
                      collection: 'map',
                      dataSource: 'main',
                      action: 'list',
                      fieldNames: {
                        field: ['point'],
                      },
                      params: {
                        paginate: false,
                      },
                    },
                    'x-toolbar': 'BlockSchemaToolbar',
                    'x-settings': 'blockSettings:map',
                    'x-component': 'CardItem',
                    'x-filter-targets': [],
                    'x-app-version': '0.21.0-alpha.15',
                    properties: {
                      actions: {
                        _isJSONSchemaObject: true,
                        version: '2.0',
                        type: 'void',
                        'x-initializer': 'map:configureActions',
                        'x-component': 'ActionBar',
                        'x-component-props': {
                          style: {
                            marginBottom: 16,
                          },
                        },
                        'x-app-version': '0.21.0-alpha.15',
                        'x-uid': 'je3ohoqzqt6',
                        'x-async': false,
                        'x-index': 1,
                      },
                      vdsw8i32n94: {
                        _isJSONSchemaObject: true,
                        version: '2.0',
                        type: 'void',
                        'x-component': 'MapBlock',
                        'x-use-component-props': 'useMapBlockProps',
                        'x-app-version': '0.21.0-alpha.15',
                        properties: {
                          drawer: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            'x-component': 'Action.Drawer',
                            'x-component-props': {
                              className: 'nb-action-popup',
                            },
                            title: '{{ t("View record") }}',
                            'x-app-version': '0.21.0-alpha.15',
                            properties: {
                              tabs: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Tabs',
                                'x-component-props': {},
                                'x-initializer': 'popup:addTab',
                                'x-app-version': '0.21.0-alpha.15',
                                properties: {
                                  tab1: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    title: '{{t("Details")}}',
                                    'x-component': 'Tabs.TabPane',
                                    'x-designer': 'Tabs.Designer',
                                    'x-component-props': {},
                                    'x-app-version': '0.21.0-alpha.15',
                                    properties: {
                                      grid: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'void',
                                        'x-component': 'Grid',
                                        'x-initializer': 'popup:common:addBlock',
                                        'x-app-version': '0.21.0-alpha.15',
                                        'x-uid': 'g5d6t1hpvo8',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'hq5j3w8d8db',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'x0ne9tq1bdf',
                                'x-async': false,
                                'x-index': 1,
                              },
                            },
                            'x-uid': 'micohua87kv',
                            'x-async': false,
                            'x-index': 1,
                          },
                        },
                        'x-uid': 'e7hfatz8fxx',
                        'x-async': false,
                        'x-index': 2,
                      },
                    },
                    'x-uid': 'g2n2rqidaem',
                    'x-async': false,
                    'x-index': 1,
                  },
                },
                'x-uid': 'zmrjvgpsgeh',
                'x-async': false,
                'x-index': 1,
              },
            },
            'x-uid': 'q81voyltwkn',
            'x-async': false,
            'x-index': 1,
          },
        },
        'x-uid': 'lyadz9knnnm',
        'x-async': false,
        'x-index': 1,
      },
    },
    'x-uid': '5b3qaiczmyv',
    'x-async': true,
    'x-index': 1,
  },
};
