/**
 * This file is part of the NocoBase (R) project.
 * Copyright (c) 2020-2024 NocoBase Co., Ltd.
 * Authors: NocoBase Team.
 *
 * This project is dual-licensed under AGPL-3.0 and NocoBase Commercial License.
 * For more information, please refer to: https://www.nocobase.com/agreement.
 */

/**
 * 一个通用表单详情
 * 显示 email, number, integer, singleLineText, longText
 * password, percent, phone
 */
import { generalWithBasic } from '../../templatesOfCollection';
export const commonFormViewPage = {
  collections: generalWithBasic,
  pageSchema: {
    _isJSONSchemaObject: true,
    version: '2.0',
    type: 'void',
    'x-component': 'Page',
    'x-index': 1,
    properties: {
      nyayqbdi6fw: {
        _isJSONSchemaObject: true,
        version: '2.0',
        type: 'void',
        'x-component': 'Grid',
        'x-initializer': 'page:addBlock',
        'x-app-version': '1.0.0-alpha.17',
        'x-index': 1,
        properties: {
          udrskvvihwz: {
            _isJSONSchemaObject: true,
            version: '2.0',
            type: 'void',
            'x-component': 'Grid.Row',
            'x-app-version': '1.0.0-alpha.17',
            properties: {
              sic837d78ru: {
                _isJSONSchemaObject: true,
                version: '2.0',
                type: 'void',
                'x-component': 'Grid.Col',
                'x-app-version': '1.0.0-alpha.17',
                properties: {
                  j3tcb77zrjs: {
                    _isJSONSchemaObject: true,
                    version: '2.0',
                    type: 'void',
                    'x-acl-action': 'general:view',
                    'x-decorator': 'DetailsBlockProvider',
                    'x-use-decorator-props': 'useDetailsWithPaginationDecoratorProps',
                    'x-decorator-props': {
                      dataSource: 'main',
                      collection: 'general',
                      readPretty: true,
                      action: 'list',
                      params: {
                        pageSize: 1,
                      },
                    },
                    'x-toolbar': 'BlockSchemaToolbar',
                    'x-settings': 'blockSettings:detailsWithPagination',
                    'x-component': 'CardItem',
                    'x-app-version': '1.0.0-alpha.17',
                    properties: {
                      hgde2qiovq4: {
                        _isJSONSchemaObject: true,
                        version: '2.0',
                        type: 'void',
                        'x-component': 'Details',
                        'x-read-pretty': true,
                        'x-use-component-props': 'useDetailsWithPaginationProps',
                        'x-app-version': '1.0.0-alpha.17',
                        properties: {
                          xaaixt3ikr2: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            'x-initializer': 'details:configureActions',
                            'x-component': 'ActionBar',
                            'x-component-props': {
                              style: {
                                marginBottom: 24,
                              },
                            },
                            'x-app-version': '1.0.0-alpha.17',
                            properties: {
                              zc467d4k8pe: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                title: '{{ t("Edit") }}',
                                'x-action': 'update',
                                'x-toolbar': 'ActionSchemaToolbar',
                                'x-settings': 'actionSettings:edit',
                                'x-component': 'Action',
                                'x-component-props': {
                                  openMode: 'drawer',
                                  icon: 'EditOutlined',
                                  type: 'primary',
                                },
                                'x-decorator': 'ACLActionProvider',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  drawer: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    title: '{{ t("Edit record") }}',
                                    'x-component': 'Action.Container',
                                    'x-component-props': {
                                      className: 'nb-action-popup',
                                    },
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      tabs: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'void',
                                        'x-component': 'Tabs',
                                        'x-component-props': {},
                                        'x-initializer': 'popup:addTab',
                                        'x-app-version': '1.0.0-alpha.17',
                                        properties: {
                                          tab1: {
                                            _isJSONSchemaObject: true,
                                            version: '2.0',
                                            type: 'void',
                                            title: '{{t("Edit")}}',
                                            'x-component': 'Tabs.TabPane',
                                            'x-designer': 'Tabs.Designer',
                                            'x-component-props': {},
                                            'x-app-version': '1.0.0-alpha.17',
                                            properties: {
                                              grid: {
                                                _isJSONSchemaObject: true,
                                                version: '2.0',
                                                type: 'void',
                                                'x-component': 'Grid',
                                                'x-initializer': 'popup:common:addBlock',
                                                'x-app-version': '1.0.0-alpha.17',
                                                'x-uid': 'tbxcoz6blxo',
                                                'x-async': false,
                                                'x-index': 1,
                                              },
                                            },
                                            'x-uid': 'x4gthikn85e',
                                            'x-async': false,
                                            'x-index': 1,
                                          },
                                        },
                                        'x-uid': 'dlcr60v0lae',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'goi3ac29a92',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'xhu94zjv18h',
                                'x-async': false,
                                'x-index': 2,
                              },
                            },
                            'x-uid': 'dotl8t82ufw',
                            'x-async': false,
                            'x-index': 1,
                          },
                          grid: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            'x-component': 'Grid',
                            'x-initializer': 'details:configureFields',
                            'x-app-version': '1.0.0-alpha.17',
                            properties: {
                              qbd9sojqba9: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  '6fi8dxh1515': {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      email: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.email',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': '1ht8ymnfc18',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '2y8bzf9fa92',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'mszcq97x37n',
                                'x-async': false,
                                'x-index': 1,
                              },
                              '5qwtnq93h4m': {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  woxnz7b32ms: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      number: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.number',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': 'lg2wluayh2c',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'awljxm8hh55',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'g8raovgeqjc',
                                'x-async': false,
                                'x-index': 2,
                              },
                              v7ht9slmzwn: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  ijjcbuis4tv: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      integer: {
                                        'x-uid': 'dhdtfo7nrxn',
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.integer',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-linkage-style-rules': [],
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '9rd5u4d3lhj',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'ii6w1eqf21k',
                                'x-async': false,
                                'x-index': 3,
                              },
                              fekkqosx4q6: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  nmpljskg642: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      singleLineText: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.singleLineText',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': '88cqngc9wzf',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '44pljtolwui',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'zq7dfy9uvrj',
                                'x-async': false,
                                'x-index': 4,
                              },
                              p318qpfu85n: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  '1fayljjx90o': {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      longText: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.longText',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': 'y6rf9v4iz8o',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': '1vhh859rxwx',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': '19lk0gejxo3',
                                'x-async': false,
                                'x-index': 5,
                              },
                              '6t21tyr1aun': {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  '3h1hp3t902r': {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      password: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.password',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': '2zgn6ew5mwy',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'i3twoaoewde',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'uvsong5fn8l',
                                'x-async': false,
                                'x-index': 6,
                              },
                              inytkbn0nae: {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  h8e5m0gy2ei: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      percent: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.percent',
                                        'x-component-props': {
                                          style: {
                                            width: '100%',
                                          },
                                        },
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': '2maem18o31o',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'jtbdipyy5sc',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'as7c9lme7mm',
                                'x-async': false,
                                'x-index': 7,
                              },
                              '81q1yw3hkkn': {
                                _isJSONSchemaObject: true,
                                version: '2.0',
                                type: 'void',
                                'x-component': 'Grid.Row',
                                'x-app-version': '1.0.0-alpha.17',
                                properties: {
                                  ykobkj6pe8n: {
                                    _isJSONSchemaObject: true,
                                    version: '2.0',
                                    type: 'void',
                                    'x-component': 'Grid.Col',
                                    'x-app-version': '1.0.0-alpha.17',
                                    properties: {
                                      phone: {
                                        _isJSONSchemaObject: true,
                                        version: '2.0',
                                        type: 'string',
                                        'x-toolbar': 'FormItemSchemaToolbar',
                                        'x-settings': 'fieldSettings:FormItem',
                                        'x-component': 'CollectionField',
                                        'x-decorator': 'FormItem',
                                        'x-use-decorator-props': 'useDataFormItemProps',
                                        'x-collection-field': 'general.phone',
                                        'x-component-props': {},
                                        'x-app-version': '1.0.0-alpha.17',
                                        'x-uid': 'e66n6ewz0hi',
                                        'x-async': false,
                                        'x-index': 1,
                                      },
                                    },
                                    'x-uid': 'ai34z8y2eb4',
                                    'x-async': false,
                                    'x-index': 1,
                                  },
                                },
                                'x-uid': 'eltj0z2txug',
                                'x-async': false,
                                'x-index': 8,
                              },
                            },
                            'x-uid': '7crv1u0i3co',
                            'x-async': false,
                            'x-index': 2,
                          },
                          pagination: {
                            _isJSONSchemaObject: true,
                            version: '2.0',
                            type: 'void',
                            'x-component': 'Pagination',
                            'x-use-component-props': 'useDetailsPaginationProps',
                            'x-app-version': '1.0.0-alpha.17',
                            'x-uid': 'jfs3ntlghyo',
                            'x-async': false,
                            'x-index': 3,
                          },
                        },
                        'x-uid': 'buvsjjof9pw',
                        'x-async': false,
                        'x-index': 1,
                      },
                    },
                    'x-uid': '9ruom7jpm1h',
                    'x-async': false,
                    'x-index': 1,
                  },
                },
                'x-uid': '3pl1k9mqhy8',
                'x-async': false,
                'x-index': 1,
              },
            },
            'x-uid': '0eax0yvji6y',
            'x-async': false,
            'x-index': 2,
          },
        },
        'x-uid': 'cs71v511x7o',
        'x-async': false,
      },
    },
    'x-uid': 'welnfb52obj',
    'x-async': true,
  },
};
