# MASR对比Github其他项目

Github上的中文语音识别项目质量良莠不齐，本文为你提供一个选择的参考。

本文将MASR和以下Github上Star数较高的中文语音识别项目进行了对比

1. ASRT：https://github.com/nl8590687/ASRT_SpeechRecognition
2. 项目2：https://github.com/xxbb1234021/speech_recognition
3. DeepSpeech：https://github.com/PaddlePaddle/DeepSpeech

在正式对比之前，我想解释下一些概念。

## 训练集和测试集

通常来说，一个语音识别模型在训练集、测试集、实际使用中的效果满足如下关系：

* 训练集效果 > 测试集效果 > 实际使用的效果

以下对比的时候凡是提到识别效果，指的都是测试集识别效果。

本项目使用的测试集是AISHELL-1的测试集。

实际使用的效果都会比测试集效果要差。

## 和ASRT对比

|                    | ASRT            | MASR                                         |
| ------------------ | --------------- | -------------------------------------------- |
| 是否提供预训练模型 | 是              | 是                                           |
| 预训练模型大小     | **20MB**        | 120MB                                        |
| 识别效果           | 拼音准确率：80% | **汉字准确率：86%**（加入语言模型后**92%**） |
| 基于框架           | keras           | pytorch                                      |
| 是否端到端         | 是[?]           | **是**                                       |
| 支持自行录音识别   | 是              | 是                                           |

* ASRT预训练模型很小，下载方便，这点确实是优势。
* 汉字准确率作为评价标准比拼音准确率要难。
* 尽管ASRT声称是端到端的，但实际上是语音转拼音，再拼音转文字。
* 这里的准确率指的是（1 - 字错误率）

## 和项目2对比

项目2把thchs-30的测试集拿去当训练集用了，只有**6个小时**的录音时长。完全的过拟合，毫无泛化能力，简单地说就是，**根本不能用**。

项目2的首页在展示的时候用的是**已经被训练过**的「测试集」上的识别效果，毫无意义。

项目2的issue页里基本都是踩坑的小白。

|                    | 项目2                       | MASR                                         |
| ------------------ | --------------------------- | -------------------------------------------- |
| 是否提供预训练模型 | 要去issue页里面翻，可以翻到 | **是**                                       |
| 预训练模型大小     | 110MB                       | 120MB                                        |
| 识别效果           | 没有识别语音的能力          | **汉字准确率：86%**（加入语言模型后**92%**） |

## 和DeepSpeech对比

项目3是百度官方的。质量上确实比个人项目高很多，我也测试过。如果你比较有经验，推荐使用百度的这个项目。

DeepSpeech提供了分别提供了中英文语音识别的预训练模型。其中中文语音识别模型提供了2个，一个基于AISHELL-1数据集训练（和本项目一样），一个基于百度内部的1200小时的中文数据集训练（钞能力）。百度给出了后者在内部测试集上的表现，大约是**87%的准确率**。

|                    | DeepSpeech            | MASR                   |
| ------------------ | --------------------- | ---------------------- |
| 基于框架           | paddlepaddle          | pytorch                |
| 是否提供预训练模型 | 是                    | 是                     |
| 模型结构           | CNN + RNN(GRU)        | CNN only               |
| 预训练模型大小     | 750MB                 | **120MB**              |
| 预训练数据集大小   | **1200小时**          | 150小时                |
| 外部语言模型       | **有**                | 无                     |
| 识别效果           | **87%（内部数据集）** | 92%（AISHELL-1测试集） |

注意：百度内部数据集上的**87%**准确率比本项目的在AISHELL-1测试集上的**92%**准确率要更好，因为它的测试集要丰富得多。个人估计，百度预训练模型在AISHELL-1上的准确率应该是可以做到95%左右的，但它没有公布。