# Copyright 2022 NNAISENSE SA
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This namespace contains various utility functions, classes, and type aliases.
"""


__all__ = (
    "BatchableScalar",
    "BatchableVector",
    "DType",
    "DTypeAndDevice",
    "Device",
    "ErroneousResult",
    "Hook",
    "ObjectArray",
    "ReadOnlyTensor",
    "RealOrVector",
    "Size",
    "SuppressSacredExperiment",
    "Vector",
    "as_immutable",
    "as_read_only_tensor",
    "as_tensor",
    "cast_tensors_in_container",
    "clip_tensor",
    "clone",
    "cloning",
    "constraints",
    "device_of",
    "device_of_container",
    "dtype_of",
    "dtype_of_container",
    "empty_tensor_like",
    "ensure_ray",
    "ensure_tensor_length_and_dtype",
    "expect_none",
    "is_bool",
    "is_bool_vector",
    "is_dtype_bool",
    "is_dtype_float",
    "is_dtype_integer",
    "is_dtype_object",
    "is_dtype_real",
    "is_integer",
    "is_integer_vector",
    "is_real",
    "is_real_vector",
    "is_sequence",
    "is_tensor_on_cpu",
    "log_barrier",
    "make_I",
    "make_batched_false_for_vmap",
    "make_empty",
    "make_gaussian",
    "make_nan",
    "make_ones",
    "make_randint",
    "make_tensor",
    "make_uniform",
    "make_zeros",
    "modify_tensor",
    "modify_vector",
    "multiply_rows_by_scalars",
    "mutable_copy",
    "numpy_copy",
    "pass_info_if_needed",
    "penalty",
    "rank",
    "read_only_tensor",
    "recursiveprintable",
    "rowwise_sum",
    "set_default_logger_config",
    "split_workload",
    "stdev_from_radius",
    "storage_ptr",
    "to_numpy_dtype",
    "to_stdev_init",
    "to_torch_dtype",
    "violation",
)


from . import (
    cloning,
    constraints,
    hook,
    immutable,
    objectarray,
    ranking,
    readonlytensor,
    recursiveprintable,
    structures,
    tensormaker,
)
from .constraints import log_barrier, penalty, violation
from .hook import Hook
from .immutable import as_immutable, mutable_copy
from .misc import (
    BatchableScalar,
    BatchableVector,
    Device,
    DType,
    DTypeAndDevice,
    ErroneousResult,
    RealOrVector,
    Size,
    SuppressSacredExperiment,
    Vector,
    as_tensor,
    cast_tensors_in_container,
    clip_tensor,
    clone,
    device_of,
    device_of_container,
    dtype_of,
    dtype_of_container,
    empty_tensor_like,
    ensure_ray,
    ensure_tensor_length_and_dtype,
    expect_none,
    is_bool,
    is_bool_vector,
    is_dtype_bool,
    is_dtype_float,
    is_dtype_integer,
    is_dtype_object,
    is_dtype_real,
    is_integer,
    is_integer_vector,
    is_real,
    is_real_vector,
    is_sequence,
    is_tensor_on_cpu,
    make_batched_false_for_vmap,
    make_empty,
    make_gaussian,
    make_I,
    make_nan,
    make_ones,
    make_randint,
    make_tensor,
    make_uniform,
    make_zeros,
    message_from,
    modify_tensor,
    modify_vector,
    multiply_rows_by_scalars,
    numpy_copy,
    pass_info_if_needed,
    rowwise_sum,
    set_default_logger_config,
    split_workload,
    stdev_from_radius,
    storage_ptr,
    to_numpy_dtype,
    to_stdev_init,
    to_torch_dtype,
)
from .objectarray import ObjectArray
from .ranking import rank
from .readonlytensor import ReadOnlyTensor, as_read_only_tensor, read_only_tensor
