/*
 * Validity90 tests for utility functions
 * Copyright (C) 2017-2018 Nikita Mikhailov <nikita.s.mikhailov@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <glib.h>
#include <stdlib.h>

#include "validity90/utils.h"
#include "validity90/validity90.h"

// @TEST_DEF /utils/tls_prf/test1
void UTILS_TLS_PRF_TEST1() {
    guint8 secret[] = {
        0x71, 0x7c, 0xd7, 0x2d, 0x09, 0x62, 0xbc, 0x4a, 0x28, 0x46, 0x13, 0x8d, 0xbb, 0x2c, 0x24, 0x19,
        0x25, 0x12, 0xa7, 0x64, 0x07, 0x06, 0x5f, 0x38, 0x38, 0x46, 0x13, 0x9d, 0x4b, 0xec, 0x20, 0x33,
    };
    gchar str[] = "GWK";
    guint8 seed[] = {
        0x32, 0x30, 0x46, 0x39, 0x43, 0x54, 0x4f, 0x31, 0x57, 0x57, 0x00, 0x50, 0x43, 0x30, 0x47, 0x56,
        0x42, 0x5a, 0x34, 0x00,
    };
    gsize required_len = 0x20;

    guint8 expected_result[] = {
        0x45, 0xa5, 0x9a, 0x01, 0x0b, 0xb2, 0x80, 0xb4, 0xea, 0x93, 0xd9, 0x46, 0xdc, 0x99, 0x52, 0x6f,
        0x75, 0xe1, 0xfd, 0x1f, 0x81, 0x6e, 0x98, 0x81, 0xf1, 0xeb, 0x69, 0xfc, 0xaa, 0x82, 0x14, 0xbc,
    };

    guint8 out[required_len];
    g_assert(validity90_tls_prf(secret, G_N_ELEMENTS(secret), str, seed, G_N_ELEMENTS(seed), required_len, out, NULL));
    g_assert_cmpmem(out, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

// @TEST_DEF /utils/tls_prf/test2
void UTILS_TLS_PRF_TEST2() {
    guint8 secret[] = {
        0x71, 0x7c, 0xd7, 0x2d, 0x09, 0x62, 0xbc, 0x4a, 0x28, 0x46, 0x13, 0x8d, 0xbb, 0x2c, 0x24, 0x19,
        0x25, 0x12, 0xa7, 0x64, 0x07, 0x06, 0x5f, 0x38, 0x38, 0x46, 0x13, 0x9d, 0x4b, 0xec, 0x20, 0x33,
    };
    gchar str[] = "GWK";
    guint8 seed[] = {
        0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x42, 0x6f, 0x78, 0x00, 0x30, 0x00,
    };
    gsize required_len = 0x20;

    guint8 expected_result[] = {
        0x48, 0x78, 0x02, 0x70, 0x5e, 0x5a, 0xc4, 0xa9, 0x93, 0x1c, 0x44, 0xaa, 0x4d, 0x32, 0x25, 0x22,
        0x39, 0xe0, 0xbf, 0x8f, 0x0c, 0x85, 0x4d, 0xde, 0x49, 0x0c, 0xcc, 0xf6, 0x87, 0xef, 0xad, 0x9c,
    };

    guint8 out[required_len];
    g_assert(validity90_tls_prf(secret, G_N_ELEMENTS(secret), str, seed, G_N_ELEMENTS(seed), required_len, out, NULL));
    g_assert_cmpmem(out, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

// @TEST_DEF /utils/tls_prf/test3
void UTILS_TLS_PRF_TEST3() {
    guint8 secret[] = {
        0x30, 0xad, 0xd9, 0x09, 0xad, 0x08, 0x64, 0x53, 0xee, 0x1b, 0xaf, 0xc6, 0xbd, 0x4e, 0x4e, 0xce,
        0x12, 0x70, 0xa6, 0x44, 0xd0, 0x15, 0x68, 0x89, 0x56, 0xe6, 0xac, 0x79, 0x62, 0xea, 0xcd, 0xab,
    };
    gchar str[] = "master secret";
    guint8 seed[] = {
        0x95, 0x6c, 0x41, 0xa9, 0x12, 0x86, 0x8a, 0xda, 0x9b, 0xb2, 0x5b, 0xb4, 0xbb, 0xd6, 0x1d, 0xde,
        0x4f, 0xda, 0x23, 0x2a, 0x74, 0x7b, 0x2a, 0x93, 0xf8, 0xac, 0xc6, 0x69, 0x24, 0x70, 0xc4, 0x2a,
        0x00, 0x00, 0x87, 0x5e, 0x8d, 0x67, 0x9c, 0x83, 0x5c, 0x5e, 0x4c, 0xb8, 0xba, 0x1f, 0xb8, 0x2b,
        0x6c, 0xf8, 0x5d, 0x38, 0x33, 0x01, 0x5e, 0xd7, 0x20, 0x3f, 0x7d, 0x34, 0x26, 0x5e, 0xcf, 0x55,
    };
    gsize required_len = 0x30;

    guint8 expected_result[] = {
        0x8d, 0x05, 0xb5, 0x1e, 0x85, 0x86, 0xd9, 0xce, 0xae, 0x2e, 0x60, 0x03, 0xff, 0x4f, 0x95, 0x63,
        0xdf, 0xd9, 0x7d, 0x99, 0x1f, 0x36, 0x31, 0x17, 0x2e, 0xee, 0x84, 0xd7, 0x74, 0xc2, 0xbd, 0xa1,
        0xbb, 0xc9, 0x88, 0x64, 0x74, 0x1c, 0x88, 0x31, 0xbd, 0x13, 0x99, 0xb6, 0x7d, 0x88, 0x0f, 0x67,
    };

    guint8 out[required_len];
    g_assert(validity90_tls_prf(secret, G_N_ELEMENTS(secret), str, seed, G_N_ELEMENTS(seed), required_len, out, NULL));
    g_assert_cmpmem(out, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

// @TEST_DEF  /utils/tls_prf/test4
void UTILS_TLS_PRF_TEST4() {
    guint8 secret[] = {
        0x8d, 0x05, 0xb5, 0x1e, 0x85, 0x86, 0xd9, 0xce, 0xae, 0x2e, 0x60, 0x03, 0xff, 0x4f, 0x95, 0x63,
        0xdf, 0xd9, 0x7d, 0x99, 0x1f, 0x36, 0x31, 0x17, 0x2e, 0xee, 0x84, 0xd7, 0x74, 0xc2, 0xbd, 0xa1,
        0xbb, 0xc9, 0x88, 0x64, 0x74, 0x1c, 0x88, 0x31, 0xbd, 0x13, 0x99, 0xb6, 0x7d, 0x88, 0x0f, 0x67,
    };
    gchar str[] = "key expansion";
    guint8 seed[] = {
        0x95, 0x6c, 0x41, 0xa9, 0x12, 0x86, 0x8a, 0xda, 0x9b, 0xb2, 0x5b, 0xb4, 0xbb, 0xd6, 0x1d, 0xde,
        0x4f, 0xda, 0x23, 0x2a, 0x74, 0x7b, 0x2a, 0x93, 0xf8, 0xac, 0xc6, 0x69, 0x24, 0x70, 0xc4, 0x2a,
        0x00, 0x00, 0x87, 0x5e, 0x8d, 0x67, 0x9c, 0x83, 0x5c, 0x5e, 0x4c, 0xb8, 0xba, 0x1f, 0xb8, 0x2b,
        0x6c, 0xf8, 0x5d, 0x38, 0x33, 0x01, 0x5e, 0xd7, 0x20, 0x3f, 0x7d, 0x34, 0x26, 0x5e, 0xcf, 0x55,
    };
    gsize required_len = 0x120;

    guint8 expected_result[] = {
        0x93, 0xbb, 0x6f, 0x94, 0x10, 0x2e, 0xc9, 0x72, 0x09, 0x28, 0x59, 0x4c, 0x20, 0xae, 0xee, 0xd8,
        0xb1, 0xd0, 0x8e, 0xa1, 0x4e, 0x78, 0x83, 0x64, 0xc2, 0xb2, 0x97, 0xcb, 0x50, 0xe1, 0x83, 0x7a,
        0x6a, 0x59, 0xe2, 0xf0, 0x3c, 0xee, 0x8c, 0xa9, 0xf1, 0xfe, 0x95, 0xde, 0xd0, 0xba, 0x0f, 0x2f,
        0x25, 0x16, 0xad, 0x3a, 0x44, 0xf2, 0x9b, 0xce, 0x06, 0x45, 0xab, 0x31, 0xbb, 0xa3, 0x9f, 0xfd,
        0xa4, 0x1c, 0x14, 0x8d, 0x11, 0x1f, 0x26, 0x4f, 0x8c, 0xb8, 0x2d, 0xb3, 0x50, 0x22, 0xdc, 0xbf,
        0x48, 0xb5, 0x1c, 0xd4, 0x07, 0xc3, 0xa5, 0x64, 0x3e, 0x4c, 0xe3, 0x8b, 0xc4, 0xa1, 0x42, 0xc9,
        0xc7, 0x34, 0x94, 0x88, 0x17, 0xc8, 0x47, 0xaf, 0x25, 0x3b, 0xf4, 0xf5, 0x06, 0x6e, 0x0d, 0xc3,
        0xe7, 0xc4, 0x98, 0xdc, 0x48, 0x70, 0x92, 0xc5, 0xe4, 0x95, 0x95, 0x64, 0xf4, 0x10, 0xf8, 0x4a,
        0xa8, 0x24, 0x68, 0xcd, 0x48, 0x70, 0x6c, 0x9e, 0xc2, 0x0c, 0xef, 0x08, 0x94, 0x4d, 0x69, 0x27,
        0xf9, 0x42, 0xfd, 0x4f, 0x85, 0xab, 0x4a, 0xc3, 0x43, 0x88, 0x69, 0x13, 0xfd, 0x72, 0xc3, 0x4d,
        0x29, 0x47, 0x16, 0x08, 0x69, 0xf0, 0x6d, 0x0e, 0xb9, 0x8b, 0xe4, 0x70, 0x18, 0x6a, 0xef, 0x59,
        0xa4, 0x9c, 0xd3, 0x31, 0xd7, 0x13, 0x48, 0x25, 0x3c, 0xce, 0x55, 0x81, 0x9e, 0x96, 0x48, 0x09,
        0x8f, 0x2f, 0x98, 0x88, 0xf9, 0xee, 0x2b, 0x0a, 0xc6, 0xcd, 0x08, 0xb1, 0xda, 0x6c, 0x31, 0xcb,
        0x9a, 0xd8, 0xb7, 0xae, 0x1d, 0x76, 0xe3, 0xda, 0x52, 0xd4, 0xa3, 0x94, 0xb6, 0x82, 0xec, 0x88,
        0x5a, 0x8e, 0x75, 0xd4, 0x34, 0xfd, 0x1e, 0x91, 0xfb, 0xa6, 0x96, 0xec, 0x64, 0x8d, 0x3e, 0x10,
        0xc9, 0x3d, 0xb9, 0x97, 0x6d, 0x7e, 0x82, 0x3b, 0xaa, 0x82, 0x54, 0xe0, 0x68, 0xc1, 0xd2, 0x34,
        0x17, 0x19, 0x3e, 0xd6, 0x3e, 0x7d, 0xb5, 0x91, 0x91, 0x24, 0x87, 0xaf, 0x75, 0x09, 0xfa, 0x7e,
        0xcd, 0x23, 0x27, 0xe3, 0x17, 0xfc, 0x38, 0x8b, 0xc2, 0xa9, 0x49, 0x1b, 0xcc, 0xed, 0x8c, 0xda,
    };
    guint8 out[required_len];
    g_assert(validity90_tls_prf(secret, G_N_ELEMENTS(secret), str, seed, G_N_ELEMENTS(seed), required_len, out, NULL));
    g_assert_cmpmem(out, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

// @TEST_DEF  /utils/tls_prf/test5
void UTILS_TLS_PRF_TEST5() {
    guint8 secret[] = {
        0x8d, 0x05, 0xb5, 0x1e, 0x85, 0x86, 0xd9, 0xce, 0xae, 0x2e, 0x60, 0x03, 0xff, 0x4f, 0x95, 0x63,
        0xdf, 0xd9, 0x7d, 0x99, 0x1f, 0x36, 0x31, 0x17, 0x2e, 0xee, 0x84, 0xd7, 0x74, 0xc2, 0xbd, 0xa1,
        0xbb, 0xc9, 0x88, 0x64, 0x74, 0x1c, 0x88, 0x31, 0xbd, 0x13, 0x99, 0xb6, 0x7d, 0x88, 0x0f, 0x67,
    };
    gchar str[] = "client finished";
    guint8 seed[] = {
        0x36, 0xd8, 0x1e, 0xc0, 0xf0, 0xe5, 0x84, 0xa8, 0xe8, 0x9a, 0xae, 0xe9, 0xc5, 0xad, 0xf1, 0xc3,
        0xba, 0xe6, 0xcb, 0xc9, 0x55, 0xb7, 0xee, 0x44, 0xf3, 0x7a, 0x2a, 0xb6, 0x40, 0x55, 0x54, 0x2a,
    };
    gsize required_len = 0xc;

    guint8 expected_result[] = {
        0x7e, 0x33, 0xa9, 0x6b, 0x05, 0x51, 0xa0, 0x94, 0xc4, 0x62, 0x43, 0x84,
    };
    
    guint8 out[required_len];
    g_assert(validity90_tls_prf(secret, G_N_ELEMENTS(secret), str, seed, G_N_ELEMENTS(seed), required_len, out, NULL));
    g_assert_cmpmem(out, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

// @TEST_DEF  /utils/tls_prf/test6
void UTILS_TLS_PRF_TEST6() {
    guint8 factory_key[] = {
        0x71, 0x7c, 0xd7, 0x2d, 0x09, 0x62, 0xbc, 0x4a,
        0x28, 0x46, 0x13, 0x8d, 0xbb, 0x2c, 0x24, 0x19,
        0x25, 0x12, 0xa7, 0x64, 0x07, 0x06, 0x5f, 0x38,
        0x38, 0x46, 0x13, 0x9d, 0x4b, 0xec, 0x20, 0x33,
    };
    guint8 expected_result[] = {
        0x48, 0x78, 0x02, 0x70, 0x5e, 0x5a, 0xc4, 0xa9, 0x93, 0x1c, 0x44, 0xaa, 0x4d, 0x32, 0x25, 0x22,
        0x39, 0xe0, 0xbf, 0x8f, 0x0c, 0x85, 0x4d, 0xde, 0x49, 0x0c, 0xcc, 0xf6, 0x87, 0xef, 0xad, 0x9c,
    };

    //guint8 seed[] = "VirtualBox\0" "0";
    guint8 seed[] = { 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x42, 0x6f, 0x78, 0x00, 0x30, 0x00 };

    guint8 master_key_aes[0x20];

    gsize required_len = 0x20;
    g_assert(validity90_tls_prf(factory_key, G_N_ELEMENTS(factory_key), "GWK", seed, G_N_ELEMENTS(seed), required_len, master_key_aes, NULL));
    g_assert_cmpmem(master_key_aes, required_len, expected_result, G_N_ELEMENTS(expected_result));
}

