/*
 * Validity90 Prototype
 * Copyright (C) 2017-2018 Nikita Mikhailov <nikita.s.mikhailov@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef CONSTANTS_H
#define CONSTANTS_H

#include "validity90/validity90.h"

#define dword unsigned int
#define byte unsigned char

#define MASK_VARIABLE (1 << 30)
#define M(x) (MASK_VARIABLE | x)

static byte init_sequence_msg1[] = { 0x01 };
static byte init_sequence_msg2[] = { 0x19 };
static byte init_sequence_msg3[] = { 0x43, 0x02 };
static byte init_sequence_msg4[] = {
    0x06, 0x02, 0x00, 0x00, 0x01, 0x39, 0x17, 0xb3,
    0xdd, 0xa9, 0x13, 0x83, 0xb5, 0xbc, 0xac, 0x64,
    0xfa, 0x4a, 0xd3, 0x5d, 0xce, 0x96, 0x57, 0x0a,
    0x9d, 0x2d, 0x97, 0x4b, 0x80, 0x92, 0x6a, 0x43,
    0x1f, 0x9c, 0xd4, 0x62, 0x48, 0x98, 0x0a, 0x26,
    0x3c, 0x6f, 0xce, 0xf6, 0xa8, 0x28, 0x39, 0xa9,
    0x0b, 0x59, 0xac, 0x59, 0x08, 0x48, 0x85, 0x9a,
    0xfa, 0xc8, 0x17, 0xb7, 0xd5, 0x3b, 0xf5, 0x1c,
    0xd3, 0x20, 0x5c, 0x1b, 0x8f, 0x43, 0x04, 0x8b,
    0xe8, 0x25, 0x3c, 0x3b, 0xd2, 0x47, 0x93, 0x7c,
    0x83, 0x7a, 0xca, 0x8b, 0x18, 0xd3, 0xcc, 0x8e,
    0xe8, 0xc8, 0x97, 0x1a, 0xc4, 0xf6, 0x88, 0x81,
    0x3c, 0xf3, 0xd8, 0x55, 0x0d, 0x71, 0x49, 0x69,
    0x85, 0xb7, 0xec, 0x07, 0xff, 0x2d, 0xc7, 0x89,
    0x6d, 0x33, 0x0f, 0xda, 0xb2, 0x63, 0xa0, 0xee,
    0x43, 0x3a, 0x5c, 0x4b, 0xc9, 0x10, 0x43, 0x9d,
    0x1c, 0x61, 0x61, 0x85, 0x3f, 0xeb, 0x03, 0xf5,
    0x50, 0x22, 0x09, 0x50, 0x2e, 0x73, 0x08, 0xbe,
    0xb7, 0x91, 0x94, 0x73, 0xcf, 0xe6, 0x9f, 0x42,
    0x2c, 0x30, 0x50, 0x2d, 0x22, 0x6a, 0x4d, 0x0a,
    0x34, 0xd9, 0x6c, 0x8c, 0x77, 0x95, 0x6c, 0xf6,
    0x9d, 0xb8, 0xef, 0x6c, 0xf9, 0x27, 0xa3, 0xb5,
    0x78, 0x49, 0xd4, 0xaa, 0x8a, 0xd4, 0xb4, 0x42,
    0x66, 0x92, 0x3e, 0x34, 0xb8, 0x2a, 0x39, 0xc8,
    0x14, 0x6b, 0xa3, 0xcd, 0x70, 0x8c, 0x70, 0xdf,
    0xed, 0xb5, 0x0c, 0x2d, 0xe6, 0x1f, 0xeb, 0x45,
    0xb1, 0xd4, 0xf1, 0x95, 0x84, 0x29, 0x72, 0x03,
    0xf5, 0xfd, 0xc8, 0x65, 0x79, 0x5f, 0xec, 0x9d,
    0x64, 0x49, 0xf3, 0xba, 0x9b, 0x6f, 0x1e, 0x4b,
    0xed, 0x69, 0x8e, 0xe1, 0x51, 0xe8, 0x3d, 0x4d,
    0x87, 0x02, 0xf7, 0x6a, 0x40, 0x06, 0xcf, 0xa2,
    0x4d, 0x9b, 0x79, 0x78, 0x88, 0x20, 0x3b, 0x22,
    0x69, 0xf8, 0xa7, 0x7d, 0x52, 0x40, 0x34, 0xac,
    0x32, 0xe4, 0xaf, 0x58, 0xb8, 0x6e, 0xbc, 0x63,
    0x55, 0x2c, 0xb3, 0x5b, 0x12, 0xb2, 0x85, 0x25,
    0x5d, 0xea, 0xf3, 0xa3, 0x2b, 0xf4, 0x6c, 0xdc,
    0x5a, 0xd3, 0xbc, 0x1c, 0x9e, 0xd1, 0xbc, 0xc1,
    0x12, 0xc7, 0x21, 0x43, 0xf9, 0xae, 0xc5, 0x68,
    0xe2, 0xca, 0xcf, 0xa8, 0x9b, 0xa0, 0xc7, 0xbb,
    0x65, 0x59, 0x0d, 0x8b, 0x93, 0xe6, 0x87, 0x1a,
    0x33, 0xc6, 0xc6, 0x98, 0x3c, 0x0a, 0xcd, 0x04,
    0xe7, 0x37, 0xff, 0x55, 0xee, 0xe0, 0x24, 0xca,
    0x6b, 0x9a, 0x48, 0x33, 0x2c, 0x1a, 0x69, 0xa5,
    0xa3, 0xfd, 0xd2, 0x4b, 0x96, 0x4c, 0xf7, 0xe7,
    0xc5, 0x52, 0x29, 0xbb, 0x0b, 0x48, 0xa6, 0xe3,
    0x39, 0xeb, 0x2c, 0x42, 0xd0, 0x7e, 0xc8, 0x50,
    0xa4, 0xee, 0x78, 0x06, 0x60, 0xad, 0x6c, 0x77,
    0xff, 0xa3, 0x02, 0xa6, 0x3b, 0xd1, 0x94, 0x26,
    0x13, 0x4c, 0x45, 0x33, 0xd6, 0xf9, 0x67, 0x44,
    0x11, 0x63, 0xfb, 0x78, 0xb7, 0x35, 0x47, 0xc6,
    0x8a, 0x49, 0x3b, 0x2f, 0x80, 0x0d, 0x3c, 0xda,
    0xb8, 0x27, 0xb1, 0x16, 0x76, 0x27, 0x89, 0x99,
    0x2a, 0xae, 0x3c, 0x8a, 0xb3, 0x45, 0xa4, 0x9e,
    0xdd, 0x31, 0x2d, 0xfd, 0x2a, 0x27, 0xbc, 0x50,
    0x14, 0x27, 0xdc, 0x7f, 0xa0, 0x0a, 0xc3, 0xc5,
    0xc3, 0x65, 0x51, 0xdb, 0xb3, 0xd5, 0xca, 0xd8,
    0xd5, 0xbd, 0x7c, 0xea, 0x37, 0xe5, 0x8a, 0x31,
    0x30, 0x7a, 0x6d, 0x50, 0xe6, 0xae, 0x37, 0x9a,
    0x53, 0xf1, 0x36, 0x66, 0x78, 0xc0, 0x74, 0x1a,
    0x3d, 0x87, 0x2b, 0x8d, 0xcf, 0xef, 0xa7, 0xf6,
    0x31, 0x28, 0xdc, 0x82, 0x45
};
static byte init_sequence_msg5[] = { 0x3e };
static byte init_sequence_msg6[] = {
    0x40, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00
};


static dword init_sequence_rsp1[] = {
    0x00, 0x00, 0xf0, 0xb0, 0x5e, 0x54, 0xa4, 0x00,
    0x00, 0x00, 0x06, 0x07, 0x01, 0x30, 0x00, 0x01,
    0x00, 0x00, 0x26, 0x85, 0x88, 0x42, 0x45, 0x3b,
    0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, M(1)
};
static dword init_sequence_rsp2[] = {
    0x00, 0x00, 0x00, 0x03, 0x01, 0x02, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, M(1), M(1), M(1), M(1),
    0x00, 0x00, 0x00, 0x00, M(2), M(2), M(2), M(2),
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
};

static dword init_sequence_rsp3[] = {
    0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x98, 0xc9, 0x71, 0x56, 0x01, 0x00, 0x34, 0x46,
    0x02, 0x00, 0x07, 0x00, 0x60, 0x39, 0x00, 0x00,
    0x01, 0x00, 0x84, 0x08, 0x01, 0x00, 0x07, 0x00,
    0xb0, 0x02, 0x00, 0x00, 0x02, 0x00, 0x84, 0x28,
    0x03, 0x00, 0x12, 0x00, 0x10, 0x10, 0x00, 0x00,
    0x02, 0x00, 0x66, 0x37, 0x01, 0x00, 0x0c, 0x00,
    0x40, 0x22, 0x02, 0x00, 0x01, 0x00, 0x86, 0x47,
    0x00, 0x00, 0x01, 0x00, 0x20, 0x5a, 0x00, 0x00,
    0x02, 0x00, 0x23, 0x77, 0x00, 0x00, 0x01, 0x00,
    0xd0, 0x2f, 0x00, 0x00
};
static dword init_sequence_rsp4[] = { 0x00, 0x00 };
static dword init_sequence_rsp5[] = {
    0x00, 0x00, 0xef, 0x00, 0x40, 0x00, 0x00, 0x10,
    0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x05, 0x00,
    0x01, 0x04, 0x07, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x10, 0x00, 0x00, 0x02, 0x01, 0x02, 0x00,
    0x00, 0x20, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00,
    0x05, 0x05, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x80, 0x00, 0x00, 0x06, 0x06, 0x03, 0x00,
    0x00, 0x80, 0x04, 0x00, 0x00, 0x80, 0x00, 0x00,
    0x04, 0x03, 0x05, 0x00, 0x00, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x03, 0x00
};
static dword init_sequence_rsp6[] = {
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x00, 0x6e, 0x34, 0x0b, 0x9c,
    0xff, 0xb3, 0x7a, 0x98, 0x9c, 0xa5, 0x44, 0xe6,
    0xbb, 0x78, 0x0a, 0x2c, 0x78, 0x90, 0x1d, 0x3f,
    0xb3, 0x37, 0x38, 0x76, 0x85, 0x11, 0xa3, 0x06,
    0x17, 0xaf, 0xa0, 0x1d, 0x00, 0x04, 0x00, 0xa1,
    0x00, 0xc8, 0x38, 0xd8, 0xe1, 0xdb, 0xf5, 0x04,
    0x53, 0x04, 0x1a, 0xc5, 0xa7, 0xb4, 0x0b, 0x2f,
    0x1e, 0xf2, 0x7d, 0x7e, 0x1b, 0xfd, 0x48, 0xda,
    0xa9, 0x42, 0x06, 0x59, 0xf3, 0x3b, 0x07, 0xa7,
    0xe3, 0x02, 0x65, 0x4c, 0x1a, 0xdd, 0xa3, 0x57,
    0x65, 0x13, 0x84, 0xc7, 0x98, 0x38, 0x4e, 0x5e,
    0xd9, 0xc7, 0x33, 0x5c, 0xed, 0x15, 0x55, 0x3c,
    0xf5, 0xf4, 0xde, 0x14, 0xa0, 0xf2, 0x59, 0x68,
    0x00, 0xa2, 0xa0, 0x98, 0x58, 0xc2, 0x06, 0x67,
    0xd5, 0xc1, 0x06, 0xe3, 0xbf, 0xe6, 0x6a, 0xec,
    0x6a, 0xc0, 0x2d, 0xb2, 0xd8, 0x77, 0xd9, 0x0e,
    0xc4, 0x12, 0xe3, 0xab, 0x48, 0xab, 0xaa, 0xb4,
    0xb9, 0x56, 0x75, 0x30, 0x69, 0x9d, 0x0a, 0xc3,
    0xd9, 0xbb, 0xff, 0xde, 0x42, 0x11, 0xbd, 0x34,
    0x03, 0x21, 0xcf, 0xa2, 0x8d, 0x3c, 0x1b, 0xe4,
    0xba, 0xf0, 0x1f, 0xf4, 0x40, 0x69, 0x6f, 0xb4,
    0x78, 0x18, 0xf3, 0x2d, 0x6b, 0x22, 0x80, 0x86,
    0x64, 0x31, 0x14, 0x34, 0x2a, 0x81, 0x2c, 0xcc,
    0xd7, 0xc6, 0x62, 0xf3, 0x9e, 0x5f, 0x78, 0xa6,
    0x39, 0xd3, 0xdb, 0x57, 0xc3, 0x30, 0xd4, 0xdd,
    0x12, 0x8f, 0x12, 0x90, 0x7e, 0x4b, 0x95, 0x09,
    0x0e, 0xfa, 0xa2, 0xe3, 0x17, 0x07, 0xe9, 0x74,
    0xd8, 0x33, 0xa2, 0x42, 0x20, 0x00, 0x9a, 0x33,
    0xca, 0x70, 0x1c, 0xb9, 0x3f, 0x02, 0x6e, 0x78,
    0xa2, 0xca, 0x03, 0x00, 0xb8, 0x00, 0xed, 0x52,
    0xbb, 0x71, 0xb3, 0xd9, 0x0c, 0x00, 0x86, 0xad,
    0x64, 0x0d, 0x45, 0x76, 0xc7, 0x32, 0xb6, 0xd5,
    0xd3, 0x39, 0x2d, 0x89, 0x5e, 0x65, 0x4b, 0x60,
    0x6a, 0x82, 0x6a, 0xe5, 0xbd, 0x0c, 0x17, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xab, 0x9d,
    0xfd, 0xba, 0x74, 0x25, 0x29, 0x93, 0x9d, 0x2d,
    0x5d, 0xf4, 0x77, 0xec, 0x90, 0x2e, 0x13, 0xb8,
    0x21, 0x1a, 0x19, 0x70, 0x1e, 0x50, 0x2f, 0xf5,
    0x6e, 0x6e, 0x25, 0xae, 0x8c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xdd, 0xf4, 0x04, 0x74, 0xf0, 0x7a,
    0xe4, 0xe0, 0x79, 0xd1, 0xf1, 0x9f, 0xae, 0xbd,
    0xa8, 0xef, 0x1e, 0xfa, 0x18, 0xc2, 0x6a, 0x76,
    0xae, 0xa5, 0xaa, 0xbf, 0xc3, 0x4f, 0x12, 0x94,
    0x8c, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0x58,
    0xed, 0x0f, 0x31, 0x33, 0x45, 0x63, 0xc8, 0x8a,
    0xd5, 0x53, 0xd9, 0xe4, 0x6e, 0x20, 0x5d, 0x54,
    0x3b, 0x83, 0x99, 0xcf, 0x9b, 0xef, 0x9e, 0xa8,
    0xaa, 0xc5, 0xeb, 0xfb, 0x20, 0xa2, 0x05, 0x00,
    0xa4, 0x01, 0xec, 0x5d, 0x90, 0x0e, 0x5a, 0x79,
    0x58, 0x6d, 0x2c, 0xdb, 0xee, 0xc6, 0x22, 0x40,
    0xc6, 0x89, 0x9d, 0x37, 0x47, 0x5e, 0x0f, 0x46,
    0xbb, 0x9e, 0xfd, 0x3f, 0x5a, 0x4f, 0x32, 0xe8,
    0x27, 0xd2, 0x17, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x4b, 0x60, 0xd2, 0x27, 0x3e, 0x3c,
    0xce, 0x3b, 0xf6, 0xb0, 0x53, 0xcc, 0xb0, 0x06,
    0x1d, 0x65, 0xbc, 0x86, 0x98, 0x76, 0x55, 0xbd,
    0xeb, 0xb3, 0xe7, 0x93, 0x3a, 0xaa, 0xd8, 0x35,
    0xc6, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xc2,
    0x98, 0xd8, 0x45, 0x39, 0xa1, 0xf4, 0xa0, 0x33,
    0xeb, 0x2d, 0x81, 0x7d, 0x03, 0x77, 0xf2, 0x40,
    0xa4, 0x63, 0xe5, 0xe6, 0xbc, 0xf8, 0x47, 0x42,
    0x2c, 0xe1, 0xf2, 0xd1, 0x17, 0x6b, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf5, 0x51, 0xbf, 0x37, 0x68, 0x40,
    0xb6, 0xcb, 0xce, 0x5e, 0x31, 0x6b, 0x57, 0x33,
    0xce, 0x2b, 0x16, 0x9e, 0x0f, 0x7c, 0x4a, 0xeb,
    0xe7, 0x8e, 0x9b, 0x7f, 0x1a, 0xfe, 0xe2, 0x42,
    0xe3, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x25,
    0x63, 0xfc, 0xc2, 0xca, 0xb9, 0xf3, 0x84, 0x9e,
    0x17, 0xa7, 0xad, 0xfa, 0xe6, 0xbc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x53, 0x41, 0xe6, 0xb2, 0x64, 0x69,
    0x79, 0xa7, 0x0e, 0x57, 0x65, 0x30, 0x07, 0xa1,
    0xf3, 0x10, 0x16, 0x94, 0x21, 0xec, 0x9b, 0xdd,
    0x9f, 0x1a, 0x56, 0x48, 0xf7, 0x5a, 0xde, 0x00,
    0x5a, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x53, 0x41,
    0xe6, 0xb2, 0x64, 0x69, 0x79, 0xa7, 0x0e, 0x57,
    0x65, 0x30, 0x07, 0xa1, 0xf3, 0x10, 0x16, 0x94,
    0x21, 0xec, 0x9b, 0xdd, 0x9f, 0x1a, 0x56, 0x48,
    0xf7, 0x5a, 0xde, 0x00, 0x5a, 0xf1, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x90, 0x01, 0xd7, 0xb7, 0xf6, 0x53, 0x2b, 0xf4,
    0xa3, 0x4f, 0x4f, 0x41, 0x90, 0xfe, 0xad, 0x55,
    0x1c, 0xe6, 0x2a, 0xba, 0x54, 0x08, 0xe5, 0x30,
    0x60, 0xe6, 0x36, 0x1c, 0x35, 0x6a, 0x77, 0x1d,
    0xc7, 0x7b, 0x20, 0x00, 0x00, 0x00, 0x17, 0x00,
    0x00, 0x00, 0xce, 0xd6, 0xb5, 0xfe, 0xbc, 0x99,
    0x3f, 0x0c, 0x9b, 0x05, 0xfa, 0x6e, 0xf0, 0x9b,
    0x42, 0x6f, 0x18, 0x98, 0xf6, 0x10, 0x53, 0x53,
    0x86, 0xa3, 0x74, 0x55, 0x66, 0x76, 0x6f, 0x17,
    0x71, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xce,
    0xf4, 0x5f, 0x49, 0xfd, 0xcc, 0xd0, 0x87, 0xe3,
    0x50, 0x1d, 0x75, 0x26, 0xb8, 0x65, 0x81, 0x67,
    0xbd, 0xac, 0x68, 0x4b, 0x6f, 0x4f, 0xb0, 0x99,
    0x00, 0xab, 0x91, 0x55, 0x61, 0x3e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x30, 0x46,
    0x02, 0x21, 0x00, 0x92, 0xa1, 0xf8, 0x3a, 0xd4,
    0x45, 0x57, 0xcb, 0x82, 0x0f, 0x2f, 0x07, 0x0f,
    0xaf, 0x87, 0xe5, 0x1c, 0x82, 0x9d, 0x85, 0x29,
    0x28, 0xab, 0x9e, 0xaa, 0x0d, 0x23, 0x31, 0x9e,
    0xa8, 0x25, 0x5e, 0x02, 0x21, 0x00, 0x8d, 0x98,
    0x5c, 0xba, 0x0c, 0x62, 0x39, 0xa5, 0x31, 0xcf,
    0x20, 0xc0, 0x14, 0xa9, 0x57, 0x29, 0xb7, 0x62,
    0xd7, 0x75, 0x5a, 0xd6, 0x8c, 0xf8, 0x20, 0xdd,
    0x93, 0xf6, 0x45, 0xa0, 0x59, 0x53, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

const static dword setup_sequence_rsp5[] = {
    0x00, 0x00, 0xef, 0x00, 0x40, 0x00, 0x00, 0x10,
    0x10, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00
};

const static byte setup_sequence_msg6[] = {
    0x08, 0x5c, 0x20, 0x00, 0x80, 0x07, 0x00, 0x00,
    0x00, 0x04
};
const static dword setup_sequence_rsp6[] = { 0x00, 0x00 };

const static byte setup_sequence_msg7[] = {
    0x07, 0x80, 0x20, 0x00, 0x80, 0x04,
};
const static dword setup_sequence_rsp7[] = {
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
};

const static byte setup_sequence_msg8[] = { 0x75 };
const static dword setup_sequence_rsp8[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x71, 0x00
};

const static byte setup_sequence_config_data[] = {
    0x06, 0x02, 0x00, 0x00, 0x01, 0x5f, 0xb8, 0xa0,
    0xb6, 0x2c, 0x11, 0x2e, 0x78, 0x2a, 0x5a, 0xc3,
    0x75, 0x8e, 0xbf, 0x97, 0x74, 0xaa, 0x48, 0x77,
    0xf5, 0xeb, 0x25, 0xb0, 0x52, 0xa2, 0xf4, 0x6a,
    0x03, 0x76, 0xd3, 0x15, 0xab, 0xdc, 0x3d, 0x13,
    0x84, 0xe0, 0xbf, 0xc0, 0x6c, 0x6e, 0x3f, 0x5b,
    0x1d, 0x6f, 0x69, 0xe8, 0x25, 0xc5, 0x5d, 0xa9,
    0xc9, 0x0e, 0x9a, 0x2d, 0x42, 0x7d, 0xf6, 0xbc,
    0x6f, 0xc3, 0xd1, 0x34, 0x4d, 0x11, 0x97, 0x3f,
    0x80, 0xa2, 0x89, 0x0d, 0x7c, 0xd4, 0x81, 0x7b,
    0xf9, 0x7b, 0x97, 0x75, 0xc4, 0x9b, 0xa3, 0xca,
    0xaa, 0x3d, 0x4f, 0x05, 0xf7, 0xee, 0x2d, 0xef,
    0xd8, 0xe2, 0x5f, 0x4d, 0x5f, 0x3a, 0x82, 0xb2,
    0xc9, 0x6f, 0x38, 0x7b, 0xfe, 0xa1, 0x73, 0xdc,
    0x91, 0x1b, 0x11, 0x4d, 0x2c, 0x6f, 0xbc, 0x85,
    0x12, 0xb3, 0xa3, 0xb7, 0x4c, 0xd5, 0x35, 0x45,
    0xa8, 0x38, 0x2e, 0x81, 0x10, 0x16, 0x73, 0xfc,
    0xed, 0x84, 0xc4, 0xd5, 0xc0, 0xf4, 0x9e, 0xe3,
    0xda, 0x45, 0x39, 0x0e, 0x22, 0xb0, 0x02, 0x7e,
    0x67, 0x05, 0x9d, 0x7a, 0x3c, 0xb2, 0x79, 0x0e,
    0x8c, 0x8a, 0x8d, 0x88, 0x77, 0x5a, 0x86, 0x44,
    0x2f, 0xbd, 0x23, 0x18, 0xbb, 0x05, 0x05, 0x9c,
    0x65, 0x54, 0xc8, 0x3c, 0x6f, 0xac, 0xfd, 0x02,
    0xe8, 0x29, 0x8b, 0x52, 0x42, 0xbe, 0x9b, 0xd7,
    0x49, 0xfd, 0x6a, 0x3c, 0x36, 0x9f, 0xa8, 0x65,
    0x09, 0xfb, 0xda, 0x03, 0x97, 0x60, 0x62, 0x40,
    0xb9, 0x3c, 0xda, 0x3c, 0x47, 0x3c, 0x13, 0x68,
    0xeb, 0x54, 0xe0, 0x82, 0xdb, 0xa0, 0x26, 0x8a,
    0x53, 0xb7, 0xcd, 0x76, 0xb8, 0x7d, 0x94, 0x84,
    0x78, 0x93, 0xff, 0xb2, 0xa5, 0x07, 0xe5, 0x47,
    0x6a, 0x8d, 0x8f, 0x46, 0x13, 0x92, 0x73, 0x45,
    0xb6, 0xe1, 0x4e, 0x0e, 0xe8, 0xe8, 0x2f, 0xcd,
    0x3b, 0x59, 0x57, 0xc9, 0x3d, 0xc9, 0xaa, 0xd2,
    0x22, 0x06, 0x30, 0x00, 0x30, 0xfe, 0x04, 0x19,
    0x23, 0x9f, 0x1b, 0xed, 0x78, 0x47, 0x75, 0xa2,
    0x9b, 0xde, 0xd4, 0x70, 0x45, 0x23, 0xfb, 0x63,
    0x48, 0x13, 0x57, 0x30, 0xea, 0xd8, 0x3e, 0xf9,
    0x26, 0x1b, 0x18, 0xfe, 0x70, 0xb2, 0x79, 0x16,
    0x47, 0x80, 0x13, 0xa1, 0x9a, 0x67, 0xf1, 0x1f,
    0x7e, 0xe2, 0x05, 0x43, 0xc4, 0xaf, 0x3d, 0x34,
    0xdc, 0x05, 0x7d, 0x41, 0x82, 0x5c, 0xba, 0xc6,
    0xd0, 0x0c, 0xf8, 0x77, 0xde, 0xf1, 0x68, 0xc3,
    0xf7, 0xde, 0x59, 0x4f, 0xb7, 0x80, 0x78, 0x4c,
    0xfa, 0x27, 0x41, 0x3a, 0xe1, 0x5a, 0x4d, 0x38,
    0x7d, 0x74, 0x52, 0xc0, 0x7f, 0xbb, 0x73, 0xf2,
    0x5e, 0x58, 0xb1, 0x14, 0x77, 0x61, 0xd1, 0x4a,
    0x80, 0xda, 0x4d, 0x0a, 0xf5, 0x6a, 0x38, 0xfc,
    0x52, 0xbb, 0x1e, 0x6f, 0x24, 0x72, 0x14, 0xc8,
    0x23, 0x2a, 0x11, 0xd9, 0x93, 0xf2, 0x5e, 0xac,
    0x40, 0x10, 0x71, 0xd1, 0x4d, 0x76, 0xa9, 0x8c,
    0x82, 0x90, 0x6f, 0x4b, 0x75, 0x63, 0x3a, 0xd8,
    0x52, 0x2d, 0xb3, 0xb8, 0x37, 0x63, 0xbb, 0x71,
    0xbe, 0xd1, 0x91, 0x49, 0x4e, 0x88, 0xf5, 0x5f,
    0xce, 0xf6, 0x50, 0xda, 0xc3, 0xd2, 0xa7, 0xc8,
    0xa6, 0x0f, 0x2d, 0x6b, 0xed, 0x07, 0x6f, 0xbc,
    0x5f, 0x87, 0xa4, 0x9d, 0xd8, 0xa9, 0x70, 0x00,
    0x47, 0x3b, 0xa2, 0x05, 0x97, 0xd1, 0x07, 0x96,
    0x69, 0x10, 0xd5, 0xf3, 0x2d, 0xdd, 0xbb, 0xb8,
    0xfd, 0x09, 0x64, 0xa8, 0x2c, 0x40, 0x83, 0x1c,
    0xcd, 0x50, 0x95, 0xe6, 0xb5, 0x48, 0xc7, 0x38,
    0x13, 0x1c, 0xfb, 0xdb, 0x38, 0xb8, 0xc9, 0x1a,
    0xa3, 0xd9, 0x53, 0x24, 0xe1, 0x61, 0xf8, 0x10,
    0xe1, 0x95, 0x50, 0x7d, 0xd8, 0x0e, 0xe7, 0x72,
    0x26, 0x6e, 0x30, 0xf9, 0x21, 0xd6, 0x41, 0x57,
    0xeb, 0xd7, 0x2c, 0x98, 0xcc, 0x17, 0x22, 0xd9,
    0x63, 0xa5, 0x20, 0xda, 0x6e, 0xfa, 0xfe, 0xac,
    0x37, 0x82, 0x4f, 0xd2, 0xb1, 0x6d, 0x99, 0x85,
    0xb1, 0x24, 0xaa, 0xbc, 0x6b, 0x43, 0x91, 0x28,
    0x3f, 0x2a, 0xa2, 0x23, 0xc7, 0x51, 0x8d, 0x12,
    0xef, 0xee, 0x01, 0xc8, 0x60, 0xcc, 0x66, 0xfc,
    0x13, 0xbc, 0x42, 0x94, 0x88, 0x9a, 0xcc, 0x17,
    0x69, 0x72, 0x07, 0xe7, 0xe8, 0x48, 0x6f, 0x45,
    0x83, 0x53, 0x96, 0x63, 0x79, 0x79, 0xc0, 0x4d,
    0x0d, 0xa2, 0x29, 0x07, 0xa8, 0x3a, 0x08, 0x5e,
    0x82, 0x08, 0x16, 0xe3, 0x62, 0x6e, 0x09, 0x13,
    0x3c, 0xdb, 0x36, 0x32, 0xfa, 0x4a, 0x97, 0xc3,
    0xcf, 0x30, 0xfa, 0xe1, 0x4c, 0xd8, 0xad, 0x56,
    0x2d, 0x01, 0xb6, 0x1e, 0xe2, 0x5b, 0xbb, 0xb7,
    0x03, 0xa1, 0xbd, 0x17, 0x83, 0x1b, 0x1b, 0xc1,
    0x92, 0x4c, 0x11, 0x79, 0x83, 0x51, 0x06, 0xd3,
    0x6b, 0xfd, 0x6e, 0xdf, 0xb6, 0xdd, 0xb1, 0x4b,
    0x2d, 0xad, 0x8f, 0xb5, 0x53, 0x55, 0x8e, 0xf1,
    0x40, 0x37, 0x08, 0x1c, 0xe9, 0x65, 0xb9, 0xbb,
    0xaa, 0xb7, 0x4f, 0x98, 0x4b, 0x79, 0xb4, 0x3c,
    0x26, 0x6a, 0xe3, 0xcb, 0x5e, 0xe3, 0xc2, 0x83,
    0x19, 0xff, 0x1c, 0x67, 0x51, 0x6e, 0x93, 0xe8,
    0x9f, 0x0f, 0x30, 0xc2, 0x27, 0x91, 0xb7, 0xf4,
    0xc2, 0xf4, 0x0b, 0x26, 0xb1, 0xa1, 0x6f, 0x97,
    0xf9, 0xdc, 0x6b, 0x12, 0x74, 0x44, 0x11, 0x33,
    0xa6, 0x25, 0x98, 0xd5, 0x5b, 0x13, 0x74, 0xea,
    0xa1, 0xa8, 0xa0, 0xca, 0xbd, 0x33, 0xdb, 0x3d,
    0xe9, 0xea, 0x76, 0xd2, 0xe1, 0x8e, 0xd5, 0x38,
    0x5d, 0x3f, 0x28, 0xc2, 0x7e, 0xcf, 0x1e, 0x5a,
    0x39, 0xc6, 0x0e, 0xb7, 0x64, 0xe0, 0x2c, 0x27,
    0xf3, 0x69, 0xa5, 0xe6, 0x90, 0xd2, 0xd4, 0xb4,
    0x36, 0x76, 0x6d, 0xe5, 0x99, 0xe8, 0x50, 0xb8,
    0x92, 0x02, 0x5d, 0xb3, 0x0e, 0xc9, 0x24, 0x39,
    0x68, 0x06, 0xb6, 0x1e, 0xe7, 0x77, 0x57, 0xb3,
    0x7b, 0x75, 0x0d, 0x4a, 0x13, 0x42, 0xb2, 0xfa,
    0x68, 0x42, 0x5e, 0x88, 0x65, 0xe8, 0xa1, 0x22,
    0x10, 0xde, 0xa0, 0xd0, 0x81, 0x52, 0x76, 0xfc,
    0x40, 0xdf, 0xef, 0xf6, 0x15, 0xfe, 0x08, 0x28,
    0x3f, 0x33, 0xfc, 0x4a, 0x4a, 0x0d, 0x2a, 0x98,
    0x28, 0x8a, 0x1d, 0xaf, 0xed, 0xce, 0xdd, 0x05,
    0xa2, 0x87, 0xdf, 0xc5, 0x1a, 0xf0, 0x9e, 0xc3,
    0x38, 0xbd, 0x81, 0x32, 0x24, 0x75, 0xde, 0x91,
    0xb9, 0x86, 0x92, 0x5d, 0x6e, 0xb7, 0x47, 0x65,
    0x11, 0xe5, 0xbf, 0xb1, 0xa5, 0x35, 0x6f, 0x4c,
    0x0d, 0x02, 0x9d, 0xea, 0x93, 0x5b, 0xa3, 0x42,
    0xcf, 0xd1, 0xfe, 0xba, 0xa4, 0xb0, 0xdc, 0x6b,
    0x4e, 0xf1, 0x64, 0x39, 0x16, 0xf9, 0x46, 0x89,
    0x7f, 0xb9, 0xdb, 0x50, 0xcd, 0xff, 0x27, 0x8e,
    0x93, 0x76, 0xae, 0x0e, 0xe3, 0xb6, 0x06, 0xf5,
    0x94, 0x3d, 0x14, 0x95, 0x7c, 0x7e, 0x26, 0x38,
    0xfc, 0x09, 0xbe, 0x54, 0x1e, 0x0e, 0xf5, 0x7f,
    0xba, 0x11, 0x9f, 0x21, 0xb4, 0x61, 0x7b, 0xef,
    0x9f, 0x24, 0x48, 0x5d, 0x21, 0x12, 0xc2, 0x68,
    0x84, 0xe6, 0xa1, 0xbc, 0xa9, 0x83, 0x56, 0x9c,
    0x8a, 0x40, 0x26, 0xa1, 0x20, 0xe6, 0x1f, 0x25,
    0xdc, 0x76, 0x02, 0x69, 0x20, 0x0e, 0x93, 0x39,
    0xdb, 0x7b, 0x94, 0x4d, 0x15, 0x8f, 0x87, 0x9d,
    0x4a, 0x69, 0x99, 0x89, 0x72, 0x53, 0xa4, 0x3b,
    0x1c, 0x06, 0x57, 0x27, 0xbf, 0x53, 0x8e, 0xd2,
    0x13, 0xc9, 0x1c, 0x1d, 0x0a, 0x8e, 0x3d, 0xe1,
    0xa3, 0xe7, 0x71, 0x47, 0xcb, 0xd7, 0x77, 0xed,
    0x22, 0x35, 0x87, 0x70, 0xfe, 0x7b, 0x6b, 0x3b,
    0x56, 0x8a, 0xfa, 0xd3, 0xb5, 0xec, 0xf0, 0xa3,
    0x86, 0xd0, 0x92, 0x39, 0x23, 0xca, 0x51, 0x7b,
    0x8c, 0xb5, 0xde, 0x3b, 0x42, 0xbc, 0x5d, 0xd1,
    0x1a, 0x7b, 0x02, 0x58, 0x9c, 0xb2, 0x79, 0x64,
    0x62, 0xe7, 0xdc, 0xfd, 0x39, 0xe9, 0xb7, 0xc1,
    0x98, 0xc3, 0x0f, 0x08, 0x17, 0x66, 0x10, 0x8e,
    0x9f, 0xc6, 0xf9, 0xe9, 0xb7, 0x01, 0xde, 0x21,
    0x1b, 0xa0, 0x98, 0x2b, 0x4f, 0xd4, 0xb6, 0x17,
    0x26, 0xa5, 0x02, 0x5e, 0xba, 0x49, 0xfc, 0x55,
    0x50, 0xf0, 0xd7, 0xcd, 0xc4, 0xd1, 0x34, 0xe6,
    0x05, 0xcb, 0xd3, 0xbc, 0xff, 0x90, 0x43, 0x67,
    0xb3, 0x30, 0x83, 0xb0, 0x57, 0x55, 0xbb, 0xf9,
    0x6f, 0x32, 0xf0, 0xb8, 0x47, 0xde, 0x23, 0xa9,
    0x0d, 0x39, 0xd0, 0xf7, 0x31, 0x4c, 0x89, 0x57,
    0xcc, 0xb9, 0x5c, 0xd3, 0x22, 0xad, 0x57, 0x54,
    0x92, 0xd6, 0x47, 0x00, 0x70, 0x4f, 0xaf, 0x75,
    0x5e, 0x50, 0x04, 0xfe, 0xc2, 0xfb, 0xa1, 0x14,
    0xa1, 0xeb, 0x40, 0x0f, 0xbd, 0x5a, 0x6a, 0xad,
    0x1c, 0x02, 0x35, 0x64, 0xdf, 0x86, 0xae, 0x72,
    0x59, 0xfb, 0xfd, 0x6f, 0x0f, 0x50, 0x10, 0xa4,
    0x5c, 0x4d, 0x31, 0x35, 0x5d, 0xcb, 0x85, 0xb2,
    0x22, 0xd7, 0x36, 0xd2, 0x36, 0xf1, 0xf1, 0x30,
    0x1c, 0x18, 0x2d, 0x04, 0x8f, 0xa8, 0xe1, 0xd2,
    0x83, 0x9c, 0xf7, 0x4c, 0xf0, 0x8b, 0x3c, 0xfd,
    0x31, 0x55, 0x47, 0xfc, 0xc1, 0x3e, 0x83, 0xe4,
    0x52, 0x59, 0xb9, 0x9d, 0x41, 0x58, 0xf4, 0x49,
    0x94, 0x92, 0x27, 0xb0, 0xd4, 0xb4, 0x55, 0x1a,
    0x32, 0x9d, 0xe0, 0x92, 0x3c, 0x1d, 0xd5, 0x16,
    0xa2, 0xbf, 0x64, 0x12, 0xa6, 0x70, 0x38, 0x21,
    0x28, 0xe8, 0xcb, 0x91, 0xa6, 0xa5, 0x89, 0xee,
    0xad, 0x05, 0xb9, 0x8a, 0xbc, 0xf2, 0x1f, 0x4f,
    0x50, 0xdb, 0x2e, 0x85, 0xf6, 0xfb, 0x0a, 0x47,
    0x9b, 0x70, 0xa9, 0x88, 0x02, 0xac, 0x65, 0xf1,
    0x74, 0xa9, 0xbe, 0xf5, 0x42, 0x40, 0x5b, 0x30,
    0xf4, 0x0e, 0x2e, 0x44, 0x15, 0x81, 0x64, 0x36,
    0x0d, 0x7f, 0xba, 0xfb, 0x86, 0x21, 0x17, 0xb4,
    0x57, 0xf5, 0x4e, 0xe7, 0xa9, 0x30, 0x09, 0xff,
    0xb0, 0x64, 0x62, 0x43, 0x14, 0xb7, 0xca, 0xc4,
    0xe9, 0xf8, 0xfc, 0xb4, 0xc7, 0x99, 0x39, 0xdf,
    0x1e, 0xd6, 0xed, 0x4a, 0xf4, 0xbf, 0x5a, 0x13,
    0x68, 0x0a, 0x11, 0xde, 0x21, 0xab, 0xbb, 0x1f,
    0xa3, 0x2b, 0x19, 0x6a, 0x4f, 0x33, 0xd6, 0x84,
    0xae, 0xaf, 0xbb, 0x8d, 0x9c, 0x3d, 0xcc, 0x5e,
    0x73, 0x6e, 0x48, 0x27, 0x4d, 0x84, 0xd8, 0x0b,
    0x4b, 0x23, 0xa6, 0x29, 0x11, 0x13, 0x7b, 0x5b,
    0xcf, 0xf9, 0x62, 0x69, 0x11, 0x80, 0x2a, 0x43,
    0x33, 0x5a, 0x90, 0xbc, 0x79, 0x31, 0x01, 0x54,
    0xb7, 0xff, 0x39, 0xa4, 0x72, 0xcd, 0x4a, 0x35,
    0x39, 0x04, 0x9f, 0x7b, 0xed, 0x9e, 0x60, 0x75,
    0x86, 0x66, 0x7b, 0x2f, 0x6c, 0xdc, 0xda, 0x38,
    0x0c, 0x81, 0x74, 0x9c, 0x5f, 0xd9, 0xee, 0x67,
    0xf6, 0x11, 0xc9, 0x6d, 0x2e, 0x47, 0xbe, 0x90,
    0x73, 0x01, 0x16, 0x63, 0x80, 0x95, 0x34, 0x4d,
    0xb7, 0x52, 0x11, 0x8c, 0xa1, 0xf8, 0x1d, 0x2d,
    0x18, 0xa4, 0x57, 0xb2, 0x25, 0x12, 0x2f, 0xbd,
    0x0b, 0x69, 0x50, 0x8e, 0xd4, 0x8a, 0x45, 0x55,
    0x61, 0x4e, 0x5f, 0xeb, 0x03, 0xef, 0xf2, 0x60,
    0xdd, 0x88, 0xfa, 0x43, 0x91, 0x65, 0xcb, 0x10,
    0x07, 0xa9, 0xc9, 0x9a, 0x46, 0xf0, 0xc4, 0x18,
    0xc4, 0x76, 0x4a, 0x03, 0x99, 0x14, 0x05, 0x3c,
    0xfc, 0xbe, 0x37, 0xa4, 0xae, 0x32, 0x93, 0x97,
    0x6b, 0x93, 0xe2, 0x71, 0x82, 0xdd, 0x97, 0xd5,
    0xf3, 0x38, 0xbb, 0x90, 0x7e, 0x37, 0x08, 0x5d,
    0x65, 0xa2, 0x4c, 0x0f, 0xe4, 0x9c, 0xe7, 0x1a,
    0x2b, 0x41, 0x33, 0xd8, 0xa2, 0xbf, 0x24, 0x34,
    0x68, 0xed, 0x9e, 0x43, 0x21, 0x09, 0xd0, 0x6b,
    0x0a, 0x23, 0xe4, 0x36, 0xb1, 0x0e, 0xa7, 0x1b,
    0xa7, 0xc1, 0x00, 0x1d, 0xd8, 0xea, 0x09, 0x32,
    0x80, 0x28, 0x11, 0x97, 0xf9, 0xa4, 0x13, 0xa1,
    0xd1, 0x96, 0x4e, 0xa0, 0x10, 0xed, 0x20, 0x23,
    0x43, 0xe0, 0xbb, 0x77, 0x41, 0x3b, 0x3e, 0xfb,
    0x86, 0x64, 0x2a, 0x58, 0x1c, 0xd2, 0x02, 0x0a,
    0xf8, 0xdf, 0x3c, 0x9b, 0x5b, 0xf8, 0x9e, 0x3a,
    0x5d, 0xd8, 0x5e, 0x95, 0x9d, 0x7b, 0xf4, 0xee,
    0x09, 0xaf, 0xc5, 0xba, 0x87, 0x90, 0xc4, 0xa4,
    0xd0, 0x71, 0xe1, 0x25, 0xab, 0x01, 0xe4, 0xe6,
    0x38, 0xc4, 0xda, 0x27, 0xd5, 0xfd, 0x11, 0xf8,
    0xf3, 0x78, 0xd6, 0x5d, 0x76, 0x99, 0x28, 0x6d,
    0xde, 0x97, 0xb4, 0x3c, 0x37, 0xc3, 0x32, 0xa1,
    0xc4, 0x0c, 0xc4, 0x95, 0x6a, 0xce, 0x81, 0x20,
    0xfb, 0x05, 0xe5, 0xf8, 0x03, 0x38, 0xda, 0xdb,
    0x41, 0x1b, 0x5b, 0x27, 0x71, 0x03, 0xa5, 0x92,
    0x18, 0x88, 0x77, 0x94, 0xb5, 0x8b, 0x82, 0x50,
    0x12, 0xef, 0x68, 0xe3, 0x51, 0xc4, 0xb7, 0x27,
    0xbf, 0x58, 0x8c, 0x75, 0x63, 0x88, 0xdd, 0xfc,
    0xd8, 0x8a, 0x9d, 0xf6, 0xec, 0x9e, 0xd1, 0xc8,
    0x6a, 0x98, 0x39, 0x77, 0xe9, 0xf5, 0x2b, 0x5d,
    0x2b, 0x16, 0x7f, 0xae, 0x04, 0xd9, 0xf7, 0x8b,
    0xe7, 0x30, 0xd4, 0xdd, 0x80, 0x78, 0x11, 0xc4,
    0x26, 0x28, 0x28, 0xf2, 0x42, 0xbe, 0x0c, 0xa7,
    0xb4, 0xc0, 0x5d, 0x80, 0x54, 0x2b, 0x08, 0x29,
    0x30, 0x26, 0x5f, 0x57, 0xcc, 0xc4, 0x39, 0xea,
    0x39, 0xce, 0x42, 0xd7, 0x5e, 0x17, 0x6f, 0x1d,
    0xd5, 0xc8, 0x93, 0xe9, 0x58, 0x35, 0x1e, 0x43,
    0x93, 0xfa, 0x5c, 0x73, 0xd5, 0x44, 0x4d, 0x0d,
    0x93, 0x84, 0x72, 0x05, 0x38, 0x2e, 0x7b, 0x1c,
    0xe7, 0x4b, 0xf9, 0x33, 0xe3, 0xef, 0xc1, 0xbf,
    0x2c, 0x7b, 0xd4, 0xc9, 0xa2, 0x9b, 0x08, 0x5e,
    0xe0, 0x6b, 0x28, 0xec, 0x0d, 0xd7, 0x0e, 0xb7,
    0x6b, 0x9a, 0x0d, 0x29, 0x95, 0x39, 0xa2, 0x63,
    0x55, 0x64, 0x89, 0xec, 0xbc, 0x08, 0x08, 0x23,
    0x51, 0xd4, 0x7f, 0x19, 0x67, 0x3f, 0xbd, 0xd1,
    0x06, 0x9b, 0xd5, 0x91, 0x9b, 0x0c, 0xf8, 0x89,
    0xf4, 0x68, 0xce, 0x4d, 0xad, 0xba, 0x82, 0x2a,
    0xd4, 0x90, 0xc3, 0xc6, 0x7f, 0x0d, 0xc0, 0x89,
    0x74, 0x1b, 0x47, 0x6c, 0xfa, 0xc9, 0xe1, 0x3f,
    0xd5, 0xcb, 0xd6, 0x4c, 0xf0, 0xf3, 0x6d, 0x72,
    0x5b, 0x77, 0x60, 0xdb, 0x01, 0x27, 0x74, 0x41,
    0xc3, 0x23, 0x55, 0x44, 0x1d, 0x20, 0xb9, 0xb8,
    0x43, 0x9c, 0x2b, 0x5e, 0x44, 0xf0, 0x24, 0xb8,
    0x14, 0x67, 0x1b, 0x8a, 0xaa, 0x55, 0x57, 0xb3,
    0xf5, 0xb3, 0x22, 0xdd, 0xc8, 0x84, 0x88, 0x93,
    0xf8, 0x31, 0x12, 0x8a, 0xba, 0xea, 0x87, 0xf5,
    0x67, 0xe8, 0x86, 0xd4, 0x8b, 0xf5, 0xb9, 0x24,
    0xe8, 0x6c, 0xfa, 0x6f, 0x87, 0x7b, 0x68, 0x9a,
    0xf0, 0x8a, 0xc3, 0x3b, 0x3c, 0x15, 0x91, 0x60,
    0x46, 0x2d, 0x37, 0xf1, 0x16, 0xd1, 0x7f, 0xbc,
    0xec, 0xdf, 0xd8, 0xfc, 0xed, 0xa7, 0x99, 0x03,
    0x97, 0xe8, 0x88, 0x2b, 0xdf, 0x84, 0x26, 0x71,
    0xcf, 0x80, 0x0e, 0x90, 0xdb, 0x6d, 0x2c, 0x42,
    0xfd, 0x9f, 0xe9, 0x36, 0x57, 0x54, 0xad, 0x3a,
    0x65, 0x15, 0x40, 0x2c, 0xfd, 0xd7, 0xc5, 0x0f,
    0x07, 0x9f, 0x0b, 0x79, 0xd8, 0xb7, 0x70, 0x26,
    0x11, 0x80, 0xdc, 0x39, 0xcb, 0x94, 0x25, 0x0a,
    0x9b, 0xbc, 0x48, 0x36, 0xcf, 0xff, 0x6c, 0xef,
    0xa8, 0xf9, 0x01, 0x21, 0x98, 0x36, 0xe5, 0x38,
    0xfc, 0x74, 0x9f, 0xd3, 0xb3, 0x62, 0xbe, 0xc8,
    0xf4, 0x4e, 0xf3, 0xd2, 0x72, 0x3a, 0xef, 0x20,
    0xb4, 0x42, 0x3a, 0x94, 0xab, 0x0c, 0x7c, 0x81,
    0x86, 0xce, 0xc5, 0xe9, 0x3e, 0xcb, 0x75, 0xec,
    0x90, 0x9d, 0x8b, 0x81, 0xeb, 0x76, 0x94, 0x66,
    0xff, 0xaa, 0xd5, 0xaf, 0xf2, 0x97, 0x22, 0x07,
    0x3e, 0x78, 0x55, 0xde, 0x1a, 0x2c, 0xdf, 0x53,
    0x91, 0x48, 0x44, 0x2a, 0x9c, 0x70, 0x2f, 0x65,
    0xa3, 0x43, 0x9c, 0x1d, 0x09, 0x5a, 0x95, 0x5f,
    0xbf, 0x58, 0xb6, 0xc9, 0xc2, 0x34, 0xca, 0x6d,
    0xea, 0x3a, 0x69, 0xcd, 0x4d, 0xd4, 0x48, 0x2f,
    0xe8, 0x70, 0x3b, 0xe0, 0x0b, 0x88, 0x4c, 0x8c,
    0xee, 0xbc, 0xd2, 0xe2, 0x65, 0x65, 0xa5, 0xc9,
    0x69, 0xd5, 0x28, 0xa5, 0x91, 0x52, 0xf1, 0x6b,
    0x8d, 0xcb, 0x56, 0x08, 0xc3, 0x00, 0xc3, 0x46,
    0xa5, 0xdf, 0x50, 0x12, 0x32, 0x97, 0xc0, 0x35,
    0x90, 0xdb, 0x28, 0x18, 0xf4, 0x36, 0xab, 0x8e,
    0xb1, 0x3e, 0x91, 0xc9, 0xba, 0x0e, 0x6b, 0x0c,
    0xb2, 0x8d, 0x87, 0x2e, 0xeb, 0xe1, 0xa5, 0x83,
    0x71, 0x32, 0x44, 0x76, 0x13, 0xed, 0xcd, 0x68,
    0x19, 0x8d, 0x96, 0x7d, 0x12, 0xb3, 0x3f, 0x14,
    0xa0, 0xae, 0x56, 0xc7, 0xc3, 0xd4, 0x46, 0xf0,
    0xb0, 0xde, 0x6e, 0xdb, 0x7c, 0xa8, 0x79, 0xdb,
    0x2d, 0x6e, 0xb6, 0x61, 0x6c, 0x7c, 0x2a, 0x87,
    0x19, 0x21, 0x94, 0x74, 0x3c, 0x69, 0xb0, 0x0c,
    0x62, 0xde, 0x83, 0x81, 0xe9, 0x79, 0xb6, 0x5c,
    0x62, 0xa0, 0x8d, 0xd1, 0x83, 0xac, 0x73, 0x0e,
    0x0f, 0xcd, 0x18, 0x89, 0x03, 0xe7, 0x3b, 0x17,
    0x69, 0x0e, 0x84, 0x85, 0x45, 0x1c, 0x2d, 0x76,
    0x3b, 0x9b, 0x5d, 0x67, 0xf5, 0x47, 0x62, 0xf2,
    0x97, 0x4a, 0x49, 0x27, 0x7f, 0x17, 0x1a, 0x53,
    0x61, 0xc3, 0x8a, 0x80, 0xa9, 0x7e, 0xc0, 0x3f,
    0xbc, 0x71, 0x86, 0x91, 0x56, 0x62, 0x84, 0x2c,
    0x46, 0x48, 0x5a, 0x56, 0xdb, 0x12, 0x2c, 0xfe,
    0xe3, 0xf1, 0xf5, 0x3d, 0xa7, 0xe9, 0xce, 0xfa,
    0x2c, 0x83, 0x9e, 0x0c, 0x80, 0x21, 0x8d, 0x7f,
    0xdb, 0x55, 0xef, 0xeb, 0x0e, 0xc0, 0xa3, 0xb5,
    0x60, 0xf1, 0x51, 0xe8, 0x51, 0x48, 0x97, 0x1e,
    0x4a, 0x14, 0xca, 0x8b, 0xff, 0xc2, 0xbe, 0xf9,
    0x87, 0x32, 0x8a, 0xc9, 0x9d, 0x54, 0x66, 0x04,
    0x24, 0x98, 0x25, 0x12, 0xff, 0x90, 0xd3, 0x04,
    0xb1, 0xdf, 0x8b, 0xf0, 0xac, 0x22, 0x15, 0x88,
    0x68, 0x90, 0x17, 0xa0, 0x98, 0x64, 0x0e, 0x98,
    0xfd, 0x19, 0xdb, 0x45, 0x9e, 0xed, 0x98, 0xa3,
    0x81, 0x49, 0xa5, 0x49, 0xf7, 0x31, 0x85, 0xc4,
    0x73, 0x55, 0x6d, 0x50, 0xc7, 0x2e, 0xdc, 0x10,
    0x53, 0x84, 0xbb, 0x52, 0x9b, 0xcb, 0x22, 0xf4,
    0x4d, 0xd5, 0xd3, 0xce, 0x73, 0xa9, 0x67, 0x28,
    0xf6, 0xae, 0xe4, 0xc6, 0x09, 0x9c, 0x09, 0x66,
    0x6a, 0x3f, 0xa9, 0x68, 0x69, 0x2b, 0xb0, 0xfd,
    0x8b, 0x51, 0x90, 0xd3, 0xd5, 0x17, 0xd9, 0x96,
    0x57, 0xdd, 0xd4, 0x41, 0x6d, 0x34, 0x42, 0xce,
    0xd3, 0xcd, 0xe0, 0xd4, 0x3e, 0xc6, 0x72, 0x61,
    0x84, 0xb4, 0x8a, 0x8a, 0x7b, 0xb9, 0x74, 0x17,
    0xf5, 0xba, 0xe6, 0xb5, 0x5c, 0x68, 0xb7, 0xbb,
    0xd3, 0x8e, 0x92, 0x97, 0x0f, 0x47, 0xd4, 0x11,
    0x1d, 0xf3, 0x6a, 0x98, 0x7b, 0x2d, 0x38, 0x39,
    0x1e, 0xab, 0x5a, 0xda, 0x3c, 0xf4, 0x57, 0x20,
    0xfb, 0xc4, 0x69, 0xc2, 0x49, 0xdf, 0xf1, 0x62,
    0x7f, 0xd6, 0xa9, 0x12, 0x3f, 0x33, 0x1c, 0x5f,
    0xb4, 0xd8, 0xb2, 0x84, 0x02, 0xb5, 0xaa, 0xcc,
    0x4b, 0x18, 0x6a, 0xda, 0x3d, 0x91, 0x08, 0x47,
    0xbf, 0x71, 0x58, 0xfe, 0x73, 0xdf, 0x1b, 0xcf,
    0xbe, 0x50, 0x75, 0x20, 0xf6, 0x4b, 0x87, 0xed,
    0x67, 0xd7, 0x4c, 0xa4, 0x40, 0xda, 0xde, 0xb7,
    0x65, 0xc4, 0x8d, 0x8c, 0xbd, 0x1e, 0x29, 0x69,
    0x97, 0x17, 0x2d, 0x48, 0x4f, 0x03, 0x8c, 0x3a,
    0x86, 0x3c, 0x06, 0x78, 0xbc, 0x43, 0x99, 0x61,
    0x32, 0x4e, 0xb8, 0x01, 0x34, 0xb7, 0x7e, 0x01,
    0xfa, 0x00, 0xf8, 0x44, 0xaa, 0x74, 0xf0, 0xf5,
    0xe2, 0x9a, 0xba, 0x0c, 0x96, 0x32, 0xf0, 0x6c,
    0x55, 0x14, 0x17, 0xf2, 0x02, 0x5f, 0x69, 0x8a,
    0x52, 0xd6, 0xdd, 0xd4, 0x1c, 0x50, 0x66, 0xa8,
    0x8f, 0x94, 0x1f, 0x45, 0xbd, 0x07, 0x84, 0x93,
    0x87, 0x03, 0xb1, 0x1b, 0x56, 0xe3, 0xdd, 0x62,
    0xe7, 0x16, 0x3c, 0x4b, 0x9b, 0x72, 0xff, 0x95,
    0xab, 0xa7, 0xb1, 0xd7, 0x41, 0x69, 0x55, 0xa5,
    0x32, 0x76, 0x7b, 0x85, 0xe7, 0x58, 0xce, 0x61,
    0xc6, 0xb5, 0x74, 0x79, 0x40, 0xec, 0x5a, 0x86,
    0x59, 0x24, 0xd0, 0x2c, 0x32, 0x69, 0xda, 0x8b,
    0x81, 0x1a, 0x85, 0x94, 0x69, 0xca, 0x3c, 0xf6,
    0x49, 0x67, 0x3a, 0xb3, 0xf8, 0x61, 0x28, 0xd8,
    0xaf, 0x89, 0x2e, 0x16, 0xa2, 0xdc, 0x2e, 0x87,
    0x08, 0xed, 0x8a, 0xde, 0xa7, 0xaa, 0x99, 0x4f,
    0xde, 0x34, 0xe5, 0x4f, 0xbc, 0xdb, 0x70, 0x8d,
    0xa3, 0xe1, 0x4a, 0xa3, 0x6b, 0xc2, 0xb1, 0xca,
    0x07, 0xd3, 0x03, 0x6e, 0x8a, 0x6f, 0x24, 0xb5,
    0x89, 0x22, 0x14, 0x7c, 0x41, 0xb2, 0x0e, 0x15,
    0x39, 0xd1, 0x1b, 0xa3, 0x73, 0x40, 0x94, 0x1a,
    0x9e, 0x49, 0x34, 0xa9, 0x4a, 0x58, 0xb8, 0x20,
    0xe2, 0xf6, 0x24, 0x52, 0x34, 0xe3, 0xb9, 0x01,
    0xfd, 0x9f, 0xe0, 0xa8, 0x91, 0xf4, 0x46, 0x27,
    0x22, 0xf9, 0x04, 0x7f, 0xca, 0x8a, 0xf6, 0x9c,
    0xbf, 0x63, 0x3f, 0x6a, 0x09, 0xa1, 0xbf, 0x76,
    0x74, 0xe0, 0x45, 0xa6, 0xdf, 0xd5, 0xfd, 0x27,
    0xf2, 0x11, 0x26, 0x0c, 0x6a, 0xa9, 0x63, 0xf6,
    0x23, 0x8e, 0x0f, 0xe5, 0x22, 0x19, 0x9b, 0xb1,
    0x83, 0x5e, 0x4d, 0x10, 0x3f, 0xae, 0xf7, 0x9e,
    0x2d, 0xfb, 0x5f, 0x88, 0xcb, 0xd5, 0x49, 0x28,
    0xbc, 0x12, 0xce, 0x24, 0xde, 0x99, 0x70, 0xcd,
    0xcd, 0x24, 0x43, 0xd0, 0x4c, 0x60, 0x6f, 0x7c,
    0xa7, 0x9c, 0x1a, 0xcd, 0xfb, 0x3b, 0x61, 0x2b,
    0xae, 0x2b, 0x15, 0xbb, 0x94, 0x65, 0x72, 0x52,
    0xd1, 0x0a, 0x2e, 0x94, 0xf3, 0x30, 0xcd, 0x10,
    0x44, 0x80, 0x10, 0xef, 0xee, 0x8b, 0x26, 0xd6,
    0xbf, 0x09, 0x13, 0x92, 0xce, 0x8e, 0x78, 0xa4,
    0xd9, 0xde, 0x8d, 0x08, 0x1f, 0xd6, 0x12, 0xd2,
    0x21, 0x6e, 0x3c, 0xce, 0x11, 0x99, 0x8e, 0xf0,
    0x4f, 0x76, 0x16, 0x3e, 0x7f, 0x2a, 0x43, 0xe9,
    0x5f, 0x5c, 0xa9, 0xdb, 0x1b, 0x78, 0xbd, 0x9f,
    0x31, 0x98, 0xac, 0xfe, 0xb1, 0xd0, 0x9b, 0xd9,
    0xdf, 0x86, 0x37, 0xde, 0x35, 0x2c, 0x12, 0xba,
    0x69, 0x52, 0xde, 0xae, 0x48, 0x7c, 0x52, 0x35,
    0x4a, 0xee, 0xa1, 0xe8, 0x5a, 0xd6, 0x9a, 0x35,
    0xd0, 0x3a, 0x13, 0xc8, 0x7a, 0x61, 0x87, 0xb5,
    0x8c, 0x00, 0xec, 0x35, 0x72, 0xf9, 0x19, 0x3c,
    0x0f, 0x41, 0x7d, 0x43, 0x09, 0x68, 0xaa, 0xa8,
    0xe3, 0xc8, 0x6e, 0x84, 0x4a, 0xca, 0x88, 0x09,
    0x36, 0x80, 0xf0, 0x86, 0x7c, 0x13, 0xa8, 0x8f,
    0xf6, 0xb2, 0x05, 0x5a, 0x90, 0xe0, 0xeb, 0x78,
    0x24, 0x40, 0xcd, 0x51, 0x64, 0x55, 0x2f, 0x38,
    0x7c, 0xcc, 0xfe, 0x9b, 0x82, 0xe4, 0xfd, 0x88,
    0x95, 0x5b, 0xa2, 0x69, 0x07, 0xa7, 0x5b, 0x49,
    0xb2, 0x16, 0xdc, 0x20, 0x46, 0x8a, 0x82, 0xde,
    0xf0, 0x9f, 0xc3, 0xc4, 0x36, 0x89, 0x05, 0x68,
    0xf8, 0xe0, 0x57, 0xca, 0xb9, 0x8f, 0x1f, 0xb0,
    0x54, 0x4c, 0xa5, 0xb0, 0x13, 0x66, 0x3c, 0x51,
    0xed, 0x94, 0xa5, 0x34, 0x73, 0x33, 0x23, 0x0e,
    0x13, 0x23, 0xdc, 0x27, 0xd3, 0xd6, 0xbd, 0xcb,
    0xf3, 0xdc, 0x8e, 0x35, 0x41, 0x9d, 0x18, 0x21,
    0x25, 0x6b, 0x70, 0xbc, 0xd4, 0x43, 0xde, 0xc4,
    0xfc, 0xba, 0x83, 0x4d, 0x20, 0x7c, 0x46, 0xbf,
    0xa6, 0x93, 0x22, 0x11, 0x5a, 0xbb, 0x26, 0xbd,
    0xdd, 0x0a, 0x33, 0x25, 0xeb, 0xe2, 0x0f, 0xbe,
    0x7e, 0xa7, 0x25, 0x1d, 0x02, 0x16, 0x4d, 0xa9,
    0x21, 0xa1, 0xe9, 0x22, 0xec, 0x78, 0x1a, 0x9a,
    0xcb, 0xe7, 0x8c, 0xc9, 0xd2, 0xc0, 0x16, 0x02,
    0x73, 0x6c, 0x0a, 0xb5, 0xef, 0x50, 0xc4, 0xe2,
    0xb7, 0x96, 0xf4, 0xe0, 0x2d, 0x23, 0x73, 0x9d,
    0x75, 0xb9, 0x72, 0x8a, 0x01, 0x36, 0x03, 0xb5,
    0x21, 0x57, 0xf2, 0x7d, 0x3e, 0x02, 0x4b, 0x88,
    0xba, 0x48, 0x35, 0x35, 0x84, 0x17, 0x02, 0xd1,
    0x75, 0x00, 0xbd, 0x75, 0x24, 0x25, 0xe8, 0xad,
    0x15, 0x76, 0x69, 0x95, 0x3e, 0x00, 0xe6, 0xa5,
    0x32, 0x3f, 0x43, 0x5e, 0xc0, 0xa1, 0xe7, 0xe8,
    0x52, 0xc1, 0xa9, 0x5f, 0x68, 0x84, 0x3a, 0x3b,
    0x81, 0xc7, 0x0b, 0x0d, 0x10, 0x2c, 0x37, 0xd2,
    0x5a, 0x9c, 0x5d, 0x3c, 0x4b, 0x56, 0xcc, 0xd2,
    0x62, 0x6b, 0xda, 0xf4, 0xc3, 0xc8, 0xf9, 0xad,
    0x3a, 0x98, 0x18, 0x82, 0x2c, 0xd7, 0x9e, 0x4b,
    0x6a, 0x78, 0x46, 0x74, 0x0d, 0x59, 0x94, 0x2f,
    0xd1, 0xd2, 0xa6, 0x21, 0x2c, 0x14, 0x02, 0x3c,
    0xa1, 0xde, 0xf1, 0x0b, 0x22, 0x49, 0xa1, 0x7a,
    0xe0, 0x10, 0xb8, 0x4c, 0xfc, 0x32, 0x24, 0x36,
    0x55, 0xab, 0xb7, 0xeb, 0xe0, 0x13, 0x40, 0xd2,
    0x43, 0x50, 0x75, 0xcd, 0x25, 0x9a, 0x3f, 0x00,
    0xc8, 0x9c, 0xd8, 0xcb, 0x93, 0x38, 0xb5, 0x2c,
    0x44, 0x4d, 0x22, 0x55, 0x20, 0xb1, 0xa3, 0xed,
    0x6e, 0x46, 0xe4, 0xef, 0x45, 0xe9, 0x20, 0x03,
    0x58, 0xef, 0xca, 0x65, 0x6c, 0x24, 0x21, 0x70,
    0x45, 0x68, 0xe3, 0x3d, 0xd7, 0x7d, 0xb9, 0xe0,
    0xa0, 0x01, 0xc6, 0xd4, 0x89, 0x5e, 0xc9, 0xfb,
    0x5a, 0x7c, 0x2c, 0x95, 0x12, 0x15, 0x33, 0x21,
    0x3c, 0xf8, 0xe4, 0xfb, 0xee, 0x92, 0xff, 0x76,
    0x81, 0x1c, 0x95, 0x86, 0xd7, 0x00, 0xec, 0x8c,
    0x94, 0x8b, 0x5c, 0x7e, 0xfb, 0x81, 0x48, 0x7a,
    0xe8, 0x57, 0x46, 0x89, 0x18, 0xcd, 0xe6, 0xe1,
    0x6c, 0x99, 0x7e, 0x5e, 0x0a, 0xb7, 0xc1, 0x7a,
    0x7f, 0x8a, 0x63, 0x98, 0x6b, 0x1c, 0x51, 0x39,
    0xf5, 0x24, 0xa2, 0x3a, 0x8b, 0x02, 0x21, 0xb2,
    0xb3, 0xf0, 0x22, 0x87, 0x19, 0x62, 0xd2, 0x3d,
    0xd1, 0x3e, 0x72, 0xfa, 0x07, 0xf5, 0x1e, 0x76,
    0x84, 0x7c, 0xb5, 0xf1, 0xc9, 0x23, 0x49, 0x9a,
    0xf7, 0xf0, 0x4d, 0x00, 0x3a, 0x5d, 0x30, 0x2f,
    0xd3, 0x3e, 0xa7, 0xe4, 0x33, 0x7c, 0xe6, 0xbf,
    0xf8, 0x3b, 0x29, 0xf0, 0x1b, 0xf5, 0xc2, 0x25,
    0x35, 0xcd, 0xde, 0xf0, 0x17, 0xe1, 0xae, 0xdf,
    0x2c, 0x5c, 0xa4, 0xda, 0x6c, 0xf9, 0x1b, 0x4c,
    0xc1, 0x3a, 0xc3, 0xd0, 0x05, 0xdf, 0xa9, 0x35,
    0x80, 0xac, 0xa1, 0x62, 0x05, 0x17, 0x22, 0xb7,
    0x1e, 0xfd, 0xcf, 0xd9, 0x90, 0x97, 0x4f, 0x92,
    0x39, 0xb4, 0x84, 0x5d, 0xdb, 0xe6, 0x29, 0x6d,
    0x4b, 0xaf, 0x9a, 0x78, 0xd6, 0xb4, 0x27, 0x78,
    0x3b, 0x6b, 0x43, 0x26, 0x7d, 0x09, 0x71, 0x3f,
    0x59, 0x7a, 0x50, 0x98, 0xf9, 0x0e, 0x3e, 0x1d,
    0x9c, 0x27, 0x8e, 0xc3, 0xc5, 0x55, 0xe7, 0xef,
    0xdd, 0x9f, 0x64, 0x86, 0x68, 0x2c, 0x31, 0x76,
    0xcc, 0x1e, 0x68, 0x86, 0x28, 0x81, 0x4f, 0x0f,
    0xb6, 0x6d, 0x3f, 0x02, 0xfb, 0x1b, 0x33, 0xda,
    0x7e, 0x06, 0x15, 0x38, 0xee, 0x50, 0x84, 0x6d,
    0xc6, 0x8c, 0x66, 0xd0, 0xeb, 0xcc, 0x3b, 0xbf,
    0x86, 0xc1, 0x38, 0x05, 0x43, 0x91, 0x5d, 0xa6,
    0xfb, 0xb1, 0x4d, 0x72, 0x6f, 0x82, 0x19, 0x98,
    0x79, 0x46, 0x06, 0x54, 0x31, 0x17, 0xeb, 0x19,
    0x73, 0x47, 0x78, 0x13, 0x76, 0x39, 0x99, 0x70,
    0x8c, 0x99, 0x3f, 0xe6, 0xda, 0xc4, 0xb0, 0x56,
    0xc0, 0xa6, 0x75, 0x50, 0x92, 0xb4, 0x33, 0xdc,
    0x37, 0x4d, 0x9d, 0x45, 0xc4, 0x60, 0x7f, 0x04,
    0x3e, 0xaf, 0xcd, 0x2c, 0x40, 0x93, 0x94, 0xec,
    0xc1, 0x96, 0xc2, 0xa2, 0x9d, 0xb6, 0x4b, 0xae,
    0x3f, 0xd9, 0x52, 0xa8, 0xf3, 0x63, 0xe3, 0x34,
    0xf0, 0x74, 0x45, 0xeb, 0xf6, 0xb1, 0x7c, 0x84,
    0x19, 0xf8, 0x4d, 0x41, 0xc6, 0x1e, 0xc0, 0x0e,
    0x88, 0x90, 0x49, 0xf2, 0x53, 0x18, 0x05, 0x9e,
    0xfd, 0xd4, 0x1f, 0xa4, 0x6e, 0xcc, 0x4d, 0xe3,
    0x20, 0x91, 0x16, 0x0a, 0x3b, 0x75, 0x30, 0x35,
    0x73, 0x14, 0x42, 0x79, 0x2e, 0x6c, 0xb3, 0x37,
    0x22, 0xbd, 0x52, 0xb7, 0xdf, 0xae, 0x5c, 0x80,
    0x1f, 0xb3, 0x08, 0xfd, 0x0d, 0x2e, 0x8a, 0x20,
    0xe8, 0xfc, 0x6b, 0x85, 0x35, 0xb4, 0x89, 0x6d,
    0x83, 0xb6, 0x8d, 0x71, 0x52, 0x7f, 0x1d, 0xf6,
    0x04, 0xac, 0xc2, 0xc0, 0x77, 0x29, 0xca, 0x30,
    0x0d, 0xcf, 0xe9, 0x58, 0x32, 0x9f, 0x83, 0x19,
    0xd5, 0x7d, 0xaf, 0xd0, 0xa8, 0x28, 0x95, 0xb8,
    0x29, 0x78, 0x58, 0x58, 0x66, 0xef, 0xc2, 0xcc,
    0x01, 0x8e, 0x6f, 0xd6, 0x4e, 0xb3, 0x65, 0x6d,
    0x86, 0xe6, 0x70, 0x7d, 0xd7, 0xce, 0x7b, 0x94,
    0xf6, 0x39, 0xa3, 0xad, 0x0e, 0x51, 0xe8, 0xea,
    0x9c, 0xc0, 0xb7, 0x71, 0x37, 0x52, 0x11, 0x09,
    0xbf, 0x66, 0x01, 0x62, 0x82, 0xdb, 0x7d, 0x64,
    0xcb, 0x0a, 0xa9, 0xa4, 0x1d, 0x34, 0x15, 0x4f,
    0x13, 0x29, 0x68, 0xab, 0xef, 0xd4, 0x5b, 0x93,
    0x7e, 0xf1, 0xf6, 0xb9, 0xeb, 0x23, 0xc7, 0x81,
    0x04, 0xb1, 0x19, 0xbd, 0x99, 0xbb, 0x43, 0xcc,
    0x83, 0x8d, 0x39, 0xec, 0x9d, 0xe3, 0x3e, 0x26,
    0x03, 0x5b, 0xe7, 0x50, 0xd6, 0xe3, 0x22, 0xc6,
    0xe7, 0xc0, 0xbf, 0xb3, 0x69, 0xd7, 0x40, 0x73,
    0x55, 0x07, 0xaf, 0x37, 0x12, 0xba, 0x1d, 0x29,
    0x92, 0x20, 0xef, 0x9f, 0x9c, 0xc6, 0xf8, 0x69,
    0x5b, 0x38, 0xb0, 0xd7, 0xba, 0xc3, 0x64, 0x3b,
    0x68, 0xcf, 0x94, 0x55, 0xde, 0x12, 0xae, 0x44,
    0x34, 0xc9, 0xa9, 0xd4, 0xa3, 0xf1, 0x0a, 0x11,
    0x17, 0x2d, 0x84, 0xe4, 0x92, 0x46, 0x5b, 0x1e,
    0x56, 0xf0, 0x52, 0x02, 0xfd, 0xd7, 0x43, 0x0b,
    0xe4, 0x72, 0x04, 0x4e, 0x3d, 0x30, 0x71, 0xe1,
    0x07, 0x78, 0xfb, 0xf2, 0xae, 0xa3, 0xd2, 0x78,
    0x72, 0xca, 0x2c, 0xc0, 0x5e, 0x44, 0xf9, 0x16,
    0xf5, 0x7e, 0xa1, 0x5b, 0x49, 0xca, 0x81, 0xc3,
    0x92, 0xd8, 0x87, 0xf3, 0x52, 0x18, 0x5e, 0xad,
    0x9b, 0x5d, 0x9d, 0x93, 0x89, 0x14, 0xad, 0x50,
    0xa7, 0xf0, 0xf3, 0xc3, 0x6a, 0xdf, 0xc0, 0x9a,
    0x93, 0x7b, 0x87, 0x7e, 0x4f, 0x71, 0x78, 0xbf,
    0xc3, 0x99, 0xa7, 0x13, 0xad, 0x52, 0xef, 0x1f,
    0xc5, 0xc2, 0x73, 0x10, 0xa3, 0x00, 0xe3, 0x94,
    0x7f, 0xcd, 0x02, 0xc4, 0x4c, 0xf4, 0x09, 0xd4,
    0xe3, 0xb2, 0x60, 0x7d, 0x1b, 0xb7, 0x78, 0xce,
    0x15, 0x62, 0x77, 0x88, 0x3c, 0x6c, 0xe2, 0x77,
    0xea, 0xe0, 0xae, 0x8d, 0x64, 0x61, 0x14, 0xff,
    0x14, 0xf3, 0x3c, 0xc2, 0xe2, 0xf2, 0x8a, 0x56,
    0xb6, 0x35, 0xd5, 0x29, 0xc4, 0x19, 0x23, 0x41,
    0x4e, 0x75, 0x78, 0x95, 0x8f, 0x7c, 0xa2, 0x7c,
    0x1e, 0x18, 0xb0, 0x47, 0xd2, 0x88, 0x96, 0x6a,
    0xbf, 0x39, 0xc1, 0xf6, 0x97, 0x95, 0x23, 0xa7,
    0x84, 0xcc, 0x89, 0x34, 0x26, 0x15, 0x55, 0x30,
    0xb0, 0xb2, 0xee, 0xfc, 0x8a, 0x39, 0x2b, 0x3b,
    0x69, 0xe6, 0xf0, 0x0c, 0x76, 0x1f, 0x97, 0x4d,
    0x1f, 0xf7, 0x89, 0x7f, 0x23, 0x1a, 0x6b, 0x37,
    0xfc, 0xc7, 0xcf, 0x75, 0xd6, 0xce, 0x8a, 0xf7,
    0xae, 0xba, 0xf0, 0x92, 0x30, 0x42, 0x37, 0x2d,
    0x09, 0xf9, 0x1a, 0xfe, 0x39, 0xaf, 0xbd, 0x9c,
    0x2d, 0x12, 0x39, 0x9c, 0xe8, 0x53, 0xb6, 0xdf,
    0x41, 0x58, 0x4e, 0x76, 0x06, 0x16, 0xdb, 0x8e,
    0xec, 0x6f, 0xa7, 0x2e, 0x29, 0xbd, 0x91, 0x7a,
    0x58, 0x45, 0x34, 0xc1, 0xdb, 0x45, 0x96, 0x0b,
    0x9b, 0xd4, 0xeb, 0xb3, 0x2f, 0x57, 0x59, 0x9d,
    0xfd, 0x9a, 0xc8, 0x72, 0xb2, 0x90, 0x90, 0xf7,
    0x15, 0x87, 0xef, 0x8a, 0xc5, 0x3b, 0xe9, 0x34,
    0x3d, 0xa0, 0x6d, 0xcb, 0x52, 0xc8, 0x28, 0x3c,
    0xe9, 0x84, 0x15, 0x3a, 0x79, 0x89, 0xa7, 0x81,
    0x26, 0x8c, 0x62, 0xe7, 0x8e, 0x08, 0xb7, 0xff,
    0x5d, 0xe8, 0x20, 0x4e, 0x16, 0x00, 0xb9, 0x13,
    0xe4, 0x19, 0xa9, 0x2d, 0xa9, 0x9e, 0xa1, 0x54,
    0x2d, 0xc9, 0xce, 0x7b, 0x7d, 0x16, 0x47, 0x5d,
    0x25, 0x0c, 0xb4, 0x19, 0x78, 0xbd, 0x06, 0x9d,
    0xcb, 0xb5, 0x95, 0x6f, 0xd3, 0x32, 0x4f, 0x7e,
    0xe6, 0xdc, 0x9a, 0xf4, 0x1c, 0x4d, 0xcc, 0xff,
    0x26, 0xa3, 0xbe, 0x70, 0xa5, 0x74, 0x52, 0x91,
    0xa2, 0x6d, 0x57, 0xf1, 0x35, 0x32, 0xfa, 0x3f,
    0xc5, 0x88, 0xb6, 0x68, 0x91, 0x1f, 0x99, 0x83,
    0x0b, 0xb4, 0xdb, 0x6b, 0x2f, 0xa1, 0xe4, 0x6b,
    0xeb, 0xa4, 0x90, 0x6a, 0xfb, 0x4a, 0xc2, 0x49,
    0x31, 0x09, 0xaf, 0xbe, 0x5e, 0xf8, 0xd7, 0x91,
    0x3f, 0x5b, 0x3d, 0x0f, 0x01, 0x58, 0xcc, 0xb2,
    0xa3, 0x64, 0x84, 0x93, 0x6b, 0x26, 0x8c, 0x35,
    0x1d, 0x60, 0xc2, 0xcc, 0x9a, 0x35, 0x09, 0x4d,
    0xb0, 0x51, 0x8d, 0x91, 0x0c, 0xb6, 0xc4, 0x6d,
    0xa6, 0xa8, 0x07, 0x8c, 0x39, 0x97, 0x3b, 0xc4,
    0x45, 0x39, 0x2f, 0xc0, 0x73, 0x62, 0xab, 0xf1,
    0xa1, 0x06, 0xa1, 0x57, 0xfe, 0x46, 0xb8, 0x7c,
    0x4c, 0xd3, 0xbf, 0xec, 0x80, 0xb6, 0xfc, 0x21,
    0xac, 0xb9, 0x14, 0xcd, 0x31, 0x1f, 0x9a, 0x34,
    0xb3, 0xf4, 0x97, 0x3d, 0x05, 0xff, 0xb4, 0xaf,
    0x9c, 0x36, 0x60, 0x30, 0xbb, 0x34, 0x53, 0xee,
    0xc6, 0x96, 0x31, 0x98, 0xf8, 0xa1, 0xe0, 0xa9,
    0x72, 0x69, 0x1b, 0x84, 0x55, 0x9c, 0x17, 0x42,
    0x01, 0x90, 0x16, 0x65, 0x05, 0xef, 0x3d, 0x0a,
    0xab, 0xde, 0xa5, 0xaa, 0x3c, 0x97, 0xc4, 0xc9,
    0x42, 0xaa, 0x85, 0x2a, 0xe2, 0xda, 0x73, 0x64,
    0x1e, 0x73, 0x47, 0x3b, 0xe5, 0xd9, 0x06, 0x7d,
    0x5b, 0xd0, 0x66, 0x16, 0xaa, 0xb7, 0xe6, 0x4b,
    0xef, 0x39, 0xe4, 0x69, 0x6f, 0x31, 0x9f, 0x89,
    0xee, 0xdf, 0xcd, 0x4f, 0xdb, 0x8f, 0xc6, 0x49,
    0xd8, 0x39, 0x65, 0x9d, 0x79, 0x01, 0x7e, 0x37,
    0x42, 0xb4, 0x75, 0xba, 0xc9, 0xbe, 0x03, 0x10,
    0xfc, 0x96, 0xe4, 0xff, 0x65, 0x36, 0x13, 0x9d,
    0x4d, 0xb5, 0x51, 0x2b, 0xec, 0x04, 0xf3, 0x8a,
    0x59, 0xc8, 0xfe, 0xcf, 0x9d, 0xc4, 0xf0, 0x28,
    0x1b, 0x60, 0xba, 0xd1, 0x34, 0x92, 0xe4, 0x7f,
    0xd5, 0xae, 0x76, 0x0c, 0x78, 0x01, 0xf9, 0x57,
    0x77, 0xe4, 0xb1, 0x9f, 0xe0, 0x26, 0x34, 0x7b,
    0xe0, 0x55, 0xa4, 0x97, 0x66, 0x07, 0x36, 0x9d,
    0x5a, 0x17, 0x46, 0x27, 0x8a, 0xb9, 0x0a, 0x90,
    0x68, 0xd9, 0x79, 0x8f, 0x5d, 0x3b, 0xec, 0x63,
    0xd2, 0x10, 0x33, 0x44, 0x23, 0x34, 0x63, 0x51,
    0xa3, 0x45, 0x3e, 0x93, 0x6c, 0x84, 0x83, 0x80,
    0xfc, 0x30, 0x7a, 0x41, 0x4d, 0x65, 0x7b, 0x60,
    0x41, 0xc1, 0xe2, 0x09, 0x02, 0x1b, 0xe4, 0xc0,
    0xe4, 0x2e, 0x98, 0xcd, 0x5d, 0xfa, 0xfd, 0x17,
    0x76, 0xfd, 0x2b, 0x27, 0x25, 0xf8, 0xe4, 0x8d,
    0x43, 0x73, 0xee, 0x8d, 0x07, 0xc2, 0x48, 0x43,
    0x46, 0x4d, 0x81, 0x59, 0xfc, 0x8c, 0x17, 0xec,
    0x57, 0x2a, 0x69, 0xf4, 0x79, 0xce, 0x6e, 0x2b,
    0x90, 0xcc, 0x86, 0xe6, 0x7f, 0x3e, 0x33, 0x10,
    0xc8, 0xfd, 0x9d, 0x27, 0x13, 0xcf, 0x6f, 0xcf,
    0x05, 0xa3, 0x4c, 0x9e, 0xbe, 0xb7, 0x25, 0xc4,
    0x16, 0x0f, 0xd6, 0x99, 0x62, 0xaa, 0xde, 0xf9,
    0xcf, 0x20, 0x47, 0x89, 0xb5, 0x17, 0xaa, 0x05,
    0xa4, 0xa7, 0xc1, 0x10, 0xba, 0x42, 0x1a, 0x82,
    0xc6, 0x37, 0x1b, 0x6a, 0x2a, 0x94, 0xdd, 0x05,
    0x86, 0x8e, 0xc4, 0x85, 0xf7, 0x48, 0x8f, 0xed,
    0xa0, 0x63, 0xd2, 0xbf, 0x7f, 0x01, 0x4a, 0x2d,
    0x1e, 0xf9, 0x49, 0x77, 0x41, 0x06, 0xfd, 0xcf,
    0x04, 0xa2, 0x0b, 0x71, 0xd6, 0xb7, 0x85, 0xaa,
    0xfd, 0x5b, 0x7e, 0x76, 0xb2, 0x7a, 0xc9, 0xed,
    0xd5, 0xa3, 0xdd, 0x41, 0x1d, 0xf4, 0xc8, 0x73,
    0xd1, 0x11, 0x1f, 0x88, 0x74, 0xa0, 0x96, 0x4a,
    0x79, 0x20, 0x7d, 0x84, 0x0f, 0xeb, 0xb9, 0xab,
    0x62, 0x2a, 0xd6, 0x7c, 0x3a, 0x63, 0xfb, 0x22,
    0x5b, 0x37, 0x1e, 0x73, 0x2c, 0xcb, 0xa3, 0xf3,
    0x53, 0xce, 0x29, 0xf0, 0x86, 0xbd, 0xc9, 0xe0,
    0xd7, 0x69, 0xa5, 0x14, 0xe7, 0x55, 0x33, 0x03,
    0xa3, 0x42, 0x83, 0x42, 0x68, 0x9b, 0x7e, 0x92,
    0xbd, 0xfe, 0x6c, 0x68, 0xed, 0x2e, 0x82, 0xd0,
    0xad, 0xbf, 0x19, 0x8a, 0xb7, 0x90, 0x8c, 0xe9,
    0x55, 0x9f, 0x0a, 0x95, 0xf1, 0x23, 0xa0, 0x5a,
    0xe7, 0x95, 0xa2, 0xa6, 0xec, 0x49, 0xd4, 0x14,
    0xcf, 0xf5, 0x4a, 0x46, 0x71, 0x1c, 0x17, 0x38,
    0x4e, 0xb8, 0x78, 0x6c, 0x99, 0xd0, 0xf4, 0x38,
    0xeb, 0x8d, 0x38, 0x16, 0x6d, 0x3f, 0x63, 0xda,
    0x3b, 0x9b, 0x8f, 0x86, 0x48, 0x6a, 0x62, 0xa5,
    0x9c, 0xfd, 0x0c, 0x79, 0xdd, 0x9a, 0x7f, 0x6b,
    0xc1, 0x93, 0xf0, 0x44, 0x4b, 0xee, 0xe7, 0x0c,
    0x4e, 0xb4, 0x74, 0x8a, 0x14, 0x70, 0x15, 0x3d,
    0x90, 0x09, 0xb4, 0x7e, 0xe9, 0x09, 0xb0, 0x4e,
    0x89, 0xe6, 0xae, 0xfc, 0xa1, 0x62, 0x37, 0x74,
    0x3c, 0x40, 0x5b, 0x52, 0x5a, 0xe2, 0x94, 0x61,
    0x22, 0x3e, 0xd2, 0xe7, 0x1e, 0x0b, 0xd5, 0x8e,
    0x51, 0x67, 0x70, 0x3e, 0xa2, 0xbf, 0x89, 0x0a,
    0xaa, 0x26, 0x39, 0xb5, 0xb1, 0xdf, 0xcd, 0x50,
    0x33, 0xb5, 0x81, 0xea, 0x13, 0x77, 0x60, 0x16,
    0x38, 0xef, 0xfe, 0xc9, 0xe3, 0x8b, 0x1f, 0x66,
    0x34, 0x9a, 0xe0, 0x4c, 0xef, 0xf0, 0xb0, 0xbc,
    0xce, 0xb5, 0xfd, 0x12, 0x89, 0x35, 0x2a, 0xe6,
    0x9f, 0x1b, 0x70, 0xc3, 0x22, 0xbe, 0x1a, 0xbc,
    0xa0, 0x60, 0x20, 0x46, 0x25, 0x3c, 0x95, 0xa0,
    0x8b, 0xf0, 0x6c, 0x63, 0x54, 0x49, 0x57, 0x4c,
    0x18, 0x53, 0x23, 0x78, 0x0e, 0x59, 0x29, 0xaf,
    0x14, 0x90, 0x8c, 0x44, 0x2a, 0x3d, 0xe7, 0xe1,
    0x8a, 0x5e, 0xbf, 0x0b, 0xb0, 0x19, 0x5e, 0x7f,
    0xd8, 0x90, 0xfa, 0x3b, 0xbc, 0x6e, 0xf6, 0x83,
    0xfa, 0xae, 0xc4, 0x9d, 0xc3, 0x69, 0xab, 0x47,
    0xff, 0xb9, 0xa3, 0x6b, 0x63, 0x82, 0xc6, 0xcb,
    0x19, 0xa2, 0x00, 0xb9, 0x14, 0x67, 0x28, 0xdb,
    0xab, 0xdb, 0xda, 0xae, 0x86, 0xdc, 0x40, 0x37,
    0xec, 0x91, 0xdf, 0xb1, 0x7c, 0x5c, 0x82, 0x72,
    0x42, 0xce, 0x7a, 0xc9, 0xdc, 0x14, 0xfc, 0x6d,
    0x6c, 0x62, 0x69, 0x4e, 0xc9, 0x30, 0xc6, 0x8f,
    0xd7, 0x90, 0x49, 0xc9, 0xf3, 0x86, 0xe3, 0x30,
    0x6a, 0x7f, 0x5e, 0x0b, 0x16, 0x9b, 0x34, 0xad,
    0x37, 0xa9, 0x1d, 0x02, 0xd5, 0x00, 0xd8, 0x8a,
    0xc4, 0x47, 0x5d, 0x42, 0x39, 0x52, 0x58, 0x5a,
    0xbe, 0x69, 0x09, 0x25, 0x98, 0x7c, 0xef, 0x30,
    0xfc, 0x54, 0x7f, 0x98, 0x7a, 0xbb, 0xc7, 0x19,
    0x1c, 0x0c, 0x2e, 0xe0, 0x95, 0x2b, 0xbe, 0x42,
    0xef, 0xcd, 0x99, 0xb2, 0x0a, 0x0b, 0xbf, 0xa2,
    0xd1, 0x5a, 0xed, 0x90, 0x3d, 0x85, 0xd7, 0xf9,
    0xb7, 0xec, 0xb5, 0xfb, 0xad, 0x46, 0x9c, 0x94,
    0x18, 0xe8, 0xab, 0xc1, 0x1c, 0x5c, 0x94, 0xe0,
    0x8b, 0x96, 0x84, 0x05, 0x81, 0x04, 0xcd, 0x0e,
    0x1d, 0xc0, 0xf0, 0x98, 0xbf, 0x97, 0x34, 0x04,
    0xff, 0x8d, 0x7b, 0x9a, 0xfa, 0x8b, 0x7f, 0x00,
    0x0b, 0x3a, 0x68, 0xe7, 0x6f, 0x4c, 0x63, 0x47,
    0xf2, 0x47, 0xf8, 0xa3, 0x35, 0x63, 0x07, 0x43,
    0x64, 0xd8, 0x44, 0xab, 0xcb, 0xa7, 0xdc, 0xe8,
    0x6a, 0xe7, 0xe0, 0xbf, 0xd3, 0x5d, 0xbd, 0x47,
    0x9f, 0x11, 0x46, 0x83, 0xb2, 0x86, 0x3e, 0x73,
    0xe2, 0x1a, 0x91, 0xad, 0x4a, 0xbb, 0x04, 0xb6,
    0x0e, 0x4f, 0xd1, 0xc1, 0xdb, 0x6c, 0xf9, 0x1d,
    0xcb, 0x8e, 0x6b, 0x19, 0x89, 0xed, 0xec, 0x74,
    0x36, 0x85, 0x50, 0x4f, 0x76, 0x51, 0x49, 0xb4,
    0x1a, 0x0f, 0xfc, 0x98, 0x7d, 0x5b, 0x48, 0xcc,
    0x90, 0xc1, 0xa2, 0xe4, 0x26, 0x96, 0x21, 0x2c,
    0x92, 0x93, 0xb9, 0x2d, 0xb8, 0xbf, 0xaa, 0x26,
    0x0b, 0xa4, 0x4c, 0xe6, 0xe0, 0xf3, 0x8d, 0x79,
    0x37, 0x6d, 0x92, 0xc8, 0x67, 0x74, 0xe0, 0xea,
    0x3f, 0x91, 0x36, 0x8a, 0x8f, 0xbf, 0xd8, 0xc7,
    0xeb, 0x0f, 0x6f, 0xec, 0x6b, 0xff, 0xa3, 0x90,
    0x8e, 0x68, 0x6f, 0xce, 0xe6, 0xfb, 0xa1, 0x37,
    0x58, 0xaf, 0xdc, 0x78, 0xb6, 0x60, 0x48, 0xf5,
    0xff, 0x51, 0x91, 0x91, 0x84, 0xa9, 0xe4, 0x28,
    0xc5, 0x20, 0x8b, 0x67, 0xc2, 0xd1, 0x32, 0xf0,
    0x09, 0x9d, 0x6b, 0xff, 0xf3, 0xe8, 0x82, 0xba,
    0x35, 0x3a, 0xa0, 0xd5, 0xbc, 0xb9, 0xf3, 0xaa,
    0x7f, 0xe8, 0x4a, 0x3a, 0x0d, 0xf0, 0xcd, 0xac,
    0xdc, 0xdc, 0x41, 0x69, 0xc6, 0x69, 0x2d, 0xc5,
    0xb3, 0xe9, 0xc1, 0x36, 0xf5, 0x08, 0x5f, 0x0f,
    0xbe, 0xfc, 0xec, 0x4c, 0x70, 0xd2, 0xe0, 0x99,
    0xe7, 0x68, 0xd8, 0x18, 0xb4, 0x8d, 0xdc, 0x07,
    0xfc, 0x6b, 0x58, 0xa8, 0x66, 0xb6, 0x3a, 0xfb,
    0xe4, 0x8b, 0x8c, 0xc7, 0xaa, 0xf6, 0x7d, 0x61,
    0x7a, 0xd6, 0xe3, 0x78, 0xfe, 0xa2, 0xdf, 0x31,
    0x48, 0xdf, 0x1b, 0x83, 0x13, 0xb3, 0xa6, 0xac,
    0x0b, 0x9b, 0x03, 0xdf, 0x5b, 0x83, 0xbd, 0xe2,
    0xb7, 0xa2, 0x3d, 0x53, 0x6e, 0x33, 0x15, 0x58,
    0xc6, 0x56, 0x3b, 0x53, 0x27, 0xf6, 0xf3, 0xda,
    0xc9, 0xa6, 0x8a, 0x3b, 0xaf, 0x71, 0x02, 0xd0,
    0xc3, 0xe9, 0xb9, 0x1e, 0xcc, 0xe7, 0x70, 0x7f,
    0xa3, 0x07, 0xdc, 0x57, 0x9e, 0xc2, 0xd9, 0x6e,
    0xcf, 0xb5, 0x45, 0xe6, 0xfe, 0xc7, 0x0c, 0x02,
    0x7b, 0x9d, 0xed, 0xaa, 0x09, 0x68, 0xa5, 0x05,
    0xde, 0x17, 0x02, 0x85, 0x95, 0x3f, 0x23, 0xe4,
    0x0f, 0x86, 0xf3, 0x8c, 0xed, 0x90, 0x7b, 0x55,
    0x37, 0x2c, 0xbb, 0xa1, 0x31, 0x26, 0x03, 0x66,
    0x75, 0xe8, 0x2c, 0x5f, 0x2f, 0xb1, 0x05, 0x69,
    0x42, 0x24, 0x8d, 0x97, 0x17, 0xb6, 0x10, 0xf1,
    0x00, 0x5d, 0xd4, 0xc4, 0x6c, 0x7a, 0x93, 0xdd,
    0x11, 0xcf, 0x14, 0x95, 0x13, 0xb4, 0xfe, 0x72,
    0xc5, 0x62, 0xd6, 0xe9, 0xb4, 0x7f, 0x3d, 0xae,
    0x37, 0x52, 0x05, 0x03, 0x4c, 0x41, 0x1b, 0x46,
    0x67, 0x38, 0xe5, 0x32, 0x9f, 0x95, 0x05, 0xa8,
    0xec, 0x6e, 0x25, 0xc2, 0xba, 0x84, 0x41, 0x8e,
    0x37, 0x64, 0x3d, 0x3f, 0xc0, 0x40, 0xf6, 0x24,
    0xd9, 0x06, 0xdf, 0x6a, 0xff, 0xe1, 0x94, 0xb6,
    0x0d, 0xf4, 0xe6, 0x17, 0xd3, 0x8a, 0x66, 0x3f,
    0xde, 0x43, 0x4b, 0xc6, 0xd8, 0xc7, 0xa4, 0x86,
    0xef, 0xff, 0x90, 0xc5, 0x3d, 0x55, 0x6a, 0x82,
    0x10, 0x37, 0x3b, 0x09, 0xd8, 0xff, 0xd5, 0x5e,
    0x3a, 0xa6, 0xc9, 0xa7, 0x81, 0xca, 0xc2, 0xef,
    0x19, 0x81, 0xfd, 0xa6, 0x8a, 0xbd, 0xff, 0xa2,
    0xc9, 0x26, 0x20, 0x3f, 0xaa, 0x25, 0xb9, 0x35,
    0x94, 0x5f, 0xc7, 0xe4, 0xd3, 0x54, 0xdd, 0xcf,
    0x17, 0xc1, 0x15, 0x02, 0xce, 0xb1, 0xa5, 0x08,
    0x78, 0x88, 0x15, 0x89, 0x9d, 0xab, 0x9b, 0xca,
    0x68, 0x26, 0x22, 0x93, 0x71, 0x36, 0x3a, 0xa4,
    0x97, 0x19, 0xbd, 0x05, 0x4a, 0x46, 0x17, 0x08,
    0x07, 0x27, 0x75, 0x1f, 0xa9, 0xa0, 0xc4, 0x7d,
    0x06, 0xe2, 0x9f, 0xb0, 0x89, 0x9a, 0xc7, 0xad,
    0x64, 0xd1, 0x01, 0x80, 0x82, 0xa2, 0x2b, 0xf6,
    0x2c, 0x06, 0x58, 0x3d, 0x37, 0x18, 0xdc, 0x29,
    0x4c, 0x89, 0xbe, 0x2f, 0x7a, 0x81, 0xef, 0xad,
    0x90, 0xf6, 0x84, 0x5d, 0x5b, 0x52, 0x4f, 0x18,
    0x47, 0x1a, 0x28, 0x7b, 0xe9, 0xdc, 0xf5, 0x43,
    0x49, 0xd7, 0xfd, 0xfa, 0xf9, 0xf6, 0xb5, 0x4c,
    0x59, 0xd1, 0xdc, 0x75, 0x22, 0x46, 0x84, 0x61,
    0xde, 0x48, 0x48, 0x91, 0xef, 0x5b, 0x85, 0x12,
    0x8b, 0x41, 0x96, 0x71, 0x96, 0x69, 0x94, 0xe2,
    0x00, 0x48, 0x91, 0x13, 0x6d, 0xca, 0xe9, 0x0a,
    0x79, 0x23, 0x58, 0x36, 0xe1, 0x20, 0x50, 0x07,
    0xf0, 0x21, 0x60, 0x1a, 0x9d, 0xbe, 0x17, 0xbe,
    0x98, 0x0f, 0x82, 0x48, 0x18, 0xe2, 0xbc, 0xa2,
    0xe7, 0x87, 0xf6, 0xc9, 0x35, 0xb6, 0x6c, 0x10,
    0x07, 0x48, 0xda, 0xc1, 0x97, 0x39, 0xa3, 0x15,
    0x8f, 0x79, 0xa1, 0x10, 0x2f, 0xd6, 0x0e, 0x8f,
    0x13, 0x76, 0xfa, 0x4a, 0xb7, 0xc0, 0x8f, 0x56,
    0xb3, 0x8b, 0x6a, 0xba, 0x5b, 0xf0, 0x55, 0xe3,
    0x90, 0x48, 0xea, 0x2a, 0xf3, 0x49, 0xdf, 0x21,
    0x32, 0xc9, 0x5b, 0x7b, 0xa9, 0x70, 0xe8, 0x37,
    0x3c, 0xca, 0xf3, 0x06, 0x60, 0x6a, 0x42, 0xc0,
    0x4a, 0x3d, 0x67, 0x78, 0xcf, 0x64, 0x26, 0x1d,
    0x5d, 0x63, 0x84, 0x7e, 0x10, 0x8a, 0x94, 0x09,
    0xa6, 0x94, 0x82, 0xa8, 0x85, 0x88, 0x59, 0xf2,
    0x38, 0xbb, 0x7b, 0x1c, 0x79, 0xf1, 0x61, 0x9e,
    0x65, 0xdb, 0x36, 0xa1, 0x5e, 0x28, 0x29, 0x82,
    0xcb, 0x29, 0x59, 0x33, 0xf0, 0xde, 0xc8, 0xa8,
    0x36, 0x54, 0xf7, 0xe0, 0x8a, 0x07, 0x7e, 0xe8,
    0xde, 0x75, 0x55, 0xcc, 0x15, 0x79, 0x96, 0x7a,
    0xe7, 0xce, 0x63, 0xb7, 0x66, 0x56, 0x62, 0xa4,
    0xdb, 0xcd, 0x46, 0x77, 0x8a, 0x3c, 0x5a, 0xd4,
    0x23, 0x43, 0x02, 0xed, 0xff, 0x08, 0x4f, 0xea,
    0xe3, 0xf9, 0x4f, 0x93, 0x4c, 0xb0, 0xb4, 0x10,
    0xd6, 0x4e, 0x06, 0xe1, 0x06, 0xc0, 0x5a, 0xd8,
    0x75, 0x9d, 0xb8, 0x5f, 0x4c, 0x6b, 0x66, 0x36,
    0xeb, 0x5d, 0xf1, 0xfc, 0x61, 0xb9, 0xb7, 0x52,
    0xd2, 0xa2, 0xdb, 0xbc, 0x0f, 0x4e, 0x31, 0xc3,
    0x3c, 0x5d, 0xc5, 0xf0, 0xf7, 0xc4, 0x33, 0xcf,
    0xa8, 0x01, 0x34, 0xb1, 0xd4, 0xda, 0x0a, 0xb7,
    0x5a, 0x60, 0xf9, 0xc0, 0x3b, 0x17, 0xab, 0xce,
    0x44, 0x92, 0x59, 0x71, 0xcc, 0xf3, 0x57, 0x1c,
    0x74, 0x5c, 0x5f, 0xfa, 0x37, 0xf1, 0xb2, 0x5a,
    0xa7, 0xab, 0x0c, 0xc7, 0x12, 0x22, 0xe9, 0x75,
    0xcb, 0x1e, 0x6c, 0x31, 0xff, 0xc9, 0xe9, 0xd6,
    0x2d, 0xec, 0x9a, 0x09, 0x66, 0xb6, 0xc5, 0xac,
    0xfa, 0xf5, 0xee, 0xe6, 0x88, 0xb5, 0x7b, 0xcf,
    0x80, 0x90, 0xd9, 0x64, 0x21, 0x10, 0x15, 0xab,
    0x34, 0xc9, 0x9d, 0xf2, 0xf1, 0xd8, 0xb2, 0x86,
    0x43, 0x63, 0x26, 0x63, 0x36, 0xe0, 0xe5, 0xee,
    0x32, 0xe0, 0x14, 0xf3, 0x6d, 0x3d, 0x31, 0x4f,
    0xd9, 0x5b, 0x74, 0x50, 0x26, 0xbf, 0x33, 0x15,
    0x19, 0x00, 0x96, 0x18, 0x92, 0xb0, 0x6d, 0xc8,
    0xb9, 0x3e, 0x94, 0x18, 0xc2, 0x3f, 0x69, 0x66,
    0xc1, 0xa1, 0xa2, 0x11, 0xf9, 0x5f, 0x6d, 0xce,
    0x3f, 0xf3, 0x9d, 0x0c, 0x73, 0xab, 0x44, 0x43,
    0x7e, 0x8e, 0x96, 0xa5, 0x6a, 0xf5, 0x02, 0x33,
    0xcf, 0x03, 0x67, 0x68, 0xc9, 0xfd, 0xf7, 0xd5,
    0xe4, 0x21, 0xb9, 0x47, 0xa4, 0x44, 0x28, 0xd2,
    0xef, 0x23, 0x7b, 0x26, 0x58, 0x7e, 0xd8, 0x20,
    0x4a, 0xc4, 0x9e, 0x73, 0x44, 0x14, 0x0c, 0x45,
    0x86, 0x36, 0x1b, 0x61, 0x33, 0x65, 0x6e, 0x0f,
    0xe5, 0x0d, 0xdc, 0xf1, 0x89, 0x70, 0x1b, 0x52,
    0x0b, 0x55, 0xf8, 0x22, 0x4a, 0x13, 0xe1, 0x1e,
    0x36, 0xf1, 0x22, 0x38, 0x59, 0x7b, 0x8f, 0x0f,
    0xef, 0x89, 0xc0, 0x62, 0x64, 0xf2, 0x49, 0x77,
    0x1c, 0x5e, 0x9f, 0x0e, 0x61, 0x2e, 0x4a, 0x31,
    0xd4, 0xa9, 0xf6, 0x75, 0xfa, 0xf2, 0x92, 0xf3,
    0xa9, 0x89, 0xaa, 0x1b, 0xcf, 0x01, 0x6f, 0x8d,
    0x08, 0x94, 0x99, 0x49, 0x5c, 0x05, 0x9d, 0x41,
    0x62, 0x35, 0x7a, 0x22, 0x56, 0x51, 0x3d, 0xde,
    0x80, 0x51, 0x94, 0xc2, 0xa1, 0x39, 0x3c, 0xd5,
    0xaf, 0x51, 0xfe, 0x8e, 0x0e, 0x78, 0xc0, 0xe2,
    0x38, 0xfd, 0xf6, 0x7d, 0x6a, 0x4f, 0x6f, 0xb3,
    0x2c, 0xea, 0xb2, 0x9b, 0xd7, 0x84, 0xe1, 0x79,
    0xbe, 0x28, 0x43, 0x6e, 0x88, 0xd4, 0xe5, 0x0b,
    0x2b, 0xc5, 0xef, 0x3d, 0xd0, 0xc2, 0x5f, 0x3d,
    0xe0, 0x68, 0x4b, 0xce, 0xc2, 0xb6, 0x64, 0xfd,
    0xd6, 0x3c, 0x64, 0xca, 0xb4, 0xe9, 0x5f, 0x8d,
    0xab, 0xb5, 0x73, 0x58, 0xf9, 0x2e, 0xdc, 0x43,
    0x87, 0xa1, 0xd6, 0xaa, 0xcb, 0x00, 0x30, 0x95,
    0xf6, 0x81, 0xd8, 0xd7, 0x07, 0x5d, 0x77, 0xed,
    0xe5, 0x58, 0xf0, 0x0e, 0x9e, 0x44, 0xef, 0x3c,
    0x41, 0x2a, 0x91, 0xe1, 0x21, 0xa7, 0x27, 0xe8,
    0xf2, 0x5e, 0xf2, 0x80, 0x10, 0xd5, 0xdb, 0x45,
    0x99, 0xfd, 0x71, 0x1c, 0xb3, 0x51, 0x8b, 0x4b,
    0x79, 0xe3, 0x3c, 0x12, 0x47, 0xae, 0x9d, 0x9d,
    0x5c, 0xdd, 0xb0, 0xee, 0x77, 0x74, 0xf5, 0xcb,
    0x1d, 0x1a, 0xf9, 0x0c, 0xf1, 0x1b, 0x78, 0x17,
    0xd5, 0xd5, 0x32, 0x39, 0x65, 0xe0, 0xc2, 0x83,
    0xb0, 0x03, 0x4c, 0xff, 0x2c, 0x1c, 0x76, 0x3a,
    0x35, 0x80, 0x36, 0xcf, 0x35, 0x36, 0x6f, 0xb5,
    0x6e, 0xe2, 0xe6, 0xad, 0xd0, 0x7a, 0x73, 0x50,
    0xd8, 0x40, 0x6d, 0x8b, 0xf8, 0x2f, 0x00, 0xc3,
    0xc4, 0xd5, 0x20, 0xd6, 0x07, 0x56, 0x6a, 0x8c,
    0xba, 0xf3, 0x31, 0x20, 0x6f, 0x7f, 0xa4, 0xf2,
    0x11, 0x0f, 0x21, 0xaf, 0xc1, 0xad, 0xb2, 0xfb,
    0x34, 0x4e, 0xe0, 0x4e, 0x4a, 0x9b, 0x61, 0xa3,
    0xe5, 0x8d, 0x9e, 0xa2, 0xc7, 0x48, 0x52, 0x27,
    0xf8, 0x6b, 0x2b, 0x36, 0x01, 0xdf, 0x35, 0xf0,
    0x4f, 0xc2, 0xe2, 0x5d, 0x52, 0x05, 0x63, 0x15,
    0x8c, 0xa9, 0xd8, 0x9a, 0xe9, 0xf0, 0xf9, 0x4a,
    0x08, 0xc0, 0xf4, 0xf0, 0xdc, 0x5f, 0x3d, 0xbe,
    0x0a, 0x78, 0xdc, 0xf0, 0x99, 0xfd, 0x3c, 0x1a,
    0xcd, 0x50, 0x34, 0x95, 0xf7, 0xea, 0x8d, 0x1f,
    0xbe, 0x7c, 0x90, 0x2c, 0xa9, 0xa0, 0x44, 0xed,
    0xc0, 0xbf, 0x3c, 0xd2, 0x0b, 0xd6, 0xfe, 0xb8,
    0x84, 0x75, 0x07, 0x51, 0x1a, 0x41, 0x36, 0x1b,
    0xcd, 0x35, 0xcb, 0xb8, 0x65, 0x1e, 0x74, 0x84,
    0xfd, 0xb4, 0x37, 0x9f, 0xb1, 0xf2, 0xaa, 0x0f,
    0xb0, 0x25, 0xee, 0xdf, 0x97, 0x1c, 0xe8, 0xc5,
    0x16, 0x5e, 0x53, 0x69, 0x93, 0x99, 0xa0, 0x9b,
    0x3e, 0xaf, 0xa1, 0x94, 0x4d, 0xca, 0x2a, 0x15,
    0xd3, 0xdd, 0xb7, 0xc8, 0x72, 0xc2, 0x96, 0x5b,
    0x0d, 0x88, 0x2c, 0x98, 0x58, 0xb3, 0xc6, 0x7e,
    0x4c, 0x57, 0x87, 0x6d, 0x11, 0x5a, 0x6f, 0xb2,
    0xf4, 0x0a, 0xf5, 0x8a, 0xef, 0x3f, 0x24, 0xcc,
    0xb2, 0x05, 0x35, 0x23, 0x1b, 0xde, 0xe8, 0xb9,
    0xc3, 0x0f, 0x47, 0x58, 0xa0, 0x8d, 0x89, 0x07,
    0x1a, 0x03, 0x4b, 0x5d, 0xc1, 0xb5, 0x41, 0x85,
    0x96, 0xc6, 0xed, 0x18, 0x04, 0x40, 0x27, 0x3b,
    0x19, 0xf9, 0x02, 0xc0, 0x40, 0x37, 0xdd, 0x2e,
    0x44, 0x98, 0x03, 0xfe, 0x51, 0x07, 0x48, 0x64,
    0xd1, 0x9e, 0xcc, 0xba, 0x91, 0x24, 0x3c, 0x67,
    0xcc, 0x09, 0xbd, 0x36, 0x64, 0x46, 0x2a, 0x6c,
    0x79, 0xe7, 0x44, 0x0d, 0x01, 0x99, 0x49, 0xaf,
    0xeb, 0x1c, 0x85, 0xb1, 0x17, 0x54, 0xa7, 0xa4,
    0xdb, 0x64, 0x98, 0x30, 0x24, 0xf2, 0xab, 0xd2,
    0x8f, 0x2b, 0x5a, 0xd7, 0x30, 0x4f, 0x24, 0xb5,
    0xe1, 0xa3, 0xff, 0xe5, 0x8a, 0xdd, 0x0b, 0x97,
    0x12, 0x7b, 0x61, 0x0a, 0x1f, 0x6a, 0x88, 0x48,
    0x68, 0x1e, 0x11, 0xe1, 0x4f, 0x3b, 0xc4, 0xb4,
    0xe8, 0x06, 0x78, 0x7a, 0x72, 0x78, 0xdb, 0x16,
    0xff, 0x6c, 0x16, 0xd0, 0x34, 0x7b, 0x8c, 0xca,
    0xd1, 0x3a, 0x0f, 0x04, 0xda, 0xae, 0xb9, 0x1f,
    0x8e, 0x0a, 0x1e, 0xaf, 0x5f, 0xc8, 0xc5, 0x5f,
    0x61, 0x1b, 0x39, 0x44, 0x52, 0xa2, 0xc8, 0x5d,
    0xfe, 0xee, 0x7f, 0x46, 0x4d, 0xfe, 0x20, 0xa3,
    0xa2, 0x67, 0x1a, 0x80, 0x75, 0xd2, 0x5d, 0x78,
    0x55, 0xfc, 0x94, 0x83, 0xb7, 0xec, 0x29, 0x08,
    0x9d, 0x89, 0x61, 0x68, 0xb9, 0x54, 0xe0, 0xc1,
    0xf1, 0x2a, 0x1b, 0xde, 0x71, 0x3d, 0xd2, 0xfa,
    0x60, 0xaf, 0xf5, 0x90, 0x10, 0x13, 0x51, 0x9c,
    0xf9, 0xf8, 0x52, 0xc9, 0xb1, 0xb1, 0xc9, 0x00,
    0x44, 0x37, 0x6a, 0x4a, 0x4b, 0xa3, 0xd4, 0x2f,
    0xb0, 0xff, 0xbc, 0xde, 0xbe, 0x17, 0xdc, 0x72,
    0xf9, 0xc1, 0x15, 0xd5, 0x24, 0xd6, 0xcf, 0x6f,
    0xf0, 0x31, 0x07, 0x13, 0x2e, 0xd1, 0xfe, 0x22,
    0x6c, 0x31, 0xf7, 0x3f, 0xb4, 0x4d, 0xac, 0xa0,
    0x6a, 0x34, 0x2d, 0xe6, 0x23, 0xa6, 0xb9, 0x20,
    0xdb, 0x0b, 0x60, 0x2b, 0xfc, 0x07, 0xc3, 0x79,
    0x3b, 0xae, 0x2d, 0xfa, 0xae, 0x74, 0x6e, 0xc1,
    0x0b, 0xda, 0x09, 0x1c, 0x0c, 0xfe, 0x07, 0x31,
    0x05, 0xfa, 0x0d, 0xf4, 0x87, 0x4c, 0xa8, 0xc3,
    0x8a, 0x48, 0x27, 0x17, 0xa8, 0xef, 0x28, 0x1b,
    0x53, 0x18, 0x5a, 0x72, 0xa4, 0x08, 0xa8, 0x12,
    0x1c, 0x24, 0x71, 0x58, 0x10, 0x16, 0xb2, 0x43,
    0x5c, 0x76, 0x38, 0x72, 0x61, 0x94, 0x97, 0xce,
    0xb5, 0x1d, 0xa3, 0xaa, 0x24, 0x72, 0x6f, 0x78,
    0x36, 0xa3, 0xad, 0x42, 0xc7, 0x54, 0x31, 0x43,
    0x51, 0xea, 0x1b, 0x7a, 0xb2, 0xe6, 0x48, 0xb3,
    0xff, 0xa5, 0x49, 0xee, 0x03, 0x6a, 0xd8, 0x85,
    0xa6, 0x65, 0xe2, 0x6e, 0x91, 0xe3, 0xdf, 0xe8,
    0xe8, 0xc4, 0x6b, 0xaf, 0x86, 0x8b, 0x3e, 0xb4,
    0xe1, 0x5c, 0x2a, 0x4f, 0x16, 0xb5, 0x84, 0x89,
    0x64, 0xc9, 0x12, 0xd7, 0x85, 0x27, 0x26, 0x7e,
    0xa8, 0x0e, 0x66, 0x93, 0xb6, 0x73, 0x60, 0xa7,
    0xbc, 0x11, 0x9f, 0x8f, 0x5c, 0x08, 0xa1, 0x1c,
    0xca, 0x4e, 0xa9, 0x23, 0xe1, 0x10, 0x3a, 0x47,
    0x2d, 0xaf, 0xb0, 0x54, 0x85, 0x7d, 0xe4, 0x11,
    0x2c, 0xe7, 0x28, 0xee, 0x32, 0xfb, 0x5f, 0x1f,
    0x03, 0xea, 0x36, 0xdd, 0x45, 0x14, 0xf8, 0x69,
    0xe8, 0x9a, 0x11, 0x2f, 0x35, 0xd7, 0x37, 0x33,
    0xc3, 0x92, 0xe5, 0x19, 0x49, 0x19, 0x73, 0xcd,
    0xff, 0xe1, 0x38, 0x53, 0x0c, 0xb9, 0x05, 0x78,
    0xa2, 0x96, 0x15, 0x40, 0xa6, 0x2c, 0xd8, 0x80,
    0xb9, 0x88, 0xdd, 0x27, 0xab, 0xaf, 0xcc, 0x4c,
    0x1d, 0x68, 0xbd, 0xe4, 0xdb, 0x9c, 0x0e, 0x0d,
    0x94, 0x63, 0x21, 0x69, 0x02, 0xb9, 0x9e, 0x2d,
    0x46, 0xd1, 0x7d, 0x57, 0x72, 0xb6, 0x2f, 0x11,
    0xe2, 0x96, 0x25, 0xf2, 0xde, 0xe7, 0xfe, 0x62,
    0x4f, 0x3d, 0x40, 0x70, 0xf2, 0xae, 0x22, 0x45,
    0x5b, 0xaa, 0x92, 0xfc, 0x88, 0x45, 0x0a, 0x83,
    0xab, 0x67, 0x2e, 0xa8, 0x1d, 0xfc, 0x2e, 0xcb,
    0x2f, 0xe7, 0xaa, 0x25, 0x49, 0x26, 0x84, 0x9e,
    0x72, 0x49, 0x9d, 0xb8, 0x78, 0x49, 0x07, 0x69,
    0x06, 0x6c, 0xce, 0xe7, 0xda, 0x08, 0xab, 0xdc,
    0xad, 0x0e, 0xfb, 0xed, 0xa4, 0x04, 0x61, 0x6d,
    0x14, 0x81, 0xe9, 0x79, 0x10, 0x8c, 0xa1, 0xa2,
    0x70, 0x78, 0x9b, 0xaa, 0x0e, 0xce, 0x77, 0x7a,
    0xe4, 0xd4, 0x91, 0x61, 0xdb, 0xed, 0xd9, 0xec,
    0xcf, 0x63, 0xb6, 0xa0, 0xc6, 0x3f, 0xa4, 0x27,
    0x99, 0x95, 0x0f, 0x55, 0xde, 0x50, 0x9e, 0x77,
    0xf4, 0x0c, 0xab, 0x6c, 0x46, 0xfd, 0x6c, 0x6a,
    0x92, 0x1a, 0x78, 0xf9, 0xf4, 0x6f, 0x19, 0x43,
    0x36, 0x96, 0xe3, 0xe2, 0xdf, 0xc5, 0x01, 0x99,
    0xb8, 0x18, 0xd3, 0x67, 0xbb, 0x6c, 0x41, 0x69,
    0xa9, 0x27, 0x35, 0xe0, 0xec, 0x63, 0xe5, 0xc1,
    0xd8, 0xcf, 0xfd, 0x49, 0x05, 0xf0, 0xfb, 0xce,
    0x1c, 0x03, 0x8e, 0x90, 0x28, 0xc9, 0x27, 0xeb,
    0x50, 0x54, 0x17, 0x5f, 0x3f, 0xbc, 0x37, 0x3d,
    0x76, 0x91, 0x50, 0x94, 0x7a, 0xbc, 0xe8, 0xb2,
    0x0b, 0x69, 0xf9, 0x7f, 0x48, 0xe2, 0x39, 0x18,
    0xc1, 0xa7, 0x9d, 0x09, 0x8d, 0x51, 0xbe, 0xab,
    0x3f, 0x33, 0x8d, 0xb4, 0xa8, 0xf3, 0x7a, 0x78,
    0x24, 0x77, 0x62, 0x8e, 0x34, 0x0f, 0x53, 0xb8,
    0x2b, 0x2f, 0x5a, 0x77, 0x84, 0xb9, 0xbe, 0x09,
    0xe4, 0x77, 0xef, 0x8c, 0x4c, 0x0b, 0xb5, 0x3d,
    0xa6, 0x17, 0x06, 0x1a, 0x33, 0x22, 0x53, 0x72,
    0x90, 0x28, 0x90, 0x45, 0xe3, 0x96, 0xac, 0x90,
    0x2d, 0x69, 0x98, 0x11, 0x46, 0x10, 0xeb, 0xb2,
    0x43, 0x53, 0x1c, 0xd3, 0xe2, 0xec, 0x46, 0xb0,
    0xf1, 0x49, 0xd1, 0xbf, 0xff, 0xb2, 0x15, 0xf1,
    0x63, 0x19, 0xdf, 0x57, 0x59, 0x0a, 0xf6, 0xac,
    0x2c, 0xf2, 0xef, 0xf5, 0xdb, 0xaa, 0xac, 0xe5,
    0xbc, 0xd5, 0xd7, 0xb0, 0x6f, 0x9f, 0x74, 0x33,
    0x6c, 0xe9, 0x48, 0xce, 0x8a, 0xb0, 0xc9, 0x5b,
    0xc0, 0x9d, 0x44, 0xd5, 0x78, 0x04, 0xe8, 0x7f,
    0x8d, 0x1f, 0xc3, 0x1d, 0xcb, 0x3f, 0x25, 0x83,
    0x04, 0xda, 0x03, 0xee, 0x3e, 0xe2, 0x0e, 0x33,
    0x24, 0xac, 0xef, 0x4b, 0x47, 0x08, 0xd8, 0x5e,
    0x8e, 0x45, 0xfb, 0x73, 0x44, 0xc1, 0xa2, 0xe9,
    0x41, 0x24, 0x20, 0xfb, 0x2a, 0xdb, 0xb4, 0xda,
    0x48, 0x3e, 0x8a, 0x37, 0x93, 0x28, 0xdd, 0x45,
    0xc6, 0xf1, 0x2d, 0xa6, 0x99, 0x41, 0x1e, 0x9d,
    0x8b, 0x08, 0xaa, 0xb5, 0xee, 0x88, 0x9f, 0xad,
    0xe6, 0x02, 0xfa, 0x96, 0xcd, 0x2c, 0x5f, 0xa8,
    0x73, 0xcb, 0x08, 0xe6, 0x4a, 0x9e, 0x18, 0xf8,
    0xa9, 0x63, 0x88, 0x8b, 0x4a, 0xd9, 0xa7, 0x6c,
    0x2f, 0xb0, 0x90, 0xca, 0xb1, 0x70, 0x17, 0x29,
    0x88, 0x18, 0xeb, 0xd8, 0x65, 0x83, 0x05, 0xfb,
    0x3d, 0xa9, 0x74, 0x49, 0x2e, 0x4a, 0x21, 0x17,
    0x9c, 0xd9, 0xe7, 0x87, 0x36, 0x8b, 0x12, 0x1e,
    0xd6, 0x5f, 0x7d, 0x80, 0x37, 0x2c, 0x0b, 0x34,
    0xe5, 0xcf, 0x03, 0x29, 0x82, 0x7f, 0x7a, 0x19,
    0x61, 0x07, 0xde, 0xae, 0x49, 0xb8, 0xea, 0x77,
    0xfd, 0x5b, 0x7b, 0xd8, 0x01, 0x06, 0xa0, 0xee,
    0x6a, 0x38, 0xf2, 0x02, 0x51, 0x35, 0x4e, 0x63,
    0xd5, 0x39, 0x4b, 0x4f, 0x3a, 0x1a, 0xfb, 0x8a,
    0xa4, 0x2a, 0x06, 0xde, 0x18, 0xa0, 0x34, 0xd9,
    0x3f, 0xfd, 0x7d, 0x3f, 0x96, 0x05, 0xa6, 0xed,
    0xab, 0x20, 0xfb, 0xa0, 0xd0, 0x63, 0xdc, 0xbf,
    0x5d, 0x55, 0xbc, 0xc0, 0xf9, 0xc8, 0xc7, 0xe5,
    0x6c, 0x09, 0x79, 0x58, 0xba, 0x81, 0x3e, 0xa6,
    0x5b, 0xdf, 0xaa, 0x3e, 0xd6, 0x94, 0x8c, 0xd0,
    0x64, 0xcf, 0xcb, 0x1d, 0x63, 0x0b, 0xe0, 0xba,
    0x10, 0x18, 0xa8, 0xca, 0x8f, 0xeb, 0xe6, 0xc4,
    0x34, 0xce, 0xd0, 0x6a, 0x4a, 0xba, 0x65, 0x47,
    0xad, 0x63, 0xc4, 0x0f, 0x5f, 0x02, 0xb7, 0x67,
    0x80, 0xcc, 0x07, 0x9d, 0x56, 0xca, 0x1e, 0x3b,
    0xf3, 0x95, 0x7f, 0xa3, 0x55, 0x0d, 0xc3, 0x3f,
    0x7d, 0xe0, 0x2e, 0x62, 0x9d, 0x72, 0x04, 0xd1,
    0x7d, 0x74, 0x15, 0xb0, 0x7e, 0x1f, 0x63, 0x39,
    0xe3, 0xa5, 0x03, 0xc2, 0xcc, 0xe1, 0x44, 0x34,
    0xe3, 0xbf, 0x9e, 0x9f, 0x68, 0xab, 0xa6, 0xd2,
    0x5a, 0x38, 0x70, 0xad, 0x23, 0x73, 0x7f, 0xc7,
    0x19, 0x98, 0x1b, 0x21, 0x75, 0xdf, 0x9a, 0x66,
    0x0c, 0x8e, 0x09, 0x31, 0x5f, 0xd3, 0xa1, 0xbd,
    0x65, 0x53, 0xa8, 0xaa, 0x98, 0xf7, 0xa0, 0x33,
    0xcb, 0x86, 0x2e, 0x76, 0x1b, 0xb2, 0x27, 0xdc,
    0x11, 0xfd, 0xb6, 0xe9, 0xa9, 0x36, 0xed, 0x6d,
    0xa6, 0xd3, 0x5f, 0x7b, 0x3b, 0xf2, 0xd7, 0x93,
    0xdf, 0xd2, 0x21, 0xf4, 0xcc, 0xf8, 0x96, 0x10,
    0x72, 0xff, 0xaf, 0x1b, 0x3a, 0x05, 0x15, 0x00,
    0xae, 0xab, 0xbf, 0x69, 0xa3, 0x28, 0xa3, 0x5e,
    0x0f, 0xd2, 0x5d, 0x77, 0xd8, 0x67, 0x0d, 0xa5,
    0x9c, 0x82, 0x04, 0x10, 0xc9, 0xa2, 0xc2, 0xd7,
    0xa0, 0x8c, 0xb7, 0x1c, 0x1b, 0xf2, 0x1b, 0xb9,
    0xe3, 0x49, 0x1d, 0xca, 0x41, 0xfc, 0xd9, 0x28,
    0x3d, 0xbe, 0xbb, 0x34, 0x83, 0xbf, 0xa9, 0x0c,
    0x73, 0xf3, 0x9f, 0x38, 0xcc, 0x13, 0x3c, 0x34,
    0x6d, 0x16, 0x1c, 0x79, 0xed, 0x33, 0x03, 0xd7,
    0x02, 0x5b, 0x7d, 0x15, 0x77, 0xa6, 0xee, 0x34,
    0x7e, 0xad, 0x85, 0xfd, 0x10, 0xfd, 0x6c, 0x9d,
    0x1c, 0x0f, 0xab, 0x9b, 0xd9, 0xdf, 0x85, 0xf7,
    0xa8, 0xe8, 0xcf, 0xea, 0x0b, 0x60, 0xe4, 0x00,
    0xf8, 0x01, 0xa8, 0x46, 0xa3, 0x9b, 0xa1, 0xbc,
    0xdb, 0xdd, 0x55, 0xc3, 0xf9, 0x4f, 0x47, 0xa4,
    0x51, 0xb4, 0xbe, 0xc1, 0x44, 0x9c, 0xc6, 0xd4,
    0xc8, 0xbf, 0x91, 0x65, 0xb3, 0xf0, 0x3f, 0x6a,
    0x99, 0xc7, 0xb4, 0x34, 0x9c, 0x1a, 0x0e, 0xce,
    0xe8, 0x21, 0x08, 0x24, 0x38, 0xfa, 0xfb, 0xdd,
    0x2d, 0xdb, 0xa1, 0x77, 0xc7, 0x57, 0x42, 0x5b,
    0xf9, 0xe2, 0x52, 0x8c, 0xc6, 0x6b, 0x28, 0xed,
    0xcd, 0xea, 0xf3, 0x21, 0xf0, 0xf4, 0x73, 0x49,
    0xf0, 0xb3, 0x5c, 0x39, 0xa8, 0x27, 0x5a, 0xcb,
    0xdc, 0x04, 0x43, 0xbf, 0x2b, 0x6c, 0x7d, 0xa5,
    0x44, 0x8a, 0x66, 0x2d, 0xd0, 0x1b, 0x51, 0x08,
    0x4c, 0x9d, 0x82, 0x60, 0xa3, 0xa3, 0x18, 0x3a,
    0x5c, 0xa0, 0x7b, 0x75, 0x3d, 0xc3, 0xad, 0x45,
    0xb3, 0x87, 0x65, 0xf4, 0xf1, 0x60, 0x39, 0x11,
    0xf4, 0x17, 0x3c, 0x06, 0x91, 0x4f, 0xd3, 0xfa,
    0x7f, 0x57, 0xb3, 0xf7, 0x21, 0xcc, 0x2f, 0x36,
    0xb1, 0x99, 0x95, 0x2d, 0x12, 0xaf, 0xda, 0x5c,
    0xe6, 0x07, 0x0a, 0x7a, 0x36, 0xa4, 0x14, 0xf6,
    0xdf, 0x07, 0xc5, 0xe5, 0x89, 0xb6, 0x2c, 0x19,
    0x07, 0xee, 0x06, 0x78, 0x44, 0x71, 0xdd, 0xbe,
    0x03, 0xfb, 0x63, 0x24, 0xf0, 0xcb, 0x2d, 0x86,
    0xff, 0x23, 0x22, 0xe2, 0x5d, 0xc1, 0x41, 0xbd,
    0x0f, 0x27, 0xa7, 0xd3, 0xe6, 0x09, 0x2a, 0x8f,
    0xcb, 0xe2, 0xba, 0xac, 0x44, 0xc0, 0x05, 0x61,
    0x68, 0x3b, 0xc9, 0x0b, 0x2e, 0x4e, 0x90, 0xce,
    0x30, 0x81, 0x2e, 0x42, 0xa8, 0x3a, 0x5a, 0xea,
    0x26, 0xfd, 0xd0, 0xaf, 0x3b, 0x6e, 0x0d, 0xde,
    0xc4, 0x79, 0xdb, 0xf9, 0xb9, 0xdd, 0xf1, 0x93,
    0xc3, 0x50, 0xd4, 0x54, 0x60, 0x5f, 0xc3, 0x85,
    0x3a, 0x8c, 0x62, 0x25, 0x16, 0xe4, 0x39, 0x64,
    0x31, 0x1d, 0x91, 0xed, 0x91, 0xd2, 0xe6, 0x4c,
    0x1b, 0x00, 0x60, 0x08, 0x98, 0x8f, 0x4e, 0x4d,
    0xc5, 0xe1, 0x42, 0xc0, 0xe9, 0x80, 0x8b, 0xd7,
    0xe3, 0xd1, 0xa2, 0x87, 0xc0, 0x9d, 0x86, 0xf0,
    0x5a, 0x30, 0x9e, 0x06, 0xf6, 0x0f, 0x99, 0x29,
    0xff, 0xde, 0x2b, 0x5f, 0x24, 0x57, 0xd2, 0x63,
    0x65, 0x9f, 0xe2, 0xe2, 0xd1, 0xc4, 0xe3, 0x27,
    0xdd, 0xc4, 0xa6, 0x56, 0xa5, 0xa3, 0x3c, 0x31,
    0xa7, 0x0e, 0x8d, 0xb2, 0x20, 0x9e, 0xe2, 0xe1,
    0x30, 0xef, 0xf8, 0x09, 0x4e, 0x20, 0x52, 0x3f,
    0xfd, 0xe7, 0xa4, 0xb6, 0x09, 0xd0, 0xb8, 0x34,
    0x38, 0x55, 0x4c, 0xc9, 0x31, 0xd3, 0xf1, 0x62,
    0xd1, 0x62, 0x62, 0x69, 0x75, 0xc4, 0x32, 0x50,
    0x13, 0x6f, 0x04, 0x4f, 0xf0, 0xee, 0x1c, 0x0b,
    0xae, 0x8b, 0x6a, 0x2e, 0x9d, 0x14, 0x30, 0xa4,
    0xb3, 0xfa, 0xfd, 0xa6, 0x1c, 0xb7, 0x64, 0x97,
    0xb2, 0x4a, 0x11, 0x98, 0x19, 0x82, 0x45, 0x03,
    0xe4, 0xe9, 0x63, 0x44, 0x22, 0x45, 0x67, 0xf1,
    0x0d, 0xcd, 0x89, 0x7d, 0x3a, 0xbc, 0xfe, 0xd9,
    0x85, 0xbc, 0x86, 0x3b, 0x8e, 0xee, 0xde, 0x46,
    0x56, 0x65, 0x84, 0x42, 0x5d, 0xe1, 0x09, 0x59,
    0x4d, 0xfb, 0xc8, 0xa0, 0xbe, 0xdd, 0x82, 0x7b,
    0xa1, 0xd6, 0x6d, 0x80, 0xbb, 0xea, 0x47, 0x6d,
    0x92, 0xf7, 0x54, 0x56, 0xa9, 0x31, 0x42, 0x06,
    0x1e, 0x3e, 0x69, 0xf3, 0xc6, 0x0f, 0x05, 0x89,
    0x40, 0x14, 0xda, 0xbf, 0xa3, 0x76, 0x43, 0x63,
    0xd0, 0xed, 0x73, 0x8c, 0xf5, 0x31, 0x71, 0x4b,
    0x4f, 0x2d, 0x13, 0x08, 0xd4, 0x68, 0x11, 0x97,
    0xbc, 0xf0, 0x11, 0xac, 0x7e, 0xfc, 0x05, 0x7f,
    0x6c, 0xc1, 0xd0, 0xff, 0xe2, 0x0d, 0x9c, 0xeb,
    0xfb, 0x24, 0xe2, 0x55, 0x85, 0x69, 0x5d, 0x98,
    0x51, 0x30, 0x4c, 0xdf, 0x3d, 0x62, 0x23, 0x83,
    0xd9, 0xdf, 0xcb, 0x61, 0x9f, 0x78, 0x17, 0x56,
    0x8a, 0x2e, 0xec, 0xd3, 0xd0, 0xe9, 0xf1, 0x13,
    0x01, 0x60, 0xe8, 0x59, 0x20, 0x2e, 0x85, 0x96,
    0x2a, 0x7b, 0x8f, 0xb5, 0xf3, 0x50, 0x4c, 0x28,
    0xc3, 0x4e, 0x57, 0x06, 0x7d, 0x18, 0xf0, 0x24,
    0xc0, 0xde, 0x8f, 0xea, 0x89, 0x16, 0x7d, 0x00,
    0x82, 0xd4, 0x24, 0xdf, 0x51, 0x1e, 0xd5, 0xa5,
    0x6b, 0xee, 0x2c, 0x43, 0x0d, 0x8e, 0x38, 0x29,
    0x56, 0xe0, 0x72, 0x92, 0xf5, 0xfc, 0x09, 0xec,
    0x87, 0x74, 0xf7, 0x37, 0x1b, 0xd6, 0x30, 0x69,
    0x11, 0xa1, 0xb4, 0xe8, 0xcc, 0xb0, 0x11, 0x82,
    0x90, 0xa2, 0x97, 0x80, 0xfb, 0x3c, 0x59, 0x69,
    0xc2, 0x80, 0x1c, 0xce, 0x58, 0x30, 0x5d, 0xdb,
    0x2f, 0x58, 0x7c, 0x57, 0xf0, 0x4b, 0x38, 0x6c,
    0x8f, 0xae, 0x14, 0x7a, 0xde, 0x4b, 0x01, 0x94,
    0x57, 0xfa, 0x54, 0x53, 0xde, 0x31, 0xb7, 0x67,
    0x48, 0x4f, 0xcb, 0xaf, 0xdd, 0x6a, 0x25, 0x7e,
    0x49, 0x7b, 0x65, 0xef, 0x94, 0xc4, 0xb4, 0x19,
    0x09, 0x2a, 0xd9, 0x19, 0xdb, 0x6c, 0xea, 0x34,
    0xa3, 0x26, 0x82, 0x37, 0xbf, 0xd8, 0x66, 0x5d,
    0xea, 0xb9, 0x87, 0x1b, 0xd7, 0x36, 0x47, 0x8d,
    0x80, 0xfd, 0x0c, 0x6c, 0x25, 0xa6, 0x1e, 0x98,
    0x25, 0x88, 0x67, 0x65, 0xa1, 0xd9, 0xc8, 0x92,
    0x9f, 0x77, 0x9a, 0x2c, 0xd4, 0xa2, 0xc7, 0x1d,
    0x1c, 0xf7, 0xa9, 0x7f, 0xee, 0xa1, 0x87, 0x03,
    0x5d, 0x21, 0xca, 0x61, 0xfb, 0xfe, 0xa6, 0x99,
    0xd8, 0x40, 0x3c, 0xb6, 0x8b, 0x04, 0xdd, 0x98,
    0x8f, 0x59, 0x7d, 0x5f, 0x27, 0x16, 0xc8, 0x4c,
    0x87, 0xe7, 0x0c, 0xe9, 0xf9, 0x68, 0x22, 0xf2,
    0x56, 0x41, 0x61, 0x07, 0x3d, 0xe8, 0x16, 0xdb,
    0xc0, 0x10, 0x5d, 0x45, 0x43, 0xcb, 0x49, 0x47,
    0x47, 0xf4, 0xfb, 0xb3, 0x27, 0x07, 0x8c, 0xb4,
    0x8e, 0xb9, 0x85, 0xa1, 0x09, 0x78, 0xe1, 0xfe,
    0xa0, 0xc5, 0xc0, 0xc3, 0x59, 0xa8, 0x42, 0x3b,
    0x63, 0xbc, 0x1b, 0xb9, 0x6f, 0x78, 0x24, 0xac,
    0xa1, 0xdd, 0x77, 0x71, 0xcb, 0xed, 0x8b, 0xb8,
    0x76, 0x64, 0x26, 0xb7, 0x4d, 0xa6, 0x7b, 0x72,
    0x07, 0xd6, 0x1e, 0x3f, 0x20, 0xae, 0x03, 0x9c,
    0x88, 0xd8, 0xf2, 0xe8, 0xe4, 0x5c, 0xb5, 0x2e,
    0x0a, 0xdd, 0xcf, 0xe8, 0xf0, 0xea, 0xd4, 0x39,
    0xaa, 0xdf, 0xdf, 0x71, 0x5c, 0x03, 0x8e, 0x08,
    0xa9, 0x83, 0xef, 0x43, 0x38, 0xf0, 0x0b, 0x8c,
    0x9d, 0x4e, 0x8c, 0x16, 0xe6, 0xaf, 0xaa, 0x87,
    0xeb, 0xba, 0x49, 0x6e, 0x53, 0xcd, 0x38, 0x45,
    0x51, 0x92, 0x33, 0x4d, 0xb8, 0xd2, 0x45, 0x73,
    0x77, 0x92, 0x2a, 0x11, 0xde, 0x5f, 0x6d, 0x14,
    0xb5, 0xcb, 0xa6, 0xdd, 0xd8, 0xdd, 0x52, 0x19,
    0x98, 0x04, 0x32, 0xab, 0x43, 0x02, 0x8f, 0xed,
    0x3e, 0x08, 0x41, 0x30, 0xbb, 0x1d, 0x67, 0x30,
    0xe1, 0x55, 0xd0, 0x78, 0x44, 0x1f, 0x34, 0x6b,
    0x7b, 0x6f, 0xcf, 0x00, 0xf2, 0x96, 0x03, 0x9f,
    0x4e, 0x51, 0x06, 0xa6, 0x89, 0xa7, 0xe2, 0x79,
    0x37, 0xa5, 0xa1, 0x97, 0xce, 0x75, 0xdc, 0x0c,
    0xb6, 0xe7, 0xe3, 0x23, 0x9d, 0xe2, 0x89, 0x49,
    0x55, 0xb1, 0x48, 0xd6, 0x72, 0x82, 0x63, 0x5a,
    0x0f, 0x5a, 0x59, 0x8b, 0x0e, 0xd2, 0xc2, 0x39,
    0xc4, 0xf9, 0x0a, 0x32, 0x26, 0xb8, 0x52, 0x41,
    0x83, 0xb2, 0x02, 0x93, 0x2e, 0x4a, 0x47, 0xab,
    0xed, 0x4f, 0x0c, 0x70, 0x93, 0xe1, 0xeb, 0x05,
    0xb2, 0xfa, 0xd7, 0xfe, 0x71, 0x01, 0xfa, 0x65,
    0x80, 0x8b, 0xed, 0x0b, 0x70, 0xd3, 0x5d, 0x8a,
    0xd1, 0x58, 0x6b, 0x01, 0xa6, 0x13, 0x19, 0xb9,
    0x7c, 0xd3, 0xe0, 0xa9, 0x24, 0xc0, 0xed, 0x5e,
    0x6c, 0x37, 0x67, 0x0e, 0x89, 0xa0, 0xf6, 0x8e,
    0x5f, 0x74, 0x03, 0xbd, 0x1c, 0xde, 0x84, 0x70,
    0xb2, 0x72, 0xe1, 0x41, 0xaf, 0xd8, 0xf8, 0xbb,
    0x64, 0x30, 0x84, 0x0b, 0x16, 0x49, 0x09, 0xa1,
    0xb4, 0x44, 0xfe, 0x19, 0x6d, 0x12, 0xf3, 0x36,
    0xfb, 0x54, 0xb0, 0xd5, 0x7a, 0x19, 0x8c, 0x77,
    0xdf, 0x58, 0x16, 0x76, 0x9d, 0xc4, 0x35, 0x2e,
    0xad, 0x0c, 0x86, 0x97, 0x3b, 0xb4, 0x38, 0x75,
    0x62, 0xd9, 0x8d, 0x95, 0x1e, 0xe4, 0x7b, 0x28,
    0x34, 0x98, 0x8c, 0x7b, 0x35, 0xe0, 0xaa, 0xa4,
    0x75, 0xeb, 0xcf, 0xb9, 0x6d, 0x18, 0x1e, 0x19,
    0xe0, 0x79, 0x5c, 0xae, 0xe4, 0x00, 0xd6, 0xaf,
    0xb3, 0x3c, 0xcf, 0xcf, 0x74, 0xd5, 0x7f, 0x32,
    0x78, 0x19, 0x8f, 0x4f, 0x82, 0xd7, 0x79, 0xb0,
    0x59, 0x15, 0xb2, 0xd5, 0xae, 0xf1, 0xb7, 0x81,
    0x4c, 0x96, 0x32, 0xc2, 0x41, 0x18, 0x49, 0xfb,
    0xac, 0x32, 0x66, 0x20, 0xbb, 0xb0, 0x05, 0x8f,
    0xb1, 0xde, 0x30, 0x5e, 0x64, 0x56, 0x58, 0xad,
    0xcb, 0xae, 0x20, 0x7f, 0xa7, 0xad, 0x2a, 0x00,
    0xf1, 0xd9, 0xde, 0xcb, 0x18, 0xc6, 0x68, 0x7f,
    0x59, 0x56, 0x98, 0xcc, 0xff, 0x9d, 0x55, 0x2a,
    0x34, 0x0c, 0xe4, 0xaa, 0xc7, 0x1b, 0x0d, 0x23,
    0xa7, 0x89, 0x37, 0x69, 0x46, 0xe7, 0x51, 0xa1,
    0x8b, 0x52, 0xee, 0x22, 0xeb, 0x37, 0x57, 0x54,
    0xb7, 0xb5, 0x70, 0xa8, 0x4c, 0xd7, 0xd3, 0x93,
    0x6c, 0xdf, 0x7b, 0x8e, 0x97, 0xf0, 0x3a, 0xe7,
    0x4e, 0x1a, 0x81, 0xd1, 0x1f, 0x85, 0xf4, 0x54,
    0x4a, 0x79, 0xc3, 0xf4, 0xd7, 0x5a, 0xcd, 0xc2,
    0xd3, 0x00, 0x38, 0x85, 0x7e, 0x8f, 0xcf, 0xc2,
    0x92, 0x1c, 0x54, 0x8d, 0x1d, 0x0d, 0x4e, 0x03,
    0x30, 0xf0, 0x4a, 0x8f, 0xfc, 0x5d, 0x61, 0x15,
    0x92, 0x6e, 0x8a, 0x61, 0x45, 0xb6, 0x25, 0x2a,
    0x0c, 0x44, 0x04, 0x56, 0x05, 0x16, 0xf1, 0x50,
    0x8f, 0x4c, 0xb3, 0x11, 0x6a, 0x69, 0x62, 0x92,
    0xf0, 0x42, 0xd4, 0xc3, 0x55, 0x16, 0x3b, 0xa1,
    0x16, 0x41, 0x92, 0xaa, 0x14, 0x17, 0x80, 0xed,
    0x33, 0xa5, 0x15, 0x62, 0xe5, 0x02, 0xe8, 0xfc,
    0x7d, 0xa8, 0x0c, 0x9a, 0x1f, 0xa6, 0x31, 0xf5,
    0xe5, 0x82, 0x0b, 0xf2, 0x24, 0x10, 0x6d, 0x8f,
    0x97, 0x42, 0x77, 0x93, 0xf7, 0x63, 0xde, 0xca,
    0x84, 0x2c, 0x9d, 0xe5, 0x7c, 0xf3, 0x91, 0xd2,
    0x5f, 0xa1, 0x7f, 0xfe, 0x48, 0x8f, 0x8d, 0x61,
    0x66, 0xc8, 0xa8, 0x77, 0xb2, 0x87, 0x89, 0xfb,
    0xee, 0x10, 0x88, 0xcf, 0xad, 0xf1, 0xb0, 0xd8,
    0x51, 0xf0, 0xd0, 0x51, 0x5f, 0x1e, 0xa5, 0x46,
    0xcb, 0xc9, 0x3e, 0x76, 0xca, 0x79, 0xfd, 0x1a,
    0xaa, 0x1c, 0x22, 0x5e, 0xdd, 0x79, 0x1b, 0x90,
    0x94, 0x63, 0x19, 0x05, 0x54, 0xa2, 0x5b, 0xa7,
    0x9c, 0x81, 0x32, 0x14, 0x7f, 0xea, 0xe3, 0x1f,
    0x55, 0x8f, 0x89, 0x89, 0x08, 0x9b, 0x3a, 0x35,
    0x71, 0x13, 0x79, 0x5b, 0xe9, 0xa4, 0x1b, 0x5f,
    0x73, 0x11, 0x38, 0x30, 0xa2, 0x5f, 0xcd, 0x56,
    0x87, 0xae, 0x3d, 0x12, 0x57, 0xa8, 0xa6, 0x3b,
    0x4a, 0x32, 0xc1, 0x27, 0x4d, 0x3d, 0xbe, 0x0f,
    0xbc, 0xfc, 0x1c, 0x49, 0xc4, 0xe5, 0x0a, 0x21,
    0x73, 0xcc, 0x72, 0x37, 0x90, 0xb9, 0x9b, 0x57,
    0x53, 0x07, 0x10, 0x42, 0x0b, 0x66, 0xdc, 0x30,
    0xe6, 0x8b, 0xf4, 0x7c, 0xa4, 0x36, 0x34, 0xd9,
    0xd7, 0x45, 0xbc, 0xee, 0xa4, 0x5f, 0x39, 0x78,
    0x0e, 0x4f, 0x58, 0xdd, 0xe8, 0xd3, 0xdb, 0x4c,
    0xb6, 0xa1, 0x43, 0x91, 0x07, 0x5b, 0x5c, 0x8e,
    0x8f, 0xb1, 0xa1, 0x7b, 0x5d, 0x3c, 0xdd, 0x26,
    0x1f, 0xde, 0x06, 0x7c, 0x41, 0x0b, 0xc2, 0xa3,
    0x08, 0x96, 0xe8, 0x18, 0x96, 0x5a, 0xb3, 0x39,
    0x41, 0xd2, 0x3c, 0x1c, 0xd7, 0x1b, 0xe6, 0x22,
    0xfe, 0xec, 0x9e, 0x73, 0x7d, 0x7b, 0xa9, 0xdf,
    0x88, 0xcb, 0x95, 0xd0, 0x1c, 0xe8, 0xca, 0x51,
    0x13, 0x86, 0x47, 0x35, 0x71, 0x52, 0xf5, 0x56,
    0xbd, 0x7b, 0x54, 0x78, 0x42, 0xf1, 0xee, 0x2c,
    0x9f, 0x36, 0x6c, 0xe1, 0x72, 0x5f, 0x8c, 0xa6,
    0xa1, 0xb2, 0x3a, 0xff, 0x56, 0x5a, 0x32, 0xdb,
    0xa2, 0x63, 0xe6, 0x4b, 0x49, 0xba, 0x3a, 0x4c,
    0x99, 0xa6, 0x89, 0xa9, 0x3a, 0x25, 0xd6, 0x92,
    0x0c, 0xdf, 0xa2, 0x99, 0xc2, 0x99, 0x30, 0xee,
    0x21, 0xc0, 0x82, 0xad, 0xd1, 0x81, 0x77, 0xeb,
    0x35, 0x7d, 0x9a, 0xa7, 0x24, 0xd4, 0x2c, 0xd0,
    0x00, 0xc7, 0xb2, 0xb1, 0x2b, 0x53, 0x92, 0x7c,
    0x4f, 0x45, 0xb1, 0xf8, 0x85, 0x38, 0x34, 0x4e,
    0xc4, 0x8d, 0xd4, 0xe8, 0x8e, 0xe1, 0x05, 0x1a,
    0xd8, 0xf5, 0xef, 0xbc, 0xff, 0xff, 0xd9, 0xb0,
    0x65, 0x65, 0x1e, 0x12, 0xfc, 0x31, 0x52, 0xe4,
    0x8d, 0xb1, 0x61, 0x10, 0x5a, 0xcd, 0x22, 0xff,
    0xf6, 0xb2, 0x52, 0x32, 0x36, 0x05, 0x3c, 0x84,
    0xa6, 0xb1, 0xb3, 0x37, 0xaf, 0x7b, 0x59, 0xcb,
    0x67, 0x57, 0xf6, 0x9d, 0x5c, 0x6e, 0x30, 0xbd,
    0x12, 0xd5, 0x07, 0xdd, 0x76, 0xfd, 0xb1, 0xe7,
    0x78, 0x1e, 0x21, 0x88, 0xa7, 0x29, 0x2f, 0x28,
    0x38, 0x77, 0xc6, 0x3e, 0x0b, 0x43, 0x28, 0x21,
    0x46, 0x9a, 0x61, 0xea, 0xc4, 0x7e, 0x61, 0x4e,
    0x51, 0xfd, 0x8d, 0xd9, 0xef, 0x23, 0x8d, 0x64,
    0xc7, 0x77, 0x8f, 0x78, 0x1e, 0xdf, 0xca, 0xc2,
    0xe8, 0x79, 0x4e, 0xa2, 0xc3, 0x6b, 0xfe, 0x6c,
    0x21, 0xa1, 0x7b, 0x2b, 0xac, 0x3e, 0x9a, 0xd3,
    0xfe, 0xa2, 0x4d, 0xc1, 0x35, 0x1f, 0x17, 0xa5,
    0x8e, 0x42, 0x7f, 0x8f, 0x75, 0x8c, 0x8a, 0xfc,
    0x4f, 0x58, 0x45, 0xa9, 0x26, 0xb5, 0xda, 0xec,
    0x38, 0x88, 0x0c, 0xea, 0x42, 0x63, 0x06, 0x7d,
    0x4f, 0x49, 0x5f, 0xd1, 0x38, 0xd6, 0xcd, 0x35,
    0x62, 0xe6, 0x1f, 0x8d, 0xdf, 0xb8, 0x2f, 0xb4,
    0x47, 0x9b, 0x3f, 0x9c, 0xae, 0xec, 0x49, 0x13,
    0x59, 0x75, 0x63, 0xbe, 0x80, 0xd2, 0xb0, 0x45,
    0x9c, 0x46, 0x8d, 0x28, 0xd3, 0x22, 0x37, 0x99,
    0xfd, 0x53, 0x32, 0x9c, 0xc3, 0x3b, 0x6b, 0xb5,
    0x41, 0x07, 0x51, 0xfc, 0xba, 0x09, 0x02, 0xb9,
    0x7f, 0x43, 0x59, 0x97, 0x12, 0x6a, 0x19, 0x25,
    0x90, 0x66, 0x5f, 0x56, 0x2c, 0x3d, 0xb5, 0x50,
    0xe1, 0xcb, 0x93, 0xd5, 0xb5, 0x3c, 0x8d, 0x0e,
    0x62, 0x58, 0x91, 0xe1, 0x44, 0x6c, 0x0c, 0x78,
    0x6b, 0xc3, 0x6c, 0xc2, 0x03, 0x23, 0xf4, 0x74,
    0x53, 0x24, 0x6e, 0x92, 0x21, 0x58, 0x5d, 0x9b,
    0xbd, 0xa0, 0xf1, 0xc3, 0xc1, 0xa6, 0x4c, 0xd9,
    0x5d, 0x58, 0xa7, 0x67, 0x4a, 0x48, 0xb3, 0xdc,
    0xd6, 0x81, 0xe3, 0xcf, 0x63, 0x41, 0x3f, 0x1f,
    0x55, 0xf2, 0x96, 0x70, 0x68, 0xa3, 0x58, 0x6e,
    0x68, 0x52, 0xab, 0x73, 0x95, 0x61, 0xf6, 0x52,
    0xdf, 0xef, 0x4c, 0xc3, 0x27, 0x3e, 0xa4, 0x11,
    0xe2, 0x56, 0xef, 0x70, 0x35, 0x78, 0x45, 0x6d,
    0xac, 0x4f, 0xf1, 0xe0, 0x01, 0xc3, 0xcc, 0xca,
    0xd6, 0x02, 0xc4, 0x5c, 0x84, 0x7f, 0xbf, 0x48,
    0xf8, 0xa4, 0x84, 0xb1, 0xfd, 0x07, 0x2d, 0xf8,
    0x68, 0xa6, 0x72, 0x4b, 0x18, 0x1f, 0xe7, 0x90,
    0x26, 0x01, 0x41, 0x3b, 0x6c, 0x45, 0x3e, 0x2d,
    0x6a, 0xfe, 0x03, 0x07, 0xb7, 0x28, 0x2d, 0x92,
    0x61, 0xaa, 0x67, 0xc2, 0x6d, 0x92, 0x2d, 0xdf,
    0x0c, 0x6e, 0x7e, 0x3a, 0x5d, 0x65, 0xf1, 0xfe,
    0x5f, 0x5f, 0x27, 0xc8, 0x2d, 0xc6, 0xa1, 0x56,
    0xfb, 0xa9, 0x1f, 0x2f, 0x90, 0xe8, 0x51, 0xd0,
    0xcf, 0x0a, 0x1b, 0x48, 0x7e, 0xb3, 0x37, 0xc2,
    0x72, 0x68, 0x15, 0x17, 0x32, 0x38, 0xb3, 0x3f,
    0x1f, 0x1d, 0x80, 0xcb, 0xbd, 0xbb, 0x44, 0x82,
    0x30, 0x2a, 0x93, 0x07, 0xaf, 0x94, 0xd6, 0xf4,
    0x23, 0x20, 0x10, 0x15, 0x17, 0x93, 0xf9, 0xd1,
    0xad, 0x00, 0xfb, 0x91, 0xdf, 0x36, 0xb6, 0xb7,
    0x3d, 0x9d, 0x11, 0x35, 0x30, 0xbc, 0x5e, 0x53,
    0xf5, 0xe1, 0xf0, 0xb0, 0x9d, 0x16, 0xab, 0x3a,
    0x40, 0x1f, 0x28, 0x53, 0xac, 0x3d, 0x92, 0x7f,
    0x28, 0x88, 0x50, 0x17, 0x2c, 0x2c, 0xc7, 0x91,
    0xa7, 0xe7, 0xb2, 0x37, 0xf9, 0x27, 0xe8, 0x10,
    0x08, 0x35, 0x96, 0xe1, 0x35, 0x61, 0xa6, 0x3a,
    0x6f, 0x77, 0x3f, 0xf7, 0xcd, 0x4b, 0x41, 0x40,
    0x6e, 0x5e, 0x32, 0xb4, 0xaf, 0xc2, 0xf9, 0xe8,
    0x79, 0xfa, 0x12, 0x63, 0xcc, 0xd1, 0x3f, 0xbe,
    0xb8, 0xc3, 0xee, 0xd8, 0xbc, 0x3f, 0xb7, 0x59,
    0xe3, 0xec, 0x07, 0x86, 0xc4, 0xc6, 0xce, 0x4a,
    0x59, 0xae, 0x6e, 0x04, 0x74, 0x2c, 0x63, 0x90,
    0xfa, 0x6c, 0xda, 0xac, 0x0f, 0x10, 0xd0, 0x7d,
    0xb5, 0x22, 0x50, 0x35, 0x46, 0x57, 0x52, 0x63,
    0x67, 0x5a, 0xf3, 0x23, 0x99, 0x81, 0x08, 0xfa,
    0xd3, 0x2c, 0xd4, 0x35, 0x98, 0x32, 0x49, 0xfa,
    0x0f, 0x09, 0x5f, 0x0d, 0x51, 0x13, 0xd6, 0x18,
    0xd2, 0xee, 0x49, 0xfc, 0x3f, 0x63, 0x3b, 0x87,
    0x6e, 0xfd, 0x53, 0x23, 0x43, 0xaf, 0x4a, 0x1a,
    0x7f, 0x4b, 0x2c, 0xdd, 0x5b, 0x15, 0x23, 0x75,
    0xa4, 0xc9, 0xc0, 0xdb, 0x13, 0xfd, 0x6d, 0x3c,
    0x11, 0x18, 0xda, 0x55, 0xd4, 0xff, 0x04, 0x87,
    0x6c, 0x5b, 0x8c, 0x9f, 0x94, 0x3a, 0xec, 0xf4,
    0x39, 0x8f, 0x22, 0x63, 0x33, 0x8b, 0xed, 0x6f,
    0x77, 0xee, 0x56, 0xb2, 0x6a, 0x8d, 0x38, 0x4f,
    0x10, 0xca, 0xe1, 0x2b, 0x35, 0x96, 0x3f, 0x56,
    0x64, 0x32, 0x46, 0x53, 0x73, 0x5a, 0xff, 0x3c,
    0xc1, 0xb7, 0xc7, 0xa5, 0x67, 0xb8, 0x26, 0x69,
    0xd8, 0x5f, 0xea, 0x97, 0xbf, 0x10, 0xa6, 0xd4,
    0x25, 0xe3, 0x64, 0x2f, 0x05, 0xbb, 0x4d, 0xff,
    0x56, 0x13, 0xbb, 0x7d, 0x49, 0x77, 0x58, 0x43,
    0x87, 0x7b, 0xf2, 0xf5, 0xbc, 0x0e, 0xf6, 0x6f,
    0xf5, 0xe6, 0xb3, 0xd2, 0x71, 0xc3, 0x33, 0xa3,
    0xff, 0xd7, 0x50, 0x75, 0xb6, 0x79, 0x36, 0x01,
    0xda, 0x40, 0x5b, 0x2f, 0x62, 0xec, 0x4c, 0x76,
    0x83, 0x4e, 0xba, 0x99, 0xea, 0x75, 0xe2, 0x76,
    0x70, 0x07, 0xdc, 0x45, 0x03, 0xee, 0x07, 0x1f,
    0x48, 0x2b, 0xb2, 0x7d, 0xec, 0xb3, 0x07, 0x80,
    0xa1, 0x73, 0x91, 0x71, 0xd9, 0xdf, 0x8d, 0x81,
    0x1f, 0x60, 0x94, 0x79, 0x1f, 0xf9, 0x5c, 0xda,
    0xba, 0x55, 0xe1, 0x10, 0x2d, 0xb3, 0xc8, 0xe8,
    0xe8, 0x47, 0xc6, 0xb8, 0xdf, 0xb1, 0x2e, 0x72,
    0x23, 0x28, 0xbf, 0x15, 0xae, 0x87, 0x6e, 0x76,
    0x4f, 0xac, 0xe0, 0x81, 0xa1, 0x16, 0xb5, 0x99,
    0x52, 0x23, 0x26, 0x5a, 0x2c, 0x16, 0xe0, 0x8f,
    0xd0, 0x41, 0x6d, 0x39, 0xec, 0xa0, 0x61, 0xb5,
    0x0c, 0x01, 0xbe, 0xba, 0xb7, 0x81, 0x9a, 0x42,
    0xd1, 0x1d, 0xf6, 0x04, 0xe7, 0xbf, 0x86, 0x06,
    0x4d, 0xfc, 0x52, 0x99, 0x81, 0x00, 0xb4, 0xfd,
    0x2d, 0xb9, 0x0b, 0x7b, 0xdb, 0xea, 0xe3, 0x6a,
    0x3a, 0xbd, 0xf9, 0xe7, 0xe2, 0x6d, 0x35, 0x84,
    0xa2, 0x6c, 0xfd, 0x7d, 0x2b, 0xe7, 0x5f, 0x2d,
    0xd1, 0xf7, 0x6d, 0x9d, 0xa7, 0xa5, 0x09, 0x9b,
    0xad, 0x97, 0xb6, 0x7b, 0x75, 0x5b, 0x6d, 0x06,
    0x81, 0x52, 0xf4, 0xf0, 0x3e, 0x59, 0x3c, 0xad,
    0xbc, 0xca, 0x69, 0x7d, 0x57, 0xc5, 0x04, 0x89,
    0x4e, 0xe7, 0x36, 0xaf, 0xf9, 0xcd, 0x7d, 0xe7,
    0xe5, 0x0e, 0x9b, 0xf7, 0x5f, 0x7f, 0xa2, 0xb2,
    0xc9, 0xe4, 0xf5, 0x92, 0x38, 0xc8, 0x87, 0x86,
    0x5a, 0xcb, 0xd9, 0x8f, 0x4a, 0x68, 0xd2, 0xa1,
    0x2a, 0x8b, 0x4c, 0x08, 0x99, 0xad, 0xb8, 0x5d,
    0x7b, 0xe0, 0x84, 0x39, 0xa0, 0x39, 0x4e, 0x76,
    0x80, 0x96, 0xe3, 0xdc, 0xa5, 0x87, 0x94, 0x09,
    0xa2, 0xb5, 0xa0, 0x0b, 0x01, 0x38, 0x1e, 0x95,
    0x40, 0x63, 0x92, 0x62, 0x0e, 0xab, 0xee, 0x8f,
    0x9e, 0x91, 0x93, 0xe3, 0xd1, 0x2f, 0x8a, 0x7e,
    0xac, 0x30, 0xfc, 0xe1, 0x66, 0x02, 0x4f, 0xe2,
    0x87, 0x51, 0x06, 0xaf, 0x1b, 0x24, 0x08, 0x91,
    0x0c, 0x78, 0xe8, 0x26, 0x85, 0xbb, 0xc1, 0xf0,
    0x55, 0x55, 0xb1, 0x6c, 0x4d, 0x9b, 0x81, 0xfc,
    0x09, 0x32, 0xc0, 0x23, 0xfe, 0x01, 0xed, 0x7e,
    0xd5, 0x1d, 0x8e, 0xee, 0x0d, 0x08, 0xcf, 0x5a,
    0xaa, 0xe9, 0x40, 0x02, 0xda, 0x3d, 0xc2, 0x53,
    0xb4, 0x33, 0xd5, 0x1f, 0xa8, 0xa6, 0x28, 0x34,
    0xfa, 0xc0, 0xb9, 0xd1, 0x3d, 0x4f, 0x8d, 0x4f,
    0x7a, 0x37, 0x01, 0x1a, 0x07, 0x16, 0x18, 0xdc,
    0xb0, 0x9c, 0x3f, 0x5e, 0xbe, 0xdf, 0x5a, 0x04,
    0xb7, 0x4d, 0xc9, 0x5e, 0xdd, 0x43, 0x18, 0x4a,
    0x6d, 0x0d, 0x1a, 0x57, 0x2b, 0x2f, 0x4b, 0x90,
    0x06, 0xef, 0x86, 0x0d, 0xb2, 0xc4, 0x90, 0xab,
    0xb4, 0x3c, 0x23, 0x6a, 0x9d, 0xcb, 0x0b, 0x3b,
    0xaf, 0x9b, 0xf0, 0x8f, 0xa9, 0x6c, 0x1e, 0x27,
    0x00, 0x0e, 0x13, 0xa0, 0xef, 0x73, 0x23, 0xee,
    0x33, 0x6b, 0x9f, 0xe1, 0xdb, 0x76, 0x92, 0x9d,
    0x8d, 0x67, 0x78, 0x2a, 0xc2, 0xc3, 0x65, 0xd6,
    0xd4, 0xa0, 0x28, 0x61, 0xa2, 0xdd, 0xad, 0x1e,
    0x63, 0xba, 0x85, 0xd4, 0x7c, 0x38, 0xae, 0x58,
    0x44, 0x53, 0x40, 0x47, 0xc3, 0x94, 0xff, 0xe9,
    0xd7, 0x3f, 0x0b, 0xf1, 0xe1, 0x65, 0x03, 0x97,
    0xa9, 0x06, 0x60, 0xb6, 0xf7, 0x18, 0x3a, 0xeb,
    0xaa, 0xa9, 0x62, 0xe8, 0xe7, 0x58, 0x59, 0xf4,
    0xc3, 0xe1, 0x3e, 0x85, 0x2e, 0x7e, 0xed, 0x6e,
    0x70, 0x8c, 0x93, 0xdf, 0x6e, 0x25, 0xcf, 0xfd,
    0x54, 0x57, 0x6c, 0xb4, 0xa3, 0x8c, 0x72, 0x97,
    0x7a, 0x5f, 0xba, 0x98, 0xb9, 0x24, 0xc0, 0xa5,
    0xe2, 0xc1, 0x19, 0x37, 0xb8, 0x75, 0x61, 0xfe,
    0xba, 0x56, 0x4e, 0xa4, 0x73, 0x63, 0x26, 0x4e,
    0x2f, 0x52, 0x44, 0x67, 0x33, 0x1a, 0xf5, 0xb7,
    0x67, 0x06, 0x0b, 0x57, 0x96, 0x2a, 0x52, 0xa3,
    0x89, 0x16, 0x46, 0x61, 0x63, 0x17, 0xdf, 0xe8,
    0xf5, 0xc8, 0xae, 0x35, 0x46, 0x7c, 0x10, 0xb1,
    0xf3, 0xc5, 0x7a, 0x10, 0xd9, 0x31, 0xfa, 0xe6,
    0x50, 0xe6, 0x18, 0xd6, 0xf0, 0x72, 0x55, 0x61,
    0xe9, 0x64, 0xaa, 0xcc, 0xed, 0x4d, 0x54, 0xf2,
    0x17, 0xd0, 0x0a, 0xd2, 0xe5, 0x87, 0x25, 0x8d,
    0x0f, 0xed, 0x58, 0x01, 0x47, 0x20, 0xcb, 0x4d,
    0xb0, 0xc9, 0x8a, 0xce, 0x32, 0xf2, 0x14, 0x29,
    0x28, 0x29, 0x04, 0x28, 0x30, 0x27, 0x47, 0x5a,
    0xe4, 0xf0, 0xff, 0x74, 0x1f, 0xb8, 0x82, 0xfe,
    0xec, 0x97, 0x34, 0x87, 0x2d, 0x9f, 0x6c, 0x04,
    0xd3, 0xfc, 0xc6, 0x4c, 0xd4, 0x98, 0x3b, 0xa0,
    0x68, 0x4c, 0xa4, 0x1b, 0x64, 0xea, 0xa1, 0x93,
    0x9c, 0x8f, 0xcc, 0x2f, 0xd8, 0x1c, 0x4e, 0xf6,
    0x36, 0xe7, 0x6c, 0x2f, 0x13, 0x1c, 0xe2, 0xde,
    0x25, 0xf0, 0x31, 0xc0, 0xbc, 0x5d, 0x33, 0xb0,
    0xc0, 0x54, 0x85, 0xca, 0xdb, 0xae, 0xa0, 0x8b,
    0x01, 0x64, 0x6a, 0x56, 0x31, 0xb5, 0x4c, 0xac,
    0x84, 0xfd, 0xdf, 0xf9, 0x79, 0x1f, 0xc0, 0xca,
    0xef, 0xe8, 0x89, 0x99, 0xa8, 0x81, 0x14, 0xd5,
    0x39, 0x0e, 0x79, 0xc8, 0x6b, 0xc6, 0x45, 0x08,
    0xa3, 0x29, 0x63, 0x82, 0xea, 0x2c, 0xc6, 0xa5,
    0x0b, 0xd2, 0x5d, 0x6f, 0x7e, 0xb9, 0xd5, 0x4b,
    0x16, 0x89, 0xd3, 0xa7, 0xc6, 0xea, 0xe2, 0xae,
    0x73, 0x21, 0x83, 0x44, 0xc3, 0x83, 0xc3, 0xe5,
    0x0c, 0x83, 0x6e, 0xb7, 0xd1, 0xac, 0x10, 0x0c,
    0x07, 0xf4, 0x80, 0xae, 0xf0, 0x86, 0xfa, 0x53,
    0x17, 0x90, 0x06, 0x89, 0xca, 0x95, 0xb5, 0x94,
    0xf0, 0xbd, 0xb8, 0x44, 0xec, 0xc2, 0xbf, 0x99,
    0xd2, 0x2b, 0x63, 0x20, 0x37, 0x2e, 0xb8, 0x91,
    0x01, 0xc1, 0x45, 0x76, 0xf8, 0x7a, 0xd1, 0xbe,
    0x0c, 0x8e, 0x18, 0xce, 0x9c, 0xa9, 0x8f, 0x53,
    0x2c, 0x2d, 0x24, 0x11, 0x3e, 0x3e, 0x6a, 0xb2,
    0x38, 0x71, 0x7d, 0x9a, 0xba, 0x4b, 0xa9, 0x27,
    0x73, 0x7f, 0xea, 0xbe, 0x74, 0x90, 0x11, 0x12,
    0x30, 0x88, 0x6f, 0x58, 0x9f, 0x19, 0xf9, 0x53,
    0x11, 0xad, 0xc7, 0x09, 0x98, 0xa5, 0x1b, 0xec,
    0x68, 0xaf, 0x1f, 0x9c, 0x6c, 0x2d, 0x5c, 0x3f,
    0xe1, 0x29, 0x57, 0x81, 0x08, 0x97, 0x04, 0xe1,
    0x56, 0xad, 0x35, 0x24, 0xc2, 0xfe, 0xfa, 0x68,
    0x73, 0xa7, 0xb6, 0xcf, 0xa9, 0x34, 0xde, 0x3c,
    0x0e, 0xa1, 0x27, 0xdb, 0xa2, 0xcd, 0xa0, 0x5d,
    0x1a, 0xcb, 0x0e, 0x12, 0x3c, 0xef, 0x4f, 0xc2,
    0xf2, 0xa6, 0x73, 0x56, 0x9f, 0x28, 0xee, 0x92,
    0x1e, 0x57, 0x68, 0x86, 0x47, 0x3d, 0x6e, 0xe3,
    0xdb, 0x30, 0x41, 0x5b, 0xcc, 0xa4, 0xb8, 0x87,
    0x86, 0x5e, 0x63, 0x3b, 0xc8, 0x01, 0xc1, 0x7c,
    0xaa, 0x85, 0x45, 0xc9, 0x3f, 0x26, 0x67, 0xc2,
    0xd8, 0xcd, 0x1f, 0x0d, 0x76, 0x33, 0xed, 0x6e,
    0x07, 0x24, 0xf6, 0xea, 0x66, 0xc5, 0xba, 0xa3,
    0xa1, 0x3f, 0xae, 0x0c, 0xd9, 0x81, 0x96, 0xf0,
    0xb1, 0x6d, 0xe9, 0x1e, 0xc2, 0xcf, 0x2e, 0x9a,
    0x35, 0x16, 0x3c, 0x87, 0x2d, 0x10, 0x71, 0x4b,
    0xd8, 0x6d, 0x4d, 0xee, 0x31, 0x7c, 0x0c, 0x11,
    0xf5, 0xac, 0x24, 0xf6, 0x64, 0xe7, 0xe5, 0x37,
    0x18, 0x6a, 0x4d, 0xcb, 0xec, 0xe4, 0xf9, 0x0b,
    0x74, 0x3e, 0x2e, 0x54, 0xf2, 0x47, 0x63, 0x73,
    0xf4, 0x9d, 0x4a, 0x7f, 0x52, 0xbb, 0x63, 0xc3,
    0x3c, 0x39, 0x93, 0xc4, 0x80, 0xad, 0x8f, 0xa7,
    0x2e, 0x36, 0x0f, 0x9b, 0x20, 0xc3, 0xf0, 0x62,
    0xc2, 0x76, 0x02, 0x04, 0xbd, 0x01, 0x93, 0xde,
    0x7e, 0xe9, 0x22, 0x60, 0xc6, 0xfb, 0xce, 0x21,
    0xb8, 0x20, 0xc7, 0xcd, 0x90, 0x68, 0x85, 0xc6,
    0x82, 0xfd, 0xcd, 0xea, 0xc3, 0xef, 0x3c, 0x9b,
    0xff, 0x9a, 0xe6, 0x28, 0x32, 0xac, 0xea, 0xf4,
    0x93, 0x45, 0x0a, 0x49, 0x2e, 0x9d, 0x4b, 0xb3,
    0x1f, 0x0b, 0x8a, 0x11, 0x3a, 0xa1, 0x3b, 0xe9,
    0xa2, 0x8c, 0x16, 0x41, 0x98, 0xe7, 0x02, 0x0d,
    0xdb, 0xc9, 0x7f, 0x7a, 0x26, 0x2f, 0x4a, 0x8b,
    0xa2, 0x5a, 0xf2, 0x05, 0x4c, 0x27, 0x0e, 0x7b,
    0x1d, 0x82, 0x16, 0x7b, 0xd2, 0xfe, 0x0b, 0x2c,
    0x90, 0x1c, 0x0b, 0x2f, 0x78, 0x25, 0xff, 0x6a,
    0x1f, 0xe8, 0x1f, 0x2f, 0x77, 0xc3, 0x85, 0xa6,
    0x2f, 0x50, 0x70, 0xc8, 0x8e, 0x2a, 0x95, 0x52,
    0x9b, 0x30, 0x41, 0x43, 0x04,
};
const static dword setup_sequence_config_data_rsp[] = { 0x00, 0x00 };

const static byte setup_sequence_msg10[] = { 0x3e };
const static dword setup_sequence_rsp10[] = {
    0x00, 0x00, 0xef, 0x00, 0x40, 0x00, 0x00, 0x10,
    0x10, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00
};

const static byte setup_sequence_msg11[] = {
    0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0xf0,
    0x00, 0x01, 0x04, 0x07, 0x00, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x9d, 0xa6, 0xbb, 0x3e, 0xb1, 0xd4, 0xd1,
    0x64, 0x18, 0x11, 0xb0, 0xa2, 0x40, 0x2b, 0xa5,
    0x01, 0x0d, 0x6d, 0x0f, 0x2f, 0x7f, 0xfd, 0x8d,
    0xeb, 0xc7, 0xe7, 0xe6, 0x8c, 0x31, 0x47, 0x33,
    0x33, 0x02, 0x01, 0x02, 0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x84, 0x0a, 0xcf, 0xea, 0x4e, 0x99, 0x8b,
    0x53, 0x02, 0xdf, 0x52, 0xdb, 0x54, 0xb7, 0x65,
    0x4b, 0x16, 0x4a, 0x10, 0x57, 0x68, 0x11, 0x49,
    0xfc, 0xbb, 0x3e, 0xc7, 0xa5, 0x59, 0xc8, 0x0d,
    0xb2, 0x05, 0x05, 0x03, 0x00, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x5c, 0x70, 0xf7, 0xcc, 0xce, 0x2f, 0xc2,
    0xd7, 0x62, 0x0f, 0x69, 0xda, 0x63, 0x54, 0x8f,
    0xc3, 0x92, 0x87, 0x7c, 0x88, 0x39, 0x3e, 0x9c,
    0x45, 0x32, 0x7a, 0x10, 0xc2, 0x1d, 0x46, 0x26,
    0x7f, 0x06, 0x06, 0x03, 0x00, 0x00, 0x80, 0x04,
    0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x5a, 0x5e, 0xeb, 0x28, 0x4e, 0xe0, 0x5d,
    0xda, 0xe4, 0x7e, 0xe2, 0x7d, 0xc7, 0x5f, 0xaf,
    0xaf, 0x09, 0xbc, 0x8b, 0x11, 0x2a, 0x65, 0x2b,
    0xde, 0x4e, 0xab, 0x8a, 0xfc, 0x61, 0xf2, 0xdf,
    0x75, 0x04, 0x03, 0x05, 0x00, 0x00, 0x00, 0x05,
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0e, 0x82, 0x8e, 0xaf, 0xf8, 0x26, 0xa0,
    0x45, 0x4f, 0x6a, 0x50, 0xf6, 0x0a, 0x36, 0xd5,
    0x01, 0x43, 0x72, 0xaa, 0xaf, 0x26, 0x21, 0x41,
    0xe5, 0xce, 0xd9, 0xd0, 0xa0, 0x05, 0x69, 0x07,
    0xc2, 0x05, 0x00, 0xb8, 0x00, 0x17, 0x00, 0x00,
    0x00, 0x20, 0x00, 0x00, 0x00, 0x2f, 0x7b, 0x69,
    0x64, 0x7f, 0xf8, 0x19, 0x49, 0x56, 0xbd, 0xc0,
    0x16, 0x75, 0x34, 0x8f, 0x3d, 0xf0, 0x14, 0xad,
    0x52, 0x3a, 0x77, 0xe7, 0xbb, 0xa9, 0x60, 0x46,
    0xea, 0x5f, 0xea, 0xe4, 0xad, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xa4, 0xf2, 0x7d, 0x61, 0xef, 0x9e, 0xcf,
    0xad, 0x6b, 0x36, 0x8c, 0x5e, 0xc4, 0x18, 0x95,
    0x70, 0x28, 0xd9, 0x19, 0x2e, 0x9b, 0x7e, 0x22,
    0x3d, 0xf5, 0x0c, 0xb4, 0x1b, 0xd7, 0x00, 0x83,
    0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x04, 0xe1, 0x27, 0x00, 0x00, 0x10, 0xb5, 0xdb,
    0xaf, 0x1c, 0x02, 0x00, 0x00, 0xb0, 0x3d, 0xdc,
    0xaf, 0x1c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0xa4,
    0x01, 0x17, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x4b, 0x60, 0xd2, 0x27, 0x3e, 0x3c, 0xce,
    0x3b, 0xf6, 0xb0, 0x53, 0xcc, 0xb0, 0x06, 0x1d,
    0x65, 0xbc, 0x86, 0x98, 0x76, 0x55, 0xbd, 0xeb,
    0xb3, 0xe7, 0x93, 0x3a, 0xaa, 0xd8, 0x35, 0xc6,
    0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xc2, 0x98,
    0xd8, 0x45, 0x39, 0xa1, 0xf4, 0xa0, 0x33, 0xeb,
    0x2d, 0x81, 0x7d, 0x03, 0x77, 0xf2, 0x40, 0xa4,
    0x63, 0xe5, 0xe6, 0xbc, 0xf8, 0x47, 0x42, 0x2c,
    0xe1, 0xf2, 0xd1, 0x17, 0x6b, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf5, 0x51, 0xbf, 0x37, 0x68, 0x40, 0xb6,
    0xcb, 0xce, 0x5e, 0x31, 0x6b, 0x57, 0x33, 0xce,
    0x2b, 0x16, 0x9e, 0x0f, 0x7c, 0x4a, 0xeb, 0xe7,
    0x8e, 0x9b, 0x7f, 0x1a, 0xfe, 0xe2, 0x42, 0xe3,
    0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x25, 0x63,
    0xfc, 0xc2, 0xca, 0xb9, 0xf3, 0x84, 0x9e, 0x17,
    0xa7, 0xad, 0xfa, 0xe6, 0xbc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
};

static const dword setup_sequence_rsp11[] = {
    0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x17, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x2f, 0x7b,
    0x69, 0x64, 0x7f, 0xf8, 0x19, 0x49, 0x56, 0xbd,
    0xc0, 0x16, 0x75, 0x34, 0x8f, 0x3d, 0xf0, 0x14,
    0xad, 0x52, 0x3a, 0x77, 0xe7, 0xbb, 0xa9, 0x60,
    0x46, 0xea, 0x5f, 0xea, 0xe4, 0xad, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xa4, 0xf2, 0x7d, 0x61, 0xef, 0x9e,
    0xcf, 0xad, 0x6b, 0x36, 0x8c, 0x5e, 0xc4, 0x18,
    0x95, 0x70, 0x28, 0xd9, 0x19, 0x2e, 0x9b, 0x7e,
    0x22, 0x3d, 0xf5, 0x0c, 0xb4, 0x1b, 0xd7, 0x00,
    0x83, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x5b,
    0xf1, 0x34, 0xa5, 0x2a, 0x11, 0x58, 0xc1, 0x07,
    0xcb, 0x26, 0x73, 0xc6, 0xb4, 0x19, 0x10, 0xee,
    0x84, 0xec, 0x84, 0x68, 0x56, 0xae, 0x21, 0xa9,
    0x1a, 0x05, 0x18, 0x4a, 0xe1, 0xdf, 0x96, 0xb4,
    0x7e, 0x30, 0xa3, 0xc7, 0xa9, 0x34, 0x3c, 0x7a,
    0xfc, 0x4f, 0x91, 0xa7, 0xfa, 0x9e, 0x7c, 0xc6,
    0x64, 0x41, 0xcf, 0x52, 0xde, 0xcf, 0x4d, 0x22,
    0x81, 0xc2, 0xec, 0xfc, 0xba, 0xad, 0x1c, 0xb6,
    0xb4, 0x77, 0xfa, 0x0f, 0xb1, 0x2b, 0xa2, 0x1e,
    0x98, 0xde, 0x38, 0x41, 0x5b, 0x3c, 0xbd, 0xa0,
    0x57, 0xa1, 0x19, 0x28, 0x1d, 0x62, 0x8a, 0x57,
    0x6e, 0x36, 0x56, 0xd9, 0xcb, 0xe0, 0x4e, 0x6b,
    0xae, 0xde, 0xab, 0x14, 0x3b, 0x41, 0x1d, 0x26,
    0x0b, 0x4a, 0xd4, 0xa7, 0x0b, 0x13, 0xef, 0x09,
    0x7a, 0xa0, 0xc1, 0x22, 0x48, 0xe3, 0x4e, 0x94,
    0x07, 0x8a, 0x37, 0x95, 0x65, 0x91, 0xbe, 0x6c,
    0x57, 0x75, 0x83, 0x55, 0x48, 0x24, 0xff, 0x6f,
    0x2b, 0x48
};

static const byte setup_sequence_msg12[] = { 0x01 };
static const dword setup_sequence_rsp12[] = {
    0x00, 0x00, 0xf0, 0xb0, 0x5e, 0x54, 0xa4, 0x00,
    0x00, 0x00, 0x06, 0x07, 0x01, 0x30, 0x00, 0x01,
    0x00, 0x09, 0x69, 0xfb, 0x88, 0x9b, 0x40, 0xf7,
    0x00, 0x23, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07
};

static const byte setup_sequence_msg13[] = { 0x50 };
static const dword setup_sequence_rsp13[] = {
    0x00, 0x00, 0x9c, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0xf0, 0xd4,
    0x55, 0x3e, 0x1c, 0x7e, 0xbb, 0x3d, 0x05, 0xa5,
    0xf1, 0xb6, 0xc3, 0x9c, 0x64, 0xe8, 0x90, 0x2e,
    0xbe, 0xad, 0x04, 0xba, 0x1e, 0x19, 0xfc, 0x91,
    0xdd, 0x03, 0x4a, 0xb8, 0x8c, 0x66, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xb4, 0x25, 0xb4, 0x5d, 0x87, 0x6e,
    0x0d, 0x2d, 0x88, 0x9b, 0xc1, 0x27, 0x40, 0xf8,
    0x2f, 0xed, 0xa9, 0xe9, 0xfe, 0xde, 0x9f, 0x85,
    0x57, 0x02, 0x35, 0x76, 0x62, 0xc7, 0x96, 0x3b,
    0x56, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00,
    0x00, 0x00, 0x30, 0x44, 0x02, 0x20, 0x47, 0xda,
    0x2e, 0x43, 0xca, 0xbb, 0xef, 0x04, 0x75, 0xfa,
    0xbb, 0xf5, 0xc7, 0xdb, 0x7c, 0x56, 0xaf, 0x90,
    0xed, 0xb1, 0x19, 0x1e, 0xd4, 0xa6, 0x8d, 0xff,
    0x0e, 0x68, 0x7b, 0xed, 0x93, 0x17, 0x02, 0x20,
    0x6b, 0x88, 0xbd, 0xa2, 0x2c, 0x09, 0x75, 0x52,
    0xcc, 0x80, 0x70, 0x9a, 0xd0, 0xf5, 0xe2, 0xf9,
    0x66, 0x25, 0x7c, 0xa4, 0x0b, 0x32, 0xed, 0x06,
    0x85, 0xde, 0x9d, 0x90, 0xeb, 0x8f, 0x31, 0xb3,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const byte setup_sequence_completed[] = { 0x1a };
static const dword setup_sequence_completed_rsp[] = { 0x00, 0x00 };

static byte tls_client_hello[] = {
    0x44, 0x00, 0x00, 0x00,
    0x16, 0x03, 0x03, 0x00, 0x43, 0x01, 0x00, 0x00,
    0x3f, 0x03, 0x03, 0x95, 0x6c, 0x41, 0xa9, 0x12,
    0x86, 0x8a, 0xda, 0x9b, 0xb2, 0x5b, 0xb4, 0xbb,
    0xd6, 0x1d, 0xde, 0x4f, 0xda, 0x23, 0x2a, 0x74,
    0x7b, 0x2a, 0x93, 0xf8, 0xac, 0xc6, 0x69, 0x24,
    0x70, 0xc4, 0x2a, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0x05, 0x00,
    0x3d, 0x00, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x02,
    0x00, 0x17, 0x00, 0x0b, 0x00, 0x02, 0x01, 0x00
};

byte tls_certificate[] = {
    0x44, 0x00, 0x00, 0x00,
    0x16, 0x03, 0x03, 0x01, 0x55,

    0x0b, 0x00, 0x00,
    0xc0, 0x00, 0x00, 0xb8, 0x00, 0x00, 0xb8,

    0x00, 0x00,

    0x17, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,           /* cert from pre-tls */
    0x00, 0xab, 0x9d, 0xfd, 0xba, 0x74, 0x25, 0x29,
    0x93, 0x9d, 0x2d, 0x5d, 0xf4, 0x77, 0xec, 0x90,
    0x2e, 0x13, 0xb8, 0x21, 0x1a, 0x19, 0x70, 0x1e,
    0x50, 0x2f, 0xf5, 0x6e, 0x6e, 0x25, 0xae, 0x8c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdd, 0xf4, 0x04,
    0x74, 0xf0, 0x7a, 0xe4, 0xe0, 0x79, 0xd1, 0xf1,
    0x9f, 0xae, 0xbd, 0xa8, 0xef, 0x1e, 0xfa, 0x18,
    0xc2, 0x6a, 0x76, 0xae, 0xa5, 0xaa, 0xbf, 0xc3,
    0x4f, 0x12, 0x94, 0x8c, 0x8f, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xa5, 0x58, 0xed, 0x0f, 0x31, 0x33, 0x45,
    0x63, 0xc8, 0x8a, 0xd5, 0x53, 0xd9, 0xe4, 0x6e,
    0x20, 0x5d, 0x54, 0x3b, 0x83, 0x99, 0xcf, 0x9b,
    0xef, 0x9e, 0xa8, 0xaa, 0xc5, 0xeb, 0xfb, 0x21,
    0xa3,

    0x10, 0x00, 0x00, 0x41, 0x04, 0x1d, 0xd8,
    0x36, 0x68, 0xe9, 0xb0, 0x7b, 0x93, 0x12, 0x38,
    0x31, 0x23, 0x90, 0xc8, 0x87, 0xca, 0xdb, 0x82,
    0x27, 0x39, 0xde, 0x7b, 0x43, 0xd2, 0x23, 0xd7,
    0xcd, 0xd1, 0x3c, 0x77, 0x0e, 0xd2, 0xd1, 0x93,
    0x70, 0x02, 0xaf, 0x3b, 0x18, 0x47, 0xc5, 0x30,
    0x4c, 0x33, 0x60, 0xcf, 0xbf, 0xc5, 0x9b, 0x3c,
    0x67, 0xd9, 0x45, 0x06, 0x38, 0xda, 0x92, 0xbe,
    0x65, 0xbf, 0x81, 0x8c, 0xaa, 0x7e, 0x0f, 0x00,
    0x00, 0x48, 0x30, 0x46, 0x02, 0x21, 0x00, 0xa3,
    0xad, 0xaa, 0x61, 0x00, 0xe6, 0x9d, 0xbd, 0xcf,
    0x48, 0x73, 0xb7, 0xa6, 0xed, 0xe3, 0x62, 0x0a,
    0x79, 0xe4, 0xf8, 0x14, 0x27, 0x4d, 0xeb, 0x73,
    0x91, 0x01, 0x0c, 0xae, 0x08, 0xb9, 0x43, 0x02,
    0x21, 0x00, 0xd3, 0x28, 0xa4, 0x86, 0xcf, 0x8b,
    0xaf, 0x35, 0xc9, 0x04, 0xf7, 0x1f, 0xe2, 0x56,
    0x22, 0xf7, 0x5d, 0xdf, 0x53, 0x13, 0x4f, 0xc6,
    0xdb, 0x6b, 0xc0, 0x0d, 0x57, 0x90, 0xc4, 0x23,
    0xfe, 0x06, 0x14, 0x03, 0x03, 0x00, 0x01, 0x01,


    /* encrypted handshake */
    0x16, 0x03, 0x03, 0x00, 0x50,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x6f, 0xda, 0xdb,
    0xa0, 0x35, 0x1b, 0xe1, 0xb9, 0xca, 0xa3, 0x90,
    0xdf, 0x7e, 0x17, 0xec, 0x0b, 0xe8, 0xcc, 0xf9,
    0xa4, 0x92, 0x1b, 0x77, 0x9c, 0x0f, 0xf3, 0xc6,
    0xdc, 0xf9, 0xb3, 0x7d, 0x3c, 0x41, 0x6c, 0x4c,
    0x80, 0x95, 0x66, 0x7e, 0xb1, 0x7e, 0x37, 0x3d,
    0x28, 0xef, 0xa4, 0xca, 0xfd, 0x3e, 0xfd, 0x8f,
    0xdd, 0x84, 0x10, 0xc5, 0xb2, 0x71, 0x38, 0xab,
    0x8d, 0x9c, 0xe3, 0xac, 0x46
};

char scan_matrix1[] = {
  0x02, 0x98, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x20, 0x00,
  0x80, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x20, 0x05,
  0x00, 0x24, 0x20, 0x00, 0x00, 0x50, 0x20, 0x77,
  0x36, 0x28, 0x20, 0x01, 0x00, 0x30, 0x20, 0x01,
  0x00, 0x08, 0x21, 0x70, 0x00, 0x0c, 0x21, 0x00,
  0x00, 0x48, 0x21, 0x02, 0x00, 0x4c, 0x21, 0x00,
  0x00, 0x58, 0x20, 0x00, 0x00, 0x5c, 0x20, 0x00,
  0x00, 0x60, 0x20, 0x00, 0x00, 0x68, 0x20, 0x05,
  0x00, 0x6c, 0x20, 0x01, 0x29, 0x70, 0x20, 0x01,
  0x21, 0x74, 0x20, 0x01, 0x88, 0x78, 0x20, 0x01,
  0x80, 0x84, 0x20, 0x20, 0x00, 0x94, 0x20, 0x01,
  0x80, 0x9c, 0x20, 0x09, 0x02, 0xa0, 0x20, 0x0b,
  0x19, 0xb4, 0x20, 0x00, 0x00, 0xb8, 0x20, 0x3b,
  0x04, 0xbc, 0x20, 0x14, 0x00, 0xc0, 0x20, 0x02,
  0x00, 0xc4, 0x20, 0x01, 0x00, 0xc8, 0x20, 0x02,
  0x00, 0x33, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x80, 0xcc, 0x20, 0x00, 0x00, 0xf5, 0x03, 0xd0,
  0x20, 0x00, 0x00, 0xa1, 0x01, 0x32, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00, 0x80, 0xdc, 0x20, 0xe8,
  0x03, 0xe0, 0x20, 0x64, 0x01, 0xe4, 0x20, 0xd0,
  0x02, 0xe8, 0x20, 0x00, 0x01, 0xf0, 0x20, 0x05,
  0x00, 0xf8, 0x20, 0x05, 0x00, 0xfc, 0x20, 0x00,
  0x00, 0xb8, 0x20, 0x3b, 0x00, 0x00, 0x08, 0x04,
  0x00, 0x14, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00,
  0x00, 0x08, 0x08, 0x00, 0x00, 0x14, 0x08, 0x30,
  0x00, 0x08, 0x08, 0x00, 0x00, 0x14, 0x08, 0x31,
  0x00, 0x1c, 0x08, 0x1a, 0x00, 0x32, 0x00, 0x0c,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x50, 0x11, 0x01,
  0x00, 0x4c, 0x11, 0x26, 0x00, 0x34, 0x00, 0x08,
  0x03, 0x10, 0x07, 0x1d, 0x10, 0x07, 0x1d, 0x10,
  0x07, 0x1d, 0x10, 0x07, 0x1d, 0x10, 0x07, 0x1c,
  0x01, 0x06, 0x58, 0x10, 0x08, 0x01, 0x01, 0x00,
  0x00, 0x07, 0xc8, 0x07, 0x8c, 0x06, 0x10, 0x00,
  0x00, 0x20, 0x4f, 0x80, 0x00, 0x7f, 0x00, 0x00,
  0x03, 0x07, 0x01, 0x07, 0x01, 0x0c, 0x07, 0x03,
  0x2c, 0x08, 0xfc, 0x80, 0x09, 0x5a, 0x80, 0x0a,
  0xfc, 0x08, 0xfb, 0x80, 0x0b, 0x5a, 0x09, 0x5b,
  0x80, 0x0a, 0xfb, 0x08, 0xfa, 0x80, 0x0b, 0x5b,
  0x09, 0x5c, 0x80, 0x0a, 0xfa, 0x08, 0xf9, 0x80,
  0x0b, 0x5c, 0x09, 0x5d, 0x80, 0x0a, 0xf9, 0x08,
  0xf8, 0x80, 0x0b, 0x5d, 0x09, 0x5e, 0x80, 0x0a,
  0xf8, 0x08, 0xf7, 0x80, 0x0b, 0x5e, 0x09, 0x5f,
  0x80, 0x0a, 0xf7, 0x08, 0xf6, 0x80, 0x0b, 0x5f,
  0x09, 0x60, 0x80, 0x0a, 0xf6, 0x08, 0xf5, 0x80,
  0x0b, 0x60, 0x09, 0x61, 0x80, 0x0a, 0xf5, 0x08,
  0xf4, 0x80, 0x0b, 0x61, 0x09, 0x62, 0x80, 0x0a,
  0xf4, 0x08, 0xf3, 0x80, 0x0b, 0x62, 0x09, 0x63,
  0x80, 0x0a, 0xf3, 0x08, 0xf2, 0x80, 0x0b, 0x63,
  0x09, 0x64, 0x80, 0x0a, 0xf2, 0x08, 0xf1, 0x80,
  0x0b, 0x64, 0x09, 0x65, 0x80, 0x0a, 0xf1, 0x08,
  0xf0, 0x80, 0x0b, 0x65, 0x09, 0x66, 0x80, 0x0a,
  0xf0, 0x08, 0xef, 0x80, 0x0b, 0x66, 0x09, 0x67,
  0x80, 0x0a, 0xef, 0x08, 0xee, 0x80, 0x0b, 0x67,
  0x09, 0x68, 0x80, 0x0a, 0xee, 0x08, 0xed, 0x80,
  0x0b, 0x68, 0x09, 0x6c, 0x80, 0x0a, 0xed, 0x08,
  0xec, 0x80, 0x0b, 0x6c, 0x09, 0x6d, 0x80, 0x0a,
  0xec, 0x08, 0xeb, 0x80, 0x0b, 0x6d, 0x09, 0x6e,
  0x80, 0x0a, 0xeb, 0x08, 0xea, 0x80, 0x0b, 0x6e,
  0x09, 0x6f, 0x80, 0x0a, 0xea, 0x08, 0xe9, 0x80,
  0x0b, 0x6f, 0x09, 0x70, 0x80, 0x0a, 0xe9, 0x08,
  0xe8, 0x80, 0x0b, 0x70, 0x09, 0x71, 0x80, 0x0a,
  0xe8, 0x08, 0xe7, 0x80, 0x0b, 0x71, 0x09, 0x72,
  0x80, 0x0a, 0xe7, 0x08, 0xe6, 0x80, 0x0b, 0x72,
  0x09, 0x73, 0x80, 0x0a, 0xe6, 0x08, 0xe5, 0x80,
  0x0b, 0x73, 0x09, 0x74, 0x80, 0x0a, 0xe5, 0x08,
  0xe4, 0x80, 0x0b, 0x74, 0x09, 0x75, 0x80, 0x0a,
  0xe4, 0x08, 0xe3, 0x80, 0x0b, 0x75, 0x09, 0x76,
  0x80, 0x0a, 0xe3, 0x08, 0xe2, 0x80, 0x0b, 0x76,
  0x09, 0x77, 0x80, 0x0a, 0xe2, 0x08, 0xe1, 0x80,
  0x0b, 0x77, 0x09, 0x78, 0x80, 0x0a, 0xe1, 0x08,
  0xe0, 0x80, 0x0b, 0x78, 0x09, 0x79, 0x80, 0x0a,
  0xe0, 0x08, 0xdf, 0x80, 0x0b, 0x79, 0x09, 0x7a,
  0x80, 0x0a, 0xdf, 0x08, 0xde, 0x80, 0x0b, 0x7a,
  0x09, 0x7b, 0x80, 0x0a, 0xde, 0x08, 0xdd, 0x80,
  0x0b, 0x7b, 0x09, 0x7c, 0x80, 0x0a, 0xdd, 0x08,
  0xdc, 0x80, 0x0b, 0x7c, 0x09, 0x7d, 0x80, 0x0a,
  0xdc, 0x08, 0xdb, 0x80, 0x0b, 0x7d, 0x09, 0x7e,
  0x80, 0x0a, 0xdb, 0x08, 0xda, 0x80, 0x0b, 0x7e,
  0x09, 0x7f, 0x80, 0x0a, 0xda, 0x08, 0xd9, 0x80,
  0x0b, 0x7f, 0x09, 0x80, 0x80, 0x0a, 0xd9, 0x08,
  0xd8, 0x80, 0x0b, 0x80, 0x09, 0x81, 0x80, 0x0a,
  0xd8, 0x08, 0xd7, 0x80, 0x0b, 0x81, 0x09, 0x82,
  0x80, 0x0a, 0xd7, 0x08, 0xd6, 0x80, 0x0b, 0x82,
  0x09, 0x83, 0x80, 0x0a, 0xd6, 0x08, 0xd5, 0x80,
  0x0b, 0x83, 0x09, 0x84, 0x80, 0x0a, 0xd5, 0x08,
  0xd4, 0x80, 0x0b, 0x84, 0x09, 0x85, 0x80, 0x0a,
  0xd4, 0x08, 0xd3, 0x80, 0x0b, 0x85, 0x09, 0x86,
  0x80, 0x0a, 0xd3, 0x08, 0xd2, 0x80, 0x0b, 0x86,
  0x09, 0x87, 0x80, 0x0a, 0xd2, 0x08, 0xd1, 0x80,
  0x0b, 0x87, 0x09, 0x88, 0x80, 0x0a, 0xd1, 0x08,
  0xd0, 0x80, 0x0b, 0x88, 0x09, 0x89, 0x80, 0x0a,
  0xd0, 0x08, 0xcf, 0x80, 0x0b, 0x89, 0x09, 0x8a,
  0x80, 0x0a, 0xcf, 0x08, 0xce, 0x80, 0x0b, 0x8a,
  0x09, 0x8b, 0x80, 0x0a, 0xce, 0x08, 0xcd, 0x80,
  0x0b, 0x8b, 0x09, 0x8c, 0x80, 0x0a, 0xcd, 0x08,
  0xcc, 0x80, 0x0b, 0x8c, 0x09, 0x8d, 0x80, 0x0a,
  0xcc, 0x08, 0xcb, 0x80, 0x0b, 0x8d, 0x09, 0x8e,
  0x80, 0x0a, 0xcb, 0x08, 0xca, 0x80, 0x0b, 0x8e,
  0x09, 0x8f, 0x80, 0x0a, 0xca, 0x08, 0xc9, 0x80,
  0x0b, 0x8f, 0x09, 0x90, 0x80, 0x0a, 0xc9, 0x08,
  0xc8, 0x80, 0x0b, 0x90, 0x09, 0x91, 0x80, 0x0a,
  0xc8, 0x08, 0xc7, 0x80, 0x0b, 0x91, 0x09, 0x92,
  0x80, 0x0a, 0xc7, 0x08, 0xc6, 0x80, 0x0b, 0x92,
  0x09, 0x93, 0x80, 0x0a, 0xc6, 0x08, 0xc5, 0x80,
  0x0b, 0x93, 0x09, 0x94, 0x80, 0x0a, 0xc5, 0x08,
  0xc4, 0x80, 0x0b, 0x94, 0x09, 0x95, 0x80, 0x0a,
  0xc4, 0x08, 0xc3, 0x80, 0x0b, 0x95, 0x09, 0x96,
  0x80, 0x0a, 0xc3, 0x08, 0xc2, 0x80, 0x0b, 0x96,
  0x09, 0x97, 0x80, 0x0a, 0xc2, 0x08, 0xc1, 0x80,
  0x0b, 0x97, 0x09, 0x98, 0x80, 0x0a, 0xc1, 0x08,
  0xc0, 0x80, 0x0b, 0x98, 0x09, 0x99, 0x80, 0x0a,
  0xc0, 0x08, 0xbf, 0x80, 0x0b, 0x99, 0x09, 0x9a,
  0x80, 0x0a, 0xbf, 0x08, 0xbe, 0x80, 0x0b, 0x9a,
  0x09, 0x9b, 0x80, 0x0a, 0xbe, 0x08, 0xbd, 0x80,
  0x0b, 0x9b, 0x09, 0x9c, 0x80, 0x0a, 0xbd, 0x08,
  0xbc, 0x80, 0x0b, 0x9c, 0x09, 0x9d, 0x80, 0x0a,
  0xbc, 0x08, 0xbb, 0x80, 0x0b, 0x9d, 0x09, 0x9e,
  0x80, 0x0a, 0xbb, 0x08, 0xba, 0x80, 0x0b, 0x9e,
  0x09, 0x9f, 0x80, 0x0a, 0xba, 0x08, 0xb9, 0x80,
  0x0b, 0x9f, 0x09, 0xa0, 0x80, 0x0a, 0xb9, 0x08,
  0xb8, 0x80, 0x0b, 0xa0, 0x08, 0x01, 0x80, 0x0a,
  0xb8, 0x08, 0xb7, 0x80, 0x0a, 0x01, 0x08, 0x02,
  0x80, 0x0a, 0xb7, 0x08, 0xb6, 0x80, 0x0a, 0x02,
  0x08, 0x03, 0x80, 0x0a, 0xb6, 0x08, 0xb5, 0x80,
  0x0a, 0x03, 0x08, 0x04, 0x80, 0x20, 0x03, 0x07,
  0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2f, 0x00, 0x04, 0x00, 0x90, 0x00, 0x00,
  0x00, 0x29, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x35, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x17, 0x00, 0x00, 0x00, 0x26, 0x00, 0x28,
  0x00, 0xfb, 0xb2, 0x0f, 0x00, 0x00, 0x00, 0x0f,
  0x00, 0x30, 0x00, 0x00, 0x00, 0x60, 0x01, 0x02,
  0x00, 0x40, 0x01, 0x0a, 0x00, 0x01, 0x80, 0x00,
  0x00, 0x0a, 0x02, 0x00, 0x00, 0x0b, 0x19, 0x00,
  0x00, 0x50, 0xc3, 0x60, 0xea, 0x01, 0x09, 0x10,
  0x00, 0x2e, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x18,
  0x00, 0x23, 0x00, 0x00, 0x00, 0x90, 0x00, 0x90,
  0x00, 0x4d, 0x01, 0x00, 0x00, 0x90, 0x01, 0x7c,
  0x01, 0x3c, 0x32, 0x32, 0x32, 0x64, 0x0a, 0x02,
  0x01, 0x30, 0x00, 0xcc, 0x01, 0x03, 0x00, 0x00,
  0x00, 0xff, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
  0x03, 0xff, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00,
  0x03, 0xff, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00,
  0x03, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
  0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e,
  0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26,
  0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
  0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
  0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
  0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
  0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e,
  0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
  0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e,
  0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
  0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e,
  0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
  0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e,
  0x7f, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86,
  0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e,
  0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
  0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e,
  0x9f, 0x14, 0x24, 0x44, 0x36, 0x52, 0x3c, 0x28,
  0x40, 0x2a, 0x42, 0x2e, 0x46, 0x32, 0x48, 0x34,
  0x48, 0x32, 0x4a, 0x34, 0x4c, 0x32, 0x4c, 0x36,
  0x52, 0x38, 0x50, 0x3a, 0x50, 0x3a, 0x4e, 0x38,
  0x50, 0x3a, 0x54, 0x38, 0x52, 0x38, 0x50, 0x3a,
  0x50, 0x38, 0x50, 0x3a, 0x52, 0x3e, 0x28, 0x3c,
  0x28, 0x3e, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3c,
  0x28, 0x28, 0x28, 0x3e, 0x2a, 0x28, 0x28, 0x28,
  0x28, 0x3c, 0x28, 0x3a, 0x48, 0x46, 0x3c, 0x50,
  0x3c, 0x28, 0x38, 0x4e, 0x28, 0x4e, 0x28, 0x28,
  0x3e, 0x28, 0x28, 0x28, 0x3c, 0x4e, 0x3a, 0x28,
  0x3a, 0x50, 0x3c, 0x28, 0x28, 0x50, 0x3a, 0x28,
  0x3e, 0x28, 0x28, 0x2c, 0x28, 0x28, 0x28, 0x28,
  0x3e, 0x28, 0x3e, 0x28, 0x38, 0x28, 0x3e, 0x28,
  0x28, 0x4c, 0x3a, 0x28, 0x3c, 0x28, 0x3a, 0x28,
  0x3a, 0x4c, 0x3a, 0x4a, 0x3c, 0x4c, 0x3a, 0x4c,
  0x3a, 0x4a, 0x38, 0x28, 0x3a, 0x4a, 0x38, 0x38,
  0x3a, 0x38, 0x34, 0x34, 0x34, 0x32, 0x28, 0x1a,
  0x12, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80,
  0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
  0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
  0x80, 0x80, 0x80, 0x7f, 0x81, 0x7f, 0x81, 0x80,
  0x80, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x80,
  0x80, 0x7f, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80,
  0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x81, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x7f
};

/*char scan_matrix2[] = {
  0x39, 0x20, 0xbf, 0x02, 0x00, 0xff, 0xff, 0x00,
  0x00, 0x01, 0x99, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x99, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x00, 0x00, 0x99, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xed, 0x4e, 0x70,
  0x35, 0xe2, 0x1f, 0x37, 0xf1,
};*/

static char pre_key[] = {
    0x71, 0x7c, 0xd7, 0x2d, 0x09, 0x62, 0xbc, 0x4a,
    0x28, 0x46, 0x13, 0x8d, 0xbb, 0x2c, 0x24, 0x19,
    0x25, 0x12, 0xa7, 0x64, 0x07, 0x06, 0x5f, 0x38,
    0x38, 0x46, 0x13, 0x9d, 0x4b, 0xec, 0x20, 0x33,
};

static char led_green_on[] = {
  0x39, 0x20, 0xbf, 0x02, 0x00, 0xff, 0xff, 0x00, 0x00, 0x01, 0x99, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x99, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x00, 0x00, 0x99, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static char led_red_blink[] = {
  0x39, 0xee, 0x02, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x01, 0xff, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00,
  0x00, 0x01, 0xff, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4b, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static char led_green_blink[] = {
  0x39, 0xf4, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x01, 0xff, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0x01, 0x00,
  0x00, 0x00, 0xff, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


static char v97_scan_matrix2[] = {
  0x02, 0x98, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x20, 0x00,
  0x80, 0x00, 0x00, 0x01, 0x00, 0x32, 0x00, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x20, 0x05,
  0x00, 0x24, 0x20, 0x00, 0x00, 0x50, 0x20, 0x77,
  0x36, 0x28, 0x20, 0x01, 0x00, 0x30, 0x20, 0x01,
  0x00, 0x08, 0x21, 0x70, 0x00, 0x0c, 0x21, 0x00,
  0x00, 0x48, 0x21, 0x02, 0x00, 0x4c, 0x21, 0x00,
  0x00, 0x58, 0x20, 0x00, 0x00, 0x5c, 0x20, 0x00,
  0x00, 0x60, 0x20, 0x00, 0x00, 0x68, 0x20, 0x05,
  0x00, 0x6c, 0x20, 0x01, 0x29, 0x70, 0x20, 0x01,
  0x21, 0x74, 0x20, 0x01, 0x88, 0x78, 0x20, 0x01,
  0x80, 0x84, 0x20, 0x20, 0x00, 0x94, 0x20, 0x01,
  0x80, 0x9c, 0x20, 0x09, 0x02, 0xa0, 0x20, 0x0b,
  0x19, 0xb4, 0x20, 0x00, 0x00, 0xb8, 0x20, 0x3b,
  0x04, 0xbc, 0x20, 0x14, 0x00, 0xc0, 0x20, 0x02,
  0x00, 0xc4, 0x20, 0x01, 0x00, 0xc8, 0x20, 0x02,
  0x00, 0x33, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x80, 0xcc, 0x20, 0x00, 0x00, 0xf5, 0x03, 0xd0,
  0x20, 0x00, 0x00, 0xa1, 0x01, 0x32, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00, 0x80, 0xdc, 0x20, 0xe8,
  0x03, 0xe0, 0x20, 0x64, 0x01, 0xe4, 0x20, 0xd0,
  0x02, 0xe8, 0x20, 0x00, 0x01, 0xf0, 0x20, 0x05,
  0x00, 0xf8, 0x20, 0x05, 0x00, 0xfc, 0x20, 0x00,
  0x00, 0xb8, 0x20, 0x3b, 0x00, 0x00, 0x08, 0x04,
  0x00, 0x14, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00,
  0x00, 0x08, 0x08, 0x00, 0x00, 0x14, 0x08, 0x30,
  0x00, 0x08, 0x08, 0x00, 0x00, 0x14, 0x08, 0x31,
  0x00, 0x1c, 0x08, 0x1a, 0x00, 0x32, 0x00, 0x0c,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x50, 0x11, 0x01,
  0x00, 0x4c, 0x11, 0x26, 0x00, 0x34, 0x00, 0x08,
  0x03, 0x10, 0x07, 0x1d, 0x10, 0x07, 0x1d, 0x10,
  0x07, 0x1d, 0x10, 0x07, 0x1d, 0x10, 0x07, 0x1c,
  0x01, 0x06, 0x58, 0x10, 0x08, 0x01, 0x01, 0x00,
  0x00, 0x07, 0xc8, 0x07, 0x8c, 0x06, 0x10, 0x00,
  0x00, 0x20, 0x4f, 0x80, 0x00, 0x7f, 0x00, 0x00,
  0x03, 0x07, 0x01, 0x07, 0x01, 0x0c, 0x07, 0x03,
  0x2c, 0x08, 0xfc, 0x80, 0x09, 0x5a, 0x80, 0x0a,
  0xfc, 0x08, 0xfb, 0x80, 0x0b, 0x5a, 0x09, 0x5b,
  0x80, 0x0a, 0xfb, 0x08, 0xfa, 0x80, 0x0b, 0x5b,
  0x09, 0x5c, 0x80, 0x0a, 0xfa, 0x08, 0xf9, 0x80,
  0x0b, 0x5c, 0x09, 0x5d, 0x80, 0x0a, 0xf9, 0x08,
  0xf8, 0x80, 0x0b, 0x5d, 0x09, 0x5e, 0x80, 0x0a,
  0xf8, 0x08, 0xf7, 0x80, 0x0b, 0x5e, 0x09, 0x5f,
  0x80, 0x0a, 0xf7, 0x08, 0xf6, 0x80, 0x0b, 0x5f,
  0x09, 0x60, 0x80, 0x0a, 0xf6, 0x08, 0xf5, 0x80,
  0x0b, 0x60, 0x09, 0x61, 0x80, 0x0a, 0xf5, 0x08,
  0xf4, 0x80, 0x0b, 0x61, 0x09, 0x62, 0x80, 0x0a,
  0xf4, 0x08, 0xf3, 0x80, 0x0b, 0x62, 0x09, 0x63,
  0x80, 0x0a, 0xf3, 0x08, 0xf2, 0x80, 0x0b, 0x63,
  0x09, 0x64, 0x80, 0x0a, 0xf2, 0x08, 0xf1, 0x80,
  0x0b, 0x64, 0x09, 0x65, 0x80, 0x0a, 0xf1, 0x08,
  0xf0, 0x80, 0x0b, 0x65, 0x09, 0x66, 0x80, 0x0a,
  0xf0, 0x08, 0xef, 0x80, 0x0b, 0x66, 0x09, 0x67,
  0x80, 0x0a, 0xef, 0x08, 0xee, 0x80, 0x0b, 0x67,
  0x09, 0x68, 0x80, 0x0a, 0xee, 0x08, 0xed, 0x80,
  0x0b, 0x68, 0x09, 0x6c, 0x80, 0x0a, 0xed, 0x08,
  0xec, 0x80, 0x0b, 0x6c, 0x09, 0x6d, 0x80, 0x0a,
  0xec, 0x08, 0xeb, 0x80, 0x0b, 0x6d, 0x09, 0x6e,
  0x80, 0x0a, 0xeb, 0x08, 0xea, 0x80, 0x0b, 0x6e,
  0x09, 0x6f, 0x80, 0x0a, 0xea, 0x08, 0xe9, 0x80,
  0x0b, 0x6f, 0x09, 0x70, 0x80, 0x0a, 0xe9, 0x08,
  0xe8, 0x80, 0x0b, 0x70, 0x09, 0x71, 0x80, 0x0a,
  0xe8, 0x08, 0xe7, 0x80, 0x0b, 0x71, 0x09, 0x72,
  0x80, 0x0a, 0xe7, 0x08, 0xe6, 0x80, 0x0b, 0x72,
  0x09, 0x73, 0x80, 0x0a, 0xe6, 0x08, 0xe5, 0x80,
  0x0b, 0x73, 0x09, 0x74, 0x80, 0x0a, 0xe5, 0x08,
  0xe4, 0x80, 0x0b, 0x74, 0x09, 0x75, 0x80, 0x0a,
  0xe4, 0x08, 0xe3, 0x80, 0x0b, 0x75, 0x09, 0x76,
  0x80, 0x0a, 0xe3, 0x08, 0xe2, 0x80, 0x0b, 0x76,
  0x09, 0x77, 0x80, 0x0a, 0xe2, 0x08, 0xe1, 0x80,
  0x0b, 0x77, 0x09, 0x78, 0x80, 0x0a, 0xe1, 0x08,
  0xe0, 0x80, 0x0b, 0x78, 0x09, 0x79, 0x80, 0x0a,
  0xe0, 0x08, 0xdf, 0x80, 0x0b, 0x79, 0x09, 0x7a,
  0x80, 0x0a, 0xdf, 0x08, 0xde, 0x80, 0x0b, 0x7a,
  0x09, 0x7b, 0x80, 0x0a, 0xde, 0x08, 0xdd, 0x80,
  0x0b, 0x7b, 0x09, 0x7c, 0x80, 0x0a, 0xdd, 0x08,
  0xdc, 0x80, 0x0b, 0x7c, 0x09, 0x7d, 0x80, 0x0a,
  0xdc, 0x08, 0xdb, 0x80, 0x0b, 0x7d, 0x09, 0x7e,
  0x80, 0x0a, 0xdb, 0x08, 0xda, 0x80, 0x0b, 0x7e,
  0x09, 0x7f, 0x80, 0x0a, 0xda, 0x08, 0xd9, 0x80,
  0x0b, 0x7f, 0x09, 0x80, 0x80, 0x0a, 0xd9, 0x08,
  0xd8, 0x80, 0x0b, 0x80, 0x09, 0x81, 0x80, 0x0a,
  0xd8, 0x08, 0xd7, 0x80, 0x0b, 0x81, 0x09, 0x82,
  0x80, 0x0a, 0xd7, 0x08, 0xd6, 0x80, 0x0b, 0x82,
  0x09, 0x83, 0x80, 0x0a, 0xd6, 0x08, 0xd5, 0x80,
  0x0b, 0x83, 0x09, 0x84, 0x80, 0x0a, 0xd5, 0x08,
  0xd4, 0x80, 0x0b, 0x84, 0x09, 0x85, 0x80, 0x0a,
  0xd4, 0x08, 0xd3, 0x80, 0x0b, 0x85, 0x09, 0x86,
  0x80, 0x0a, 0xd3, 0x08, 0xd2, 0x80, 0x0b, 0x86,
  0x09, 0x87, 0x80, 0x0a, 0xd2, 0x08, 0xd1, 0x80,
  0x0b, 0x87, 0x09, 0x88, 0x80, 0x0a, 0xd1, 0x08,
  0xd0, 0x80, 0x0b, 0x88, 0x09, 0x89, 0x80, 0x0a,
  0xd0, 0x08, 0xcf, 0x80, 0x0b, 0x89, 0x09, 0x8a,
  0x80, 0x0a, 0xcf, 0x08, 0xce, 0x80, 0x0b, 0x8a,
  0x09, 0x8b, 0x80, 0x0a, 0xce, 0x08, 0xcd, 0x80,
  0x0b, 0x8b, 0x09, 0x8c, 0x80, 0x0a, 0xcd, 0x08,
  0xcc, 0x80, 0x0b, 0x8c, 0x09, 0x8d, 0x80, 0x0a,
  0xcc, 0x08, 0xcb, 0x80, 0x0b, 0x8d, 0x09, 0x8e,
  0x80, 0x0a, 0xcb, 0x08, 0xca, 0x80, 0x0b, 0x8e,
  0x09, 0x8f, 0x80, 0x0a, 0xca, 0x08, 0xc9, 0x80,
  0x0b, 0x8f, 0x09, 0x90, 0x80, 0x0a, 0xc9, 0x08,
  0xc8, 0x80, 0x0b, 0x90, 0x09, 0x91, 0x80, 0x0a,
  0xc8, 0x08, 0xc7, 0x80, 0x0b, 0x91, 0x09, 0x92,
  0x80, 0x0a, 0xc7, 0x08, 0xc6, 0x80, 0x0b, 0x92,
  0x09, 0x93, 0x80, 0x0a, 0xc6, 0x08, 0xc5, 0x80,
  0x0b, 0x93, 0x09, 0x94, 0x80, 0x0a, 0xc5, 0x08,
  0xc4, 0x80, 0x0b, 0x94, 0x09, 0x95, 0x80, 0x0a,
  0xc4, 0x08, 0xc3, 0x80, 0x0b, 0x95, 0x09, 0x96,
  0x80, 0x0a, 0xc3, 0x08, 0xc2, 0x80, 0x0b, 0x96,
  0x09, 0x97, 0x80, 0x0a, 0xc2, 0x08, 0xc1, 0x80,
  0x0b, 0x97, 0x09, 0x98, 0x80, 0x0a, 0xc1, 0x08,
  0xc0, 0x80, 0x0b, 0x98, 0x09, 0x99, 0x80, 0x0a,
  0xc0, 0x08, 0xbf, 0x80, 0x0b, 0x99, 0x09, 0x9a,
  0x80, 0x0a, 0xbf, 0x08, 0xbe, 0x80, 0x0b, 0x9a,
  0x09, 0x9b, 0x80, 0x0a, 0xbe, 0x08, 0xbd, 0x80,
  0x0b, 0x9b, 0x09, 0x9c, 0x80, 0x0a, 0xbd, 0x08,
  0xbc, 0x80, 0x0b, 0x9c, 0x09, 0x9d, 0x80, 0x0a,
  0xbc, 0x08, 0xbb, 0x80, 0x0b, 0x9d, 0x09, 0x9e,
  0x80, 0x0a, 0xbb, 0x08, 0xba, 0x80, 0x0b, 0x9e,
  0x09, 0x9f, 0x80, 0x0a, 0xba, 0x08, 0xb9, 0x80,
  0x0b, 0x9f, 0x09, 0xa0, 0x80, 0x0a, 0xb9, 0x08,
  0xb8, 0x80, 0x0b, 0xa0, 0x08, 0x01, 0x80, 0x0a,
  0xb8, 0x08, 0xb7, 0x80, 0x0a, 0x01, 0x08, 0x02,
  0x80, 0x0a, 0xb7, 0x08, 0xb6, 0x80, 0x0a, 0x02,
  0x08, 0x03, 0x80, 0x0a, 0xb6, 0x08, 0xb5, 0x80,
  0x0a, 0x03, 0x08, 0x04, 0x80, 0x20, 0x03, 0x07,
  0x04, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2f, 0x00, 0x04, 0x00, 0x90, 0x00, 0x00,
  0x00, 0x29, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x35, 0x00, 0x04, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x17, 0x00, 0x00, 0x00, 0x26, 0x00, 0x28,
  0x00, 0xfb, 0xb2, 0x0f, 0x00, 0x00, 0x00, 0x0f,
  0x00, 0x30, 0x00, 0x00, 0x00, 0x60, 0x01, 0x02,
  0x00, 0x40, 0x01, 0x0a, 0x00, 0x01, 0x80, 0x00,
  0x00, 0x0a, 0x02, 0x00, 0x00, 0x0b, 0x19, 0x00,
  0x00, 0x50, 0xc3, 0x60, 0xea, 0x01, 0x09, 0x10,
  0x00, 0x2e, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x18,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x90, 0x00, 0x90,
  0x00, 0x4d, 0x01, 0x00, 0x00, 0x90, 0x01, 0x7c,
  0x01, 0x3c, 0x32, 0x32, 0x32, 0x64, 0x0a, 0x02,
  0x01, 0x30, 0x00, 0xcc, 0x01, 0x03, 0x00, 0x00,
  0x00, 0xff, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
  0x03, 0xff, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00,
  0x03, 0xff, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00,
  0x03, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
  0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e,
  0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26,
  0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
  0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
  0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
  0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
  0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e,
  0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
  0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e,
  0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
  0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e,
  0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
  0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e,
  0x7f, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86,
  0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e,
  0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
  0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e,
  0x9f, 0x16, 0x26, 0x50, 0x3e, 0x28, 0x42, 0x28,
  0x46, 0x2c, 0x4c, 0x30, 0x4c, 0x32, 0x4c, 0x32,
  0x4c, 0x2c, 0x4c, 0x32, 0x4e, 0x34, 0x50, 0x36,
  0x52, 0x36, 0x4e, 0x36, 0x50, 0x36, 0x52, 0x34,
  0x50, 0x38, 0x52, 0x3a, 0x52, 0x38, 0x58, 0x38,
  0x56, 0x38, 0x54, 0x3a, 0x56, 0x3c, 0x5a, 0x3a,
  0x5c, 0x3e, 0x56, 0x3a, 0x56, 0x3c, 0x54, 0x3a,
  0x56, 0x3e, 0x56, 0x3c, 0x54, 0x3c, 0x54, 0x36,
  0x50, 0x2e, 0x4e, 0x34, 0x44, 0x42, 0x34, 0x4e,
  0x32, 0x4c, 0x32, 0x4e, 0x34, 0x4c, 0x2e, 0x4a,
  0x30, 0x4a, 0x36, 0x4e, 0x36, 0x4e, 0x34, 0x56,
  0x38, 0x54, 0x3c, 0x28, 0x3e, 0x56, 0x3a, 0x58,
  0x3e, 0x58, 0x3a, 0x54, 0x3a, 0x54, 0x3a, 0x56,
  0x3e, 0x52, 0x34, 0x50, 0x30, 0x4c, 0x36, 0x4c,
  0x32, 0x4a, 0x30, 0x4c, 0x32, 0x4c, 0x32, 0x4a,
  0x30, 0x48, 0x2c, 0x44, 0x32, 0x46, 0x30, 0x46,
  0x30, 0x40, 0x28, 0x40, 0x28, 0x3c, 0x52, 0x28,
  0x52, 0x28, 0x4c, 0x28, 0x46, 0x22, 0x36, 0x32,
  0x28, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
  0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
  0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
  0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7d,
  0x7d
};

#undef byte
#endif // CONSTANTS_H
