import {BaseComp} from '../../../aiChat/comp/base';
import {comp} from '../../../aiChat/comp/comp';
import {Model} from '../../../aiChat/comp/decorators';
import {AssistantPersona} from '../../../aiChat/options/personaOptions';
import {ControllerContext} from '../../../types/controllerContext';
import {ConversationStarter} from '../../../types/conversationStarter';
import {CompConversationStarters} from '../conversationStarters/conversationStarters.model';
import {CompConversationStartersProps} from '../conversationStarters/conversationStarters.types';
import {renderLaunchPad} from './launchPad.renderer';
import {CompLaunchPadActions, CompLaunchPadElements, CompLaunchPadEvents, CompLaunchPadProps} from './launchPad.types';
import {updateLaunchPad} from './launchPad.update';

@Model('launchPad', renderLaunchPad, updateLaunchPad)
export class CompLaunchPad<AiMsg> extends BaseComp<
    AiMsg,
    CompLaunchPadProps,
    CompLaunchPadElements,
    CompLaunchPadEvents,
    CompLaunchPadActions
> {
    private conversationStartersComp: CompConversationStarters<AiMsg> | undefined;

    constructor(context: ControllerContext<AiMsg>, props: CompLaunchPadProps) {
        super(context, props);
        this.setConversationStarters(props.conversationStarters);
    }

    public setAssistantPersona(assistantPersona: AssistantPersona | undefined) {
        this.setProp('assistantPersona', assistantPersona);
        this.executeDomAction('updateAssistantPersona', assistantPersona);
    }

    public setConversationStarters(conversationStarters: ConversationStarter[] | undefined) {
        if (!conversationStarters && !this.conversationStartersComp) {
            return;
        }

        if (conversationStarters && !this.conversationStartersComp) {
            const onConversationStarterSelected = this.getProp(
                'onConversationStarterSelected',
            ) as CompLaunchPadProps['onConversationStarterSelected'];

            this.conversationStartersComp = comp(CompConversationStarters<AiMsg>)
                .withContext(this.context)
                .withProps({
                    conversationStarters,
                    onConversationStarterSelected,
                } satisfies CompConversationStartersProps)
                .create();

            this.addSubComponent(
                this.conversationStartersComp.id,
                this.conversationStartersComp,
                'conversationStartersContainer',
            );

            return;
        }

        if (!conversationStarters && this.conversationStartersComp) {
            this.removeSubComponent(this.conversationStartersComp.id);
            this.conversationStartersComp = undefined;
        } else {
            this.conversationStartersComp?.updateConversationStarters(conversationStarters);
        }
    }

    public setShowGreeting(showGreeting: boolean) {
        this.setProp('showGreeting', showGreeting);
        this.executeDomAction('resetGreeting', showGreeting);
    }

    private resetConversationStarters() {
        const conversationStarters = this.getProp('conversationStarters') as ConversationStarter[] | undefined;
        this.setConversationStarters(conversationStarters);
    }
}
