# NLUX + Shadcn + Tailwind CSS

A React JS project that showcases how to use [`NLUX`](https://docs.nlkit.com/nlux), 
[`shadcn/ui`](https://ui.shadcn.com/), [Tailwind CSS](https://tailwindcss.com/) to 
build a ChatGPT-like chat interface.

`NLUX` handles the chat logic and `shadcn/ui` provides the UI components for thread switching, model selection, 
and more.

## Features Included:

* Chat interface with multiple threads
* Model selection, and switching between multiple `NLUX` adapters
* Loading and overriding conversation history
* Toggling between light and dark mode

## Run The Project

First, clone the repository:

```bash
git clone git@github.com:nlkitai/demos.git
```

Then, navigate to the `nlux-with-shadcn` directory:

```bash
cd demos/nlux-with-shadcn
```

Install the dependencies:

```bash
npm install
# or
yarn
# or
pnpm install
```

Run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
```
