## Starter Project for NLUX with Next.js and Vercel AI

This is folder contains the code for the starter project initiated when you run `npx nlux-cli create nextjs`.
It consists of an AI chat app that showcases `NLUX` with `Next.js` and several types of adapters.

## Run The Project

1. Add your **OpenAI API key** to the `.env` file.
2. Run the following command to install the dependencies:

```bash
npm install
```

3. Run the following command to start the development server:

```bash
npm run dev
```

## Create A New Project Using This Starter

To create a new project using this starter, you can simply run the following command:

```bash
npx nlux-cli create nextjs my-app-name
```

A new folder named `my-app-name` will be created with the starter project files.

## Features Showcased

The main features shown in this starter project are:

* **NLUX Chat Interface** - A simple chat interface to interact with the AI.
* **Text Streaming** - The chat interface supports text streaming.
* **Vercel AI SDK** - Used to connect to GPT-4 Turbo and generate responses. 

## Dependencies

* `React` — Latest `18.x` version.
* `Next.js` — Latest `14.x` version.
* `NLUX` — Latest `2.x` version.
* `Vercel AI` — Version `3.2.10` or higher.

## Learn More

To learn more about NLUX, take a look at the following resources:

- [Documentation](https://docs.nlkit.com/nlux) — Learn about Next.js features and API.
- [Examples](https://docs.nlkit.com/examples) — Find more examples of using NLUX with different setups.

You can check out the  [NLUX GitHub repository](https://github.com/nlkitai/nlux/) - your feature requests and contributions are welcome.
