---
sidebar_label: 'Overview'
---

# OpenAI Adapter From Browser (Unsafe)

OpenAI offers a variety of APIs to help developers build applications that can understand and generate natural-language
text, voice recognition, image generation, and more. Yet, OpenAI's APIs are built for server-side and are meant to be
used from a backend server, not from the browser. That's why we are marking this adapter as "unsafe".

If you are looking for a quick way to test OpenAI from your **local** environment for testing purposes, you can use this
adapter. However, if you are looking to use OpenAI in a production environment, you should build a backend service that
connects to OpenAI and use `NLUX`'s [custom adapters](/learn/adapters/custom-adapters) feature to build an adapter for your
backend.

## Supported Features

`NLUX` provides a wrapper around the OpenAI API that allows you to:

* **Build a ChatGPT-like interface** to embed in your website or application.
* **Customize the model**'s responses to fit your use case, using system messages, custom prompts, and more.
* **Stream conversations** to the user in real-time, as they're generated by the model.

:::warning
This `NLUX` OpenAI adapter connects to OpenAI API directly from the browser, using an API key.<br />
The OpenAI API is built for server-side usage, and **the API key should not be exposed to the client**.

You can use this adapter for testing purposes, but in a production setup you should build your own server
that connects to the OpenAI API, and use that server with `NLUX`.

We recommend using [`NLUX`'s custom adapters feature](/learn/adapters/custom-adapters) to create an adapter for your server.
:::

## OpenAI Adapter + Proxies

In order to connect to OpenAI's API, you need to create an account and get an API key.
That API key is unique to your account, and it should be kept secret. **When building frontend applications, you should
never expose your API key on a public page. Instead, you should use a proxy server to make requests to OpenAI's API**
(Example: A Node.js server that handles authentication and makes requests to OpenAI's API on behalf of the user).

The `NLUX` library only handles frontend UI and communication with backends, and does not offer a way to build proxy
servers.

It's fine to use `@nlux/openai` or `@nlux/openai-react` to connect to OpenAI without a proxy server when you're building prototypes or applications that
will only be used locally, or when each user provides their own API key, but it's not recommended that you include your
API key in your frontend application's source code and deploy it to a public URL, because anyone can view your API key
and use it to make requests to on your behalf.

:::tip
If you have built a custom backend that uses OpenAI's APIs, please use
`NLUX`'s [custom adapters](/learn/adapters/custom-adapters)
feature to build an adapter for your backend.
:::

If you would like to use `NLUX` with a proxy server to connect to OpenAI or any other AI backend, you can use `NLUX`'s
[custom adapters](/learn/adapters/custom-adapters) feature to build your own adapter. Several examples of custom adapters are
provided.
