# Installation Guide 🚀

!Generated by GPT!

Welcome to the installation guide for YassQueenDB! Follow the steps below to set up this powerful semantic graph database library on your machine.

## Prerequisites 📚

Make sure you have Python 3.6 or higher installed. You can check your Python version using the following command:

`python --version`

## Step 1: Clone the repository 🖥️

First, clone the YassQueenDB repository from GitHub:

`git clone https://github.com/nileshkhetrapal/YassQueenDB.git`

Navigate to the cloned directory:

`cd YassQueenDB`

## Step 2: Set up a virtual environment (optional) ⚙️

It is recommended to set up a virtual environment to keep your project dependencies isolated from your global Python installation. Run the following command to create a virtual environment:

`python -m venv venv`

Activate the virtual environment:

* On macOS and Linux:
  
  `source venv/bin/activate`
  
* On Windows:
  
  `.\venv\Scripts\activate`
  

## Step 3: Install required libraries 📦

YassQueenDB requires a few external libraries to work correctly. Install the required libraries using the following command:

`pip install tensorflow tensorflow-hub networkx numpy scipy scikit-learn`

This will install:

1. **TensorFlow** (2.x): For loading and using the Universal Sentence Encoder (USE) model.
2. **TensorFlow Hub**: For downloading the USE model.
3. **NetworkX**: For creating, managing, and analyzing graphs.
4. **NumPy**: For handling numerical operations.
5. **SciPy**: For calculating eigenvalues and eigenvectors in the Laplacian eigenmaps function.
6. **Scikit-learn**: For calculating cosine distances between embeddings.

## Step 4: Verify installation 🧪

To verify that everything is set up correctly, run the following command:

`python -c "import yassqueendb"`

If there are no errors, you have successfully installed YassQueenDB! 🎉

Now you can start using YassQueenDB for your projects by importing it in your Python scripts:

`from yassqueendb import GraphDatabase`

Happy graphing! 🌐💡
