# small-python-projects

![Static Badge](https://img.shields.io/badge/python-3.12-blue)
![Static Badge](https://img.shields.io/badge/python-3.13-blue)
![GitHub License](https://img.shields.io/github/license/niftycode/small-python-projects)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
![GitHub Issues or Pull Requests](https://img.shields.io/github/issues/niftycode/small-python-projects)

## Introduction

After knowing the basics of a programming language, the question arises of the next step. Instead of continuing to deal with theory, it makes sense to develop your own programs. Small entry-level programs can help with this. Because you can see how a program has been implemented. In addition, you can try to further develop the program. Or you can first try to find a solution yourself without first taking a look at the finished code.

This collection of small Python programs wants to help beginners in this way. Depending on the state of knowledge, some code may seem trivial. Others, on the other hand, may be a great challenge. In the latter case, you should not be deterred, but try to understand the code step by step. In this context, it is not a bad idea to rewrite the program in order to get a better understanding.

## Table of Contents

* bmi-1
* bmi-2 (same as "bmi-1", but with exception handling)
* bmi-3 (same as "bmi-2", but with exception handling in a separate module)
* fahrenheit-converter
* hex-to-dec
* addition-quiz
* palindrome
* quadratic-equation
* text-handling
* box-volume
* random-password
* two-points-distance
* Turtle
  * square
