#!/bin/sh
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


# Install some more fonts (I did not find open-sans-fonts in RHEL repos)
# dnf install -y open-sans-fonts

# Install cpio (missing dependency needed by coolwsd-systemplate-setup)
dnf install -y cpio

# Install gnupg2
dnf install -y gnupg2

# install ca-certificates
dnf install -y ca-certificates

# install ssh-keygen binary for the WOPI proof key
dnf install -y openssh

# Install curl for simple healthchecks and wget
dnf install -y curl wget

# Add Collabora repos
wget https://collaboraoffice.com/${repo:-repos}/CollaboraOnline/CODE-centos8/repodata/repomd.xml.key && rpm --import repomd.xml.key

if [ "$type" == "cool" ] && [ -n ${secret_key+set} ]; then
    echo "Based on the provided build arguments Collabora Online from customer repo will be used."
    dnf config-manager --add-repo https://collaboraoffice.com/${repo:-repos}/CollaboraOnline/${version:-21.11}/customer-centos8-${secret_key}
elif [ "$type" == "key" ]; then
    echo "Based on the provided build arguments license key enabled Collabora Online was selected, but it's available only on Ubuntu. Collabora Online Development Edition will be used."
    type="code"
    dnf config-manager --add-repo https://collaboraoffice.com/${repo:-repos}/CollaboraOnline/CODE-centos8
else
    echo "Based on the provided build arguments Collabora Online Development Edition will be used."
    dnf config-manager --add-repo https://collaboraoffice.com/${repo:-repos}/CollaboraOnline/CODE-centos8
fi

# Install the Collabora packages

dnf install -y coolwsd collaboraoffice-dict* collaboraofficebasis-ar collaboraofficebasis-as collaboraofficebasis-ast collaboraofficebasis-bg collaboraofficebasis-bn-IN collaboraofficebasis-br collaboraofficebasis-ca collaboraofficebasis-calc collaboraofficebasis-ca-valencia collaboraofficebasis-core collaboraofficebasis-cs collaboraofficebasis-cy collaboraofficebasis-da collaboraofficebasis-de collaboraofficebasis-draw collaboraofficebasis-el collaboraofficebasis-en-GB collaboraofficebasis-en-US collaboraofficebasis-es collaboraofficebasis-et collaboraofficebasis-eu collaboraofficebasis-extension-pdf-import collaboraofficebasis-fi collaboraofficebasis-fr collaboraofficebasis-ga collaboraofficebasis-gd collaboraofficebasis-gl collaboraofficebasis-graphicfilter collaboraofficebasis-gu collaboraofficebasis-he collaboraofficebasis-hi collaboraofficebasis-hr collaboraofficebasis-hu collaboraofficebasis-id collaboraofficebasis-images collaboraofficebasis-impress collaboraofficebasis-is collaboraofficebasis-it collaboraofficebasis-ja collaboraofficebasis-km collaboraofficebasis-kn collaboraofficebasis-ko collaboraofficebasis-lt collaboraofficebasis-lv collaboraofficebasis-ml collaboraofficebasis-mr collaboraofficebasis-nb collaboraofficebasis-nl collaboraofficebasis-nn collaboraofficebasis-oc collaboraofficebasis-ooofonts collaboraofficebasis-ooolinguistic collaboraofficebasis-or collaboraofficebasis-pa-IN collaboraofficebasis-pl collaboraofficebasis-pt collaboraofficebasis-pt-BR collaboraofficebasis-ro collaboraofficebasis-ru collaboraofficebasis-sk collaboraofficebasis-sl collaboraofficebasis-sr collaboraofficebasis-sr-Latn collaboraofficebasis-sv collaboraofficebasis-ta collaboraofficebasis-te collaboraofficebasis-tr collaboraofficebasis-uk collaboraofficebasis-vi collaboraofficebasis-writer collaboraofficebasis-zh-CN collaboraofficebasis-zh-TW

if [ "$type" == "cool" ] || [ "$type" == "key" ]; then
    dnf -y install collabora-online-brand
else
    dnf -y install CODE-brand
fi

# Install inotifywait and killall to automatic restart coolwsd, if coolwsd.xml changes
dnf install -y https://dl.fedoraproject.org/pub/epel/epel-release-latest-8.noarch.rpm
dnf install -y inotify-tools psmisc perl

# Cleanup
dnf clean all

# Remove WOPI Proof key generated by the package, we need unique key for each container
rm -rf /etc/coolwsd/proof_key*

# Fix permissions
# cf. start-collabora-online.sh that is run by cool user
# # Fix domain name resolution from jails
# cp /etc/resolv.conf /etc/hosts /opt/cool/systemplate/etc/
chown cool:cool /opt/cool/systemplate/etc/hosts /opt/cool/systemplate/etc/resolv.conf
# generated ssl cert/key and WOPI proof key go into /etc/coolwsd
chown cool:cool /etc/coolwsd
