BEGIN TRANSACTION
BEGIN

	-- Disable constraints for all tables:
    EXEC sp_msforeachtable 'ALTER TABLE ? NOCHECK CONSTRAINT all'

    SELECT [Id] INTO #autoUsers FROM [dbo].[MembershipUser] WHERE [Email] IN ('autoAdmin@test.co.uk', 'autoGroupAdmin@test.co.uk', 'autoRemoveUser@test.co.uk', 'autoUser@test.co.uk', 'autoUser2@test.co.uk', 'autoUser3@test.co.uk', 'autoTest@email.com', 'VisRegUser@email.com', 'autoEditUser@test.co.uk');
	DECLARE @groupAdmin AS uniqueidentifier;
    SELECT @groupAdmin = id FROM [dbo].[MembershipUser] WHERE Email = 'autoGroupAdmin@test.co.uk';
    DECLARE @autoUser AS uniqueidentifier;
    SELECT @autoUser = id FROM [dbo].[MembershipUser] WHERE Email = 'autoUser@test.co.uk';

	DECLARE @entityTable TABLE (id VARCHAR(50))
	INSERT INTO @entityTable SELECT Entity_Id FROM [dbo].[Comment] WHERE CreatedBy IN ( SELECT * FROM #autoUsers);
    INSERT INTO @entityTable SELECT Entity_Id FROM [dbo].[Discussion] WHERE CreatedBy IN ( SELECT * FROM #autoUsers);
	
    DELETE FROM [dbo].[GroupSite] 
	WHERE [GroupId] IN (
		SELECT Id FROM [dbo].[Group]
		WHERE [GroupOwner] IN (
			SELECT * FROM #autoUsers
		)
	);

	DELETE FROM [dbo].[Image]
	WHERE [CreatedBy] IN (
		 SELECT [Id] FROM #autoUsers
	);

	DELETE FROM [dbo].[Entity] 
    WHERE [Id] IN (
        SELECT * FROM @entityTable
    );

    DELETE FROM [dbo].[File] 
    WHERE [CreatedBy] IN (
        SELECT * FROM #autoUsers
    );

    DELETE FROM [dbo].[Folder] 
    WHERE [CreatedBy] IN (
        SELECT * FROM #autoUsers
    );

    DELETE FROM [dbo].[GroupUser] 
    WHERE [Group_Id] IN (
        SELECT [Id] FROM [dbo].[Group] WHERE [GroupOwner] IN (SELECT * FROM #autoUsers)
    );

    DELETE FROM [dbo].[MembershipUsersInRoles]
    WHERE [UserIdentifier] IN (
        SELECT * FROM #autoUsers
    );

    DELETE FROM [dbo].[SystemPage]
    WHERE [Slug] = 'repeat-slug-test';

    DELETE FROM [dbo].[Comment]
    WHERE [CreatedBy] IN (
        SELECT * FROM #autoUsers
    );

    DELETE FROM [dbo].[Discussion]
    WHERE [CreatedBy] IN (
        SELECT * FROM #autoUsers
    );
	
	DELETE FROM [dbo].[Group] 
    WHERE [GroupOwner] IN (
        SELECT * FROM #autoUsers
    );

    DELETE FROM [dbo].[MembershipUser]
    WHERE [Id] IN (
        SELECT * FROM #autoUsers
    );
    
	DROP TABLE #autoUsers

    -- Re-enable constraints for all tables:
    EXEC sp_msforeachtable 'ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all';	

END
BEGIN

	-- Disable constraints for all tables:
	EXEC sp_msforeachtable 'ALTER TABLE ? NOCHECK CONSTRAINT all'
	
    DECLARE @admin AS uniqueidentifier;
    SELECT @admin = id FROM [dbo].[MembershipUser] WHERE Email = 'admin@futurenhs.co.uk'

	/**
	* INSERT AUTOMATION MEMBERSHIPUSERS
	*/
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'autoAdmin@test.co.uk', N'vcf4NjFgrLG/mUdmP+pq4PfpMvuDWUijJ6ZtMzKIurI=', N'oYbbbqThocFtlwkwQLLHvfaBefwXGZrM', N'autoAdmin@test.co.uk', 1, 0, 0, CAST(N'2021-06-01 08:52:42.150' AS DateTime2), CAST(N'2022-01-11 16:23:43.493' AS DateTime2), CAST(N'2021-06-01 08:52:42.150' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 16:21:43.690' AS DateTime2), 0, 0, N'autoadmin', 1, 1, N'auto', N'Admin', N'AA')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'autoGroupAdmin@test.co.uk', N'CnC6nl0+/sjVKTKeNeuHN5Yc2oPjNXtKbuRVdE9L6XU=', N'lgMfng4Ktdl7LWXHMfU2aULppquZADvj', N'autoGroupAdmin@test.co.uk', 1, 0, 0, CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'2022-01-11 16:25:11.010' AS DateTime2), CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 16:25:11.200' AS DateTime2), 0, 0, N'autogroupadmin', 1, 1, N'Auto', N'GroupAdmin', N'AG')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'autoUser@test.co.uk', N'CnC6nl0+/sjVKTKeNeuHN5Yc2oPjNXtKbuRVdE9L6XU=', N'lgMfng4Ktdl7LWXHMfU2aULppquZADvj', N'autoUser@test.co.uk', 1, 0, 0, CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'2022-01-11 16:25:11.010' AS DateTime2), CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 16:25:11.200' AS DateTime2), 0, 0, N'autouser', 1, 1, N'auto', N'User', N'AU')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (NEWID(), N'autoRemoveUser@test.co.uk', N'CnC6nl0+/sjVKTKeNeuHN5Yc2oPjNXtKbuRVdE9L6XU=', N'lgMfng4Ktdl7LWXHMfU2aULppquZADvj', N'autoRemoveUser@test.co.uk', 1, 0, 0, CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'2022-01-11 16:25:11.010' AS DateTime2), CAST(N'2021-06-01 08:53:55.410' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 16:25:11.200' AS DateTime2), 0, 0, N'autoremoveuser', 1, 1, N'auto', N'RemoveUser', N'AR')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'2ccff73e-f897-424c-afcb-ad5000a368a8', N'autoUser2@test.co.uk', N'qzWIgd8jJjPsoDkJ8NOVP7Dz7DjoXTsZagRkMwztYPw=', N'0Sim4e4mRlskAZJ6kpn2iSrzXxJXPapy', N'autoUser2@test.co.uk', 1, 0, 0, CAST(N'2021-06-23 09:54:57.213' AS DateTime2), CAST(N'2021-11-08 14:59:36.647' AS DateTime2), CAST(N'2021-06-23 09:54:57.213' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2021-11-08 14:59:37.193' AS DateTime2), 0, 0, N'autouser2', 1, 1, N'Auto', N'User2', N'AU')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'cb72fa31-e1b2-428a-8847-ad57009babd9', N'autoUser3@test.co.uk', N'Cd6U3nRQDqEbHa/V26rxOxyIL28wqfAjPdYzfN0JylU=', N'2gbwL74MNaZ8QK4dcaiedfP/fdJwdIpA', N'autoUser3@test.co.uk', 1, 0, 0, CAST(N'2021-06-30 09:26:46.923' AS DateTime2), CAST(N'2021-08-31 15:59:51.490' AS DateTime2), CAST(N'2021-06-30 09:26:46.923' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2021-08-31 15:59:51.873' AS DateTime2), 0, 0, N'autouser3', 1, 1, N'Auto', N'User3', N'AU')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'a51c9076-cf85-42da-bb30-adda00f5b3c6', N'VisRegUser@email.com', N'wJuXPg5bhhTfTEaUVmSAanZvLvRQvi0eY7lhbv7UoS8=', N'e0ZQHTFeBgp5Bte3hq1QbXxkZv9FBULO', N'VisRegUser@email.com', 1, 0, 0, CAST(N'2021-11-08 14:54:34.483' AS DateTime2), CAST(N'2022-01-11 10:16:20.327' AS DateTime2), CAST(N'2021-11-08 14:54:34.483' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 10:16:20.567' AS DateTime2), 0, 0, N'visreguser-email-com', 1, 1, N'Vis', N'Reg', N'VR')
	INSERT [dbo].[MembershipUser] ([Id], [UserName], [Password], [PasswordSalt], [Email], [IsApproved], [IsLockedOut], [IsBanned], [CreatedAtUTC], [LastLoginDateUTC], [LastPasswordChangedDateUTC], [LastLockoutDateUTC], [LastActivityDateUTC], [FailedPasswordAttemptCount], [FailedPasswordAnswerAttempt], [Slug], [HasAgreedToTermsAndConditions], [IsTrustedUser], [FirstName], [Surname], [Initials]) VALUES (N'24949588-81c0-4ae0-8d67-ae04011f41b4', N'autoEditUser@test.co.uk', N'GoHbGkQpGB/jgY3jN0hb5jSl4DEwbuME4dsdRP41NJw=', N'ZBp81AWhmQ2Qar5zuh6mmVPF/Fl5J6gg', N'autoEditUser@test.co.uk', 1, 0, 0, CAST(N'2021-12-20 17:25:52.167' AS DateTime2), CAST(N'2022-01-11 12:23:55.377' AS DateTime2), CAST(N'2021-12-20 17:25:52.167' AS DateTime2), CAST(N'1753-01-01 00:00:00.000' AS DateTime2), CAST(N'2022-01-11 10:43:43.793' AS DateTime2), 0, 0, N'autoedituser-test-co-uk', 1, 1, N'autoEdit', N'User', N'AU')	
	
	SELECT [Id] INTO #seededUsers FROM [dbo].[MembershipUser] WHERE [Email] IN ('autoAdmin@test.co.uk', 'autoGroupAdmin@test.co.uk', 'autoRemoveUser@test.co.uk', 'autoUser@test.co.uk', 'autoUser2@test.co.uk', 'autoUser3@test.co.uk', 'autoTest@email.com', 'VisRegUser@email.com', 'autoEditUser@test.co.uk');
	
	/**
	* INSERT AUTOMATION FILES
	*/
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (N'919e0125-06f7-49a8-a94b-adff00b699f4', N'docTest', N'Test doc FNHS105', N'docTest.doc', N'26624', N'.doc', N'1314d02f-289a-48b9-8ed8-74f7a1f080e4.doc', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-12-15 11:04:49.8791246' AS DateTime2), CAST(N'2022-01-10 12:31:13.8900000' AS DateTime2), N'f86d22cf-1b0e-4d24-8120-adc500d224fb', (SELECT id FROM FileStatus WHERE Name='Verified'), 0x27EBB0DE9064A9A6F6647FB94F08CAA7)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'docTest', N'test doc', N'docTest.doc', N'26624', N'.doc', N'1314d02f-289a-48b9-8ed8-74f7a1f080e4.doc', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-12-15 11:04:49.8791246' AS DateTime2), CAST(N'2022-01-10 12:31:13.8900000' AS DateTime2), N'0c94aa3c-3143-496b-a9f4-adac010e0fc1', (SELECT id FROM FileStatus WHERE Name='Verified'), 0x27EBB0DE9064A9A6F6647FB94F08CAA7)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (N'54249d0f-3544-4b76-b6fb-ae0001022c09', N'pdfTest', N'test pdf', N'pdfTest.pdf', N'31242', N'.pdf', N'6c606efa-86f8-4b69-a74c-020a367c60c6.pdf', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-12-16 15:39:58.5342308' AS DateTime2), CAST(N'2021-12-16 15:39:58.6123562' AS DateTime2), N'f86d22cf-1b0e-4d24-8120-adc500d224fb', (SELECT id FROM FileStatus WHERE Name='Verified'), 0xEF0D9857E5BF01074BCBEFBC2AA1BEC6)	
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test ppt',  N'test ppt', N'test.pptx', 29594, N'.pptx', N'9334e127-766b-41e7-a900-35ad64a2258e.pptx', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:46:39.9000121' AS DateTime2), CAST(N'2021-11-05 11:46:40.0719395' AS DateTime2), N'f86d22cf-1b0e-4d24-8120-adc500d224fb', (SELECT id FROM FileStatus WHERE Name='Verified'), 0x6995F3087714AE2908F0A56CA435B070)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test excel', N'test excel', N'TestExcel.xlsx', 7898, N'.xlsx', N'75b731ef-1aae-4622-b1e7-3ad19983840b.xlsx', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:47:25.2124850' AS DateTime2), CAST(N'2021-11-05 11:47:25.2437944' AS DateTime2), N'f86d22cf-1b0e-4d24-8120-adc500d224fb', (SELECT id FROM FileStatus WHERE Name='Verified'), 0xD4A720E76181F8B12BBACAEE0BFFCD08)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test pdf',  N'test pdf', N'testPDF.pdf', 180109, N'.pdf', N'0f0ff7ec-9f38-4ccb-8e8c-dadd51670cef.pdf', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:46:16.5671393' AS DateTime2), CAST(N'2021-11-05 11:46:16.7390179' AS DateTime2), N'a16c2581-a916-4adc-afb5-adda00f73b4c', (SELECT id FROM FileStatus WHERE Name='Verified'), 0x7EC45D63B3DBAEB1E9E9134E4D718A9C)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test ppt',  N'test ppt', N'test.pptx', 29594, N'.pptx', N'9334e127-766b-41e7-a900-35ad64a2258e.pptx', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:46:39.9000121' AS DateTime2), CAST(N'2021-11-05 11:46:40.0719395' AS DateTime2), N'a16c2581-a916-4adc-afb5-adda00f73b4c', (SELECT id FROM FileStatus WHERE Name='Verified'), 0x6995F3087714AE2908F0A56CA435B070)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test excel', N'test excel', N'TestExcel.xlsx', 7898, N'.xlsx', N'75b731ef-1aae-4622-b1e7-3ad19983840b.xlsx', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:47:25.2124850' AS DateTime2), CAST(N'2021-11-05 11:47:25.2437944' AS DateTime2), N'a16c2581-a916-4adc-afb5-adda00f73b4c', (SELECT id FROM FileStatus WHERE Name='Verified'), 0xD4A720E76181F8B12BBACAEE0BFFCD08)
	INSERT [dbo].[File] ([Id], [Title], [Description], [FileName], [FileSizeBytes], [FileExtension], [BlobName], [CreatedBy], [ModifiedBy], [CreatedAtUtc], [ModifiedAtUtc], [ParentFolder], [FileStatus], [BlobHash]) VALUES (NEWID(), N'test doc',  N'test doc', N'Concern doc3.docx', 12736, N'.docx', N'1dd07f72-8c83-4697-a80a-546749ed1920.docx', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL, CAST(N'2021-11-05 11:47:47.2254067' AS DateTime2), CAST(N'2021-11-05 11:47:47.3035328' AS DateTime2), N'a16c2581-a916-4adc-afb5-adda00f73b4c', (SELECT id FROM FileStatus WHERE Name='Verified'), 0xAEF3F81BAE17391B23CDCB1559B5F5C2)
	
	/**
	* INSERT AUTOMATION FOLDERS
	*/
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'14380b32-d5e6-4f98-aff7-ad7c00ea75ce', N'Empty Folder', N'Empty Folder for testing', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-08-06 14:13:38.6033333' AS DateTime2), NULL, N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (NEWID(), N'DeleteFolder', N'Folder to be deleted by automation', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-10-18 12:45:06.7541366' AS DateTime2), NULL, N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (NEWID(), N'EditableFolder', N'Folder to be edited by automation', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-10-18 12:45:06.7541366' AS DateTime2), NULL, N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'0c94aa3c-3143-496b-a9f4-adac010e0fc1', N'Public Empty Folder', N'Empty Folder for testing', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-09-23 16:23:15.8405472' AS DateTime2), NULL, N'61de48cf-686e-483d-84cf-ad95010721d3')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'f86d22cf-1b0e-4d24-8120-adc500d224fb', N'Automation Test Folder', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2021-10-18 12:45:06.7541366' AS DateTime2), NULL, N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'a16c2581-a916-4adc-afb5-adda00f73b4c', N'Base Folder 1', N'Folder Test', N'a51c9076-cf85-42da-bb30-adda00f5b3c6', CAST(N'2021-11-08 15:00:08.5681812' AS DateTime2), NULL, N'41234726-7e93-4767-afbe-adda00f560a2')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'bd939a64-4a7b-44c0-b7dc-adda00f746b3', N'Base Folder 2', NULL, N'a51c9076-cf85-42da-bb30-adda00f5b3c6', CAST(N'2021-11-08 15:00:18.2995929' AS DateTime2), NULL, N'41234726-7e93-4767-afbe-adda00f560a2')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'6a596e94-6b20-4c3a-8f44-ae1d00bc2d57', N'Folder 1', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2022-01-14 11:25:07.9148295' AS DateTime2), N'f86d22cf-1b0e-4d24-8120-adc500d224fb', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'7af7d1b4-ec3c-42c1-a093-ae1d00bc334c', N'Folder 2', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2022-01-14 11:25:12.9988659' AS DateTime2), N'6a596e94-6b20-4c3a-8f44-ae1d00bc2d57', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'00980e58-f271-4e33-a27a-ae1d00bdee27', N'Folder 3', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2022-01-14 11:31:30.9024318' AS DateTime2), N'7af7d1b4-ec3c-42c1-a093-ae1d00bc334c', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'f575cd91-8992-42de-9840-706f525ac82d', N'Folder 5', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2022-03-16T14:11:09.0000000' AS DateTime2), N'ac3f1100-3e29-41bf-804f-2305b7fb7b04', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[Folder] ([Id], [Title], [Description], [CreatedBy], [CreatedAtUtc], [ParentFolder], [Group_Id]) VALUES (N'ac3f1100-3e29-41bf-804f-2305b7fb7b04', N'Folder 4', NULL, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', CAST(N'2022-03-16T14:10:57.0000000' AS DateTime2), N'00980e58-f271-4e33-a27a-ae1d00bdee27', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
		
	/**
	*	INSERT AUTOMATION GROUPS
	*/	
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'Automation Admin Group', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-06-01 08:58:41.317' AS DateTime2), N'aa', 0, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'Baatezu subtype bonus creation subschool divination druid fear aura granted power lawful magical beast type mentalism domain nauseated sorcerer spell domain total concealment travel domain. Abjuration alignment alternate form blindsight construct type damage fate domain fly free action halfling domain improved evasion infection lawful melee miniature figure modifier natural reach plant type player character result spell descriptor spell immunity strength domain subschool suffering domain swarm subtype unarmed attack untrained.')
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'0d1ea1e0-83f9-491f-b99a-ad4000df7f09', N'AutoPendingGroup', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-06-07 13:33:43.493' AS DateTime2), N'autopendinggroup', 0, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'3e4a64dc-664a-4388-bc52-ad950106fb30', N'Automation Private Group', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-08-31 15:57:29.117' AS DateTime2), N'automation-private-group', 0, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'61de48cf-686e-483d-84cf-ad95010721d3', N'Automation Public Group', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-08-31 15:58:02.087' AS DateTime2), N'automation-public-group', 1, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'41234726-7e93-4767-afbe-adda00f560a2', N'Automation Visual Regression Group', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-11-08 14:53:23.520' AS DateTime2), N'automation-visual-regression-group', 0, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'b8c36360-ecbe-4ade-a3c2-adfd00f01faf', N'Automation Editable Group', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2021-12-13 14:34:15.833' AS DateTime2), N'automation-editable-group', 0, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	INSERT [dbo].[Group] ([Id], [Name], [Description], [IsLocked], [ModerateDiscussions], [ModerateComments], [SortOrder], [CreatedAtUtc], [Slug], [PublicGroup], [GroupOwner], [Subtitle], [Introduction], [AboutUs]) VALUES (N'A16A30FC-0B2C-467E-A44B-0EDE6B11DAE0', N'Automation Group To Be Restricted', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', 0, 0, 0, 0, CAST(N'2022-05-30 13:25:08.000' AS DateTime2), N'automation-gtbr-group', 1, N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', N'DO NOT USE - This group is reserved solely for use by our automated test scripts', NULL)
	
	/** 
	*	INSERT AUTOMATION GROUPSITES
	*/
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'aa'), N'4463f190-4d60-4289-b033-b619f011b1fe', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'aa'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'autopendinggroup'), N'768e10cf-f460-4b73-b2e3-d80ebdf221a8', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'autopendinggroup'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'automation-private-group'), N'646f3491-f4f8-4c94-9c1e-1d185fbf6343', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'automation-private-group'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'automation-public-group'), N'82e5de40-1c93-4a5d-bc79-03fe14117dcd', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'automation-public-group'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'automation-visual-regression-group'), N'ab22598d-ef80-4d7f-bfca-c658d11631a8', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'automation-visual-regression-group'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'automation-editable-group'), N'51d10e22-d20a-4ae9-9d75-6d10d9a60d79', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'automation-editable-group'))
	INSERT [dbo].[GroupSite] ([GroupId], [ContentRootId], [CreatedBy], [CreatedAtUTC]) VALUES ((SELECT Id FROM [dbo].[Group] WHERE [Slug] = 'automation-gtbr-group'), N'e140f61c-cb4b-41e0-a80d-5565cbd0259e', (SELECT Id FROM [dbo].[MembershipUser] WHERE [Email] = 'autoGroupAdmin@test.co.uk'), (SELECT CreatedAtUTC FROM [dbo].[Group] WHERE [Slug] = 'automation-gtbr-group'))

	/**
	* INSERT AUTOMATION GROUPUSER RECORDS
	*/
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'57102d73-fdee-4638-9ce9-ad4000df7fd7', 1, 0, 0, 0, CAST(N'2021-06-07 13:33:44.180' AS DateTime2), CAST(N'2021-06-07 13:33:44.200' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'0d1ea1e0-83f9-491f-b99a-ad4000df7f09')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (NEWID(), 1, 0, 0, 0, CAST(N'2021-06-07 13:33:44.180' AS DateTime2), CAST(N'2021-06-07 13:33:44.200' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'A16A30FC-0B2C-467E-A44B-0EDE6B11DAE0')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'f88834d9-a686-4355-b36d-ad3a0094027f', 1, 0, 0, 0, CAST(N'2021-06-01 08:58:53.220' AS DateTime2), CAST(N'2021-06-01 20:06:06.300' AS DateTime2), @admin, (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'03815f35-d9c7-45ce-8abb-ad950106fb56', 1, 0, 0, 0, CAST(N'2021-08-31 15:57:29.243' AS DateTime2), CAST(N'2021-08-31 15:57:29.257' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'3e4a64dc-664a-4388-bc52-ad950106fb30')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'30b8253b-0183-4753-9766-ad95010721dd', 1, 0, 0, 0, CAST(N'2021-08-31 15:58:02.117' AS DateTime2), CAST(N'2021-08-31 15:58:02.117' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'61de48cf-686e-483d-84cf-ad95010721d3')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'8dde30b0-2960-46f8-8162-ae1a00a912d9', 1, 0, 0, 0, CAST(N'2022-01-11 10:15:34.693' AS DateTime2), CAST(N'2022-01-11 10:16:25.673' AS DateTime2), N'a51c9076-cf85-42da-bb30-adda00f5b3c6', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'41234726-7e93-4767-afbe-adda00f560a2')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'0f175c8d-32d0-499b-8225-adfd00f01fbd', 1, 0, 0, 0, CAST(N'2021-12-13 14:34:15.880' AS DateTime2), CAST(N'2021-12-13 14:34:15.880' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Admin'), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', N'b8c36360-ecbe-4ade-a3c2-adfd00f01faf')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'f302fdf3-b6e6-47f0-ba60-ad3a0094303d', 1, 0, 0, 0, CAST(N'2021-06-01 08:59:32.257' AS DateTime2), CAST(N'2021-06-07 11:53:29.393' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (NEWID(), 1, 0, 0, 0, CAST(N'2021-06-01 08:59:32.257' AS DateTime2), CAST(N'2021-06-07 11:53:29.393' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), (SELECT id FROM MembershipUser WHERE UserName ='autoRemoveUser@test.co.uk'), N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'49a507ec-f826-4742-bc98-ad4000dfbd0d', 0, 0, 0, 0, CAST(N'2021-06-07 13:34:36.413' AS DateTime2), NULL, NULL, (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'0d1ea1e0-83f9-491f-b99a-ad4000df7f09')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'2d5b049a-35af-430e-ad11-ad5000a37b65', 0, 0, 0, 0, CAST(N'2021-06-23 09:55:13.190' AS DateTime2), NULL, NULL, (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'2ccff73e-f897-424c-afcb-ad5000a368a8', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'3839a52e-cbc3-4963-b455-ad95010750b5', 1, 0, 0, 0, CAST(N'2021-08-31 15:58:42.093' AS DateTime2), CAST(N'2021-09-01 14:04:06.650' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'2ccff73e-f897-424c-afcb-ad5000a368a8', N'3e4a64dc-664a-4388-bc52-ad950106fb30')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'f8b8f77b-933c-4847-a856-ad7c00da84e7', 0, 0, 0, 0, CAST(N'2021-08-06 13:15:36.233' AS DateTime2), NULL, NULL, (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'cb72fa31-e1b2-428a-8847-ad57009babd9', N'2d841d48-9753-463f-aff2-ad3a0093f48b')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'0288b4fa-93fb-4ea5-b8c9-ad950107aaaa', 0, 0, 0, 0, CAST(N'2021-08-31 15:59:58.857' AS DateTime2), NULL, NULL, (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'cb72fa31-e1b2-428a-8847-ad57009babd9', N'3e4a64dc-664a-4388-bc52-ad950106fb30')
	INSERT [dbo].[GroupUser] ([Id], [Approved], [Rejected], [Locked], [Banned], [RequestToJoinDateUTC], [ApprovedToJoinDateUTC], [ApprovingMembershipUser_Id], [MembershipRole_Id], [MembershipUser_Id], [Group_Id]) VALUES (N'29e5731d-c2d5-4607-90ce-ae1a00a97a41', 1, 0, 0, 0, CAST(N'2022-01-11 10:17:02.937' AS DateTime2), CAST(N'2022-01-11 10:17:20.900' AS DateTime2), N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'), N'a51c9076-cf85-42da-bb30-adda00f5b3c6', N'41234726-7e93-4767-afbe-adda00f560a2')
	
	/**
	* INSERT AUTOMATION MEMBERSHIPUSERSINROLE
	*/
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', (SELECT id FROM MembershipRole WHERE roleName='Admin'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'a51c9076-cf85-42da-bb30-adda00f5b3c6', (SELECT id FROM MembershipRole WHERE roleName='Admin'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'2ccff73e-f897-424c-afcb-ad5000a368a8', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'cb72fa31-e1b2-428a-8847-ad57009babd9', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'24949588-81C0-4AE0-8D67-AE04011F41B4', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES (N'16D4D237-4686-4B4F-AE05-1CFF3F8FB43A', (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))
	INSERT [dbo].[MembershipUsersInRoles] ([UserIdentifier], [RoleIdentifier]) VALUES ((SELECT id FROM MembershipUser WHERE UserName ='autoRemoveUser@test.co.uk'), (SELECT id FROM MembershipRole WHERE roleName='Standard Members'))

	/**
	* INSERT AUTOMATION POSTS
	*/
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'ca5c5162-7a2a-482e-b15b-ad7f010e30cf', N'<p>Comment for Like test</p>', CAST(N'2021-08-09 16:23:44.043' AS DateTime2), CAST(N'2021-08-09 16:23:44.043' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'edcc5437-b704-45d8-8972-ad7f010e2316', N'<p>First Comment</p>', CAST(N'2021-08-09 16:23:32.337' AS DateTime2), CAST(N'2021-08-09 16:23:32.337' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'e56abf3c-7aa0-465a-a146-ad7f010e4acc', N'<p>Third Comment</p>', CAST(N'2021-08-09 16:24:06.220' AS DateTime2), CAST(N'2021-08-09 16:24:06.220' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'bcca8784-0e5e-496c-9bbb-ad7f010e51b4', N'<p>Fourth Comment</p>', CAST(N'2021-08-09 16:24:12.117' AS DateTime2), CAST(N'2021-08-09 16:24:12.117' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'e846a7bc-327a-4c05-89c7-ad7f010e5ed2', N'<p>Fifth Comment</p>', CAST(N'2021-08-09 16:24:23.310' AS DateTime2), CAST(N'2021-08-09 16:24:23.310' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'e4940ced-087d-41e9-a350-ad7f010e6bc9', N'<p>Sixth Comment</p>', CAST(N'2021-08-09 16:24:34.373' AS DateTime2), CAST(N'2021-08-09 16:24:34.373' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'69f7c324-3c63-4917-8b22-ad7f010e719e', N'<p>Seventh Comment</p>', CAST(N'2021-08-09 16:24:39.350' AS DateTime2), CAST(N'2021-08-09 16:24:39.350' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'58ab24e5-f3f9-4f8d-aba9-ad7f010e809d', N'<p>Eighth Comment</p>', CAST(N'2021-08-09 16:24:52.147' AS DateTime2), CAST(N'2021-08-09 16:24:52.147' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'107d1f85-3366-410c-8ffe-ad7f010e8586', N'<p>Ninth Comment</p>', CAST(N'2021-08-09 16:24:56.337' AS DateTime2), CAST(N'2021-08-09 16:24:56.337' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'0e807603-6d32-4f4f-833b-ad7f010e903a', N'<p>Tenth Comment</p>', CAST(N'2021-08-09 16:25:05.470' AS DateTime2), CAST(N'2021-08-09 16:25:05.470' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'e28ed14b-46ae-4fdd-8988-ad7f010e959c', N'<p>Eleventh Comment</p>', CAST(N'2021-08-09 16:25:10.063' AS DateTime2), CAST(N'2021-08-09 16:25:10.063' AS DateTime2), NULL, N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>First Comment</p>', CAST(N'2021-08-09 16:23:32.337' AS DateTime2), CAST(N'2021-08-09 16:23:32.337' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Third Comment</p>', CAST(N'2021-08-09 16:24:06.220' AS DateTime2), CAST(N'2021-08-09 16:24:06.220' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Fourth Comment</p>', CAST(N'2021-08-09 16:24:12.117' AS DateTime2), CAST(N'2021-08-09 16:24:12.117' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Fifth Comment</p>', CAST(N'2021-08-09 16:24:23.310' AS DateTime2), CAST(N'2021-08-09 16:24:23.310' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Sixth Comment</p>', CAST(N'2021-08-09 16:24:34.373' AS DateTime2), CAST(N'2021-08-09 16:24:34.373' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Seventh Comment</p>', CAST(N'2021-08-09 16:24:39.350' AS DateTime2), CAST(N'2021-08-09 16:24:39.350' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Eighth Comment</p>', CAST(N'2021-08-09 16:24:52.147' AS DateTime2), CAST(N'2021-08-09 16:24:52.147' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Ninth Comment</p>', CAST(N'2021-08-09 16:24:56.337' AS DateTime2), CAST(N'2021-08-09 16:24:56.337' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Tenth Comment</p>', CAST(N'2021-08-09 16:25:05.470' AS DateTime2), CAST(N'2021-08-09 16:25:05.470' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (NEWID(), N'<p>Eleventh Comment</p>', CAST(N'2021-08-09 16:25:10.063' AS DateTime2), CAST(N'2021-08-09 16:25:10.063' AS DateTime2), NULL, N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'80d3fc63-4852-4163-98ac-ad880118903c', N'<p>First blank reply</p>', CAST(N'2021-08-18 17:01:30.010' AS DateTime2), CAST(N'2021-08-18 17:01:30.010' AS DateTime2), N'edcc5437-b704-45d8-8972-ad7f010e2316', N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'edcc5437-b704-45d8-8972-ad7f010e2316')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'5313414a-ac9d-49eb-af90-ad880118b1ca', N'<p>Second blank reply</p>', CAST(N'2021-08-18 17:01:58.640' AS DateTime2), CAST(N'2021-08-18 17:01:58.640' AS DateTime2), N'edcc5437-b704-45d8-8972-ad7f010e2316', N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'edcc5437-b704-45d8-8972-ad7f010e2316')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'b578b2e5-cce4-4e84-9e64-ad880118bce2', N'<p>Third blank reply</p>', CAST(N'2021-08-18 17:02:08.110' AS DateTime2), CAST(N'2021-08-18 17:02:08.110' AS DateTime2), N'edcc5437-b704-45d8-8972-ad7f010e2316', N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'edcc5437-b704-45d8-8972-ad7f010e2316')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'c30117fc-dbb5-453c-9968-ad880118c70e', N'<p>Fourth blank reply</p>', CAST(N'2021-08-18 17:02:16.790' AS DateTime2), CAST(N'2021-08-18 17:02:16.790' AS DateTime2), N'edcc5437-b704-45d8-8972-ad7f010e2316', N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'7db6f2c4-6bf3-4178-967f-ad3a0092a580', N'edcc5437-b704-45d8-8972-ad7f010e2316')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'1af57d07-9012-4511-b9fc-ad88012033b0', N'<p>This is a comment to reply to</p>', CAST(N'2021-08-18 17:29:18.663' AS DateTime2), CAST(N'2021-08-18 17:29:18.663' AS DateTime2), NULL, N'96b155ba-e8de-40e3-980e-ad8800b0a6b8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'4760e89f-048e-4b47-a70e-339cd43a2703', N'<p>Second Public Comment</p>', CAST(N'2022-03-03T13:59:24.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'3cb17bfa-9ad4-4ab7-9801-36aff0278be0', N'<p>First Public Reply</p>', CAST(N'2022-03-03T14:00:10.0000000' AS DateTime2), NULL, N'5ca2c29e-31d6-448e-a409-6fbf83cbf844', N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'5ca2c29e-31d6-448e-a409-6fbf83cbf844')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'5ca2c29e-31d6-448e-a409-6fbf83cbf844', N'<p>First Public Comment</p>', CAST(N'2022-03-03T13:59:18.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'9652f206-bd13-4920-b6d4-76858a21029a', N'<p>Fourth Public Reply</p>', CAST(N'2022-03-03T14:01:37.0000000' AS DateTime2), NULL, N'5ca2c29e-31d6-448e-a409-6fbf83cbf844', N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'5ca2c29e-31d6-448e-a409-6fbf83cbf844')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'13fa753a-fcba-4bf3-ae4c-771103503246', N'<p>Third Public Reply</p>', CAST(N'2022-03-03T14:01:27.0000000' AS DateTime2), NULL, N'5ca2c29e-31d6-448e-a409-6fbf83cbf844', N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'5ca2c29e-31d6-448e-a409-6fbf83cbf844')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'c0011070-c541-450e-a19f-7b4f91640835', N'<p>Sixth Public Comment</p>', CAST(N'2022-03-03T13:59:53.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'285a2aa3-bfb8-41e1-b4d1-9349a68f2252', N'<p>Third Public Comment</p>', CAST(N'2022-03-03T13:59:29.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'ce818d68-d4c5-4518-8b4f-982930b5f8c1', N'<p>Fifth Public Comment</p>', CAST(N'2022-03-03T13:59:45.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'7120144f-a4a3-40dc-bd83-b7f8e7f8f66d', N'<p>Second Public Reply</p>', CAST(N'2022-03-03T14:00:30.0000000' AS DateTime2), NULL, N'3cb17bfa-9ad4-4ab7-9801-36aff0278be0', N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'5ca2c29e-31d6-448e-a409-6fbf83cbf844')
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'468cf575-9dcd-4897-9976-f747009dc13d', N'<p>Fourth Public Comment</p>', CAST(N'2022-03-03T13:59:37.0000000' AS DateTime2), NULL, NULL, N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', NULL)
	INSERT [dbo].[Comment] ([Entity_Id], [Content], [CreatedAtUTC], [ModifiedAtUTC], [InReplyTo], [Parent_EntityId], [CreatedBy], [ThreadId]) VALUES (N'DAC3D7BF-8429-410F-93F7-1A25FC9E42F2', N'<p>Reply for FNHS56 test scenario</p>', CAST(N'2022-06-16 09:57:18.000' AS DateTime2), NULL, N'1AF57D07-9012-4511-B9FC-AD88012033B0', N'96B155BA-E8DE-40E3-980E-AD8800B0A6B8', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'1AF57D07-9012-4511-B9FC-AD88012033B0')
		
	/**
	* INSERT AUTOMATION Discussions
	*/
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'493a2f0e-4195-4730-9f3c-ad7f010d40c8', N'General Discussion Validation', CAST(N'2021-08-09 16:20:19.223' AS DateTime2), 0, 1, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Discussion for general feature validation</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'3fbc0d4e-c2a7-46a0-99e9-ad7f010eb4ad', N'First Blank Discussion', CAST(N'2021-08-09 16:25:36.570' AS DateTime2), 0, 0, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Blank Discussion</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'a4bf9b51-d145-4601-92b6-ad7f010ebe84', N'Second Blank Discussion', CAST(N'2021-08-10 16:25:44.970' AS DateTime2), 0, 0, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Blank Discussion</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'6ea66f95-24bc-4179-94f4-ad7f010ec730', N'Third Blank Discussion', CAST(N'2021-08-10 16:25:52.367' AS DateTime2), 0, 0, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Blank Discussion</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'a6da1550-066f-4ae6-ae98-ad7f010ece99', N'Fourth Blank Discussion', CAST(N'2021-08-10 16:25:58.690' AS DateTime2), 0, 0, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Blank Discussion</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'e1d477d3-dfb0-4acd-b74d-ad7f010ed722', N'Fifth Blank Discussion', CAST(N'2021-08-10 16:26:05.977' AS DateTime2), 0, 0, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Blank Discussion</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'55f516e0-9117-4a43-9363-ad8200ce7d1a', N'Blank Discussion', CAST(N'2021-08-12 12:31:48.137' AS DateTime2), 0, 0, 0, N'0d1ea1e0-83f9-491f-b99a-ad4000df7f09', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Discussion to validate group card in groups list</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'96b155ba-e8de-40e3-980e-ad8800b0a6b8', N'forumSubmission Discussion', CAST(N'2021-08-10 16:20:19.223' AS DateTime2), 0, 1, 0, N'2d841d48-9753-463f-aff2-ad3a0093f48b', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>Discussion for scenarios for forumNavigation and forumSubmission features</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'83702899-fdbf-49ed-bb1d-adda00f757c3', N'New Discussion 1', CAST(N'2021-11-08 15:00:32.860' AS DateTime2), 0, 0, 0, N'41234726-7e93-4767-afbe-adda00f560a2', N'a51c9076-cf85-42da-bb30-adda00f5b3c6', N'<p>Discussion Comment</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'5889c069-5061-403b-93f6-adda00f7638a', N'New Discussion 2', CAST(N'2021-11-08 15:00:42.910' AS DateTime2), 0, 0, 0, N'41234726-7e93-4767-afbe-adda00f560a2', N'a51c9076-cf85-42da-bb30-adda00f5b3c6', N'<p>New Comment</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUTC], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'f91c0e75-9d3d-4700-9efb-adda00f770d0', N'New Discussion 3', CAST(N'2021-11-08 15:00:54.237' AS DateTime2), 0, 0, 0, N'41234726-7e93-4767-afbe-adda00f560a2', N'a51c9076-cf85-42da-bb30-adda00f5b3c6', N'<p>New Comment</p>')
	INSERT [dbo].[Discussion] ([Entity_Id], [Title], [CreatedAtUtc], [Views], [IsSticky], [IsLocked], [Group_Id], [CreatedBy], [Content]) VALUES (N'eaf7a8f1-b9a0-415d-b26d-88517132536e', N'Public Discussion Test', CAST(N'2022-03-03T13:59:01.0000000' AS DateTime2), 0, 0, 0, N'61de48cf-686e-483d-84cf-ad95010721d3', N'd74ed860-9ea5-4c95-9394-ad3a00924fa5', N'<p>A discussion to validate public access/view in read only format</p>')
	
	/**
	* INSERT ENTITY IDS INTO ENTITY
	*/
	INSERT INTO [dbo].[Entity] SELECT Entity_Id FROM Comment WHERE CreatedBy IN (SELECT * FROM #seededUsers);
	INSERT INTO [dbo].[Entity] SELECT Entity_Id FROM Discussion WHERE CreatedBy IN (SELECT * FROM #seededUsers);
	    
	DROP TABLE #seededUsers
	
    -- Re-enable constraints for all tables:
    EXEC sp_msforeachtable 'ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all';	

END
ROLLBACK TRANSACTION